/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAction;
import com.itextpdf.text.pdf.PdfAnnotation;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfBorderDictionary;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfString;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PdfAcroForm
extends PdfDictionary {
    private PdfWriter writer;
    private HashSet<PdfTemplate> fieldTemplates = new HashSet();
    private PdfArray documentFields = new PdfArray();
    private PdfArray calculationOrder = new PdfArray();
    private int sigFlags = 0;

    public PdfAcroForm(PdfWriter writer) {
        this.writer = writer;
    }

    public void setNeedAppearances(boolean value) {
        this.put(PdfName.NEEDAPPEARANCES, new PdfBoolean(value));
    }

    public void addFieldTemplates(HashSet<PdfTemplate> ft) {
        this.fieldTemplates.addAll(ft);
    }

    public void addDocumentField(PdfIndirectReference ref) {
        this.documentFields.add(ref);
    }

    public boolean isValid() {
        if (this.documentFields.size() == 0) {
            return false;
        }
        this.put(PdfName.FIELDS, this.documentFields);
        if (this.sigFlags != 0) {
            this.put(PdfName.SIGFLAGS, new PdfNumber(this.sigFlags));
        }
        if (this.calculationOrder.size() > 0) {
            this.put(PdfName.CO, this.calculationOrder);
        }
        if (this.fieldTemplates.isEmpty()) {
            return true;
        }
        PdfDictionary dic = new PdfDictionary();
        for (PdfTemplate template : this.fieldTemplates) {
            PdfFormField.mergeResources(dic, (PdfDictionary)template.getResources());
        }
        this.put(PdfName.DR, dic);
        this.put(PdfName.DA, new PdfString("/Helv 0 Tf 0 g "));
        PdfDictionary fonts = (PdfDictionary)dic.get(PdfName.FONT);
        if (fonts != null) {
            this.writer.eliminateFontSubset(fonts);
        }
        return true;
    }

    public void addCalculationOrder(PdfFormField formField) {
        this.calculationOrder.add(formField.getIndirectReference());
    }

    public void setSigFlags(int f) {
        this.sigFlags |= f;
    }

    public void addFormField(PdfFormField formField) {
        this.writer.addAnnotation(formField);
    }

    public PdfFormField addHtmlPostButton(String name, String caption, String value, String url2, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfAction action = PdfAction.createSubmitForm(url2, null, 4);
        PdfFormField button = new PdfFormField(this.writer, llx, lly, urx, ury, action);
        this.setButtonParams(button, 65536, name, value);
        this.drawButton(button, caption, font, fontSize, llx, lly, urx, ury);
        this.addFormField(button);
        return button;
    }

    public PdfFormField addResetButton(String name, String caption, String value, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfAction action = PdfAction.createResetForm(null, 0);
        PdfFormField button = new PdfFormField(this.writer, llx, lly, urx, ury, action);
        this.setButtonParams(button, 65536, name, value);
        this.drawButton(button, caption, font, fontSize, llx, lly, urx, ury);
        this.addFormField(button);
        return button;
    }

    public PdfFormField addMap(String name, String value, String url2, PdfContentByte appearance, float llx, float lly, float urx, float ury) {
        PdfAction action = PdfAction.createSubmitForm(url2, null, 20);
        PdfFormField button = new PdfFormField(this.writer, llx, lly, urx, ury, action);
        this.setButtonParams(button, 65536, name, null);
        PdfAppearance pa = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        pa.add(appearance);
        button.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pa);
        this.addFormField(button);
        return button;
    }

    public void setButtonParams(PdfFormField button, int characteristics, String name, String value) {
        button.setButton(characteristics);
        button.setFlags(4);
        button.setPage();
        button.setFieldName(name);
        if (value != null) {
            button.setValueAsString(value);
        }
    }

    public void drawButton(PdfFormField button, String caption, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfAppearance pa = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        pa.drawButton(0.0f, 0.0f, urx - llx, ury - lly, caption, font, fontSize);
        button.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, pa);
    }

    public PdfFormField addHiddenField(String name, String value) {
        PdfFormField hidden = PdfFormField.createEmpty(this.writer);
        hidden.setFieldName(name);
        hidden.setValueAsName(value);
        this.addFormField(hidden);
        return hidden;
    }

    public PdfFormField addSingleLineTextField(String name, String text, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField field2 = PdfFormField.createTextField(this.writer, false, false, 0);
        this.setTextFieldParams(field2, text, name, llx, lly, urx, ury);
        this.drawSingleLineOfText(field2, text, font, fontSize, llx, lly, urx, ury);
        this.addFormField(field2);
        return field2;
    }

    public PdfFormField addMultiLineTextField(String name, String text, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField field2 = PdfFormField.createTextField(this.writer, true, false, 0);
        this.setTextFieldParams(field2, text, name, llx, lly, urx, ury);
        this.drawMultiLineOfText(field2, text, font, fontSize, llx, lly, urx, ury);
        this.addFormField(field2);
        return field2;
    }

    public PdfFormField addSingleLinePasswordField(String name, String text, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField field2 = PdfFormField.createTextField(this.writer, false, true, 0);
        this.setTextFieldParams(field2, text, name, llx, lly, urx, ury);
        this.drawSingleLineOfText(field2, text, font, fontSize, llx, lly, urx, ury);
        this.addFormField(field2);
        return field2;
    }

    public void setTextFieldParams(PdfFormField field2, String text, String name, float llx, float lly, float urx, float ury) {
        field2.setWidget(new Rectangle(llx, lly, urx, ury), PdfAnnotation.HIGHLIGHT_INVERT);
        field2.setValueAsString(text);
        field2.setDefaultValueAsString(text);
        field2.setFieldName(name);
        field2.setFlags(4);
        field2.setPage();
    }

    public void drawSingleLineOfText(PdfFormField field2, String text, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfAppearance tp = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        PdfAppearance tp2 = (PdfAppearance)tp.getDuplicate();
        tp2.setFontAndSize(font, fontSize);
        tp2.resetRGBColorFill();
        field2.setDefaultAppearanceString(tp2);
        tp.drawTextField(0.0f, 0.0f, urx - llx, ury - lly);
        tp.beginVariableText();
        tp.saveState();
        tp.rectangle(3.0f, 3.0f, urx - llx - 6.0f, ury - lly - 6.0f);
        tp.clip();
        tp.newPath();
        tp.beginText();
        tp.setFontAndSize(font, fontSize);
        tp.resetRGBColorFill();
        tp.setTextMatrix(4.0f, (ury - lly) / 2.0f - fontSize * 0.3f);
        tp.showText(text);
        tp.endText();
        tp.restoreState();
        tp.endVariableText();
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
    }

    public void drawMultiLineOfText(PdfFormField field2, String text, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfAppearance tp = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        PdfAppearance tp2 = (PdfAppearance)tp.getDuplicate();
        tp2.setFontAndSize(font, fontSize);
        tp2.resetRGBColorFill();
        field2.setDefaultAppearanceString(tp2);
        tp.drawTextField(0.0f, 0.0f, urx - llx, ury - lly);
        tp.beginVariableText();
        tp.saveState();
        tp.rectangle(3.0f, 3.0f, urx - llx - 6.0f, ury - lly - 6.0f);
        tp.clip();
        tp.newPath();
        tp.beginText();
        tp.setFontAndSize(font, fontSize);
        tp.resetRGBColorFill();
        tp.setTextMatrix(4.0f, 5.0f);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        float yPos = ury - lly;
        while (tokenizer.hasMoreTokens()) {
            tp.showTextAligned(0, tokenizer.nextToken(), 3.0f, yPos -= fontSize * 1.2f, 0.0f);
        }
        tp.endText();
        tp.restoreState();
        tp.endVariableText();
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
    }

    public PdfFormField addCheckBox(String name, String value, boolean status, float llx, float lly, float urx, float ury) {
        PdfFormField field2 = PdfFormField.createCheckBox(this.writer);
        this.setCheckBoxParams(field2, name, value, status, llx, lly, urx, ury);
        this.drawCheckBoxAppearences(field2, value, llx, lly, urx, ury);
        this.addFormField(field2);
        return field2;
    }

    public void setCheckBoxParams(PdfFormField field2, String name, String value, boolean status, float llx, float lly, float urx, float ury) {
        field2.setWidget(new Rectangle(llx, lly, urx, ury), PdfAnnotation.HIGHLIGHT_TOGGLE);
        field2.setFieldName(name);
        if (status) {
            field2.setValueAsName(value);
            field2.setAppearanceState(value);
        } else {
            field2.setValueAsName("Off");
            field2.setAppearanceState("Off");
        }
        field2.setFlags(4);
        field2.setPage();
        field2.setBorderStyle(new PdfBorderDictionary(1.0f, 0));
    }

    public void drawCheckBoxAppearences(PdfFormField field2, String value, float llx, float lly, float urx, float ury) {
        BaseFont font = null;
        try {
            font = BaseFont.createFont("ZapfDingbats", "Cp1252", false);
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
        float size = ury - lly;
        PdfAppearance tpOn = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        PdfAppearance tp2 = (PdfAppearance)tpOn.getDuplicate();
        tp2.setFontAndSize(font, size);
        tp2.resetRGBColorFill();
        field2.setDefaultAppearanceString(tp2);
        tpOn.drawTextField(0.0f, 0.0f, urx - llx, ury - lly);
        tpOn.saveState();
        tpOn.resetRGBColorFill();
        tpOn.beginText();
        tpOn.setFontAndSize(font, size);
        tpOn.showTextAligned(1, "4", (urx - llx) / 2.0f, (ury - lly) / 2.0f - size * 0.3f, 0.0f);
        tpOn.endText();
        tpOn.restoreState();
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, value, tpOn);
        PdfAppearance tpOff = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        tpOff.drawTextField(0.0f, 0.0f, urx - llx, ury - lly);
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", tpOff);
    }

    public PdfFormField getRadioGroup(String name, String defaultValue2, boolean noToggleToOff) {
        PdfFormField radio = PdfFormField.createRadioButton(this.writer, noToggleToOff);
        radio.setFieldName(name);
        radio.setValueAsName(defaultValue2);
        return radio;
    }

    public void addRadioGroup(PdfFormField radiogroup) {
        this.addFormField(radiogroup);
    }

    public PdfFormField addRadioButton(PdfFormField radiogroup, String value, float llx, float lly, float urx, float ury) {
        PdfFormField radio = PdfFormField.createEmpty(this.writer);
        radio.setWidget(new Rectangle(llx, lly, urx, ury), PdfAnnotation.HIGHLIGHT_TOGGLE);
        String name = ((PdfName)radiogroup.get(PdfName.V)).toString().substring(1);
        if (name.equals(value)) {
            radio.setAppearanceState(value);
        } else {
            radio.setAppearanceState("Off");
        }
        this.drawRadioAppearences(radio, value, llx, lly, urx, ury);
        radiogroup.addKid(radio);
        return radio;
    }

    public void drawRadioAppearences(PdfFormField field2, String value, float llx, float lly, float urx, float ury) {
        PdfAppearance tpOn = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        tpOn.drawRadioField(0.0f, 0.0f, urx - llx, ury - lly, true);
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, value, tpOn);
        PdfAppearance tpOff = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        tpOff.drawRadioField(0.0f, 0.0f, urx - llx, ury - lly, false);
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, "Off", tpOff);
    }

    public PdfFormField addSelectList(String name, String[] options, String defaultValue2, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField choice = PdfFormField.createList(this.writer, options, 0);
        this.setChoiceParams(choice, name, defaultValue2, llx, lly, urx, ury);
        StringBuffer text = new StringBuffer();
        for (String option : options) {
            text.append(option).append('\n');
        }
        this.drawMultiLineOfText(choice, text.toString(), font, fontSize, llx, lly, urx, ury);
        this.addFormField(choice);
        return choice;
    }

    public PdfFormField addSelectList(String name, String[][] options, String defaultValue2, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField choice = PdfFormField.createList(this.writer, options, 0);
        this.setChoiceParams(choice, name, defaultValue2, llx, lly, urx, ury);
        StringBuffer text = new StringBuffer();
        for (String[] option : options) {
            text.append(option[1]).append('\n');
        }
        this.drawMultiLineOfText(choice, text.toString(), font, fontSize, llx, lly, urx, ury);
        this.addFormField(choice);
        return choice;
    }

    public PdfFormField addComboBox(String name, String[] options, String defaultValue2, boolean editable, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField choice = PdfFormField.createCombo(this.writer, editable, options, 0);
        this.setChoiceParams(choice, name, defaultValue2, llx, lly, urx, ury);
        if (defaultValue2 == null) {
            defaultValue2 = options[0];
        }
        this.drawSingleLineOfText(choice, defaultValue2, font, fontSize, llx, lly, urx, ury);
        this.addFormField(choice);
        return choice;
    }

    public PdfFormField addComboBox(String name, String[][] options, String defaultValue2, boolean editable, BaseFont font, float fontSize, float llx, float lly, float urx, float ury) {
        PdfFormField choice = PdfFormField.createCombo(this.writer, editable, options, 0);
        this.setChoiceParams(choice, name, defaultValue2, llx, lly, urx, ury);
        String value = null;
        for (String[] option : options) {
            if (!option[0].equals(defaultValue2)) continue;
            value = option[1];
            break;
        }
        if (value == null) {
            value = options[0][1];
        }
        this.drawSingleLineOfText(choice, value, font, fontSize, llx, lly, urx, ury);
        this.addFormField(choice);
        return choice;
    }

    public void setChoiceParams(PdfFormField field2, String name, String defaultValue2, float llx, float lly, float urx, float ury) {
        field2.setWidget(new Rectangle(llx, lly, urx, ury), PdfAnnotation.HIGHLIGHT_INVERT);
        if (defaultValue2 != null) {
            field2.setValueAsString(defaultValue2);
            field2.setDefaultValueAsString(defaultValue2);
        }
        field2.setFieldName(name);
        field2.setFlags(4);
        field2.setPage();
        field2.setBorderStyle(new PdfBorderDictionary(2.0f, 0));
    }

    public PdfFormField addSignature(String name, float llx, float lly, float urx, float ury) {
        PdfFormField signature = PdfFormField.createSignature(this.writer);
        this.setSignatureParams(signature, name, llx, lly, urx, ury);
        this.drawSignatureAppearences(signature, llx, lly, urx, ury);
        this.addFormField(signature);
        return signature;
    }

    public void setSignatureParams(PdfFormField field2, String name, float llx, float lly, float urx, float ury) {
        field2.setWidget(new Rectangle(llx, lly, urx, ury), PdfAnnotation.HIGHLIGHT_INVERT);
        field2.setFieldName(name);
        field2.setFlags(4);
        field2.setPage();
        field2.setMKBorderColor(BaseColor.BLACK);
        field2.setMKBackgroundColor(BaseColor.WHITE);
    }

    public void drawSignatureAppearences(PdfFormField field2, float llx, float lly, float urx, float ury) {
        PdfAppearance tp = PdfAppearance.createAppearance(this.writer, urx - llx, ury - lly);
        tp.setGrayFill(1.0f);
        tp.rectangle(0.0f, 0.0f, urx - llx, ury - lly);
        tp.fill();
        tp.setGrayStroke(0.0f);
        tp.setLineWidth(1.0f);
        tp.rectangle(0.5f, 0.5f, urx - llx - 0.5f, ury - lly - 0.5f);
        tp.closePathStroke();
        tp.saveState();
        tp.rectangle(1.0f, 1.0f, urx - llx - 2.0f, ury - lly - 2.0f);
        tp.clip();
        tp.newPath();
        tp.restoreState();
        field2.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, tp);
    }

    @Override
    public void toPdf(PdfWriter writer, OutputStream os) throws IOException {
        PdfWriter.checkPdfIsoConformance(writer, 15, this);
        super.toPdf(writer, os);
    }
}

