/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser;

import com.itextpdf.text.pdf.parser.ImageRenderInfo;
import com.itextpdf.text.pdf.parser.RenderFilter;
import com.itextpdf.text.pdf.parser.RenderListener;
import com.itextpdf.text.pdf.parser.TextRenderInfo;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiFilteredRenderListener
implements RenderListener {
    private final List<RenderListener> delegates = new ArrayList<RenderListener>();
    private final List<RenderFilter[]> filters = new ArrayList<RenderFilter[]>();

    public <E extends RenderListener> E attachRenderListener(E delegate, RenderFilter ... filterSet) {
        this.delegates.add(delegate);
        this.filters.add(filterSet);
        return delegate;
    }

    @Override
    public void beginTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.beginTextBlock();
        }
    }

    @Override
    public void renderText(TextRenderInfo renderInfo) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            boolean filtersPassed = true;
            for (RenderFilter filter2 : this.filters.get(i)) {
                if (filter2.allowText(renderInfo)) continue;
                filtersPassed = false;
                break;
            }
            if (!filtersPassed) continue;
            this.delegates.get(i).renderText(renderInfo);
        }
    }

    @Override
    public void endTextBlock() {
        for (RenderListener delegate : this.delegates) {
            delegate.endTextBlock();
        }
    }

    @Override
    public void renderImage(ImageRenderInfo renderInfo) {
        for (int i = 0; i < this.delegates.size(); ++i) {
            boolean filtersPassed = true;
            for (RenderFilter filter2 : this.filters.get(i)) {
                if (filter2.allowImage(renderInfo)) continue;
                filtersPassed = false;
                break;
            }
            if (!filtersPassed) continue;
            this.delegates.get(i).renderImage(renderInfo);
        }
    }
}

