/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.impl;

import com.pi4j.io.gpio.GpioController;
import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinAnalogInput;
import com.pi4j.io.gpio.GpioPinAnalogOutput;
import com.pi4j.io.gpio.GpioPinDigitalInput;
import com.pi4j.io.gpio.GpioPinDigitalMultipurpose;
import com.pi4j.io.gpio.GpioPinDigitalOutput;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.GpioPinOutput;
import com.pi4j.io.gpio.GpioPinPwmOutput;
import com.pi4j.io.gpio.GpioPinShutdown;
import com.pi4j.io.gpio.GpioProvider;
import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinMode;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.PinListener;
import com.pi4j.io.gpio.impl.GpioEventMonitorExecutorImpl;
import com.pi4j.io.gpio.impl.GpioPinShutdownImpl;
import com.pi4j.io.gpio.impl.GpioScheduledExecutorImpl;
import com.pi4j.io.gpio.trigger.GpioTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class GpioPinImpl
implements GpioPin,
GpioPinDigitalInput,
GpioPinDigitalOutput,
GpioPinDigitalMultipurpose,
GpioPinAnalogInput,
GpioPinAnalogOutput,
GpioPinPwmOutput,
GpioPinInput,
GpioPinOutput {
    private String name = null;
    private Object tag = null;
    private final GpioProvider provider;
    private final Pin pin;
    private PinListener monitor;
    private final GpioPinShutdownImpl shutdownOptions;
    private final Map<String, String> properties = new ConcurrentHashMap<String, String>();
    private final List<GpioPinListener> listeners = new ArrayList<GpioPinListener>();
    private final List<GpioTrigger> triggers = new ArrayList<GpioTrigger>();
    private final Map<PinState, Integer> debounce = new HashMap<PinState, Integer>();
    protected final int NO_DEBOUCE = 0;

    public GpioPinImpl(GpioController gpio, GpioProvider provider, Pin pin) {
        this.provider = provider;
        this.pin = pin;
        this.shutdownOptions = new GpioPinShutdownImpl();
    }

    @Override
    public Pin getPin() {
        return this.pin;
    }

    @Override
    public GpioProvider getProvider() {
        return this.provider;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        if (this.name == null || this.name.length() == 0) {
            return this.pin.toString();
        }
        return this.name;
    }

    @Override
    public void setTag(Object tag) {
        this.tag = tag;
    }

    @Override
    public Object getTag() {
        return this.tag;
    }

    @Override
    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    @Override
    public boolean hasProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Override
    public String getProperty(String key, String defaultValue2) {
        if (this.properties.containsKey(key)) {
            if (this.properties.get(key) == null || this.properties.get(key).isEmpty()) {
                return defaultValue2;
            }
            return this.properties.get(key);
        }
        return defaultValue2;
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public void removeProperty(String key) {
        if (this.properties.containsKey(key)) {
            this.properties.remove(key);
        }
    }

    @Override
    public void clearProperties() {
        this.properties.clear();
    }

    @Override
    public void export(PinMode mode) {
        this.provider.export(this.pin, mode);
    }

    @Override
    public void export(PinMode mode, PinState defaultState) {
        this.provider.export(this.pin, mode, defaultState);
    }

    @Override
    public void unexport() {
        this.provider.unexport(this.pin);
    }

    @Override
    public boolean isExported() {
        return this.provider.isExported(this.pin);
    }

    @Override
    public void setMode(PinMode mode) {
        this.provider.setMode(this.pin, mode);
    }

    @Override
    public PinMode getMode() {
        return this.provider.getMode(this.pin);
    }

    @Override
    public boolean isMode(PinMode mode) {
        return this.getMode() == mode;
    }

    @Override
    public void setPullResistance(PinPullResistance resistance) {
        this.provider.setPullResistance(this.pin, resistance);
    }

    @Override
    public PinPullResistance getPullResistance() {
        return this.provider.getPullResistance(this.pin);
    }

    @Override
    public boolean isPullResistance(PinPullResistance resistance) {
        return this.getPullResistance() == resistance;
    }

    @Override
    public void high() {
        this.setState(PinState.HIGH);
    }

    @Override
    public void low() {
        this.setState(PinState.LOW);
    }

    @Override
    public void toggle() {
        if (this.getState() == PinState.HIGH) {
            this.setState(PinState.LOW);
        } else {
            this.setState(PinState.HIGH);
        }
    }

    @Override
    public Future<?> blink(long delay) {
        return this.blink(delay, PinState.HIGH);
    }

    @Override
    public Future<?> blink(long delay, TimeUnit timeUnit) {
        return this.blink(delay, PinState.HIGH, timeUnit);
    }

    @Override
    public Future<?> blink(long delay, PinState blinkState) {
        return this.blink(delay, 0L, blinkState);
    }

    @Override
    public Future<?> blink(long delay, PinState blinkState, TimeUnit timeUnit) {
        return this.blink(delay, 0L, blinkState, timeUnit);
    }

    @Override
    public Future<?> blink(long delay, long duration) {
        return this.blink(delay, duration, PinState.HIGH);
    }

    @Override
    public Future<?> blink(long delay, long duration, TimeUnit timeUnit) {
        return this.blink(delay, duration, PinState.HIGH, timeUnit);
    }

    @Override
    public Future<?> blink(long delay, long duration, PinState blinkState) {
        return GpioScheduledExecutorImpl.blink(this, delay, duration, blinkState, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> blink(long delay, long duration, PinState blinkState, TimeUnit timeUnit) {
        return GpioScheduledExecutorImpl.blink(this, delay, duration, blinkState, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration) {
        return this.pulse(duration, false);
    }

    @Override
    public Future<?> pulse(long duration, TimeUnit timeUnit) {
        return this.pulse(duration, false, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, Callable<Void> callback) {
        return this.pulse(duration, false, callback);
    }

    @Override
    public Future<?> pulse(long duration, Callable<Void> callback, TimeUnit timeUnit) {
        return this.pulse(duration, false, callback, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState) {
        return this.pulse(duration, pulseState, false);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, TimeUnit timeUnit) {
        return this.pulse(duration, pulseState, false, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, Callable<Void> callback) {
        return this.pulse(duration, pulseState, false, callback);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, Callable<Void> callback, TimeUnit timeUnit) {
        return this.pulse(duration, pulseState, false, callback, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking) {
        return this.pulse(duration, PinState.HIGH, blocking);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking, TimeUnit timeUnit) {
        return this.pulse(duration, PinState.HIGH, blocking, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking, Callable<Void> callback) {
        return this.pulse(duration, PinState.HIGH, blocking, callback);
    }

    @Override
    public Future<?> pulse(long duration, boolean blocking, Callable<Void> callback, TimeUnit timeUnit) {
        return this.pulse(duration, PinState.HIGH, blocking, callback, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, boolean blocking) {
        return this.pulse(duration, pulseState, blocking, null, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, boolean blocking, TimeUnit timeUnit) {
        return this.pulse(duration, pulseState, blocking, null, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, boolean blocking, Callable<Void> callback, TimeUnit timeUnit) {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Pulse duration must be greater than 0 milliseconds.");
        }
        if (blocking) {
            this.setState(pulseState);
            try {
                Thread.sleep(duration);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Pulse blocking thread interrupted.", e);
            }
            this.setState(PinState.getInverseState(pulseState));
            if (callback != null) {
                try {
                    callback.call();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return null;
        }
        return GpioScheduledExecutorImpl.pulse(this, duration, pulseState, callback, timeUnit);
    }

    @Override
    public Future<?> pulse(long duration, PinState pulseState, boolean blocking, Callable<Void> callback) {
        return this.pulse(duration, pulseState, blocking, callback, TimeUnit.MILLISECONDS);
    }

    @Override
    public void pulseSync(long duration) throws InterruptedException {
        this.pulseSync(duration, PinState.HIGH, TimeUnit.MILLISECONDS);
    }

    @Override
    public void pulseSync(long duration, TimeUnit timeUnit) throws InterruptedException {
        this.pulseSync(duration, PinState.HIGH, timeUnit);
    }

    @Override
    public void pulseSync(long duration, PinState pulseState) throws InterruptedException {
        this.pulseSync(duration, pulseState, TimeUnit.MILLISECONDS);
    }

    @Override
    public void pulseSync(long duration, PinState pulseState, TimeUnit timeUnit) throws InterruptedException {
        if (duration <= 0L) {
            throw new IllegalArgumentException("Pulse duration must be greater than 0 milliseconds.");
        }
        this.setState(pulseState);
        Thread.sleep(duration);
        this.setState(PinState.getInverseState(pulseState));
    }

    @Override
    public void setState(PinState state) {
        this.provider.setState(this.pin, state);
    }

    @Override
    public void setState(boolean state) {
        this.provider.setState(this.pin, state ? PinState.HIGH : PinState.LOW);
    }

    @Override
    public boolean isHigh() {
        return this.getState() == PinState.HIGH;
    }

    @Override
    public boolean isLow() {
        return this.getState() == PinState.LOW;
    }

    @Override
    public PinState getState() {
        return this.provider.getState(this.pin);
    }

    @Override
    public boolean isState(PinState state) {
        return this.getState() == state;
    }

    @Override
    public boolean hasDebounce(PinState state) {
        return this.getDebounce(state) > 0;
    }

    @Override
    public int getDebounce(PinState state) {
        if (this.debounce.containsKey((Object)state)) {
            return this.debounce.get((Object)state);
        }
        return 0;
    }

    @Override
    public void setDebounce(int debounce, PinState ... state) {
        for (PinState ps : state) {
            this.debounce.put(ps, new Integer(debounce));
        }
    }

    @Override
    public void setDebounce(int debounce) {
        this.setDebounce(debounce, PinState.HIGH, PinState.LOW);
    }

    @Override
    public void setValue(double value) {
        this.provider.setValue(this.pin, value);
    }

    @Override
    public void setValue(Number value) {
        this.setValue(value.doubleValue());
    }

    @Override
    public double getValue() {
        return this.provider.getValue(this.pin);
    }

    @Override
    public void setPwm(int value) {
        this.provider.setPwm(this.pin, value);
    }

    @Override
    public void setPwmRange(int range) {
        this.provider.setPwmRange(this.pin, range);
    }

    @Override
    public int getPwm() {
        return this.provider.getPwm(this.pin);
    }

    private synchronized void updateInterruptListener() {
        if (this.listeners.size() > 0 || this.triggers.size() > 0) {
            if (this.monitor == null) {
                this.monitor = new GpioEventMonitorExecutorImpl(this);
                this.provider.addListener(this.pin, this.monitor);
            }
        } else if (this.monitor != null) {
            this.provider.removeListener(this.pin, this.monitor);
            this.monitor = null;
        }
    }

    @Override
    public synchronized void addListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        Collections.addAll(this.listeners, listener);
        this.updateInterruptListener();
    }

    @Override
    public synchronized void addListener(List<? extends GpioPinListener> listeners) {
        for (GpioPinListener gpioPinListener : listeners) {
            this.addListener(gpioPinListener);
        }
    }

    @Override
    public synchronized Collection<GpioPinListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean hasListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (GpioPinListener lsnr : listener) {
            if (this.listeners.contains(lsnr)) continue;
            return false;
        }
        return true;
    }

    @Override
    public synchronized void removeListener(GpioPinListener ... listener) {
        if (listener == null || listener.length == 0) {
            throw new IllegalArgumentException("Missing listener argument.");
        }
        for (GpioPinListener lsnr : listener) {
            this.listeners.remove(lsnr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void removeListener(List<? extends GpioPinListener> listeners) {
        for (GpioPinListener gpioPinListener : listeners) {
            this.removeListener(gpioPinListener);
        }
    }

    @Override
    public synchronized void removeAllListeners() {
        ArrayList<GpioPinListener> listeners_copy = new ArrayList<GpioPinListener>(this.listeners);
        for (int index = listeners_copy.size() - 1; index >= 0; --index) {
            GpioPinListener listener = (GpioPinListener)listeners_copy.get(index);
            this.removeListener(listener);
        }
    }

    @Override
    public synchronized Collection<GpioTrigger> getTriggers() {
        return this.triggers;
    }

    @Override
    public synchronized void addTrigger(GpioTrigger ... trigger) {
        if (trigger == null || trigger.length == 0) {
            throw new IllegalArgumentException("Missing trigger argument.");
        }
        Collections.addAll(this.triggers, trigger);
        this.updateInterruptListener();
    }

    @Override
    public synchronized void addTrigger(List<? extends GpioTrigger> triggers) {
        for (GpioTrigger gpioTrigger : triggers) {
            this.addTrigger(gpioTrigger);
        }
    }

    @Override
    public synchronized void removeTrigger(GpioTrigger ... trigger) {
        if (trigger == null || trigger.length == 0) {
            throw new IllegalArgumentException("Missing trigger argument.");
        }
        for (GpioTrigger trgr : trigger) {
            this.triggers.remove(trgr);
        }
        this.updateInterruptListener();
    }

    @Override
    public synchronized void removeTrigger(List<? extends GpioTrigger> triggers) {
        for (GpioTrigger gpioTrigger : triggers) {
            this.removeTrigger(gpioTrigger);
        }
    }

    @Override
    public synchronized void removeAllTriggers() {
        ArrayList<GpioTrigger> triggers_copy = new ArrayList<GpioTrigger>(this.triggers);
        for (int index = triggers_copy.size() - 1; index >= 0; --index) {
            GpioTrigger trigger = (GpioTrigger)triggers_copy.get(index);
            this.removeTrigger(trigger);
        }
    }

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return String.format("\"%s\" <%s>", this.name, this.pin.toString());
        }
        return this.pin.toString();
    }

    @Override
    public GpioPinShutdown getShutdownOptions() {
        return this.shutdownOptions;
    }

    @Override
    public void setShutdownOptions(GpioPinShutdown options) {
        this.shutdownOptions.setUnexport(options.getUnexport());
        this.shutdownOptions.setState(options.getState());
        this.shutdownOptions.setMode(options.getMode());
        this.shutdownOptions.setPullResistor(options.getPullResistor());
    }

    @Override
    public void setShutdownOptions(Boolean unexport) {
        this.setShutdownOptions(unexport, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state) {
        this.setShutdownOptions(unexport, state, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance) {
        this.setShutdownOptions(unexport, state, resistance, null);
    }

    @Override
    public void setShutdownOptions(Boolean unexport, PinState state, PinPullResistance resistance, PinMode mode) {
        this.shutdownOptions.setUnexport(unexport);
        this.shutdownOptions.setState(state);
        this.shutdownOptions.setMode(mode);
        this.shutdownOptions.setPullResistor(resistance);
    }
}

