/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.i2c;

import com.pi4j.io.i2c.I2CBus;
import com.pi4j.io.i2c.I2CFactoryProvider;
import com.pi4j.io.i2c.impl.I2CProviderImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class I2CFactory {
    public static final long DEFAULT_LOCKAQUIRE_TIMEOUT = 1000L;
    public static final TimeUnit DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS = TimeUnit.MILLISECONDS;
    static volatile I2CFactoryProvider provider = new I2CProviderImpl();

    private I2CFactory() {
    }

    public static I2CBus getInstance(int busNumber) throws UnsupportedBusNumberException, IOException {
        return provider.getBus(busNumber, 1000L, DEFAULT_LOCKAQUIRE_TIMEOUT_UNITS);
    }

    public static I2CBus getInstance(int busNumber, long lockAquireTimeout, TimeUnit lockAquireTimeoutUnit) throws UnsupportedBusNumberException, IOException {
        return provider.getBus(busNumber, lockAquireTimeout, lockAquireTimeoutUnit);
    }

    public static void setFactory(I2CFactoryProvider factoryProvider) {
        provider = factoryProvider;
    }

    public static int[] getBusIds() throws IOException {
        HashSet<Integer> set = null;
        for (Path device : Files.newDirectoryStream(Paths.get("/sys/bus/i2c/devices", new String[0]), "*")) {
            String[] tokens = device.toString().split("-");
            if (tokens.length != 2) continue;
            if (set == null) {
                set = new HashSet<Integer>();
            }
            set.add(Integer.valueOf(tokens[1]));
        }
        int[] result2 = null;
        if (set != null) {
            int counter = 0;
            result2 = new int[set.size()];
            for (Integer value : set) {
                result2[counter] = value;
                ++counter;
            }
        }
        return result2;
    }

    public static class UnsupportedBusNumberException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

