/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.serial;

import com.pi4j.io.gpio.exception.UnsupportedBoardType;
import com.pi4j.system.SystemInfo;
import java.io.File;
import java.io.IOException;

public class SerialPort {
    public static String getDefaultPort() throws IOException, InterruptedException, UnsupportedBoardType {
        return SerialPort.getDefaultPort(SystemInfo.getBoardType());
    }

    public static String getDefaultPort(SystemInfo.BoardType board) throws UnsupportedBoardType {
        switch (board) {
            case RaspberryPi_A: 
            case RaspberryPi_B_Rev1: 
            case RaspberryPi_B_Rev2: 
            case RaspberryPi_A_Plus: 
            case RaspberryPi_B_Plus: 
            case RaspberryPi_ComputeModule: 
            case RaspberryPi_2B: 
            case RaspberryPi_Zero: 
            case RaspberryPi_ComputeModule3: 
            case RaspberryPi_Alpha: 
            case RaspberryPi_Unknown: {
                return "/dev/ttyAMA0";
            }
            case RaspberryPi_ZeroW: 
            case RaspberryPi_3B: 
            case RaspberryPi_3B_Plus: 
            case RaspberryPi_3A_Plus: 
            case RaspberryPi_4B: 
            case RaspberryPi_400: 
            case RaspberryPi_ComputeModule4: {
                File s0ComPort = new File("/dev/ttyS0");
                if (s0ComPort.exists()) {
                    return "/dev/ttyS0";
                }
                return "/dev/ttyAMA0";
            }
            case UNKNOWN: {
                break;
            }
        }
        throw new UnsupportedBoardType();
    }
}

