/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import com.pi4j.io.gpio.Pin;
import com.pi4j.io.gpio.PinProvider;
import com.pi4j.io.gpio.PinPullResistance;
import com.pi4j.io.serial.Baud;
import com.pi4j.io.serial.DataBits;
import com.pi4j.io.serial.FlowControl;
import com.pi4j.io.serial.Parity;
import com.pi4j.io.serial.SerialConfig;
import com.pi4j.io.serial.StopBits;
import java.lang.reflect.Method;

public class CommandArgumentParser {
    public static Pin getPin(Class<? extends PinProvider> pinProviderClass, Pin defaultPin, String ... args) {
        for (int index = 0; index < args.length - 1; ++index) {
            if (!args[index].toLowerCase().equals("--pin") && !args[index].toLowerCase().equals("-p")) continue;
            try {
                int pinAddress = Integer.parseInt(args[index + 1]);
                Method m = pinProviderClass.getDeclaredMethod("getPinByAddress", Integer.TYPE);
                Object pin = m.invoke(null, pinAddress);
                return (Pin)pin;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        return defaultPin;
    }

    public static PinPullResistance getPinPullResistance(PinPullResistance defaultPull, String ... args) {
        for (int index = 0; index < args.length; ++index) {
            if (args[index].toLowerCase().equals("--up")) {
                return PinPullResistance.PULL_UP;
            }
            if (args[index].toLowerCase().equals("--down")) {
                return PinPullResistance.PULL_DOWN;
            }
            if (!args[index].toLowerCase().equals("--pull") && !args[index].toLowerCase().equals("-l") || index >= args.length - 1) continue;
            String pull = args[index + 1].toLowerCase();
            if (pull.equals("up")) {
                return PinPullResistance.PULL_UP;
            }
            if (pull.equals("1")) {
                return PinPullResistance.PULL_UP;
            }
            if (pull.equals("down")) {
                return PinPullResistance.PULL_DOWN;
            }
            if (pull.equals("0")) {
                return PinPullResistance.PULL_DOWN;
            }
            return PinPullResistance.OFF;
        }
        return defaultPull;
    }

    public static SerialConfig getSerialConfig(SerialConfig defaultConfig, String ... args) {
        for (int index = 0; index < args.length - 1; ++index) {
            if (args[index].toLowerCase().equals("--device")) {
                defaultConfig.device(args[index + 1]);
                ++index;
                continue;
            }
            if (args[index].toLowerCase().equals("--baud")) {
                defaultConfig.baud(Baud.getInstance(Integer.parseInt(args[index + 1])));
                ++index;
                continue;
            }
            if (args[index].toLowerCase().equals("--data-bits")) {
                defaultConfig.dataBits(DataBits.getInstance(Integer.parseInt(args[index + 1])));
                ++index;
                continue;
            }
            if (args[index].toLowerCase().equals("--parity")) {
                defaultConfig.parity(Parity.getInstance(args[index + 1]));
                ++index;
                continue;
            }
            if (args[index].toLowerCase().equals("--stop-bits")) {
                defaultConfig.stopBits(StopBits.getInstance(Integer.parseInt(args[index + 1])));
                ++index;
                continue;
            }
            if (!args[index].toLowerCase().equals("--flow-control")) continue;
            defaultConfig.flowControl(FlowControl.getInstance(args[index + 1]));
            ++index;
        }
        return defaultConfig;
    }
}

