/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.util;

import com.pi4j.platform.Platform;
import com.pi4j.util.StringUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeLibraryLoader {
    private static final Set<String> loadedLibraries = new TreeSet<String>();
    private static final Logger logger = Logger.getLogger(NativeLibraryLoader.class.getName());
    private static boolean initialized;

    private NativeLibraryLoader() {
    }

    public static synchronized void load(String fileName, String libName) {
        String osArch;
        if (!initialized) {
            initialized = true;
            if (System.getProperty("pi4j.debug") != null) {
                logger.setLevel(Level.ALL);
                try {
                    FileHandler fileHandler = new FileHandler("pi4j.log");
                    fileHandler.setLevel(Level.ALL);
                    ConsoleHandler consoleHandler = new ConsoleHandler();
                    consoleHandler.setLevel(Level.ALL);
                    logger.addHandler(fileHandler);
                    logger.addHandler(consoleHandler);
                }
                catch (IOException e) {
                    System.err.println("Unable to setup logging to debug. No logging will be done. Error: ");
                    e.printStackTrace();
                }
            }
        }
        if (loadedLibraries.contains(fileName)) {
            logger.fine("Library [" + fileName + "] has already been loaded; no need to load again.");
            return;
        }
        loadedLibraries.add(fileName);
        String libPath = System.getProperty("pi4j.library.path");
        if (StringUtil.isNotNullOrEmpty(libPath, true)) {
            String path;
            if (libPath.equalsIgnoreCase("system")) {
                logger.fine("Attempting to load library using {pi4j.library.path} system resolved library name: [" + libName + "]");
                try {
                    System.loadLibrary(libName);
                }
                catch (Exception ex) {
                    throw new UnsatisfiedLinkError("Pi4J was unable load the native library [" + libName + "] from the system defined library path.  The system property 'pi4j.library.path' is defined as [" + libPath + "]. You can alternatively define the 'pi4j.library.path' system property to override this behavior and specify an absolute library path.; UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
                }
            }
            if (libPath.equalsIgnoreCase("local")) {
                try {
                    libPath = NativeLibraryLoader.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
                }
                catch (URISyntaxException e) {
                    logger.severe(e.getMessage());
                    libPath = ".";
                }
                path = Paths.get(libPath, fileName).toString();
                logger.fine("Attempting to load library using {pi4j.library.path} defined path: [" + path + "]");
                try {
                    System.load(path);
                }
                catch (Exception ex) {
                    throw new UnsatisfiedLinkError("Pi4J was unable load the native library [" + libName + "] from the user defined library path.  The system property 'pi4j.library.path' is defined as [" + libPath + "]. Please make sure the defined the 'pi4j.library.path' system property contains the correct absolute library path.; UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
                }
            }
            path = Paths.get(libPath, fileName).toString();
            logger.fine("Attempting to load library using {pi4j.library.path} defined path: [" + path + "]");
            try {
                System.load(path);
            }
            catch (Exception ex) {
                throw new UnsatisfiedLinkError("Pi4J was unable load the native library [" + libName + "] from the user defined library path.  The system property 'pi4j.library.path' is defined as [" + libPath + "]. Please make sure the defined the 'pi4j.library.path' system property contains the correct absolute library path.; UNDERLYING EXCEPTION: [" + ex.getClass().getName() + "]=" + ex.getMessage());
            }
        }
        String platform = System.getProperty("pi4j.platform", Platform.RASPBERRYPI.getId());
        String linking = System.getProperty("pi4j.linking", platform.equalsIgnoreCase(Platform.RASPBERRYPI.getId()) ? "dynamic" : "static");
        switch (osArch = System.getProperty("os.arch")) {
            case "arm": {
                osArch = "armhf";
                break;
            }
            case "aarch64": {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown os.arch value " + osArch);
            }
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(".so"));
        String path = "/lib/" + platform + "/" + linking + "/" + fileName + "-" + osArch + ".so";
        logger.fine("Attempting to load [" + fileName + "] using path: [" + path + "]");
        try {
            NativeLibraryLoader.loadLibraryFromClasspath(path);
            logger.fine("Library [" + fileName + "] loaded successfully using embedded resource file: [" + path + "]");
        }
        catch (Exception | UnsatisfiedLinkError e) {
            logger.log(Level.SEVERE, "Unable to load [" + fileName + "] using path: [" + path + "]", e);
        }
    }

    public static void loadLibraryFromClasspath(String path) throws IOException {
        Path inputPath = Paths.get(path, new String[0]);
        if (!inputPath.isAbsolute()) {
            throw new IllegalArgumentException("The path has to be absolute, but found: " + inputPath);
        }
        String fileNameFull = inputPath.getFileName().toString();
        int dotIndex = fileNameFull.indexOf(46);
        if (dotIndex < 0 || dotIndex >= fileNameFull.length() - 1) {
            throw new IllegalArgumentException("The path has to end with a file name and extension, but found: " + fileNameFull);
        }
        String fileName = fileNameFull.substring(0, dotIndex);
        String extension2 = fileNameFull.substring(dotIndex);
        Path target = Files.createTempFile(fileName, extension2, new FileAttribute[0]);
        File targetFile = target.toFile();
        targetFile.deleteOnExit();
        try (InputStream source = NativeLibraryLoader.class.getResourceAsStream(inputPath.toString());){
            if (source == null) {
                throw new FileNotFoundException("File " + inputPath + " was not found in classpath.");
            }
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        System.load(target.toAbsolutePath().toString());
    }
}

