/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.wiringpi;

import com.pi4j.io.gpio.GpioFactory;
import com.pi4j.util.NativeLibraryLoader;
import com.pi4j.wiringpi.GpioInterruptEvent;
import com.pi4j.wiringpi.GpioInterruptListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class GpioInterrupt {
    private static final Object mutex = new Object();
    private static final LinkedBlockingQueue<GpioEvent> events = new LinkedBlockingQueue();
    private static final List<GpioInterruptListener> listeners = Collections.synchronizedList(new ArrayList());
    private static boolean run;
    private static ExecutorService eventExecutor;
    private static Future<?> eventTask;

    private GpioInterrupt() {
    }

    public static native int enablePinStateChangeCallback(int var0);

    public static native int disablePinStateChangeCallback(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pinStateChangeCallback(int pin, boolean state) {
        Object object = mutex;
        synchronized (object) {
            events.add(new GpioEvent(pin, state));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(GpioInterruptListener listener) {
        Object object = mutex;
        synchronized (object) {
            if (!listeners.contains(listener)) {
                listeners.add(listener);
                if (!run) {
                    GpioInterrupt.enableEventExecutor();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(GpioInterruptListener listener) {
        Object object = mutex;
        synchronized (object) {
            listeners.remove(listener);
            if (run && listeners.isEmpty()) {
                GpioInterrupt.disableEventExecutor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasListener(GpioInterruptListener listener) {
        Object object = mutex;
        synchronized (object) {
            return listeners.contains(listener);
        }
    }

    private static synchronized void enableEventExecutor() {
        if (!run) {
            run = true;
            if (eventExecutor == null) {
                eventExecutor = GpioFactory.getExecutorServiceFactory().getEventExecutorService();
            }
            eventTask = eventExecutor.submit(GpioInterrupt::handleEvents);
        }
    }

    private static void disableEventExecutor() {
        if (run) {
            run = false;
            if (eventTask != null) {
                eventTask.cancel(true);
            }
        }
    }

    public static void shutdown() {
        GpioInterrupt.disableEventExecutor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEvents() {
        while (run) {
            try {
                ArrayList<GpioInterruptListener> listenersClone;
                GpioEvent event = events.take();
                Iterator iterator = mutex;
                synchronized (iterator) {
                    listenersClone = new ArrayList<GpioInterruptListener>(listeners);
                }
                for (GpioInterruptListener listener : listenersClone) {
                    GpioInterruptEvent interruptEvent = new GpioInterruptEvent(listener, event.pin, event.state);
                    listener.pinStateChange(interruptEvent);
                }
            }
            catch (InterruptedException e) {
                if (run) continue;
                return;
            }
        }
    }

    static {
        NativeLibraryLoader.load("libpi4j.so", "pi4j");
    }

    public static class GpioEvent {
        private final int pin;
        private final boolean state;

        public GpioEvent(int pin, boolean state) {
            this.pin = pin;
            this.state = state;
        }
    }
}

