/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.bind.tuple;

import com.sleepycat.bind.tuple.TupleOutput;
import com.sleepycat.util.FastInputStream;
import com.sleepycat.util.PackedInteger;
import com.sleepycat.util.UtfOps;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TupleInput
extends FastInputStream {
    public TupleInput(byte[] buffer) {
        super(buffer);
    }

    public TupleInput(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
    }

    public TupleInput(TupleOutput output) {
        super(output.getBufferBytes(), output.getBufferOffset(), output.getBufferLength());
    }

    public final String readString() throws IndexOutOfBoundsException, IllegalArgumentException {
        byte[] myBuf = this.buf;
        int myOff = this.off;
        if (this.available() >= 2 && myBuf[myOff] == -1 && myBuf[myOff + 1] == 0) {
            this.skip(2L);
            return null;
        }
        int byteLen = UtfOps.getZeroTerminatedByteLength(myBuf, myOff);
        this.skip(byteLen + 1);
        return UtfOps.bytesToString(myBuf, myOff, byteLen);
    }

    public final char readChar() throws IndexOutOfBoundsException {
        return (char)this.readUnsignedShort();
    }

    public final boolean readBoolean() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c != 0;
    }

    public final byte readByte() throws IndexOutOfBoundsException {
        return (byte)(this.readUnsignedByte() ^ 0x80);
    }

    public final short readShort() throws IndexOutOfBoundsException {
        return (short)(this.readUnsignedShort() ^ 0x8000);
    }

    public final int readInt() throws IndexOutOfBoundsException {
        return (int)(this.readUnsignedInt() ^ Integer.MIN_VALUE);
    }

    public final long readLong() throws IndexOutOfBoundsException {
        return this.readUnsignedLong() ^ Long.MIN_VALUE;
    }

    public final float readFloat() throws IndexOutOfBoundsException {
        return Float.intBitsToFloat((int)this.readUnsignedInt());
    }

    public final double readDouble() throws IndexOutOfBoundsException {
        return Double.longBitsToDouble(this.readUnsignedLong());
    }

    public final float readSortedFloat() throws IndexOutOfBoundsException {
        int val;
        return Float.intBitsToFloat(val ^= (val = (int)this.readUnsignedInt()) < 0 ? Integer.MIN_VALUE : -1);
    }

    public final double readSortedDouble() throws IndexOutOfBoundsException {
        long val;
        return Double.longBitsToDouble(val ^= (val = this.readUnsignedLong()) < 0L ? Long.MIN_VALUE : -1L);
    }

    public final int readUnsignedByte() throws IndexOutOfBoundsException {
        int c = this.readFast();
        if (c < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c;
    }

    public final int readUnsignedShort() throws IndexOutOfBoundsException {
        int c2;
        int c1 = this.readFast();
        if ((c1 | (c2 = this.readFast())) < 0) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 8 | c2;
    }

    public final long readUnsignedInt() throws IndexOutOfBoundsException {
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 24 | c2 << 16 | c3 << 8 | c4;
    }

    private final long readUnsignedLong() throws IndexOutOfBoundsException {
        long c8;
        long c7;
        long c6;
        long c5;
        long c4;
        long c3;
        long c2;
        long c1 = this.readFast();
        if ((c1 | (c2 = (long)this.readFast()) | (c3 = (long)this.readFast()) | (c4 = (long)this.readFast()) | (c5 = (long)this.readFast()) | (c6 = (long)this.readFast()) | (c7 = (long)this.readFast()) | (c8 = (long)this.readFast())) < 0L) {
            throw new IndexOutOfBoundsException();
        }
        return c1 << 56 | c2 << 48 | c3 << 40 | c4 << 32 | c5 << 24 | c6 << 16 | c7 << 8 | c8;
    }

    public final String readBytes(int length) throws IndexOutOfBoundsException {
        StringBuilder buf2 = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int c = this.readFast();
            if (c < 0) {
                throw new IndexOutOfBoundsException();
            }
            buf2.append((char)c);
        }
        return buf2.toString();
    }

    public final String readChars(int length) throws IndexOutOfBoundsException {
        StringBuilder buf2 = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            buf2.append(this.readChar());
        }
        return buf2.toString();
    }

    public final void readBytes(char[] chars) throws IndexOutOfBoundsException {
        for (int i = 0; i < chars.length; ++i) {
            int c = this.readFast();
            if (c < 0) {
                throw new IndexOutOfBoundsException();
            }
            chars[i] = (char)c;
        }
    }

    public final void readChars(char[] chars) throws IndexOutOfBoundsException {
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = this.readChar();
        }
    }

    public final String readString(int length) throws IndexOutOfBoundsException, IllegalArgumentException {
        char[] chars = new char[length];
        this.readString(chars);
        return new String(chars);
    }

    public final void readString(char[] chars) throws IndexOutOfBoundsException, IllegalArgumentException {
        this.off = UtfOps.bytesToChars(this.buf, this.off, chars, 0, chars.length, false);
    }

    public final int getStringByteLength() throws IndexOutOfBoundsException, IllegalArgumentException {
        if (this.available() >= 2 && this.buf[this.off] == -1 && this.buf[this.off + 1] == 0) {
            return 2;
        }
        return UtfOps.getZeroTerminatedByteLength(this.buf, this.off) + 1;
    }

    public final int readPackedInt() {
        int len = PackedInteger.getReadIntLength(this.buf, this.off);
        int val = PackedInteger.readInt(this.buf, this.off);
        this.off += len;
        return val;
    }

    public final int getPackedIntByteLength() {
        return PackedInteger.getReadIntLength(this.buf, this.off);
    }

    public final long readPackedLong() {
        int len = PackedInteger.getReadLongLength(this.buf, this.off);
        long val = PackedInteger.readLong(this.buf, this.off);
        this.off += len;
        return val;
    }

    public final int getPackedLongByteLength() {
        return PackedInteger.getReadLongLength(this.buf, this.off);
    }

    public final int readSortedPackedInt() {
        int len = PackedInteger.getReadSortedIntLength(this.buf, this.off);
        int val = PackedInteger.readSortedInt(this.buf, this.off);
        this.off += len;
        return val;
    }

    public final int getSortedPackedIntByteLength() {
        return PackedInteger.getReadSortedIntLength(this.buf, this.off);
    }

    public final long readSortedPackedLong() {
        int len = PackedInteger.getReadSortedLongLength(this.buf, this.off);
        long val = PackedInteger.readSortedLong(this.buf, this.off);
        this.off += len;
        return val;
    }

    public final int getSortedPackedLongByteLength() {
        return PackedInteger.getReadSortedLongLength(this.buf, this.off);
    }

    public final BigInteger readBigInteger() {
        short len = this.readShort();
        if (len < 0) {
            len = -len;
        }
        byte[] a = new byte[len];
        a[0] = this.readByte();
        this.readFast(a, 1, a.length - 1);
        return new BigInteger(a);
    }

    public final int getBigIntegerByteLength() {
        int saveOff = this.off;
        short len = this.readShort();
        this.off = saveOff;
        if (len < 0) {
            len = -len;
        }
        return len + 2;
    }

    public final BigDecimal readBigDecimal() {
        int scale = this.readPackedInt();
        int len = this.readPackedInt();
        byte[] a = new byte[len];
        this.readFast(a, 0, len);
        BigInteger unscaledVal = new BigInteger(a);
        return new BigDecimal(unscaledVal, scale);
    }

    public final int getBigDecimalByteLength() {
        int scaleLen = this.getPackedIntByteLength();
        int saveOff = this.off;
        this.off += scaleLen;
        int lenOfUnscaleValLen = this.getPackedIntByteLength();
        int unscaledValLen = this.readPackedInt();
        this.off = saveOff;
        return scaleLen + lenOfUnscaleValLen + unscaledValLen;
    }

    public final BigDecimal readSortedBigDecimal() {
        byte sign = this.readByte();
        int exponent = this.readSortedPackedInt();
        BigDecimal normalizedVal = this.readSortedNormalizedBigDecimal();
        return normalizedVal.scaleByPowerOfTen(exponent * sign);
    }

    private BigDecimal readSortedNormalizedBigDecimal() {
        int sign;
        StringBuilder valStr = new StringBuilder(32);
        int subVal = this.readSortedPackedInt();
        int n = sign = subVal < 0 ? -1 : 1;
        while (subVal != -1) {
            String groupDigits = Integer.toString(Math.abs(subVal = subVal < 0 ? subVal + 1 : subVal));
            if (groupDigits.length() < 9) {
                int insertLen = 9 - groupDigits.length();
                for (int i = 0; i < insertLen; ++i) {
                    valStr.append("0");
                }
            }
            valStr.append(groupDigits);
            subVal = this.readSortedPackedInt();
        }
        BigInteger digitsVal = new BigInteger(valStr.toString());
        if (sign < 0) {
            digitsVal = digitsVal.negate();
        }
        int scale = valStr.length() - 1;
        return new BigDecimal(digitsVal, scale).stripTrailingZeros();
    }

    public final int getSortedBigDecimalByteLength() {
        int saveOff = this.off++;
        int len = this.getSortedPackedIntByteLength();
        this.off += len;
        int subVal = this.readSortedPackedInt();
        while (subVal != -1) {
            subVal = this.readSortedPackedInt();
        }
        len = this.off - saveOff;
        this.off = saveOff;
        return len;
    }
}

