/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.collections.StoredMapEntry;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import java.util.Map;
import java.util.Set;

public class StoredEntrySet<K, V>
extends StoredCollection<Map.Entry<K, V>>
implements Set<Map.Entry<K, V>> {
    StoredEntrySet(DataView mapView) {
        super(mapView);
    }

    @Override
    public boolean add(Map.Entry<K, V> mapEntry) {
        return this.add(mapEntry.getKey(), mapEntry.getValue());
    }

    @Override
    public boolean remove(Object mapEntry) {
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            Map.Entry entry = (Map.Entry)mapEntry;
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), true);
            if (status == OperationStatus.SUCCESS) {
                cursor.delete();
            }
            this.closeCursor(cursor);
            this.commitAutoCommit(doAutoCommit);
            return status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean contains(Object mapEntry) {
        boolean bl;
        if (!(mapEntry instanceof Map.Entry)) {
            return false;
        }
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            Map.Entry entry = (Map.Entry)mapEntry;
            OperationStatus status = cursor.findBoth(entry.getKey(), entry.getValue(), false);
            bl = status == OperationStatus.SUCCESS;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return bl;
    }

    @Override
    public String toString() {
        StringBuilder buf2 = new StringBuilder();
        buf2.append("[");
        StoredIterator i = null;
        try {
            Object entry;
            i = this.storedIterator();
            while (i.hasNext()) {
                entry = (Map.Entry)i.next();
                if (buf2.length() > 1) {
                    buf2.append(',');
                }
                Object key = entry.getKey();
                Object val = entry.getValue();
                if (key != null) {
                    buf2.append(key.toString());
                }
                buf2.append('=');
                if (val == null) continue;
                buf2.append(val.toString());
            }
            buf2.append(']');
            entry = buf2.toString();
            return entry;
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
        finally {
            StoredIterator.close(i);
        }
    }

    @Override
    Map.Entry<K, V> makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return new StoredMapEntry(this.view.makeKey(keyEntry, priKeyEntry), this.view.makeValue(priKeyEntry, valueEntry), this, iterator);
    }

    @Override
    boolean hasValues() {
        return true;
    }
}

