/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DuplicateDataException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.OperationResult;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.ExpirationInfo;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.dbi.RangeConstraint;
import com.sleepycat.je.dbi.RecordVersion;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINBoundary;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.StorageSize;
import com.sleepycat.je.tree.TrackingInfo;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockInfo;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.LockerFactory;
import com.sleepycat.je.txn.WriteLockInfo;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.Pair;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class CursorImpl
implements Cloneable {
    private static final boolean DEBUG = false;
    private static final byte CURSOR_NOT_INITIALIZED = 1;
    private static final byte CURSOR_INITIALIZED = 2;
    private static final byte CURSOR_CLOSED = 3;
    private static final String TRACE_DELETE = "Delete";
    private static final String TRACE_MOD = "Mod:";
    private static final String TRACE_INSERT = "Ins:";
    public static final int FOUND = 1;
    public static final int EXACT_KEY = 2;
    public static final int FOUND_LAST = 4;
    private static long lastAllocatedId = 0L;
    private final int thisId = (int)CursorImpl.getNextCursorId();
    private final DatabaseImpl dbImpl;
    private Locker locker;
    private final boolean retainNonTxnLocks;
    private final boolean isSecondaryCursor;
    private volatile BIN bin = null;
    private volatile int index = -1;
    private byte status;
    private CacheMode cacheMode;
    private boolean allowEviction;
    private BIN priorBIN;
    private RecordVersion currentRecordVersion;
    private int storageSize;
    private int priStorageSize;
    private int nSecWrites;
    private ThreadLocal<TreeWalkerStatsAccumulator> treeStatsAccumulatorTL;
    private TestHook testHook;

    public CursorImpl(DatabaseImpl database, Locker locker) {
        this(database, locker, true, false);
    }

    public CursorImpl(DatabaseImpl dbImpl, Locker locker, boolean retainNonTxnLocks, boolean isSecondaryCursor) {
        this.retainNonTxnLocks = retainNonTxnLocks;
        this.isSecondaryCursor = isSecondaryCursor;
        this.dbImpl = dbImpl;
        this.locker = locker;
        this.locker.registerCursor(this);
        this.cacheMode = CacheMode.DEFAULT;
        this.status = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CursorImpl cloneCursor(boolean samePosition) {
        assert (this.assertCursorState(false, false));
        CursorImpl ret = null;
        try {
            this.latchBIN();
            ret = (CursorImpl)super.clone();
            if (!this.retainNonTxnLocks) {
                ret.locker = this.locker.newNonTxnLocker();
            }
            ret.locker.registerCursor(ret);
            if (samePosition) {
                ret.addCursor();
            } else {
                ret.clear();
            }
        }
        catch (CloneNotSupportedException cannotOccur) {
            CursorImpl cursorImpl = null;
            return cursorImpl;
        }
        finally {
            this.releaseBIN();
        }
        this.criticalEviction();
        return ret;
    }

    private static long getNextCursorId() {
        return ++lastAllocatedId;
    }

    public int hashCode() {
        return this.thisId;
    }

    public Locker getLocker() {
        return this.locker;
    }

    public void setClosingLocker(CursorImpl closingCursor) {
        if (!this.retainNonTxnLocks && this.locker != closingCursor.locker) {
            this.locker.setClosingLocker(closingCursor.locker);
        }
    }

    public void clearClosingLocker() {
        this.locker.setClosingLocker(null);
    }

    public CacheMode getCacheMode() {
        return this.cacheMode;
    }

    public void setCacheMode(CacheMode mode) {
        this.cacheMode = mode;
    }

    public void setTreeStatsAccumulator(TreeWalkerStatsAccumulator tSA) {
        this.maybeInitTreeStatsAccumulator();
        this.treeStatsAccumulatorTL.set(tSA);
    }

    private void maybeInitTreeStatsAccumulator() {
        if (this.treeStatsAccumulatorTL == null) {
            this.treeStatsAccumulatorTL = new ThreadLocal();
        }
    }

    private TreeWalkerStatsAccumulator getTreeStatsAccumulator() {
        if (EnvironmentImpl.getThreadLocalReferenceCount() > 0) {
            this.maybeInitTreeStatsAccumulator();
            return this.treeStatsAccumulatorTL.get();
        }
        return null;
    }

    public void incrementLNCount() {
        TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
        if (treeStatsAccumulator != null) {
            treeStatsAccumulator.incrementLNCount();
        }
    }

    public int getIndex() {
        return this.index;
    }

    public BIN getBIN() {
        return this.bin;
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public void setOnFirstSlot() {
        assert (this.bin.isLatchOwner());
        this.index = 0;
    }

    public void setOnLastSlot() {
        assert (this.bin.isLatchOwner());
        this.index = this.bin.getNEntries() - 1;
    }

    public boolean isOnBIN(BIN bin) {
        return this.bin == bin;
    }

    public void assertBIN(BIN bin) {
        assert (this.bin == bin) : "nodeId=" + bin.getNodeId() + " cursor=" + this.dumpToString(true);
    }

    public boolean isOnSamePosition(CursorImpl other) {
        return this.bin == other.bin && this.index == other.index;
    }

    public void setBIN(BIN newBin) {
        this.bin = newBin;
    }

    public void latchBIN() {
        while (this.bin != null) {
            BIN waitingOn = this.bin;
            waitingOn.latch(this.cacheMode);
            if (this.bin == waitingOn) {
                return;
            }
            waitingOn.releaseLatch();
        }
    }

    public void releaseBIN() {
        if (this.bin != null) {
            this.bin.releaseLatchIfOwner();
        }
    }

    void addCursor(BIN bin) {
        if (bin != null) {
            assert (bin.isLatchExclusiveOwner());
            bin.addCursor(this);
        }
    }

    void addCursor() {
        if (this.bin != null) {
            this.addCursor(this.bin);
        }
    }

    private void setPosition(BIN newBin, int newIndex) {
        if (this.bin != newBin) {
            if (this.bin != null) {
                this.latchBIN();
                this.bin.removeCursor(this);
                this.bin.releaseLatch();
            }
            this.setBIN(newBin);
            this.addCursor();
        }
        this.setIndex(newIndex);
    }

    public long getCurrentNodeId() {
        BIN b = this.bin;
        return b == null ? -1L : b.getNodeId();
    }

    public long getCurrentLsn() {
        assert (this.bin != null && this.bin.isLatchOwner());
        assert (this.index >= 0 && this.index < this.bin.getNEntries());
        return this.bin.getLsn(this.index);
    }

    public byte[] getCurrentKey() {
        return this.getCurrentKey(false);
    }

    public byte[] getCurrentKey(boolean isLatched) {
        if (!isLatched) {
            this.latchBIN();
        }
        try {
            assert (this.bin != null);
            assert (this.index >= 0 && this.index < this.bin.getNEntries());
            byte[] byArray = this.bin.getKey(this.index);
            return byArray;
        }
        finally {
            if (!isLatched) {
                this.releaseBIN();
            }
        }
    }

    public boolean isProbablyExpired() {
        this.latchBIN();
        try {
            boolean bl = this.bin.isProbablyExpired(this.index);
            return bl;
        }
        finally {
            this.releaseBIN();
        }
    }

    public long getExpirationTime() {
        this.latchBIN();
        try {
            long l2 = TTL.expirationToSystemTime(this.bin.getExpiration(this.index), this.bin.isExpirationInHours());
            return l2;
        }
        finally {
            this.releaseBIN();
        }
    }

    private void setInitialized() {
        this.status = (byte)2;
    }

    public boolean isClosed() {
        return this.status == 3;
    }

    public boolean isNotInitialized() {
        return this.status == 1;
    }

    public boolean isInternalDbCursor() {
        return this.dbImpl.isInternalDb();
    }

    public boolean hasDuplicates() {
        return this.dbImpl.getSortedDuplicates();
    }

    public void beforeNonStickyOp() {
        if (this.cacheMode != CacheMode.DEFAULT && this.cacheMode != CacheMode.KEEP_HOT) {
            this.latchBIN();
            try {
                this.performCacheModeLNEviction();
            }
            finally {
                this.releaseBIN();
            }
        }
        this.releaseNonTxnLocks();
        this.criticalEviction();
    }

    public void afterNonStickyOp() {
        this.performPriorBINEviction();
        if (this.priorBIN == null) {
            this.priorBIN = this.bin;
        }
        this.criticalEviction();
    }

    public void reset() {
        this.removeCursorAndPerformCacheEviction(null);
        this.releaseNonTxnLocks();
        this.criticalEviction();
    }

    private void clear() {
        this.bin = null;
        this.index = -1;
        this.status = 1;
        this.currentRecordVersion = null;
        this.storageSize = 0;
        this.priStorageSize = 0;
        this.nSecWrites = 0;
        this.priorBIN = null;
    }

    private void releaseNonTxnLocks() {
        if (!this.retainNonTxnLocks) {
            this.locker.releaseNonTxnLocks();
        }
    }

    public void close() {
        this.close(null);
    }

    public void close(CursorImpl newCursor) {
        assert (this.assertCursorState(false, false));
        this.removeCursorAndPerformCacheEviction(newCursor);
        this.locker.unRegisterCursor(this);
        if (!this.retainNonTxnLocks) {
            this.locker.nonTxnOperationEnd();
        }
        this.status = (byte)3;
        this.criticalEviction();
    }

    private void removeCursorAndPerformCacheEviction(CursorImpl newCursor) {
        this.performPriorBINEviction();
        this.latchBIN();
        if (this.bin == null) {
            this.clear();
            return;
        }
        try {
            this.bin.removeCursor(this);
            this.performCacheModeEviction(newCursor);
        }
        finally {
            this.releaseBIN();
            this.clear();
        }
    }

    private void performPriorBINEviction() {
        if (this.priorBIN == null || this.priorBIN == this.bin) {
            return;
        }
        BIN binToEvict = this.priorBIN;
        this.priorBIN = null;
        if (this.cacheMode == CacheMode.DEFAULT || this.cacheMode == CacheMode.KEEP_HOT || this.cacheMode == CacheMode.EVICT_LN) {
            return;
        }
        binToEvict.latch(CacheMode.UNCHANGED);
        try {
            this.performCacheModeBINEviction(binToEvict);
        }
        finally {
            binToEvict.releaseLatchIfOwner();
        }
    }

    public void setAllowEviction(boolean allowed) {
        this.allowEviction = allowed;
    }

    public void criticalEviction() {
        if (this.allowEviction && (this.bin != null && this.bin.getDirty() || this.cacheMode != CacheMode.UNCHANGED && this.cacheMode != CacheMode.EVICT_BIN && this.cacheMode != CacheMode.MAKE_COLD)) {
            this.dbImpl.getEnv().criticalEviction(false);
        }
    }

    private void performCacheModeEviction(CursorImpl newCursor) {
        boolean movedOffLn;
        boolean movedOffBin;
        if (this.cacheMode == CacheMode.DEFAULT || this.cacheMode == CacheMode.KEEP_HOT) {
            return;
        }
        if (newCursor != null) {
            movedOffBin = this.bin != newCursor.bin;
            movedOffLn = movedOffBin || this.index != newCursor.index;
        } else {
            movedOffBin = true;
            movedOffLn = true;
        }
        if (movedOffLn) {
            this.performCacheModeLNEviction();
        }
        if (this.cacheMode == CacheMode.EVICT_LN) {
            return;
        }
        if (movedOffBin) {
            this.performCacheModeBINEviction(this.bin);
        }
    }

    private void performCacheModeLNEviction() {
        switch (this.cacheMode) {
            case EVICT_LN: 
            case EVICT_BIN: {
                this.evictLN(true, false);
                break;
            }
            case UNCHANGED: 
            case MAKE_COLD: {
                this.evictLN(true, true);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void performCacheModeBINEviction(BIN binToEvict) {
        switch (this.cacheMode) {
            case EVICT_BIN: {
                this.evictBIN(binToEvict, CacheMode.EVICT_BIN);
                break;
            }
            case UNCHANGED: 
            case MAKE_COLD: {
                if (!binToEvict.getFetchedCold()) break;
                this.evictBIN(binToEvict, CacheMode.UNCHANGED);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private void evictBIN(BIN binToEvict, CacheMode cacheMode) {
        this.dbImpl.getEnv().getEvictor().doCacheModeEvict(binToEvict, cacheMode);
    }

    public void evictLN() {
        this.evictLN(false, false);
    }

    private void evictLN(boolean isLatched, boolean ifFetchedCold) {
        try {
            if (!isLatched) {
                this.latchBIN();
            }
            if (this.index >= 0) {
                this.bin.evictLN(this.index, ifFetchedCold);
            }
        }
        finally {
            if (!isLatched) {
                this.releaseBIN();
            }
        }
    }

    private boolean shouldEmbedLN(byte[] data) {
        return data.length <= this.dbImpl.getEnv().getMaxEmbeddedLN() && !this.dbImpl.getSortedDuplicates() && !this.dbImpl.getDbType().isInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult deleteCurrentRecord(ReplicationContext repContext) {
        assert (this.assertCursorState(true, false));
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        DbType dbType = this.dbImpl.getDbType();
        boolean success = false;
        this.latchBIN();
        try {
            LN ln;
            LockStanding lockStanding = this.lockLN(LockType.WRITE, true, false);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                success = true;
                OperationResult operationResult = null;
                return operationResult;
            }
            long currLsn = lockStanding.lsn;
            assert (currLsn != -1L);
            boolean currEmbeddedLN = this.bin.isEmbeddedLN(this.index);
            int currLoggedSize = this.bin.getLastLoggedSize(this.index);
            byte[] currKey = this.bin.getKey(this.index);
            int expiration = this.bin.getExpiration(this.index);
            boolean expirationInHours = this.bin.isExpirationInHours();
            if (currLoggedSize == 0 && !currEmbeddedLN && envImpl.getCleaner().getFetchObsoleteSize(this.dbImpl) || !dbType.mayCreateDeletedLN()) {
                ln = this.bin.fetchLN(this.index, this.cacheMode);
                if (ln == null) {
                    this.revertLock(lockStanding);
                    success = true;
                    OperationResult operationResult = null;
                    return operationResult;
                }
            } else {
                ln = this.bin.getLN(this.index, this.cacheMode);
            }
            long oldLNMemSize = 0L;
            if (ln != null) {
                oldLNMemSize = ln.getMemorySizeIncludedByParent();
                ln.delete();
            } else {
                ln = dbType.createDeletedLN(envImpl);
            }
            WriteLockInfo wli = lockStanding.prepareForUpdate(this.bin, this.index);
            LogItem logItem = ln.optionalLog(envImpl, this.dbImpl, this.locker, wli, currEmbeddedLN, currKey, expiration, expirationInHours, currEmbeddedLN, currLsn, currLoggedSize, false, repContext);
            this.bin.deleteRecord(this.index, oldLNMemSize, logItem.lsn, ln.getVLSNSequence(), logItem.size);
            if (this.bin.getTarget(this.index) == null) {
                if (this.dbImpl.isDeferredWriteMode()) {
                    this.bin.attachNode(this.index, ln, null);
                }
            } else if (!this.dbImpl.isDeferredWriteMode()) {
                this.bin.evictLN(this.index);
            }
            this.setCurrentVersion(ln.getVLSNSequence(), logItem.lsn);
            this.setStorageSize();
            this.locker.addDeleteInfo(this.bin);
            success = true;
            this.trace(Level.FINER, TRACE_DELETE, this.bin, this.index, currLsn, logItem.lsn);
            OperationResult operationResult = DbInternal.makeResult(expiration, expirationInHours);
            return operationResult;
        }
        finally {
            if (success && !this.dbImpl.isInternalDb() && this.bin != null && this.bin.isBINDelta()) {
                this.dbImpl.getEnv().incBinDeltaDeletes();
            }
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult updateCurrentRecord(DatabaseEntry key, DatabaseEntry data, ExpirationInfo expInfo, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (this.assertCursorState(true, false));
        if (returnOldData != null) {
            returnOldData.setData(null);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
        }
        OperationResult result2 = null;
        boolean success = false;
        this.latchBIN();
        try {
            LockStanding lockStanding = this.lockLN(LockType.WRITE, true, false);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
            } else {
                result2 = this.updateRecordInternal(key != null ? Key.makeKey(key) : null, data, expInfo, returnOldData, returnNewData, lockStanding, repContext);
            }
            success = true;
            OperationResult operationResult = result2;
            return operationResult;
        }
        finally {
            if (success && !this.dbImpl.isInternalDb() && this.bin != null && this.bin.isBINDelta()) {
                this.dbImpl.getEnv().incBinDeltaUpdates();
            }
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertRecord(byte[] key, LN ln, boolean blindInsertion, ReplicationContext repContext) {
        assert (this.assertCursorState(false, true));
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        try {
            Pair<LockStanding, OperationResult> result2 = this.insertRecordInternal(key, ln, null, blindInsertion, null, repContext);
            boolean bl = result2.second() != null;
            return bl;
        }
        finally {
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult insertOrUpdateRecord(DatabaseEntry key, DatabaseEntry data, LN ln, ExpirationInfo expInfo, PutMode putMode, DatabaseEntry returnOldData, DatabaseEntry returnNewData, ReplicationContext repContext) {
        assert (key != null);
        assert (data != null);
        assert (ln != null);
        assert (putMode != null);
        assert (this.assertCursorState(false, true));
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        if (putMode != PutMode.OVERWRITE && putMode != PutMode.NO_OVERWRITE) {
            throw EnvironmentFailureException.unexpectedState(putMode.toString());
        }
        boolean success = false;
        boolean inserted = false;
        byte[] keyCopy = Key.makeKey(key);
        try {
            Pair<LockStanding, OperationResult> insertResult = this.insertRecordInternal(keyCopy, ln, expInfo, false, returnNewData, repContext);
            if (insertResult.second() != null) {
                inserted = true;
                success = true;
                OperationResult operationResult = insertResult.second();
                return operationResult;
            }
            if (putMode == PutMode.NO_OVERWRITE) {
                success = true;
                OperationResult operationResult = null;
                return operationResult;
            }
            OperationResult result2 = this.updateRecordInternal(keyCopy, data, expInfo, returnOldData, returnNewData, insertResult.first(), repContext);
            success = true;
            OperationResult operationResult = result2;
            return operationResult;
        }
        finally {
            if (success && !this.dbImpl.isInternalDb() && this.bin != null && this.bin.isBINDelta()) {
                if (inserted) {
                    this.dbImpl.getEnv().incBinDeltaInserts();
                } else {
                    this.dbImpl.getEnv().incBinDeltaUpdates();
                }
            }
            this.releaseBIN();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<LockStanding, OperationResult> insertRecordInternal(byte[] key, LN ln, ExpirationInfo expInfo, boolean blindInsertion, DatabaseEntry returnNewData, ReplicationContext repContext) {
        WriteLockInfo wli;
        boolean currEmbeddedLN;
        long currLsn;
        boolean isSlotReuse;
        boolean newEmbeddedLN;
        byte[] data;
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        Tree tree = this.dbImpl.getTree();
        LockStanding lockStanding = null;
        if (this.shouldEmbedLN(ln.getData())) {
            data = ln.getData();
            newEmbeddedLN = true;
        } else {
            newEmbeddedLN = false;
            data = null;
        }
        if (expInfo == null) {
            expInfo = ExpirationInfo.DEFAULT;
        }
        this.bin = tree.findBinForInsert(key, this.getCacheMode());
        this.locker.preLogWithoutLock(this.dbImpl);
        int insertIndex = this.bin.insertEntry1(ln, key, data, -1L, blindInsertion);
        if ((insertIndex & 0x20000) == 0) {
            isSlotReuse = true;
            this.setIndex(insertIndex);
            this.addCursor();
            this.setInitialized();
            lockStanding = this.lockLN(LockType.WRITE, true, false);
            assert (lockStanding != null);
            if (lockStanding.recordExists()) {
                return new Pair<LockStanding, Object>(lockStanding, null);
            }
            currLsn = lockStanding.lsn;
            currEmbeddedLN = this.bin.isEmbeddedLN(this.index);
            wli = lockStanding.prepareForUpdate(this.bin, this.index);
        } else {
            isSlotReuse = false;
            currEmbeddedLN = newEmbeddedLN;
            currLsn = -1L;
            this.setIndex(insertIndex &= 0xFFFDFFFF);
            this.addCursor();
            this.setInitialized();
            wli = LockStanding.prepareForInsert(this.bin);
        }
        LogItem logItem = null;
        try {
            logItem = ln.optionalLog(envImpl, this.dbImpl, this.locker, wli, newEmbeddedLN, key, expInfo.expiration, expInfo.expirationInHours, currEmbeddedLN, currLsn, 0, true, repContext);
        }
        finally {
            if (logItem == null && !isSlotReuse) {
                this.bin.setKnownDeletedAndEvictLN(this.index);
            }
        }
        assert (logItem != null);
        if (lockStanding == null) {
            this.bin.updateEntry(this.index, logItem.lsn, ln.getVLSNSequence(), logItem.size);
            this.bin.setExpiration(this.index, expInfo.expiration, expInfo.expirationInHours);
            if (this.bin.getTarget(this.index) == ln) {
                ln.addExtraMarshaledMemorySize(this.bin);
            }
        } else {
            this.bin.insertRecord(this.index, ln, logItem.lsn, logItem.size, key, data, expInfo.expiration, expInfo.expirationInHours);
        }
        if (returnNewData != null) {
            returnNewData.setData(null);
            ln.setEntry(returnNewData);
        }
        this.setInitialized();
        this.setCurrentVersion(ln.getVLSNSequence(), this.bin.getLsn(this.index));
        this.setStorageSize();
        if (this.dbImpl.getSortedDuplicates() && !this.dbImpl.isDeferredWriteMode() && this.bin.getTarget(this.index) != null) {
            this.bin.evictLN(this.index);
        }
        this.traceInsert(Level.FINER, this.bin, logItem.lsn, this.index);
        return new Pair<LockStanding, OperationResult>(lockStanding, DbInternal.makeResult(expInfo.expiration, expInfo.expirationInHours));
    }

    private OperationResult updateRecordInternal(byte[] key, DatabaseEntry data, ExpirationInfo expInfo, DatabaseEntry returnOldData, DatabaseEntry returnNewData, LockStanding lockStanding, ReplicationContext repContext) {
        boolean shouldCache;
        boolean expirationInHours;
        int expiration;
        long oldLNMemSize;
        byte[] newData;
        LN ln;
        byte[] currData;
        assert (lockStanding.recordExists());
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        DbType dbType = this.dbImpl.getDbType();
        long currLsn = lockStanding.lsn;
        assert (currLsn != -1L);
        int currLoggedSize = this.bin.getLastLoggedSize(this.index);
        byte[] currKey = this.bin.getKey(this.index);
        boolean currEmbeddedLN = this.bin.isEmbeddedLN(this.index);
        if (returnOldData != null || data.getPartial() || currLoggedSize == 0 && !currEmbeddedLN && envImpl.getCleaner().getFetchObsoleteSize(this.dbImpl) || !dbType.mayCreateUpdatedLN()) {
            if (currEmbeddedLN) {
                currData = this.bin.getData(this.index);
                ln = this.bin.getLN(this.index, this.cacheMode);
            } else {
                ln = this.bin.fetchLN(this.index, this.cacheMode);
                currData = ln != null ? ln.getData() : null;
            }
        } else {
            ln = this.bin.getLN(this.index, this.cacheMode);
            byte[] byArray = currData = ln != null ? ln.getData() : null;
        }
        if (data.getPartial()) {
            if (currData == null) {
                return null;
            }
            newData = LN.resolvePartialEntry(data, currData);
        } else {
            newData = LN.copyEntryData(data);
        }
        if (key != null && Key.compareKeys(currKey, key, this.dbImpl.getKeyComparator()) != 0) {
            throw new DuplicateDataException("Can't replace a duplicate with new data that is not equal to the existing data according to the duplicate  comparator.");
        }
        if (returnOldData != null && currData != null) {
            returnOldData.setData(null);
            LN.setEntry(returnOldData, currData);
        }
        boolean newEmbeddedLN = this.shouldEmbedLN(newData);
        if (ln != null) {
            oldLNMemSize = ln.getMemorySizeIncludedByParent();
            ln.modify(newData);
        } else {
            oldLNMemSize = 0L;
            ln = dbType.createUpdatedLN(envImpl, newData);
        }
        int oldExpiration = this.bin.getExpiration(this.index);
        boolean oldExpirationInHours = this.bin.isExpirationInHours();
        if (expInfo != null) {
            expInfo.setOldExpirationTime(TTL.expirationToSystemTime(oldExpiration, oldExpirationInHours));
        }
        if (expInfo != null && expInfo.updateExpiration) {
            if (expInfo.expiration != oldExpiration || expInfo.expirationInHours != oldExpirationInHours) {
                expInfo.setExpirationUpdated(true);
            }
            expiration = expInfo.expiration;
            expirationInHours = expInfo.expirationInHours;
        } else {
            expiration = oldExpiration;
            expirationInHours = oldExpirationInHours;
        }
        WriteLockInfo wli = lockStanding.prepareForUpdate(this.bin, this.index);
        LogItem logItem = ln.optionalLog(envImpl, this.dbImpl, this.locker, wli, newEmbeddedLN, key != null ? key : currKey, expiration, expirationInHours, currEmbeddedLN, currLsn, currLoggedSize, false, repContext);
        if (returnNewData != null) {
            returnNewData.setData(null);
            ln.setEntry(returnNewData);
        }
        this.bin.updateRecord(this.index, oldLNMemSize, logItem.lsn, ln.getVLSNSequence(), logItem.size, key, (byte[])(newEmbeddedLN ? newData : null), expiration, expirationInHours);
        boolean bl = shouldCache = this.dbImpl.isDeferredWriteMode() || !this.dbImpl.getSortedDuplicates() && !newEmbeddedLN;
        if (this.bin.getTarget(this.index) == null) {
            if (shouldCache) {
                this.bin.attachNode(this.index, ln, null);
            }
        } else if (!shouldCache) {
            this.bin.evictLN(this.index);
        }
        this.setCurrentVersion(ln.getVLSNSequence(), logItem.lsn);
        this.setStorageSize();
        this.trace(Level.FINER, TRACE_MOD, this.bin, this.index, currLsn, logItem.lsn);
        return DbInternal.makeUpdateResult(expiration, expirationInHours);
    }

    public boolean positionFirstOrLast(boolean first) {
        assert (this.assertCursorState(false, true));
        boolean found = false;
        try {
            this.bin = first ? this.dbImpl.getTree().getFirstNode(this.cacheMode) : this.dbImpl.getTree().getLastNode(this.cacheMode);
            if (this.bin != null) {
                TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
                if (this.bin.getNEntries() == 0) {
                    found = true;
                    this.index = -1;
                } else {
                    int n = this.index = first ? 0 : this.bin.getNEntries() - 1;
                    if (treeStatsAccumulator != null && !this.bin.isEntryKnownDeleted(this.index) && !this.bin.isEntryPendingDeleted(this.index)) {
                        treeStatsAccumulator.incrementLNCount();
                    }
                    found = true;
                }
            }
            this.addCursor(this.bin);
            this.setInitialized();
            return found;
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public int searchRange(DatabaseEntry searchKey, Comparator<byte[]> comparator) {
        assert (this.assertCursorState(false, true));
        boolean foundSomething = false;
        boolean foundExactKey = false;
        boolean foundLast = false;
        BINBoundary binBoundary = new BINBoundary();
        try {
            byte[] key = Key.makeKey(searchKey);
            this.bin = this.dbImpl.getTree().search(key, Tree.SearchType.NORMAL, binBoundary, this.cacheMode, comparator);
            if (this.bin != null) {
                foundSomething = true;
                if (this.bin.isBINDelta() && comparator != null) {
                    this.bin.mutateToFullBIN(false);
                }
                this.index = this.bin.findEntry(key, true, false, comparator);
                if (this.bin.isBINDelta() && (this.index < 0 || (this.index & 0x10000) == 0 || binBoundary.isLastBin)) {
                    this.bin.mutateToFullBIN(false);
                    this.index = this.bin.findEntry(key, true, false, comparator);
                }
                if (this.index >= 0) {
                    if ((this.index & 0x10000) != 0) {
                        foundExactKey = true;
                        this.index &= 0xFFFEFFFF;
                    }
                    foundLast = binBoundary.isLastBin && this.index == this.bin.getNEntries() - 1;
                }
                this.addCursor(this.bin);
            }
            this.setInitialized();
            return (foundSomething ? 1 : 0) | (foundExactKey ? 2 : 0) | (foundLast ? 4 : 0);
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public boolean searchExact(DatabaseEntry searchKey, LockType lockType) {
        return this.searchExact(searchKey, lockType, false, false) != null;
    }

    public LockStanding searchExact(DatabaseEntry searchKey, LockType lockType, boolean dirtyReadAll, boolean dataRequested) {
        assert (this.assertCursorState(false, true));
        LockStanding lockStanding = null;
        try {
            byte[] key = Key.makeKey(searchKey);
            this.bin = this.dbImpl.getTree().search(key, this.cacheMode);
            if (this.bin != null) {
                this.index = this.bin.findEntry(key, false, true);
                if (this.index < 0 && this.bin.isBINDelta() && this.bin.mayHaveKeyInFullBin(key)) {
                    this.bin.mutateToFullBIN(false);
                    this.index = this.bin.findEntry(key, false, true);
                }
                this.addCursor(this.bin);
                if (this.index >= 0) {
                    lockStanding = this.lockLNAndCheckDefunct(lockType, dirtyReadAll, dataRequested);
                }
            }
            this.setInitialized();
            return lockStanding;
        }
        catch (Throwable e) {
            this.releaseBIN();
            throw e;
        }
    }

    public OperationResult lockAndGetCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType) {
        return this.lockAndGetCurrent(foundKey, foundData, lockType, false, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult lockAndGetCurrent(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean dirtyReadAll, boolean isLatched, boolean unlatch) {
        boolean success = false;
        try {
            boolean dataRequested;
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
            if (!isLatched) {
                this.latchBIN();
            }
            assert (this.bin.getCursorSet().contains(this));
            TreeWalkerStatsAccumulator treeStatsAccumulator = this.getTreeStatsAccumulator();
            if (this.index >= 0 && this.index < this.bin.getNEntries() && this.bin.isDeleted(this.index)) {
                this.bin.queueSlotDeletion(this.index);
            }
            if (this.index < 0 || this.index >= this.bin.getNEntries() || this.bin.isEntryKnownDeleted(this.index)) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                success = true;
                OperationResult operationResult = null;
                return operationResult;
            }
            assert (TestHookExecute.doHookIfSet(this.testHook));
            boolean bl = dataRequested = foundData != null && (!foundData.getPartial() || foundData.getPartialLength() != 0);
            if (this.lockLNAndCheckDefunct(lockType, dirtyReadAll, dataRequested) == null) {
                if (treeStatsAccumulator != null) {
                    treeStatsAccumulator.incrementDeletedLNCount();
                }
                success = true;
                OperationResult operationResult = null;
                return operationResult;
            }
            OperationResult result2 = this.getCurrent(foundKey, foundData);
            success = true;
            OperationResult operationResult = result2;
            return operationResult;
        }
        finally {
            if (unlatch || !success) {
                this.releaseBIN();
            }
        }
    }

    private LockStanding lockLNAndCheckDefunct(LockType lockType, boolean dirtyReadAll, boolean dataRequested) {
        assert (!dirtyReadAll || lockType == LockType.NONE);
        assert (!dataRequested || !this.dbImpl.getSortedDuplicates());
        LockStanding standing = this.lockLN(lockType);
        if (standing.recordExists()) {
            return standing;
        }
        if (lockType != LockType.NONE) {
            this.revertLock(standing);
            return null;
        }
        if (!dirtyReadAll) {
            return null;
        }
        standing = this.lockLN(LockType.READ, false, !dataRequested);
        if (standing.lockResult.getLockGrant() == LockGrantType.DENIED) {
            assert (!standing.recordExists());
            return standing;
        }
        this.revertLock(standing);
        if (standing.recordExists()) {
            return standing;
        }
        return null;
    }

    public OperationResult getCurrent(DatabaseEntry foundKey, DatabaseEntry foundData) {
        LN ln;
        boolean dataRequested;
        assert (this.bin.isLatchExclusiveOwner());
        assert (this.index >= 0 && this.index < this.bin.getNEntries());
        assert (!this.bin.isEntryKnownDeleted(this.index));
        boolean isEmptyLN = this.dbImpl.isLNImmediatelyObsolete();
        boolean isEmbeddedLN = this.bin.isEmbeddedLN(this.index);
        boolean bl = dataRequested = foundData != null && (!foundData.getPartial() || foundData.getPartialLength() != 0);
        if (!isEmptyLN && !isEmbeddedLN && dataRequested) {
            ln = this.bin.fetchLN(this.index, this.cacheMode);
            if (ln == null) {
                return null;
            }
        } else {
            ln = null;
        }
        if (dataRequested) {
            byte[] data;
            if (ln != null) {
                data = ln.getData();
            } else if (isEmptyLN || this.bin.isNoDataLN(this.index)) {
                data = LogUtils.ZERO_LENGTH_BYTE_ARRAY;
            } else {
                assert (isEmbeddedLN);
                data = this.bin.getData(this.index);
            }
            LN.setEntry(foundData, data);
        }
        if (foundKey != null) {
            LN.setEntry(foundKey, this.bin.getKey(this.index));
        }
        long vlsn = ln != null ? ln.getVLSNSequence() : this.bin.getVLSN(this.index, false, this.cacheMode);
        this.setCurrentVersion(vlsn, this.bin.getLsn(this.index));
        this.setStorageSize();
        return DbInternal.makeResult(this.bin.getExpiration(this.index), this.bin.isExpirationInHours());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN getCurrentLN(boolean isLatched, boolean unlatch) {
        boolean success = false;
        try {
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
            if (!isLatched) {
                this.latchBIN();
            }
            assert (this.bin.getCursorSet().contains(this));
            assert (!this.bin.isEmbeddedLN(this.index));
            LN ln = this.bin.fetchLN(this.index, this.cacheMode);
            success = true;
            LN lN = ln;
            return lN;
        }
        finally {
            if (unlatch || !success) {
                this.releaseBIN();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LN lockAndGetCurrentLN(LockType lockType) {
        try {
            assert (this.assertCursorState(true, false));
            assert (this.checkAlreadyLatched(false)) : this.dumpToString(true);
            this.latchBIN();
            assert (this.bin.getCursorSet().contains(this));
            LockStanding lockStanding = this.lockLN(lockType);
            if (!lockStanding.recordExists()) {
                this.revertLock(lockStanding);
                LN lN = null;
                return lN;
            }
            assert (!this.bin.isEmbeddedLN(this.index));
            LN lN = this.bin.fetchLN(this.index, this.cacheMode);
            return lN;
        }
        finally {
            this.releaseBIN();
        }
    }

    public RecordVersion getCurrentVersion(boolean allowFetch) {
        this.checkCursorState(true, false);
        if (this.isSecondaryCursor) {
            if (this.currentRecordVersion == null) {
                throw new IllegalStateException("Record version is available via a SecondaryCursor only if the associated primary record was retrieved.");
            }
            return this.currentRecordVersion;
        }
        if (!(this.currentRecordVersion == null || this.currentRecordVersion.getVLSN() == -1L && allowFetch && this.dbImpl.getEnv().getPreserveVLSN())) {
            return this.currentRecordVersion;
        }
        this.latchBIN();
        try {
            this.setCurrentVersion(this.bin.getVLSN(this.index, allowFetch, this.cacheMode), this.bin.getLsn(this.index));
        }
        finally {
            this.releaseBIN();
        }
        return this.currentRecordVersion;
    }

    private void setCurrentVersion(long vlsn, long lsn) {
        this.currentRecordVersion = new RecordVersion(vlsn, lsn);
    }

    public int getStorageSize() {
        assert (this.assertCursorState(true, false));
        return this.priStorageSize > 0 ? this.priStorageSize : this.storageSize;
    }

    private void setStorageSize() {
        this.storageSize = StorageSize.getStorageSize(this.bin, this.index);
    }

    public void setPriInfo(CursorImpl sourceCursor) {
        this.currentRecordVersion = sourceCursor.currentRecordVersion;
        this.priStorageSize = sourceCursor.storageSize;
    }

    public int getNSecondaryWrites() {
        return this.nSecWrites;
    }

    public void setNSecondaryWrites(int nWrites) {
        this.nSecWrites = nWrites;
    }

    public boolean advanceCursor(DatabaseEntry key, DatabaseEntry data) {
        BIN oldBin = this.bin;
        int oldIndex = this.index;
        key.setData(null);
        data.setData(null);
        try {
            this.getNext(key, data, LockType.NONE, false, true, false, null);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        if (this.bin != oldBin || this.index != oldIndex) {
            if (key.getData() == null && this.bin != null && this.index > 0) {
                LN.setEntry(key, this.bin.getKey(this.index));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationResult getNext(DatabaseEntry foundKey, DatabaseEntry foundData, LockType lockType, boolean dirtyReadAll, boolean forward, boolean isLatched, RangeConstraint rangeConstraint) {
        assert (this.assertCursorState(true, false));
        assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
        OperationResult result2 = null;
        IN anchorBIN = null;
        try {
            while (this.bin != null) {
                assert (this.checkAlreadyLatched(isLatched)) : this.dumpToString(true);
                if (!isLatched) {
                    this.latchBIN();
                    isLatched = true;
                }
                this.bin.mutateToFullBIN(false);
                if (forward && ++this.index < this.bin.getNEntries() || !forward && --this.index > -1) {
                    if (rangeConstraint != null && !rangeConstraint.inBounds(this.bin.getKey(this.index))) {
                        result2 = null;
                        this.releaseBIN();
                    } else {
                        OperationResult ret = this.lockAndGetCurrent(foundKey, foundData, lockType, dirtyReadAll, true, false);
                        if (LatchSupport.TRACK_LATCHES) {
                            LatchSupport.expectBtreeLatchesHeld(1);
                        }
                        if (ret == null) continue;
                        this.incrementLNCount();
                        this.releaseBIN();
                        result2 = ret;
                    }
                    break;
                }
                anchorBIN = this.bin;
                anchorBIN.pin();
                this.bin.removeCursor(this);
                this.bin = null;
                Tree tree = this.dbImpl.getTree();
                assert (TestHookExecute.doHookIfSet(this.testHook));
                if (forward) {
                    this.bin = tree.getNextBin((BIN)anchorBIN, this.cacheMode);
                    this.index = -1;
                } else {
                    this.bin = tree.getPrevBin((BIN)anchorBIN, this.cacheMode);
                    if (this.bin != null) {
                        this.index = this.bin.getNEntries();
                    }
                }
                isLatched = true;
                if (this.bin == null) {
                    if (LatchSupport.TRACK_LATCHES) {
                        LatchSupport.expectBtreeLatchesHeld(0);
                    }
                    result2 = null;
                    break;
                }
                if (LatchSupport.TRACK_LATCHES) {
                    LatchSupport.expectBtreeLatchesHeld(1);
                }
                this.addCursor();
                anchorBIN.unpin();
                anchorBIN = null;
            }
        }
        finally {
            if (anchorBIN != null) {
                anchorBIN.unpin();
            }
        }
        if (LatchSupport.TRACK_LATCHES) {
            LatchSupport.expectBtreeLatchesHeld(0);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForInsertion(GetMode getMode, CursorImpl dupCursor) {
        CursorImpl origCursor = this;
        boolean forward = getMode.isForward();
        boolean ret = false;
        if (origCursor.bin != dupCursor.bin) {
            block7: {
                origCursor.latchBIN();
                BIN origBIN = origCursor.bin;
                origBIN.mutateToFullBIN(false);
                try {
                    if (forward) {
                        if (origBIN.getNEntries() - 1 <= origCursor.getIndex()) break block7;
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            if (origBIN.isDefunct(i)) continue;
                            ret = true;
                            break block7;
                        }
                        break block7;
                    }
                    if (origCursor.getIndex() <= 0) break block7;
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        if (origBIN.isDefunct(i)) continue;
                        ret = true;
                        break;
                    }
                }
                finally {
                    origCursor.releaseBIN();
                }
            }
            return ret;
        }
        return false;
    }

    public long skip(boolean forward, long maxCount, RangeConstraint rangeConstraint) {
        c.setCacheMode(CacheMode.UNCHANGED);
        try (CursorImpl c = this.cloneCursor(true);){
            long l2 = c.skipInternal(forward, maxCount, rangeConstraint, this);
            return l2;
        }
    }

    private long skipInternal(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor) {
        Tree tree = this.dbImpl.getTree();
        this.latchBIN();
        IN parent = null;
        IN prevBin = null;
        BIN curBin = this.bin;
        int curIndex = this.getIndex();
        long count = 0L;
        boolean success = false;
        try {
            while (true) {
                block20: {
                    curBin.mutateToFullBIN(false);
                    count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, curIndex, count);
                    if (count < 0L) {
                        curBin.releaseLatch();
                        success = true;
                        long l2 = -count;
                        return l2;
                    }
                    byte[] idKey = curBin.getNEntries() == 0 ? curBin.getIdentifierKey() : (forward ? curBin.getKey(curBin.getNEntries() - 1) : curBin.getKey(0));
                    SearchResult result2 = tree.getParentINForChildIN(curBin, false, true, CacheMode.DEFAULT);
                    parent = result2.parent;
                    if (!result2.exactParentFound) {
                        throw EnvironmentFailureException.unexpectedState("Cannot get parent of BIN id=" + curBin.getNodeId() + " key=" + Arrays.toString(idKey));
                    }
                    int parentIndex = parent.findEntry(idKey, false, false);
                    curBin = (BIN)parent.fetchIN(parentIndex, CacheMode.DEFAULT);
                    curBin.latch();
                    if (forward ? parentIndex < parent.getNEntries() - 1 : parentIndex > 0) {
                        int incr = forward ? 1 : -1;
                        parentIndex += incr;
                        while (true) {
                            prevBin = curBin;
                            curBin = null;
                            if (forward ? parentIndex >= parent.getNEntries() : parentIndex < 0) {
                                parent.releaseLatch();
                                break block20;
                            }
                            curBin = (BIN)parent.getTarget(parentIndex);
                            if (curBin == null || !curBin.latchNoWait(CacheMode.DEFAULT)) {
                                parent.releaseLatch();
                                break block20;
                            }
                            prevBin.releaseLatch();
                            prevBin = null;
                            this.setPosition(curBin, -1);
                            curBin.mutateToFullBIN(false);
                            count = this.skipEntries(forward, maxCount, rangeConstraint, finalPositionCursor, curBin, forward ? -1 : curBin.getNEntries(), count);
                            if (count < 0L) {
                                parent.releaseLatch();
                                curBin.releaseLatch();
                                success = true;
                                long l3 = -count;
                                return l3;
                            }
                            parentIndex += incr;
                        }
                    }
                    parent.releaseLatch();
                    prevBin = curBin;
                }
                BIN bIN = curBin = forward ? tree.getNextBin((BIN)prevBin, CacheMode.DEFAULT) : tree.getPrevBin((BIN)prevBin, CacheMode.DEFAULT);
                assert (!prevBin.isLatchOwner());
                if (curBin == null) {
                    success = true;
                    long l4 = count;
                    return l4;
                }
                prevBin = null;
                curIndex = forward ? -1 : curBin.getNEntries();
                this.setPosition(curBin, -1);
            }
        }
        finally {
            if (curBin != null && !success) {
                curBin.releaseLatchIfOwner();
            }
            if (prevBin != null && !success) {
                prevBin.releaseLatchIfOwner();
            }
            if (parent != null && !success) {
                parent.releaseLatchIfOwner();
            }
            if (LatchSupport.TRACK_LATCHES) {
                LatchSupport.expectBtreeLatchesHeld(0);
            }
        }
    }

    private long skipEntries(boolean forward, long maxCount, RangeConstraint rangeConstraint, CursorImpl finalPositionCursor, BIN curBin, int curIndex, long count) {
        assert (!curBin.isBINDelta());
        int incr = forward ? 1 : -1;
        int i = curIndex + incr;
        while (!(!forward ? i < 0 : i >= curBin.getNEntries())) {
            if (rangeConstraint != null && !rangeConstraint.inBounds(curBin.getKey(i))) {
                return -count;
            }
            if (!curBin.isDefunct(i)) {
                finalPositionCursor.setPosition(curBin, i);
                if (maxCount > 0L && ++count >= maxCount) {
                    return -count;
                }
            }
            i += incr;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TrackingInfo> getAncestorPath() {
        long binLsn;
        ArrayList<TrackingInfo> trackingList = new ArrayList<TrackingInfo>();
        this.latchBIN();
        BIN origBin = this.bin;
        Tree tree = this.dbImpl.getTree();
        SearchResult result2 = tree.getParentINForChildIN(origBin, false, true, CacheMode.UNCHANGED, trackingList);
        if (!result2.exactParentFound) {
            return null;
        }
        try {
            if (origBin != result2.parent.getTarget(result2.index) || origBin != this.bin) {
                List<TrackingInfo> list = null;
                return list;
            }
            binLsn = result2.parent.getLsn(result2.index);
            this.bin.latch();
        }
        finally {
            result2.parent.releaseLatch();
        }
        try {
            int binEntries = this.bin.getNEntries();
            int binIndex = this.getIndex();
            for (int i = this.bin.getNEntries() - 1; i >= 0; --i) {
                if (!this.bin.isDefunct(i)) continue;
                --binEntries;
                if (i >= binIndex) continue;
                --binIndex;
            }
            TrackingInfo info = new TrackingInfo(binLsn, this.bin.getNodeId(), binEntries, binIndex);
            trackingList.add(info);
            ArrayList<TrackingInfo> arrayList = trackingList;
            return arrayList;
        }
        finally {
            this.bin.releaseLatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockNextKeyForInsert(DatabaseEntry key) {
        DatabaseEntry tempKey = new DatabaseEntry(key.getData(), key.getOffset(), key.getSize());
        boolean lockedNextKey = false;
        boolean latched = true;
        try {
            int searchResult;
            while (((searchResult = this.searchRange(tempKey, null)) & 1) != 0 && (searchResult & 4) == 0) {
                DatabaseEntry tempData = new DatabaseEntry();
                tempData.setPartial(0, 0, true);
                OperationResult result2 = this.getNext(tempKey, tempData, LockType.RANGE_INSERT, false, true, true, null);
                latched = false;
                if (result2 != null) {
                    Comparator<byte[]> comparator = this.dbImpl.getKeyComparator();
                    int c = Key.compareKeys(tempKey, key, comparator);
                    if (c <= 0) {
                        tempKey.setData(key.getData(), key.getOffset(), key.getSize());
                        continue;
                    }
                    lockedNextKey = true;
                }
                break;
            }
        }
        finally {
            if (latched) {
                this.releaseBIN();
            }
        }
        if (!lockedNextKey) {
            this.lockEof(LockType.RANGE_INSERT);
        }
    }

    public LockStanding lockLN(LockType lockType) throws LockConflictException {
        return this.lockLN(lockType, false, false);
    }

    public LockStanding lockLN(LockType lockType, boolean allowUncontended, boolean noWait) throws LockConflictException {
        long newLsn;
        boolean prevExpirationInHours;
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        LockManager lockManager = envImpl.getTxnManager().getLockManager();
        LockStanding standing = new LockStanding();
        standing.lsn = this.bin.getLsn(this.index);
        if (standing.lsn == -1L) {
            assert (this.bin.isEntryKnownDeleted(this.index));
            standing.defunct = true;
            return standing;
        }
        if (allowUncontended && lockManager.isLockUncontended(standing.lsn)) {
            assert (this.verifyPendingDeleted(lockType));
            this.locker.preLogWithoutLock(this.dbImpl);
            standing.defunct = this.bin.isDefunct(this.index);
            return standing;
        }
        boolean wasLockedAndExpiresSoon = false;
        int prevExpiration = this.bin.getExpiration(this.index);
        if (envImpl.expiresWithin(prevExpiration, prevExpirationInHours = this.bin.isExpirationInHours(), this.dbImpl.getEnv().getTtlMaxTxnTime()) && lockManager.ownsOrSharesLock(this.locker, standing.lsn)) {
            wasLockedAndExpiresSoon = true;
        }
        if (this.locker.getDefaultNoWait()) {
            try {
                standing.lockResult = this.locker.lock(standing.lsn, lockType, true, this.dbImpl);
            }
            catch (LockNotAvailableException e) {
                this.releaseBIN();
                throw e;
            }
            catch (LockConflictException e) {
                this.releaseBIN();
                throw EnvironmentFailureException.unexpectedException(e);
            }
        } else {
            standing.lockResult = this.locker.nonBlockingLock(standing.lsn, lockType, false, this.dbImpl);
        }
        if (standing.lockResult.getLockGrant() != LockGrantType.DENIED) {
            assert (this.verifyPendingDeleted(lockType));
            standing.defunct = wasLockedAndExpiresSoon ? this.bin.isDeleted(this.index) : this.bin.isDefunct(this.index);
            return standing;
        }
        if (noWait) {
            standing.defunct = wasLockedAndExpiresSoon ? this.bin.isDeleted(this.index) : this.bin.isDefunct(this.index);
            return standing;
        }
        do {
            this.releaseBIN();
            standing.lockResult = this.locker.lock(standing.lsn, lockType, false, this.dbImpl);
            this.latchBIN();
            newLsn = this.bin.getLsn(this.index);
            if (standing.lsn == newLsn) {
                if (prevExpiration != this.bin.getExpiration(this.index) || prevExpirationInHours != this.bin.isExpirationInHours()) {
                    wasLockedAndExpiresSoon = false;
                }
                standing.defunct = wasLockedAndExpiresSoon ? this.bin.isDeleted(this.index) : this.bin.isDefunct(this.index);
                assert (this.verifyPendingDeleted(lockType));
                return standing;
            }
            this.revertLock(standing);
            standing.lsn = newLsn;
        } while (newLsn != -1L);
        assert (this.bin.isEntryKnownDeleted(this.index));
        standing.defunct = true;
        return standing;
    }

    public static void lockAfterLsnChange(DatabaseImpl dbImpl, long oldLsn, long newLsn, Locker excludeLocker) {
        Locker locker;
        LockManager lockManager = dbImpl.getEnv().getTxnManager().getLockManager();
        Set<LockInfo> owners = lockManager.getOwners(oldLsn);
        if (owners == null) {
            return;
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker) continue;
            locker.lockAfterLsnChange(oldLsn, newLsn, dbImpl);
        }
        for (LockInfo lockInfo : owners) {
            locker = lockInfo.getLocker();
            if (locker == excludeLocker || !locker.allowReleaseLockAfterLsnChange()) continue;
            locker.releaseLock(oldLsn);
        }
    }

    private void verifyCursor(BIN bin) {
        if (!bin.getCursorSet().contains(this)) {
            throw new EnvironmentFailureException(this.dbImpl.getEnv(), EnvironmentFailureReason.UNEXPECTED_STATE, "BIN cursorSet is inconsistent");
        }
    }

    private boolean assertCursorState(boolean mustBeInitialized, boolean mustNotBeInitialized) {
        try {
            this.checkCursorState(mustBeInitialized, mustNotBeInitialized);
            return true;
        }
        catch (RuntimeException e) {
            assert (false) : e.toString() + " " + this.dumpToString(true);
            return false;
        }
    }

    public void checkCursorState(boolean mustBeInitialized, boolean mustNotBeInitialized) {
        switch (this.status) {
            case 1: {
                if (!mustBeInitialized) break;
                throw new IllegalStateException("Cursor not initialized.");
            }
            case 2: {
                if (!mustNotBeInitialized) break;
                throw EnvironmentFailureException.unexpectedState("Cursor is initialized.");
            }
            case 3: {
                throw new IllegalStateException("Cursor has been closed.");
            }
            default: {
                throw EnvironmentFailureException.unexpectedState("Unknown cursor status: " + this.status);
            }
        }
    }

    private boolean verifyPendingDeleted(LockType lockType) {
        if (lockType == LockType.NONE) {
            return true;
        }
        if (this.bin == null || this.index < 0) {
            return true;
        }
        LN ln = (LN)this.bin.getTarget(this.index);
        if (ln == null) {
            return true;
        }
        boolean kd = this.bin.isEntryKnownDeleted(this.index);
        boolean pd = this.bin.isEntryPendingDeleted(this.index);
        boolean lnDeleted = ln.isDeleted();
        assert (lnDeleted && (kd || pd) || !lnDeleted && !pd) : "Deleted state mismatch LNDeleted = " + lnDeleted + " PD = " + pd + " KD = " + kd;
        return true;
    }

    public void revertLock(LockStanding standing) {
        if (standing.lockResult != null) {
            this.revertLock(standing.lsn, standing.lockResult);
            standing.lockResult = null;
        }
    }

    private void revertLock(long lsn, LockResult lockResult) {
        LockGrantType lockStatus = lockResult.getLockGrant();
        if (lockStatus == LockGrantType.NEW || lockStatus == LockGrantType.WAIT_NEW) {
            this.locker.releaseLock(lsn);
        } else if (lockStatus == LockGrantType.PROMOTION || lockStatus == LockGrantType.WAIT_PROMOTION) {
            this.locker.demoteLock(lsn);
        }
    }

    public void lockEof(LockType lockType) {
        this.locker.lock(this.dbImpl.getEofLsn(), lockType, false, this.dbImpl);
    }

    public void checkEnv() {
        this.dbImpl.getEnv().checkIfInvalid();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void traverseDbWithCursor(DatabaseImpl db, LockType lockType, boolean allowEviction, WithCursor withCursor) {
        DatabaseEntry key = new DatabaseEntry();
        DatabaseEntry data = new DatabaseEntry();
        Locker locker = null;
        CursorImpl cursor = null;
        try {
            EnvironmentImpl envImpl = db.getEnv();
            locker = LockerFactory.getInternalReadOperationLocker(envImpl);
            cursor = new CursorImpl(db, locker);
            cursor.setAllowEviction(allowEviction);
            if (cursor.positionFirstOrLast(true)) {
                OperationResult result2 = cursor.lockAndGetCurrent(key, data, lockType, false, true, true);
                boolean done = false;
                while (!done) {
                    if (result2 != null && !withCursor.withCursor(cursor, key, data)) {
                        done = true;
                    }
                    if (done || (result2 = cursor.getNext(key, data, lockType, false, true, false, null)) != null) continue;
                    done = true;
                }
            }
        }
        finally {
            if (cursor != null) {
                cursor.releaseBIN();
                cursor.close();
            }
            if (locker != null) {
                locker.operationEnd();
            }
        }
    }

    public void dump(boolean verbose) {
        System.out.println(this.dumpToString(verbose));
    }

    public void dump() {
        System.out.println(this.dumpToString(true));
    }

    private String statusToString(byte status) {
        switch (status) {
            case 1: {
                return "CURSOR_NOT_INITIALIZED";
            }
            case 2: {
                return "CURSOR_INITIALIZED";
            }
            case 3: {
                return "CURSOR_CLOSED";
            }
        }
        return "UNKNOWN (" + Byte.toString(status) + ")";
    }

    public String dumpToString(boolean verbose) {
        StringBuilder sb = new StringBuilder();
        sb.append("<Cursor idx=\"").append(this.index).append("\"");
        sb.append(" status=\"").append(this.statusToString(this.status)).append("\"");
        sb.append(">\n");
        if (verbose) {
            sb.append(this.bin == null ? "" : this.bin.dumpString(2, true));
        }
        sb.append("\n</Cursor>");
        return sb.toString();
    }

    public StatGroup getLockStats() {
        return this.locker.collectStats();
    }

    private void trace(Level level, String changeType, BIN theBin, int lnIndex, long oldLsn, long newLsn) {
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(changeType);
            sb.append(" bin=");
            sb.append(theBin.getNodeId());
            sb.append(" lnIdx=");
            sb.append(lnIndex);
            sb.append(" oldLnLsn=");
            sb.append(DbLsn.getNoFormatString(oldLsn));
            sb.append(" newLnLsn=");
            sb.append(DbLsn.getNoFormatString(newLsn));
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    private void traceInsert(Level level, BIN insertingBin, long lnLsn, int index) {
        EnvironmentImpl envImpl = this.dbImpl.getEnv();
        if (envImpl.getLogger().isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_INSERT);
            sb.append(" bin=");
            sb.append(insertingBin.getNodeId());
            sb.append(" lnLsn=");
            sb.append(DbLsn.getNoFormatString(lnLsn));
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(envImpl.getLogger(), envImpl, level, sb.toString());
        }
    }

    public void setTestHook(TestHook hook) {
        this.testHook = hook;
    }

    private boolean checkAlreadyLatched(boolean isLatched) {
        if (isLatched && this.bin != null) {
            return this.bin.isLatchExclusiveOwner();
        }
        return true;
    }

    public static interface WithCursor {
        public boolean withCursor(CursorImpl var1, DatabaseEntry var2, DatabaseEntry var3);
    }

    public static class LockStanding {
        private long lsn;
        private boolean defunct;
        private LockResult lockResult;

        public boolean recordExists() {
            return !this.defunct;
        }

        public WriteLockInfo prepareForUpdate(BIN bin, int idx) {
            WriteLockInfo wri;
            DatabaseImpl db = bin.getDatabase();
            boolean abortKD = !this.recordExists();
            byte[] abortKey = null;
            byte[] abortData = null;
            long abortVLSN = VLSN.NULL_VLSN.getSequence();
            int abortExpiration = bin.getExpiration(idx);
            boolean abortExpirationInHours = bin.isExpirationInHours();
            if (bin.isEmbeddedLN(idx)) {
                abortData = bin.getData(idx);
                abortVLSN = bin.getVLSN(idx, false, null);
                if (bin.getDatabase().allowsKeyUpdates()) {
                    abortKey = bin.getKey(idx);
                }
            }
            WriteLockInfo writeLockInfo = wri = this.lockResult == null ? null : this.lockResult.getWriteLockInfo();
            if (wri == null) {
                wri = new WriteLockInfo();
                wri.setAbortLsn(this.lsn);
                wri.setAbortKnownDeleted(abortKD);
                wri.setAbortKey(abortKey);
                wri.setAbortData(abortData);
                wri.setAbortVLSN(abortVLSN);
                wri.setAbortExpiration(abortExpiration, abortExpirationInHours);
                wri.setDb(db);
            } else {
                this.lockResult.setAbortInfo(this.lsn, abortKD, abortKey, abortData, abortVLSN, abortExpiration, abortExpirationInHours, db);
            }
            return wri;
        }

        public static WriteLockInfo prepareForInsert(BIN bin) {
            WriteLockInfo wri = new WriteLockInfo();
            wri.setDb(bin.getDatabase());
            return wri;
        }
    }
}

