/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbType;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.DbOpReplicationContext;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.HandleLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.utilint.StringUtils;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class DbTree
implements Loggable {
    public static final DatabaseId ID_DB_ID = new DatabaseId(0L);
    public static final DatabaseId NAME_DB_ID = new DatabaseId(1L);
    private static final Map<String, DbType> INTERNAL_TYPES_BY_NAME;
    public static final long NEG_DB_ID_START = -256L;
    private final AtomicLong lastAllocatedLocalDbId;
    private final AtomicLong lastAllocatedReplicatedDbId;
    private final DatabaseImpl idDatabase;
    private final DatabaseImpl nameDatabase;
    private int initialLogVersion;
    private byte flags;
    private static final byte REPLICATED_BIT = 1;
    private static final byte REP_CONVERTED_BIT = 2;
    private static final byte DUPS_CONVERTED_BIT = 4;
    private static final byte PRESERVE_VLSN_BIT = 8;
    private static final long FAST_NAME_LOOKUP_MAX_LNS = 100L;
    private EnvironmentImpl envImpl;

    public static DbType typeForDbName(String dbName) {
        DbType t = INTERNAL_TYPES_BY_NAME.get(dbName);
        if (t != null) {
            return t;
        }
        return DbType.USER;
    }

    public DbTree() {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.idDatabase.setDebugDatabaseName(DbType.ID.getInternalName());
        this.idDatabase.clearKeyPrefixing();
        this.nameDatabase = new DatabaseImpl();
        this.nameDatabase.clearKeyPrefixing();
        this.nameDatabase.setDebugDatabaseName(DbType.NAME.getInternalName());
        this.lastAllocatedLocalDbId = new AtomicLong();
        this.lastAllocatedReplicatedDbId = new AtomicLong();
        this.initialLogVersion = -1;
    }

    public DbTree(EnvironmentImpl env, boolean replicationIntended, boolean preserveVLSN) throws DatabaseException {
        this.envImpl = env;
        this.lastAllocatedLocalDbId = new AtomicLong(1L);
        this.lastAllocatedReplicatedDbId = new AtomicLong(-256L);
        DatabaseConfig idConfig = new DatabaseConfig();
        idConfig.setReplicated(false);
        idConfig.setKeyPrefixing(false);
        this.idDatabase = new DatabaseImpl(null, DbType.ID.getInternalName(), new DatabaseId(0L), env, idConfig);
        this.idDatabase.clearKeyPrefixing();
        DatabaseConfig nameConfig = new DatabaseConfig();
        nameConfig.setKeyPrefixing(false);
        this.nameDatabase = new DatabaseImpl(null, DbType.NAME.getInternalName(), new DatabaseId(1L), env, nameConfig);
        this.nameDatabase.clearKeyPrefixing();
        if (replicationIntended) {
            this.setIsReplicated();
        }
        if (preserveVLSN) {
            this.setPreserveVLSN();
        }
        this.setDupsConverted();
        this.initialLogVersion = 15;
    }

    public long getLastLocalDbId() {
        return this.lastAllocatedLocalDbId.get();
    }

    public long getLastReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.get();
    }

    private long getNextLocalDbId() {
        return this.lastAllocatedLocalDbId.incrementAndGet();
    }

    private long getNextReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.decrementAndGet();
    }

    public void setLastDbId(long lastReplicatedDbId, long lastLocalDbId) {
        this.lastAllocatedReplicatedDbId.set(lastReplicatedDbId);
        this.lastAllocatedLocalDbId.set(lastLocalDbId);
    }

    private boolean isReplicatedId(long id) {
        return id < -256L;
    }

    public void updateFromReplay(DatabaseId replayDbId) {
        assert (!this.envImpl.isMaster());
        long replayVal = replayDbId.getId();
        if (replayVal > 0L && !this.envImpl.isRepConverted()) {
            throw EnvironmentFailureException.unexpectedState("replay database id is unexpectedly positive " + replayDbId);
        }
        if (replayVal < this.lastAllocatedReplicatedDbId.get()) {
            this.lastAllocatedReplicatedDbId.set(replayVal);
        }
    }

    void initExistingEnvironment(EnvironmentImpl eImpl) throws DatabaseException {
        eImpl.checkRulesForExistingEnv(this.isReplicated(), this.getPreserveVLSN());
        this.envImpl = eImpl;
        this.idDatabase.setEnvironmentImpl(eImpl);
        this.nameDatabase.setEnvironmentImpl(eImpl);
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, HandleLocker handleLocker) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, handleLocker, null, null);
    }

    public DatabaseImpl createInternalDb(Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        dbConfig.setKeyPrefixing(false);
        DatabaseImpl ret = this.doCreateDb(locker, databaseName, dbConfig, null, null, null);
        ret.clearKeyPrefixing();
        return ret;
    }

    public DatabaseImpl createReplicaDb(Locker locker, String databaseName, DatabaseConfig dbConfig, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, null, replicatedLN, repContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doCreateDb(Locker nameLocker, String databaseName, DatabaseConfig dbConfig, HandleLocker handleLocker, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        DatabaseId newId = null;
        long allocatedLocalDbId = 0L;
        long allocatedRepDbId = 0L;
        if (replicatedLN != null) {
            newId = replicatedLN.getId();
        } else if (this.envImpl.isReplicated() && dbConfig.getReplicated()) {
            newId = new DatabaseId(this.getNextReplicatedDbId());
            allocatedRepDbId = newId.getId();
        } else {
            newId = new DatabaseId(this.getNextLocalDbId());
            allocatedLocalDbId = newId.getId();
        }
        DatabaseImpl newDb = null;
        CursorImpl idCursor = null;
        CursorImpl nameCursor = null;
        boolean operationOk = false;
        Locker idDbLocker = null;
        try {
            newDb = new DatabaseImpl(nameLocker, databaseName, newId, this.envImpl, dbConfig);
            ReplicationContext useRepContext = repContext;
            if (repContext == null) {
                useRepContext = newDb.getOperationRepContext(DbOperationType.CREATE);
            }
            this.checkReplicaWrite(nameLocker, useRepContext);
            nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
            NameLN nameLN = null;
            nameLN = replicatedLN != null ? replicatedLN : new NameLN(newId);
            nameCursor.insertRecord(StringUtils.toUTF8(databaseName), nameLN, false, useRepContext);
            if (handleLocker != null) {
                this.acquireHandleLock(nameCursor, handleLocker);
            }
            idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
            idCursor = new CursorImpl(this.idDatabase, idDbLocker);
            idCursor.insertRecord(newId.getBytes(), new MapLN(newDb), false, ReplicationContext.NO_REPLICATE);
            newDb.incrementUseCount();
            operationOk = true;
        }
        finally {
            if (idCursor != null) {
                idCursor.close();
            }
            if (nameCursor != null) {
                nameCursor.close();
            }
            if (idDbLocker != null) {
                idDbLocker.operationEnd(operationOk);
            }
            if (!operationOk) {
                if (allocatedRepDbId != 0L) {
                    this.lastAllocatedReplicatedDbId.compareAndSet(allocatedRepDbId, allocatedRepDbId + 1L);
                }
                if (allocatedLocalDbId != 0L) {
                    this.lastAllocatedLocalDbId.compareAndSet(allocatedLocalDbId, allocatedLocalDbId - 1L);
                }
            }
        }
        return newDb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl openNonRepInternalDB(DbType dbType) {
        String name = dbType.getInternalName();
        Txn autoTxn = Txn.createLocalAutoTxn(this.envImpl, new TransactionConfig());
        boolean operationOk = false;
        try {
            DatabaseImpl db = this.getDb(autoTxn, name, null, false);
            if (db == null) {
                if (this.envImpl.isReadOnly()) {
                    DatabaseImpl databaseImpl = null;
                    return databaseImpl;
                }
                DatabaseConfig dbConfig = new DatabaseConfig();
                dbConfig.setReplicated(false);
                db = this.createInternalDb(autoTxn, name, dbConfig);
            }
            operationOk = true;
            DatabaseImpl databaseImpl = db;
            return databaseImpl;
        }
        finally {
            ((Locker)autoTxn).operationEnd(operationOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireHandleLock(CursorImpl nameCursor, HandleLocker handleLocker) {
        nameCursor.latchBIN();
        try {
            long lsn = nameCursor.getCurrentLsn();
            LockResult lockResult = handleLocker.nonBlockingLock(lsn, LockType.READ, true, this.nameDatabase);
            if (lockResult.getLockGrant() == LockGrantType.DENIED) {
                nameCursor.getLocker().checkPreempted(null);
                throw EnvironmentFailureException.unexpectedState("No contention is possible with HandleLocker: " + DbLsn.getNoFormatString(lsn));
            }
        }
        finally {
            nameCursor.releaseBIN();
        }
    }

    public void optionalModifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.isDeferredWriteMode()) {
            return;
        }
        this.modifyDbRoot(db);
    }

    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        this.modifyDbRoot(db, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyDbRoot(DatabaseImpl db, long ifBeforeLsn, boolean mustExist) throws DatabaseException {
        if (this.envImpl.isReadOnly() && this.envImpl.isInInit()) {
            return;
        }
        if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
            this.envImpl.logMapTreeRoot();
        } else {
            DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
            while (true) {
                BasicLocker idDbLocker = null;
                CursorImpl cursor = null;
                boolean operationOk = false;
                try {
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    cursor = new CursorImpl(this.idDatabase, idDbLocker);
                    boolean found = cursor.searchExact(keyDbt, LockType.WRITE);
                    if (!found) {
                        if (!mustExist) break;
                        throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.LOG_INTEGRITY, "Can't find database ID: " + db.getId());
                    }
                    if (ifBeforeLsn != -1L && DbLsn.compareTo(cursor.getCurrentLsn(), ifBeforeLsn) >= 0) break;
                    MapLN mapLN = (MapLN)cursor.getCurrentLN(true, true);
                    assert (mapLN != null);
                    RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                    mapLN.getDatabase().getTree().withRootLatchedExclusive(writeMapLN);
                    operationOk = true;
                    break;
                }
                catch (LockConflictException lockConflictException) {}
                continue;
                finally {
                    if (cursor != null) {
                        cursor.releaseBIN();
                        cursor.close();
                    }
                    if (idDbLocker == null) continue;
                    ((Locker)idDbLocker).operationEnd(operationOk);
                    continue;
                }
                break;
            }
        }
    }

    private void checkReplicaWrite(Locker locker, ReplicationContext repContext) {
        if (repContext != null && repContext.mustGenerateVLSN()) {
            locker.disallowReplicaWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NameLockResult lockNameLN(Locker locker, String databaseName, String action, GetRepContext getRepContext) throws DatabaseNotFoundException, NeedRepLockerException {
        NameLockResult result2 = new NameLockResult();
        result2.dbImpl = this.getDb(locker, databaseName, null, true);
        if (result2.dbImpl == null) {
            throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
        }
        boolean success = false;
        try {
            result2.repContext = getRepContext.get(result2.dbImpl);
            this.checkReplicaWrite(locker, result2.repContext);
            if (this.envImpl.isReplicated() && result2.dbImpl.isReplicated() && locker.getTxnLocker() != null && locker.getTxnLocker().isAutoTxn() && !locker.isReplicated()) {
                throw new NeedRepLockerException();
            }
            result2.nameCursor = new CursorImpl(this.nameDatabase, locker);
            DatabaseEntry key = new DatabaseEntry(StringUtils.toUTF8(databaseName));
            boolean found = result2.nameCursor.searchExact(key, LockType.WRITE);
            if (!found) {
                throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
            }
            result2.nameLN = (NameLN)result2.nameCursor.getCurrentLN(true, true);
            assert (result2.nameLN != null);
            if (locker.getImportunate()) {
                String msg = "Database " + databaseName + " has been forcibly closed in order to apply a replicated " + action + " operation.  This Database and all associated Cursors must be closed.  All associated Transactions must be aborted.";
                for (Database db : result2.dbImpl.getReferringHandles()) {
                    DbInternal.setPreempted(db, databaseName, msg);
                }
            } else {
                int handleCount = result2.dbImpl.getReferringHandleCount();
                if (handleCount > 0) {
                    throw new IllegalStateException("Can't " + action + " database " + databaseName + ", " + handleCount + " open Database handles exist");
                }
            }
            success = true;
        }
        finally {
            if (!success) {
                this.releaseDb(result2.dbImpl);
                if (result2.nameCursor != null) {
                    result2.nameCursor.releaseBIN();
                    result2.nameCursor.close();
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateNameLN(Locker locker, String dbName, final DbOpReplicationContext repContext) throws LockConflictException {
        NameLockResult result2;
        assert (dbName != null);
        try {
            result2 = this.lockNameLN(locker, dbName, "updateConfig", new GetRepContext(){

                @Override
                public ReplicationContext get(DatabaseImpl dbImpl) {
                    return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.UPDATE_CONFIG, null);
                }
            });
        }
        catch (NeedRepLockerException e) {
            throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
        }
        CursorImpl nameCursor = result2.nameCursor;
        DatabaseImpl dbImpl = result2.dbImpl;
        ReplicationContext useRepContext = result2.repContext;
        try {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.updateCurrentRecord(null, dataDbt, null, null, null, useRepContext);
        }
        finally {
            this.releaseDb(dbImpl);
            nameCursor.releaseBIN();
            nameCursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doRenameDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, final DbOpReplicationContext repContext) throws DatabaseNotFoundException, NeedRepLockerException {
        NameLockResult result2 = this.lockNameLN(locker, databaseName, "rename", new GetRepContext(){

            @Override
            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.RENAME);
            }
        });
        CursorImpl nameCursor = result2.nameCursor;
        DatabaseImpl dbImpl = result2.dbImpl;
        ReplicationContext useRepContext = result2.repContext;
        try {
            nameCursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
            NameLN useLN = replicatedLN != null ? replicatedLN : new NameLN(dbImpl.getId());
            nameCursor.reset();
            nameCursor.insertRecord(StringUtils.toUTF8(newName), useLN, false, useRepContext);
            dbImpl.setDebugDatabaseName(newName);
            DatabaseImpl databaseImpl = dbImpl;
            return databaseImpl;
        }
        finally {
            this.releaseDb(dbImpl);
            nameCursor.close();
        }
    }

    public DatabaseImpl dbRename(Locker locker, String databaseName, String newName) throws DatabaseNotFoundException, NeedRepLockerException {
        return this.doRenameDb(locker, databaseName, newName, null, null);
    }

    public DatabaseImpl renameReplicaDb(Locker locker, String databaseName, String newName, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        try {
            return this.doRenameDb(locker, databaseName, newName, replicatedLN, repContext);
        }
        catch (NeedRepLockerException e) {
            throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseImpl doRemoveDb(Locker locker, String databaseName, DatabaseId checkId, final DbOpReplicationContext repContext) throws DatabaseNotFoundException, NeedRepLockerException {
        CursorImpl nameCursor = null;
        NameLockResult result2 = this.lockNameLN(locker, databaseName, "remove", new GetRepContext(){

            @Override
            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.REMOVE);
            }
        });
        ReplicationContext useRepContext = result2.repContext;
        try {
            nameCursor = result2.nameCursor;
            if (checkId != null && !checkId.equals(result2.nameLN.getId())) {
                throw new DatabaseNotFoundException("ID mismatch: " + databaseName);
            }
            nameCursor.deleteCurrentRecord(useRepContext);
            locker.markDeleteAtTxnEnd(result2.dbImpl, true);
            DatabaseImpl databaseImpl = result2.dbImpl;
            return databaseImpl;
        }
        finally {
            if (nameCursor != null) {
                nameCursor.close();
            }
        }
    }

    public DatabaseImpl dbRemove(Locker locker, String databaseName, DatabaseId checkId) throws DatabaseNotFoundException, NeedRepLockerException {
        return this.doRemoveDb(locker, databaseName, checkId, null);
    }

    public void removeReplicaDb(Locker locker, String databaseName, DatabaseId checkId, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        try {
            this.doRemoveDb(locker, databaseName, checkId, repContext);
        }
        catch (NeedRepLockerException e) {
            throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TruncateDbResult doTruncateDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, final DbOpReplicationContext repContext) throws DatabaseNotFoundException, NeedRepLockerException {
        assert (replicatedLN == null || repContext != null);
        NameLockResult result2 = this.lockNameLN(locker, databaseName, "truncate", new GetRepContext(){

            @Override
            public ReplicationContext get(DatabaseImpl dbImpl) {
                return repContext != null ? repContext : dbImpl.getOperationRepContext(DbOperationType.TRUNCATE, dbImpl.getId());
            }
        });
        CursorImpl nameCursor = result2.nameCursor;
        ReplicationContext useRepContext = result2.repContext;
        try {
            DatabaseImpl oldDb = result2.dbImpl;
            DatabaseId newId = replicatedLN != null ? replicatedLN.getId() : new DatabaseId(this.isReplicatedId(oldDb.getId().getId()) ? this.getNextReplicatedDbId() : this.getNextLocalDbId());
            DatabaseImpl newDb = oldDb.cloneDatabase();
            newDb.incrementUseCount();
            newDb.setId(newId);
            newDb.setTree(new Tree(newDb));
            BasicLocker idDbLocker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                idCursor.insertRecord(newId.getBytes(), new MapLN(newDb), false, ReplicationContext.NO_REPLICATE);
                operationOk = true;
            }
            finally {
                if (idCursor != null) {
                    idCursor.close();
                }
                if (idDbLocker != null) {
                    ((Locker)idDbLocker).operationEnd(operationOk);
                }
            }
            result2.nameLN.setId(newDb.getId());
            long recordCount = returnCount ? oldDb.count(0L) : 0L;
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.updateCurrentRecord(null, dataDbt, null, null, null, useRepContext);
            locker.markDeleteAtTxnEnd(oldDb, true);
            locker.markDeleteAtTxnEnd(newDb, false);
            TruncateDbResult truncateDbResult = new TruncateDbResult(oldDb, newDb, recordCount);
            return truncateDbResult;
        }
        finally {
            nameCursor.releaseBIN();
            nameCursor.close();
        }
    }

    public TruncateDbResult truncate(Locker locker, String databaseName, boolean returnCount) throws DatabaseNotFoundException, NeedRepLockerException {
        return this.doTruncateDb(locker, databaseName, returnCount, null, null);
    }

    public TruncateDbResult truncateReplicaDb(Locker locker, String databaseName, boolean returnCount, NameLN replicatedLN, DbOpReplicationContext repContext) throws DatabaseNotFoundException {
        try {
            return this.doTruncateDb(locker, databaseName, returnCount, replicatedLN, repContext);
        }
        catch (NeedRepLockerException e) {
            throw EnvironmentFailureException.unexpectedException(this.envImpl, (Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteMapLN(DatabaseId id) throws DatabaseException {
        boolean done = false;
        while (!done) {
            BasicLocker idDbLocker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                boolean found = idCursor.searchExact(new DatabaseEntry(id.getBytes()), LockType.WRITE);
                if (found) {
                    MapLN mapLN = (MapLN)idCursor.getCurrentLN(true, true);
                    assert (mapLN != null);
                    DatabaseImpl dbImpl = mapLN.getDatabase();
                    if (!dbImpl.isInUseDuringDbRemove()) {
                        idCursor.deleteCurrentRecord(ReplicationContext.NO_REPLICATE);
                        done = true;
                    }
                } else {
                    done = true;
                }
                operationOk = true;
            }
            catch (LockConflictException lockConflictException) {}
            continue;
            finally {
                if (idCursor != null) {
                    idCursor.releaseBIN();
                    idCursor.close();
                }
                if (idDbLocker == null) continue;
                ((Locker)idDbLocker).operationEnd(operationOk);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, HandleLocker handleLocker, boolean writeLock) throws DatabaseException {
        if (databaseName.equals(DbType.ID.getInternalName())) {
            return this.idDatabase;
        }
        if (databaseName.equals(DbType.NAME.getInternalName())) {
            return this.nameDatabase;
        }
        CursorImpl nameCursor = null;
        DatabaseId id = null;
        try {
            nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
            DatabaseEntry keyDbt = new DatabaseEntry(StringUtils.toUTF8(databaseName));
            boolean found = writeLock ? nameCursor.searchExact(keyDbt, LockType.WRITE) : nameCursor.searchExact(keyDbt, LockType.READ);
            if (found) {
                NameLN nameLN = (NameLN)nameCursor.getCurrentLN(true, true);
                assert (nameLN != null);
                id = nameLN.getId();
                if (handleLocker != null) {
                    this.acquireHandleLock(nameCursor, handleLocker);
                }
            }
        }
        finally {
            if (nameCursor != null) {
                nameCursor.releaseBIN();
                nameCursor.close();
            }
        }
        if (id == null) {
            return null;
        }
        return this.getDb(id, -1L, databaseName);
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        return this.getDb(dbId, lockTimeout, (String)null);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        if (dbCache.containsKey(dbId)) {
            return dbCache.get(dbId);
        }
        DatabaseImpl db = this.getDb(dbId, lockTimeout, (String)null);
        dbCache.put(dbId, db);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, String dbNameIfAvailable) throws DatabaseException {
        if (dbId.equals(this.idDatabase.getId())) {
            return this.idDatabase;
        }
        if (dbId.equals(this.nameDatabase.getId())) {
            return this.nameDatabase;
        }
        DatabaseImpl foundDbImpl = null;
        while (true) {
            BasicLocker locker = null;
            CursorImpl idCursor = null;
            boolean operationOk = false;
            try {
                DatabaseEntry keyDbt;
                boolean found;
                locker = BasicLocker.createBasicLocker(this.envImpl);
                if (lockTimeout != -1L) {
                    locker.setLockTimeout(lockTimeout);
                }
                if (found = (idCursor = new CursorImpl(this.idDatabase, locker)).searchExact(keyDbt = new DatabaseEntry(dbId.getBytes()), LockType.READ)) {
                    MapLN mapLN = (MapLN)idCursor.getCurrentLN(true, true);
                    assert (mapLN != null);
                    foundDbImpl = mapLN.getDatabase();
                    foundDbImpl.incrementUseCount();
                }
                operationOk = true;
                break;
            }
            catch (LockConflictException lockConflictException) {}
            continue;
            finally {
                if (idCursor != null) {
                    idCursor.releaseBIN();
                    idCursor.close();
                }
                if (locker == null) continue;
                ((Locker)locker).operationEnd(operationOk);
                continue;
            }
            break;
        }
        this.setDebugNameForDatabaseImpl(foundDbImpl, dbNameIfAvailable);
        return foundDbImpl;
    }

    public void releaseDb(DatabaseImpl db) {
        if (db != null && db != this.idDatabase && db != this.nameDatabase) {
            db.decrementUseCount();
        }
    }

    public void releaseDbs(Map<DatabaseId, DatabaseImpl> dbCache) {
        if (dbCache != null) {
            for (DatabaseImpl databaseImpl : dbCache.values()) {
                this.releaseDb(databaseImpl);
            }
        }
    }

    private void setDebugNameForDatabaseImpl(DatabaseImpl dbImpl, String dbName) throws DatabaseException {
        if (dbImpl != null) {
            if (dbName != null) {
                dbImpl.setDebugDatabaseName(dbName);
            } else if (this.envImpl.isValid() && !dbImpl.isDebugNameAvailable() && this.getFastNameLookup()) {
                dbImpl.setDebugDatabaseName(this.getDbName(dbImpl.getId()));
            }
        }
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    private boolean getFastNameLookup() {
        return this.nameDatabase.getTree().getMaxLNs() <= 100L;
    }

    public String getDbName(final DatabaseId id) throws DatabaseException {
        if (id.equals(ID_DB_ID)) {
            return DbType.ID.getInternalName();
        }
        if (id.equals(NAME_DB_ID)) {
            return DbType.NAME.getInternalName();
        }
        class Traversal
        implements CursorImpl.WithCursor {
            String name = null;

            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                if (nameLN != null && nameLN.getId().equals(id)) {
                    this.name = StringUtils.fromUTF8(key.getData());
                    return false;
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return traversal.name;
    }

    public Map<DatabaseId, String> getDbNamesAndIds() throws DatabaseException {
        final HashMap<DatabaseId, String> nameMap = new HashMap<DatabaseId, String>();
        class Traversal
        implements CursorImpl.WithCursor {
            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.lockAndGetCurrentLN(LockType.NONE);
                DatabaseId id = nameLN.getId();
                nameMap.put(id, StringUtils.fromUTF8(key.getData()));
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return nameMap;
    }

    public List<String> getDbNames() throws DatabaseException {
        final ArrayList<String> nameList = new ArrayList<String>();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                String name = StringUtils.fromUTF8(key.getData());
                if (!DbTree.isReservedDbName(name)) {
                    nameList.add(name);
                }
                return true;
            }
        });
        return nameList;
    }

    public static boolean isReservedDbName(String name) {
        return DbTree.typeForDbName(name).isInternal();
    }

    public int getHighestLevel(DatabaseImpl dbImpl) throws DatabaseException {
        RootLevel getLevel = new RootLevel(dbImpl);
        dbImpl.getTree().withRootLatchedShared(getLevel);
        return getLevel.getRootLevel();
    }

    boolean isReplicated() {
        return (this.flags & 1) != 0;
    }

    void setIsReplicated() {
        this.flags = (byte)(this.flags | 1);
    }

    boolean isRepConverted() {
        return (this.flags & 2) != 0;
    }

    void setIsRepConverted() {
        this.flags = (byte)(this.flags | 2);
    }

    public DatabaseImpl getIdDatabaseImpl() {
        return this.idDatabase;
    }

    public DatabaseImpl getNameDatabaseImpl() {
        return this.nameDatabase;
    }

    boolean getDupsConverted() {
        return (this.flags & 4) != 0;
    }

    void setDupsConverted() {
        this.flags = (byte)(this.flags | 4);
    }

    private boolean getPreserveVLSN() {
        return (this.flags & 8) != 0;
    }

    private void setPreserveVLSN() {
        this.flags = (byte)(this.flags | 8);
    }

    public int getInitialLogVersion() {
        return this.initialLogVersion;
    }

    public void close() {
        this.idDatabase.releaseTreeAdminMemory();
        this.nameDatabase.releaseTreeAdminMemory();
    }

    public long getTreeAdminMemory() {
        return this.idDatabase.getTreeAdminMemory() + this.nameDatabase.getTreeAdminMemory();
    }

    @Override
    public int getLogSize() {
        return LogUtils.getLongLogSize() + LogUtils.getLongLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize() + 1 + LogUtils.getPackedIntLogSize(this.initialLogVersion);
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.lastAllocatedLocalDbId.get());
        LogUtils.writeLong(logBuffer, this.lastAllocatedReplicatedDbId.get());
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
        logBuffer.put(this.flags);
        LogUtils.writePackedInt(logBuffer, this.initialLogVersion);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        if (entryVersion >= 8) {
            this.lastAllocatedLocalDbId.set(LogUtils.readLong(itemBuffer));
            this.lastAllocatedReplicatedDbId.set(LogUtils.readLong(itemBuffer));
        } else {
            this.lastAllocatedLocalDbId.set(LogUtils.readInt(itemBuffer));
            if (entryVersion >= 6) {
                this.lastAllocatedReplicatedDbId.set(LogUtils.readInt(itemBuffer));
            }
        }
        this.idDatabase.readFromLog(itemBuffer, entryVersion);
        this.nameDatabase.readFromLog(itemBuffer, entryVersion);
        this.flags = entryVersion >= 6 ? itemBuffer.get() : (byte)0;
        this.initialLogVersion = entryVersion >= 15 ? LogUtils.readPackedInt(itemBuffer) : -1;
    }

    @Override
    public void dumpLog(StringBuilder sb, boolean verbose) {
        sb.append("<dbtree lastLocalDbId = \"");
        sb.append(this.lastAllocatedLocalDbId);
        sb.append("\" lastReplicatedDbId = \"");
        sb.append(this.lastAllocatedReplicatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    String dumpString(int nSpaces) {
        StringBuilder self = new StringBuilder();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedLocalDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    static {
        EnumSet<DbType> set = EnumSet.allOf(DbType.class);
        INTERNAL_TYPES_BY_NAME = new HashMap<String, DbType>(set.size());
        for (DbType t : set) {
            if (!t.isInternal()) continue;
            INTERNAL_TYPES_BY_NAME.put(t.getInternalName(), t);
        }
    }

    private static class RootLevel
    implements WithRootLatched {
        private final DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null) {
                return null;
            }
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    public static class TruncateDbResult {
        public final DatabaseImpl oldDB;
        public final DatabaseImpl newDb;
        public final long recordCount;

        public TruncateDbResult(DatabaseImpl oldDB, DatabaseImpl newDb, long recordCount) {
            this.oldDB = oldDB;
            this.newDb = newDb;
            this.recordCount = recordCount;
        }
    }

    private static class NameLockResult {
        CursorImpl nameCursor;
        DatabaseImpl dbImpl;
        NameLN nameLN;
        ReplicationContext repContext;

        private NameLockResult() {
        }
    }

    public static class NeedRepLockerException
    extends Exception {
    }

    static interface GetRepContext {
        public ReplicationContext get(DatabaseImpl var1);
    }

    private static class RewriteMapLN
    implements WithRootLatched {
        private final CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        @Override
        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.updateCurrentRecord(null, dataDbt, null, null, null, ReplicationContext.NO_REPLICATE);
            return null;
        }
    }
}

