/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.evictor;

import com.sleepycat.je.evictor.OffHeapAllocator;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;
import sun.misc.Unsafe;

class CHeapAllocator
implements OffHeapAllocator {
    private static final boolean CHECK_BOUNDS = true;
    private static final int SIZE_BYTES = 4;
    private final Unsafe unsafe;
    private final AtomicLong usedBytes = new AtomicLong(0L);

    public CHeapAllocator() {
        try {
            Field field2 = Unsafe.class.getDeclaredField("theUnsafe");
            field2.setAccessible(true);
            this.unsafe = (Unsafe)field2.get(null);
        }
        catch (Throwable e) {
            throw new UnsupportedOperationException("Unable to get Unsafe object", e);
        }
        if (this.unsafe == null) {
            throw new UnsupportedOperationException("Unsafe singleton is null");
        }
        if (Unsafe.ARRAY_BYTE_INDEX_SCALE != 1) {
            throw new UnsupportedOperationException("Unexpected Unsafe.ARRAY_BYTE_INDEX_SCALE: " + Unsafe.ARRAY_BYTE_INDEX_SCALE);
        }
        if (Unsafe.ARRAY_INT_INDEX_SCALE != 4) {
            throw new UnsupportedOperationException("Unexpected Unsafe.ARRAY_INT_INDEX_SCALE: " + Unsafe.ARRAY_INT_INDEX_SCALE);
        }
    }

    @Override
    public void setMaxBytes(long maxBytes) {
    }

    @Override
    public long getUsedBytes() {
        return this.usedBytes.get();
    }

    @Override
    public long allocate(int size) {
        int allocSize = size + 4;
        long memId = this.unsafe.allocateMemory(allocSize);
        this.unsafe.putInt(memId, size);
        this.unsafe.setMemory(memId + 4L, size, (byte)0);
        this.usedBytes.addAndGet(this.addOverhead(allocSize));
        return memId;
    }

    @Override
    public int free(long memId) {
        int totalSize = this.addOverhead(this.size(memId) + 4);
        this.unsafe.freeMemory(memId);
        this.usedBytes.addAndGet(0 - totalSize);
        return totalSize;
    }

    private int addOverhead(int allocSize) {
        return (allocSize += allocSize % 8 + 16) < 24 ? 24 : allocSize;
    }

    @Override
    public int size(long memId) {
        return this.unsafe.getInt(memId);
    }

    @Override
    public int totalSize(long memId) {
        return this.addOverhead(this.size(memId) + 4);
    }

    @Override
    public void copy(long memId, int memOff, byte[] buf2, int bufOff, int len) {
        if (memId == 0L) {
            throw new NullPointerException("memId is 0");
        }
        if (buf2 == null) {
            throw new NullPointerException("buf is null");
        }
        if (memOff < 0 || memOff + len > this.size(memId)) {
            throw new IndexOutOfBoundsException("memOff=" + memOff + " memSize=" + this.size(memId) + " copyLen=" + len);
        }
        if (bufOff < 0 || bufOff + len > buf2.length) {
            throw new IndexOutOfBoundsException("bufOff=" + bufOff + " bufSize=" + buf2.length + " copyLen=" + len);
        }
        this.unsafe.copyMemory(null, memId + 4L + (long)memOff, buf2, Unsafe.ARRAY_BYTE_BASE_OFFSET + bufOff, len);
    }

    @Override
    public void copy(byte[] buf2, int bufOff, long memId, int memOff, int len) {
        if (memId == 0L) {
            throw new NullPointerException("memId is 0");
        }
        if (buf2 == null) {
            throw new NullPointerException("buf is null");
        }
        if (memOff < 0 || memOff + len > this.size(memId)) {
            throw new IndexOutOfBoundsException("memOff=" + memOff + " memSize=" + this.size(memId) + " copyLen=" + len);
        }
        if (bufOff < 0 || bufOff + len > buf2.length) {
            throw new IndexOutOfBoundsException("bufOff=" + bufOff + " bufSize=" + buf2.length + " copyLen=" + len);
        }
        this.unsafe.copyMemory(buf2, Unsafe.ARRAY_BYTE_BASE_OFFSET + bufOff, null, memId + 4L + (long)memOff, len);
    }

    @Override
    public void copy(long fromMemId, int fromMemOff, long toMemId, int toMemOff, int len) {
        if (fromMemId == 0L || toMemId == 0L) {
            throw new NullPointerException("memId is 0");
        }
        if (fromMemOff < 0 || fromMemOff + len > this.size(fromMemId)) {
            throw new IndexOutOfBoundsException("memOff=" + fromMemOff + " memSize=" + this.size(fromMemId) + " copyLen=" + len);
        }
        if (toMemOff < 0 || toMemOff + len > this.size(toMemId)) {
            throw new IndexOutOfBoundsException("memOff=" + toMemOff + " memSize=" + this.size(toMemId) + " copyLen=" + len);
        }
        this.unsafe.copyMemory(null, fromMemId + 4L + (long)fromMemOff, null, toMemId + 4L + (long)toMemOff, len);
    }
}

