/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.utilint.Adler32;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.util.zip.Checksum;

public class ChecksumValidator {
    private static final boolean DEBUG = false;
    private Checksum cksum = Adler32.makeChecksum();

    public void reset() {
        this.cksum.reset();
    }

    public void update(ByteBuffer buf2, int length) throws ChecksumException {
        if (buf2 == null) {
            throw new ChecksumException("null buffer given to checksum validation, probably  result of 0's in log file, len=" + length);
        }
        int bufStart = buf2.position();
        this.update(buf2.array(), bufStart + buf2.arrayOffset(), length);
    }

    public void update(byte[] buf2, int offset, int length) {
        this.cksum.update(buf2, offset, length);
    }

    void validate(long expectedChecksum, long lsn) throws ChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            throw new ChecksumException("Location " + DbLsn.getNoFormatString(lsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }

    public void validate(long expectedChecksum, long fileNum, long fileOffset) throws ChecksumException {
        if (expectedChecksum != this.cksum.getValue()) {
            long problemLsn = DbLsn.makeLsn(fileNum, fileOffset);
            throw new ChecksumException("Location " + DbLsn.getNoFormatString(problemLsn) + " expected " + expectedChecksum + " got " + this.cksum.getValue());
        }
    }
}

