/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.FileReader;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.entry.LogEntry;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class DumpFileReader
extends FileReader {
    private final Set<Byte> targetEntryTypes = new HashSet<Byte>();
    private final Set<Long> targetTxnIds;
    private final Set<Long> targetDbIds;
    protected final boolean verbose;
    private final boolean repEntriesOnly;

    public DumpFileReader(EnvironmentImpl env, int readBufferSize, long startLsn, long finishLsn, long endOfFileLsn, String entryTypes, String dbIds, String txnIds, boolean verbose, boolean repEntriesOnly, boolean forwards) throws DatabaseException {
        super(env, readBufferSize, forwards, startLsn, null, endOfFileLsn, finishLsn);
        StringTokenizer tokenizer;
        if (entryTypes != null) {
            tokenizer = new StringTokenizer(entryTypes, ",");
            while (tokenizer.hasMoreTokens()) {
                String typeString = tokenizer.nextToken();
                this.targetEntryTypes.add(Byte.valueOf(typeString.trim()));
            }
        }
        this.targetDbIds = new HashSet<Long>();
        if (dbIds != null) {
            tokenizer = new StringTokenizer(dbIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String dbIdString = tokenizer.nextToken();
                this.targetDbIds.add(Long.valueOf(dbIdString.trim()));
            }
        }
        this.targetTxnIds = new HashSet<Long>();
        if (txnIds != null) {
            tokenizer = new StringTokenizer(txnIds, ",");
            while (tokenizer.hasMoreTokens()) {
                String txnIdString = tokenizer.nextToken();
                this.targetTxnIds.add(Long.valueOf(txnIdString.trim()));
            }
        }
        this.verbose = verbose;
        this.repEntriesOnly = repEntriesOnly;
    }

    protected boolean needMatchEntry() {
        return !this.targetTxnIds.isEmpty() || !this.targetDbIds.isEmpty();
    }

    protected boolean matchEntry(LogEntry entry) {
        if (!this.targetTxnIds.isEmpty()) {
            LogEntryType type = entry.getLogType();
            if (!type.isTransactional()) {
                return false;
            }
            if (!this.targetTxnIds.contains(entry.getTransactionId())) {
                return false;
            }
        }
        if (!this.targetDbIds.isEmpty()) {
            DatabaseId dbId = entry.getDbId();
            if (dbId == null) {
                return false;
            }
            if (!this.targetDbIds.contains(dbId.getId())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected boolean isTargetEntry() {
        if (this.repEntriesOnly && !this.currentEntryHeader.getReplicated()) {
            return false;
        }
        if (this.targetEntryTypes.size() == 0) {
            return true;
        }
        return this.targetEntryTypes.contains(this.currentEntryHeader.getType());
    }

    public void summarize(boolean ignore2) {
    }
}

