/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.log.RestoreMarker;
import com.sleepycat.je.rep.InsufficientLogException;
import com.sleepycat.je.rep.NetworkRestoreConfig;
import com.sleepycat.je.rep.ReplicationNode;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.networkRestore.NetworkBackup;
import com.sleepycat.je.rep.impl.networkRestore.NetworkBackupStats;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.VLSN;
import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;

public class NetworkRestore {
    private RepImpl repImpl;
    private VLSN minVLSN;
    private int maxLag;
    private ReplicationNode logProvider;
    private volatile NetworkBackup backup;
    private Logger logger;
    private TestHook<File> interruptHook;

    private List<Server> init(InsufficientLogException logException, NetworkRestoreConfig config) throws IllegalArgumentException {
        List<ReplicationNode> logProviders;
        this.repImpl = logException.getRepImpl();
        this.logger = LoggerUtils.getLogger(this.getClass());
        this.maxLag = this.repImpl.getConfigManager().getInt(RepParams.NETWORKBACKUP_MAX_LAG);
        if (config.getLogProviders() != null && config.getLogProviders().size() > 0) {
            HashSet<String> memberNames = new HashSet<String>();
            for (ReplicationNode node : logException.getLogProviders()) {
                memberNames.add(node.getName());
            }
            for (ReplicationNode node : config.getLogProviders()) {
                if (memberNames.contains(node.getName())) continue;
                throw new IllegalArgumentException("Node:" + node.getName() + " is not a suitable member for NetworkRestore. It's not a member of logException.getLogProviders(): " + Arrays.toString(memberNames.toArray()));
            }
            logProviders = config.getLogProviders();
        } else {
            logProviders = new LinkedList<ReplicationNode>(logException.getLogProviders());
        }
        LoggerUtils.info(this.logger, this.repImpl, "Started network restore");
        LinkedList<Server> serverList = new LinkedList<Server>();
        VLSN maxVLSN = new VLSN(Long.MAX_VALUE);
        int loadThreshold = -1;
        for (ReplicationNode node : logProviders) {
            serverList.add(new Server(node, maxVLSN, loadThreshold));
        }
        this.minVLSN = maxVLSN;
        return serverList;
    }

    private void resetServerList(List<Server> serverList) {
        if (serverList.isEmpty()) {
            return;
        }
        Collections.sort(serverList);
        Server maxVlsnServer = Collections.max(serverList, Comparator.comparingLong(s -> ((Server)s).rangeEnd.getSequence()));
        this.minVLSN = new VLSN(Math.max(0L, maxVlsnServer.rangeEnd.getSequence() - (long)this.maxLag));
    }

    public synchronized void execute(InsufficientLogException logException, NetworkRestoreConfig config) throws EnvironmentFailureException, IllegalArgumentException {
        try {
            List<Server> serverList = this.init(logException, config);
            boolean firstRound = true;
            while (!serverList.isEmpty()) {
                LinkedList<Server> newServerList = new LinkedList<Server>();
                File envHome = this.repImpl.getEnvironmentHome();
                for (Server server : serverList) {
                    InetSocketAddress serverSocket = server.node.getSocketAddress();
                    if (serverSocket.equals(this.repImpl.getSocket())) continue;
                    LoggerUtils.info(this.logger, this.repImpl, "Network restore candidate server: " + server.node);
                    this.logProvider = server.node;
                    long startTime = System.currentTimeMillis();
                    try {
                        this.backup = new NetworkBackup(serverSocket, config.getReceiveBufferSize(), envHome, this.repImpl.getNameIdPair(), config.getRetainLogFiles(), server.load, this.minVLSN, this.repImpl, this.repImpl.getFileManager(), this.repImpl.getLogManager(), this.repImpl.getChannelFactory(), logException.getProperties());
                        this.backup.setInterruptHook(this.interruptHook);
                        this.backup.execute();
                        LoggerUtils.info(this.logger, this.repImpl, String.format("Network restore completed from: %s. Elapsed time: %,d s.", server.node, (System.currentTimeMillis() - startTime) / 1000L));
                        return;
                    }
                    catch (RestoreMarker.FileCreationException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                    catch (DatabaseException e) {
                        LoggerUtils.warning(this.logger, this.repImpl, "Backup failed from node: " + server.node + "\n" + e.getMessage());
                    }
                    catch (ConnectException e) {
                        LoggerUtils.info(this.logger, this.repImpl, "Backup server node: " + server.node + " is not available: " + e.getMessage());
                    }
                    catch (ServiceDispatcher.ServiceConnectFailedException | IOException e) {
                        LoggerUtils.warning(this.logger, this.repImpl, "Backup failed from node: " + server.node + "\n" + e.getMessage());
                    }
                    catch (NetworkBackup.RejectedServerException e) {
                        if (!firstRound) {
                            LoggerUtils.info(this.logger, this.repImpl, e.getMessage());
                        }
                        newServerList.add(new Server(server.node, e.getRangeLast(), e.getActiveServers()));
                    }
                    catch (IllegalArgumentException e) {
                        throw EnvironmentFailureException.unexpectedException(e);
                    }
                }
                serverList = newServerList;
                this.resetServerList(serverList);
                firstRound = false;
            }
            throw EnvironmentFailureException.unexpectedState("Tried and failed with every node");
        }
        finally {
            logException.releaseRepImpl();
        }
    }

    public NetworkBackup getBackup() {
        return this.backup;
    }

    public ReplicationNode getLogProvider() {
        return this.logProvider;
    }

    public NetworkBackupStats getNetworkBackupStats() {
        NetworkBackup currentBackup = this.backup;
        return currentBackup != null ? currentBackup.getStats() : null;
    }

    public void setInterruptHook(TestHook<File> hook) {
        this.interruptHook = hook;
    }

    private static class Server
    implements Comparable<Server> {
        private final ReplicationNode node;
        private final VLSN rangeEnd;
        private final int load;

        public Server(ReplicationNode node, VLSN rangeEnd, int load) {
            this.node = node;
            this.rangeEnd = rangeEnd;
            this.load = load;
        }

        @Override
        public int compareTo(Server o) {
            return this.load - o.load;
        }

        public String toString() {
            return this.node.getName();
        }
    }
}

