/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.arbiter.impl;

import com.sleepycat.je.JEVersion;
import com.sleepycat.je.rep.arbiter.impl.ArbiterImpl;
import com.sleepycat.je.rep.impl.BinaryNodeStateProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.BinaryProtocol;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.JVMSystemUtils;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.IOException;
import java.util.logging.Logger;

public class ArbBinaryStateService
extends ServiceDispatcher.ExecutingService {
    private final ArbiterImpl arbImpl;
    private final ServiceDispatcher dispatcher;
    private final Logger logger;
    public static final String SERVICE_NAME = "BinaryNodeState";

    public ArbBinaryStateService(ServiceDispatcher dispatcher, ArbiterImpl arbImpl) {
        super(SERVICE_NAME, dispatcher);
        this.arbImpl = arbImpl;
        this.dispatcher = dispatcher;
        this.logger = LoggerUtils.getLogger(this.getClass());
        dispatcher.register(this);
    }

    public void shutdown() {
        this.dispatcher.cancel(SERVICE_NAME);
    }

    @Override
    public Runnable getRunnable(DataChannel dataChannel) {
        return new NodeStateServiceRunnable(dataChannel);
    }

    class NodeStateServiceRunnable
    implements Runnable {
        private final DataChannel channel;

        NodeStateServiceRunnable(DataChannel channel) {
            this.channel = channel;
        }

        private BinaryNodeStateProtocol.BinaryNodeStateResponse createResponse(BinaryNodeStateProtocol protocol) {
            long joinTime = ArbBinaryStateService.this.arbImpl.getJoinGroupTime();
            long vlsnValue = ArbBinaryStateService.this.arbImpl.getArbiterVLSNTracker().get() == null ? 0L : ArbBinaryStateService.this.arbImpl.getArbiterVLSNTracker().get().getSequence();
            BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
            binaryNodeStateProtocol.getClass();
            return new BinaryNodeStateProtocol.BinaryNodeStateResponse(binaryNodeStateProtocol, ArbBinaryStateService.this.arbImpl.getNameIdPair().getName(), ArbBinaryStateService.this.arbImpl.getGroupName(), ArbBinaryStateService.this.arbImpl.getMasterStatus().getNodeMasterNameId().getName(), JEVersion.CURRENT_VERSION, joinTime, ArbBinaryStateService.this.arbImpl.getNodeState(), vlsnValue, vlsnValue, 0, 15, null, JVMSystemUtils.getSystemLoad());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BinaryNodeStateProtocol protocol = null;
            try {
                protocol = new BinaryNodeStateProtocol(NameIdPair.NOCHECK, ArbBinaryStateService.this.arbImpl.getRepImpl());
                try {
                    this.channel.getSocketChannel().configureBlocking(true);
                    BinaryNodeStateProtocol.BinaryNodeStateRequest msg = protocol.read(this.channel, BinaryNodeStateProtocol.BinaryNodeStateRequest.class);
                    String groupName = msg.getGroupName();
                    if (!ArbBinaryStateService.this.arbImpl.getGroupName().equals(groupName) || !ArbBinaryStateService.this.arbImpl.getNameIdPair().getName().equals(msg.getNodeName())) {
                        throw new BinaryProtocol.ProtocolException("Sending the request to a wrong group or a wrong node.");
                    }
                    BinaryNodeStateProtocol.BinaryNodeStateResponse response = this.createResponse(protocol);
                    protocol.write((BinaryProtocol.Message)response, this.channel);
                    LoggerUtils.finest(ArbBinaryStateService.this.logger, ArbBinaryStateService.this.arbImpl.getRepImpl(), "Deal with a node state request successfully.");
                }
                catch (BinaryProtocol.ProtocolException e) {
                    LoggerUtils.info(ArbBinaryStateService.this.logger, ArbBinaryStateService.this.arbImpl.getRepImpl(), "Get a ProtocolException with message: " + LoggerUtils.exceptionTypeAndMsg(e) + " while dealing with a node state request.");
                    BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
                    binaryNodeStateProtocol.getClass();
                    protocol.write((BinaryProtocol.Message)new BinaryProtocol.ProtocolError((BinaryProtocol)binaryNodeStateProtocol, e.getMessage()), this.channel);
                }
                catch (Exception e) {
                    LoggerUtils.info(ArbBinaryStateService.this.logger, ArbBinaryStateService.this.arbImpl.getRepImpl(), "Unexpected exception: " + LoggerUtils.exceptionTypeAndMsg(e));
                    BinaryNodeStateProtocol binaryNodeStateProtocol = protocol;
                    binaryNodeStateProtocol.getClass();
                    protocol.write((BinaryProtocol.Message)new BinaryProtocol.ProtocolError((BinaryProtocol)binaryNodeStateProtocol, e.getMessage()), this.channel);
                }
                finally {
                    if (this.channel.isOpen()) {
                        this.channel.close();
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

