/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.rep.elections.ElectionAgentThread;
import com.sleepycat.je.rep.elections.ElectionsConfig;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.utilint.LoggerUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.Channels;
import java.util.logging.Level;

public class Acceptor
extends ElectionAgentThread {
    private Proposer.Proposal promisedProposal = null;
    private Protocol.Value acceptedValue = null;
    private final SuggestionGenerator suggestionGenerator;
    public static final String SERVICE_NAME = "Acceptor";
    private final ElectionsConfig config;

    public Acceptor(Protocol protocol, ElectionsConfig config, SuggestionGenerator suggestionGenerator) {
        super((EnvironmentImpl)config.getRepImpl(), protocol, "Acceptor Thread " + config.getNameIdPair().getName());
        this.config = config;
        this.suggestionGenerator = suggestionGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block25: {
            serviceDispatcher = this.config.getServiceDispatcher();
            serviceDispatcher.register("Acceptor", this.channelQueue);
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor started");
            channel = null;
            try {
                while (true) lbl-1000:
                // 6 sources

                {
                    block23: {
                        block24: {
                            block22: {
                                if ((channel = serviceDispatcher.takeChannel("Acceptor", true, this.protocol.getReadTimeout())) == null) {
                                    return;
                                }
                                in = null;
                                out = null;
                                in = new BufferedReader(new InputStreamReader(Channels.newInputStream(channel)));
                                out = new PrintWriter(Channels.newOutputStream(channel), true);
                                requestLine = in.readLine();
                                if (requestLine != null) break block22;
                                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Acceptor: EOF on request");
                                Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                                this.cleanup();
                                continue;
                            }
                            requestMessage = null;
                            try {
                                requestMessage = this.protocol.parseRequest(requestLine);
                            }
                            catch (TextProtocol.InvalidMessageException ime) {
                                this.protocol.processIME(channel, ime);
                                Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                                this.cleanup();
                            }
                            responseMessage = null;
                            if (requestMessage.getOp() == this.protocol.PROPOSE) {
                                responseMessage = this.process((Protocol.Propose)requestMessage);
                                break block23;
                            }
                            if (requestMessage.getOp() == this.protocol.ACCEPT) {
                                responseMessage = this.process((Protocol.Accept)requestMessage);
                                break block23;
                            }
                            if (requestMessage.getOp() != this.protocol.SHUTDOWN) break block24;
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                            this.cleanup();
                            break block25;
                        }
                        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.SEVERE, "Unrecognized request: " + requestLine);
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        this.cleanup();
                        continue;
                    }
                    try {
                        responseMessage.setSendVersion(requestMessage.getSendVersion());
                        out.println(responseMessage.wireFormat());
                    }
                    catch (IOException e) {
                        try {
                            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "IO error on socket: " + e.getMessage());
                        }
                        catch (Throwable var8_11) {
                            Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                            this.cleanup();
                            throw var8_11;
                        }
                        Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                        this.cleanup();
                        continue;
                    }
                    Utils.cleanup(this.logger, this.envImpl, this.formatter, channel, in, out);
                    this.cleanup();
                    continue;
                    break;
                }
            }
            catch (InterruptedException e) {
                if (this.isShutdown()) {
                    return;
                }
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Acceptor unexpected interrupted");
                throw EnvironmentFailureException.unexpectedException(e);
            }
            finally {
                serviceDispatcher.cancel("Acceptor");
                this.cleanup();
            }
            ** GOTO lbl-1000
        }
    }

    TextProtocol.ResponseMessage process(Protocol.Propose propose) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(propose.getProposal()) > 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Propose: " + propose.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.promisedProposal = propose.getProposal();
        Protocol.Value suggestedValue = this.suggestionGenerator.get(this.promisedProposal);
        SuggestionGenerator.Ranking suggestionRanking = this.suggestionGenerator.getRanking(this.promisedProposal);
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Suggested Value: " + suggestedValue + " Suggestion Ranking: " + suggestionRanking);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Promise(protocol, this.promisedProposal, this.acceptedValue, suggestedValue, suggestionRanking, this.config.getElectionPriority(), this.config.getLogVersion(), JEVersion.CURRENT_VERSION);
    }

    TextProtocol.ResponseMessage process(Protocol.Accept accept) {
        if (this.promisedProposal != null && this.promisedProposal.compareTo(accept.getProposal()) != 0) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Reject Accept: " + accept.getProposal() + " Promised proposal: " + this.promisedProposal);
            Protocol protocol = this.protocol;
            protocol.getClass();
            return new Protocol.Reject(protocol, this.promisedProposal);
        }
        this.acceptedValue = accept.getValue();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.FINE, "Promised: " + this.promisedProposal + " Accepted: " + accept.getProposal() + " Value: " + this.acceptedValue);
        Protocol protocol = this.protocol;
        protocol.getClass();
        return new Protocol.Accepted(protocol, accept.getProposal(), this.acceptedValue);
    }

    public static interface SuggestionGenerator {
        public Protocol.Value get(Proposer.Proposal var1);

        public Ranking getRanking(Proposer.Proposal var1);

        public static class Ranking
        implements Comparable<Ranking> {
            final long major;
            final long minor;
            static Ranking UNINITIALIZED = new Ranking(Long.MIN_VALUE, Long.MIN_VALUE);

            public Ranking(long major, long minor) {
                this.major = major;
                this.minor = minor;
            }

            public int hashCode() {
                int prime = 31;
                int result2 = 1;
                result2 = 31 * result2 + (int)(this.major ^ this.major >>> 32);
                result2 = 31 * result2 + (int)(this.minor ^ this.minor >>> 32);
                return result2;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                Ranking other = (Ranking)obj;
                if (this.major != other.major) {
                    return false;
                }
                return this.minor == other.minor;
            }

            public String toString() {
                return "Ranking major:" + this.major + " minor:" + this.minor;
            }

            @Override
            public int compareTo(Ranking o) {
                int result2 = Long.compare(this.major, o.major);
                if (result2 != 0) {
                    return result2;
                }
                return Long.compare(this.minor, o.minor);
            }
        }
    }
}

