/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;

public class MasterValue
extends Protocol.StringValue {
    private static final String DELIMITER = "$$$";
    private static final String DELIMITER_REGEXP = "\\$\\$\\$";
    private final String hostname;
    private final int port;
    private final NameIdPair nameIdPair;
    private static final Protocol.ValueParser masterValueParser = new Protocol.ValueParser(){

        @Override
        public Protocol.Value parse(String wireFormat) {
            return wireFormat == null || "".equals(wireFormat) ? null : new MasterValue(wireFormat);
        }
    };

    public MasterValue(String masterHostname, int masterPort, NameIdPair masterNameIdPair) {
        super(masterHostname + DELIMITER + masterPort + DELIMITER + masterNameIdPair.getName() + DELIMITER + masterNameIdPair.getId());
        this.hostname = masterHostname;
        this.port = masterPort;
        this.nameIdPair = masterNameIdPair;
    }

    public MasterValue(String valueString) {
        super(valueString);
        String[] tokens = valueString.split(DELIMITER_REGEXP);
        this.hostname = tokens[0];
        this.port = Integer.parseInt(tokens[1]);
        this.nameIdPair = new NameIdPair(tokens[2], Integer.parseInt(tokens[3]));
    }

    public String getHostName() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String getNodeName() {
        return this.nameIdPair.getName();
    }

    public NameIdPair getNameId() {
        return this.nameIdPair;
    }

    public static Protocol.ValueParser getParser() {
        return masterValueParser;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result2 = super.hashCode();
        result2 = 31 * result2 + (this.hostname == null ? 0 : this.hostname.hashCode());
        result2 = 31 * result2 + this.nameIdPair.hashCode();
        result2 = 31 * result2 + this.port;
        return result2;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MasterValue)) {
            return false;
        }
        MasterValue other = (MasterValue)obj;
        if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
            return false;
        }
        if (!this.nameIdPair.equals(other.nameIdPair)) {
            return false;
        }
        return this.port == other.port;
    }
}

