/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.impl.node.cbvlsn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.LockNotAvailableException;
import com.sleepycat.je.rep.NodeType;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.impl.node.cbvlsn.LocalCBVLSNTracker;
import com.sleepycat.je.rep.stream.BaseProtocol;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.util.logging.Logger;

public class LocalCBVLSNUpdater {
    private static final String MASTER_SOURCE = "master";
    private static final String HEARTBEAT_SOURCE = "heartbeat";
    private final NameIdPair nameIdPair;
    private final NodeType trackedNodeType;
    private final RepNode repNode;
    private VLSN nodeCBVLSN;
    private boolean updatePending;
    private static boolean suppressGroupDBUpdates = false;
    private final Logger logger;
    private final boolean defunct;

    public LocalCBVLSNUpdater(NameIdPair nameIdPair, NodeType trackedNodeType, RepNode repNode) {
        this.defunct = repNode.isGlobalCBVLSNDefunct();
        if (!this.defunct) {
            this.nameIdPair = nameIdPair;
            this.trackedNodeType = trackedNodeType;
            this.repNode = repNode;
            this.logger = LoggerUtils.getLogger(this.getClass());
        } else {
            this.nameIdPair = null;
            this.trackedNodeType = null;
            this.repNode = null;
            this.logger = null;
        }
        this.nodeCBVLSN = VLSN.NULL_VLSN;
        this.updatePending = false;
    }

    private void set(VLSN syncableVLSN, String source) {
        assert (!this.defunct);
        assert (this.repNode.isMaster()) : "LocalCBVLSNUpdater.set() can only be called by the master";
        if (!this.nodeCBVLSN.equals(syncableVLSN)) {
            LoggerUtils.fine(this.logger, this.repNode.getRepImpl(), "update local CBVLSN for " + this.nameIdPair + " from nodeCBVLSN " + this.nodeCBVLSN + " to " + syncableVLSN + " from " + source);
            if (this.nodeCBVLSN.compareTo(syncableVLSN) >= 0) {
                throw EnvironmentFailureException.unexpectedState(this.repNode.getRepImpl(), "nodeCBVLSN" + this.nodeCBVLSN + " >= " + syncableVLSN + " attempted update local CBVLSN for " + this.nameIdPair + " from " + source);
            }
            this.nodeCBVLSN = syncableVLSN;
            this.updatePending = true;
        }
    }

    public void updateForReplica(BaseProtocol.HeartbeatResponse heartbeat) {
        if (this.defunct) {
            return;
        }
        this.doUpdate(heartbeat.getSyncupVLSN(), HEARTBEAT_SOURCE);
    }

    public void updateForMaster(LocalCBVLSNTracker tracker) {
        if (this.defunct) {
            return;
        }
        this.doUpdate(tracker.getBroadcastCBVLSN(), MASTER_SOURCE);
    }

    private void doUpdate(VLSN vlsn, String source) {
        assert (!this.defunct);
        this.set(vlsn, source);
        this.repNode.getRepImpl().updateCBVLSN(this);
    }

    public void update() {
        if (this.defunct) {
            return;
        }
        if (!this.updatePending) {
            return;
        }
        if (suppressGroupDBUpdates) {
            this.updatePending = false;
            return;
        }
        if (this.repNode.isShutdownOrInvalid()) {
            return;
        }
        try {
            VLSN candidate = this.nodeCBVLSN;
            if (candidate.isNull()) {
                return;
            }
            if (candidate.compareTo(this.repNode.getGlobalCBVLSN()) < 0) {
                return;
            }
            boolean updated = this.repNode.getRepGroupDB().updateLocalCBVLSN(this.nameIdPair, candidate, this.trackedNodeType);
            if (updated) {
                this.updatePending = false;
            }
        }
        catch (EnvironmentFailureException e) {
            throw e;
        }
        catch (LockNotAvailableException lnae) {
            LoggerUtils.info(this.repNode.getLogger(), this.repNode.getRepImpl(), " lock not available without waiting. local cbvlsn update skipped for node: " + this.nameIdPair + " Error: " + lnae.getMessage());
        }
        catch (DatabaseException e) {
            LoggerUtils.warning(this.repNode.getLogger(), this.repNode.getRepImpl(), "local cbvlsn update failed for node: " + this.nameIdPair + " Error: " + e.getMessage() + "\n" + LoggerUtils.getStackTrace(e));
        }
    }

    public static void setSuppressGroupDBUpdates(boolean suppressGroupDBUpdates) {
        LocalCBVLSNUpdater.suppressGroupDBUpdates = suppressGroupDBUpdates;
    }
}

