/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.utilint;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.rep.net.DataChannel;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.utilint.StringUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.Channel;
import java.util.logging.Level;

public class ServiceHandshake {
    public static final int SERVICE_NAME_LIMIT = 127;
    private static final int CHANNEL_WRITE_ATTEMPT_LIMIT = 10;
    private static final String REQUEST_PREFIX = "Service:";
    private static final byte[] REQUEST_PREFIX_BYTES = StringUtils.toASCII("Service:");
    private static final String AUTH_PREFIX = "Authenticate:";
    private static final byte[] AUTH_PREFIX_BYTES = StringUtils.toASCII("Authenticate:");
    private static final String AUTH_MECH_PREFIX = "Mechanism:";
    private static final byte[] AUTH_MECH_PREFIX_BYTES = StringUtils.toASCII("Mechanism:");

    static String mechanisms(AuthenticationMethod[] authList) {
        StringBuilder mechList = new StringBuilder();
        if (authList != null) {
            for (AuthenticationMethod auth : authList) {
                if (mechList.length() > 0) {
                    mechList.append(",");
                }
                mechList.append(auth.getMechanismName());
            }
        }
        return mechList.toString();
    }

    static AuthenticationMethod findMatch(String[] mechList, AuthenticationMethod[] authList) {
        for (AuthenticationMethod auth : authList) {
            for (String mech : mechList) {
                if (!mech.equals(auth.getMechanismName())) continue;
                return auth;
            }
        }
        return null;
    }

    private static boolean arraysEqual(byte[] array1, byte[] array2, int len) {
        for (int i = 0; i < len; ++i) {
            if (array1[i] == array2[i]) continue;
            return false;
        }
        return true;
    }

    private static String encodeBytes(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }

    private static void putShort(ByteBuffer buf2, short i) {
        byte b = (byte)(i >> 8 & 0xFF);
        buf2.put(b);
        b = (byte)(i >> 0 & 0xFF);
        buf2.put(b);
    }

    private static short getShort(byte[] buf2, int off) {
        return (short)(((buf2[off] & 0xFF) << 8) + ((buf2[off + 1] & 0xFF) << 0));
    }

    static class IOStreamIOAdapter
    implements IOAdapter {
        private final DataInputStream dataInputStream;
        private final OutputStream outputStream;

        IOStreamIOAdapter(InputStream input, OutputStream output) {
            this.dataInputStream = new DataInputStream(input);
            this.outputStream = output;
        }

        @Override
        public int read(byte[] buf2) throws IOException {
            this.dataInputStream.readFully(buf2);
            return buf2.length;
        }

        @Override
        public int write(byte[] buf2) throws IOException {
            this.outputStream.write(buf2);
            this.outputStream.flush();
            return buf2.length;
        }
    }

    static class ByteChannelIOAdapter
    implements IOAdapter {
        private final ByteChannel channel;

        ByteChannelIOAdapter(ByteChannel channel) {
            this.channel = channel;
        }

        @Override
        public int read(byte[] buf2) throws IOException {
            return this.channel.read(ByteBuffer.wrap(buf2));
        }

        @Override
        public int write(byte[] buf2) throws IOException {
            return this.channel.write(ByteBuffer.wrap(buf2));
        }
    }

    public static interface IOAdapter {
        public int read(byte[] var1) throws IOException;

        public int write(byte[] var1) throws IOException;
    }

    static class NoMatchAuthentication
    implements AuthenticationMethod {
        static final String MECHANISM = "NoMatch";

        NoMatchAuthentication() {
        }

        @Override
        public String getMechanismName() {
            return MECHANISM;
        }

        @Override
        public ClientInitOp getClientOp(ClientHandshake initIgnored, String paramsIgnored) {
            return null;
        }

        @Override
        public String getServerParams() {
            return "";
        }

        @Override
        public ServerInitOp getServerOp(ServerHandshake initState) {
            return new NoMatchAuthenticateOp(initState);
        }

        static class NoMatchAuthenticateOp
        extends ServerInitOp {
            NoMatchAuthenticateOp(ServerHandshake initState) {
                super(initState);
            }

            @Override
            protected InitResult processOp(DataChannel channel) throws IOException {
                this.sendBuffer(channel, ServiceDispatcher.Response.INVALID.byteBuffer());
                return InitResult.FAIL;
            }
        }
    }

    public static interface AuthenticationMethod {
        public String getMechanismName();

        public String getServerParams();

        public ServerInitOp getServerOp(ServerHandshake var1);

        public ClientInitOp getClientOp(ClientHandshake var1, String var2);
    }

    static class SendRequestOp
    extends ClientInitOp {
        private final AuthenticationMethod[] authInfo;
        private ClientInitOp authOp;

        SendRequestOp(ClientHandshake initState, AuthenticationMethod[] authInfo) {
            super(initState);
            this.authInfo = authInfo;
        }

        @Override
        protected InitResult processOp(IOAdapter ioAdapter) throws IOException {
            byte[] responseByte = new byte[1];
            ioAdapter.write(this.serviceAuthenticateMessage());
            int result2 = ioAdapter.read(responseByte);
            if (result2 < 0) {
                throw new IOException("No service authenticate response byte: " + result2);
            }
            ServiceDispatcher.Response response = ServiceDispatcher.Response.get(responseByte[0]);
            this.setResponse(response);
            if (response == null) {
                throw new IOException("Unexpected read response byte: " + responseByte[0]);
            }
            if (response != ServiceDispatcher.Response.PROCEED) {
                return InitResult.FAIL;
            }
            byte[] mechPrefix = new byte[AUTH_MECH_PREFIX_BYTES.length + 2];
            result2 = ioAdapter.read(mechPrefix);
            if (result2 < 0) {
                throw new IOException("EOF reading service authenticate response: " + result2);
            }
            if (!ServiceHandshake.arraysEqual(AUTH_MECH_PREFIX_BYTES, mechPrefix, AUTH_MECH_PREFIX_BYTES.length)) {
                throw new IOException("Unexpected service authenticate response: " + ServiceHandshake.encodeBytes(mechPrefix));
            }
            short mechLen = ServiceHandshake.getShort(mechPrefix, AUTH_MECH_PREFIX_BYTES.length);
            if (mechLen < 0) {
                throw new IOException("Invalid mechanism length received: " + mechLen);
            }
            byte[] mechBytes = new byte[mechLen];
            result2 = ioAdapter.read(mechBytes);
            if (result2 < 0) {
                throw new IOException("EOF reading service authenticate mechanism: " + result2);
            }
            String mechStr = StringUtils.fromASCII(mechBytes, 0, mechBytes.length);
            String[] mechList = mechStr.split(":");
            AuthenticationMethod selectedAuth = ServiceHandshake.findMatch(new String[]{mechList[0]}, this.authInfo);
            if (selectedAuth == null) {
                throw new IOException("Requested authentication mechanism not supported; " + mechList[0]);
            }
            this.authOp = selectedAuth.getClientOp(this.initState, mechList.length > 1 ? mechList[1] : "");
            return InitResult.DONE;
        }

        ClientInitOp getAuthOp() {
            return this.authOp;
        }

        private byte[] serviceAuthenticateMessage() {
            byte[] mechListBytes = StringUtils.toASCII(ServiceHandshake.mechanisms(this.authInfo));
            int length = AUTH_PREFIX_BYTES.length + 1 + mechListBytes.length;
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.put(AUTH_PREFIX_BYTES).put((byte)mechListBytes.length).put(mechListBytes);
            return buffer.array();
        }
    }

    static class ExpectAuthRequestOp
    extends ServerInitOp {
        static final int WAIT_FOR_REQUEST = 1;
        static final int WAIT_FOR_LIST_SIZE = 2;
        static final int WAIT_FOR_LIST = 3;
        private int phase;
        private ByteBuffer buffer;
        private AuthenticationMethod[] availableAuth;
        private AuthenticationMethod selectedAuth;

        ExpectAuthRequestOp(ServerHandshake initState, AuthenticationMethod[] authInfo) {
            super(initState);
            this.availableAuth = authInfo;
            this.phase = 1;
            this.buffer = ByteBuffer.allocate(AUTH_PREFIX_BYTES.length);
        }

        AuthenticationMethod getSelectedAuthentication() {
            return this.selectedAuth;
        }

        @Override
        protected InitResult processOp(DataChannel channel) throws IOException {
            InitResult readResult = this.fillBuffer(channel, this.buffer);
            if (readResult != InitResult.DONE) {
                return readResult;
            }
            if (this.phase == 1) {
                String prefix = StringUtils.fromASCII(this.buffer.array(), 0, ServiceHandshake.AUTH_PREFIX.length());
                if (!prefix.equals(ServiceHandshake.AUTH_PREFIX)) {
                    this.initState.logMsg(Level.WARNING, true, "Malformed authentication request: " + prefix);
                    this.sendBuffer(channel, ServiceDispatcher.Response.FORMAT_ERROR.byteBuffer());
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                this.buffer.clear();
                this.buffer.limit(1);
                this.phase = 2;
                readResult = this.fillBuffer(channel, this.buffer);
                if (readResult != InitResult.DONE) {
                    return readResult;
                }
            }
            if (this.phase == 2) {
                this.buffer.flip();
                byte mechListSize = this.buffer.get();
                if (mechListSize < 0) {
                    this.initState.logMsg(Level.WARNING, true, "Negative mechanism list size received: " + mechListSize);
                    this.sendBuffer(channel, ServiceDispatcher.Response.FORMAT_ERROR.byteBuffer());
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                this.buffer = ByteBuffer.allocate(mechListSize);
                this.phase = 3;
                readResult = this.fillBuffer(channel, this.buffer);
                if (readResult != InitResult.DONE) {
                    return readResult;
                }
            }
            if (this.phase != 3) {
                throw EnvironmentFailureException.unexpectedState("Unexpected state: + phase");
            }
            String mechListStr = StringUtils.fromASCII(this.buffer.array(), 0, this.buffer.capacity());
            String[] mechList = mechListStr.split(",");
            this.selectedAuth = ServiceHandshake.findMatch(mechList, this.availableAuth);
            if (this.selectedAuth == null) {
                this.initState.logMsg(Level.WARNING, true, "No acceptable authentication mechanism in list: " + mechListStr);
                this.sendBuffer(channel, ServiceDispatcher.Response.INVALID.byteBuffer());
                this.closeChannel(channel);
                return InitResult.FAIL;
            }
            return InitResult.DONE;
        }
    }

    static class DoAuthenticateOp
    extends ClientInitOp {
        private final AuthenticationMethod[] authInfo;

        DoAuthenticateOp(ClientHandshake initState, AuthenticationMethod[] authInfo) {
            super(initState);
            this.authInfo = authInfo;
        }

        @Override
        protected InitResult processOp(IOAdapter ioAdapter) throws IOException {
            SendRequestOp sendOp = new SendRequestOp(this.initState, this.authInfo);
            InitResult sendResult = sendOp.processOp(ioAdapter);
            if (sendResult != InitResult.DONE) {
                return sendResult;
            }
            ClientInitOp authOp = sendOp.getAuthOp();
            InitResult authResult = authOp.processOp(ioAdapter);
            if (authResult == InitResult.DONE) {
                this.setResponse(authOp.getResponse());
            }
            return authResult;
        }
    }

    static class RequireAuthenticateOp
    extends ServerInitOp {
        private final AuthenticationMethod[] authInfo;
        private ExpectAuthRequestOp expectRequestOp;
        private ServerInitOp authOp;

        RequireAuthenticateOp(ServerHandshake initState, AuthenticationMethod[] authInfo) {
            super(initState);
            this.authInfo = authInfo;
        }

        @Override
        protected InitResult processOp(DataChannel channel) throws IOException {
            if (this.expectRequestOp == null) {
                ServiceDispatcher.Response response = ServiceDispatcher.Response.AUTHENTICATE;
                InitResult writeResult = this.sendBuffer(channel, response.byteBuffer());
                if (writeResult != InitResult.DONE) {
                    return writeResult;
                }
                this.expectRequestOp = new ExpectAuthRequestOp(this.initState, this.authInfo);
            }
            if (this.authOp == null) {
                InitResult readResult = this.expectRequestOp.processOp(channel);
                if (readResult != InitResult.DONE) {
                    return readResult;
                }
                AuthenticationMethod selectedAuth = this.expectRequestOp.getSelectedAuthentication();
                if (selectedAuth == null) {
                    selectedAuth = new NoMatchAuthentication();
                }
                this.authOp = selectedAuth.getServerOp(this.initState);
                String authResponseStr = selectedAuth.getMechanismName() + ":" + selectedAuth.getServerParams();
                byte[] authResponseBytes = StringUtils.toASCII(authResponseStr);
                int length = 1 + AUTH_MECH_PREFIX_BYTES.length + 2 + authResponseBytes.length;
                ByteBuffer buffer = ByteBuffer.allocate(length);
                buffer.put(ServiceDispatcher.Response.PROCEED.byteBuffer());
                buffer.put(AUTH_MECH_PREFIX_BYTES);
                ServiceHandshake.putShort(buffer, (short)authResponseBytes.length);
                buffer.put(authResponseBytes);
                buffer.flip();
                InitResult writeResult = this.sendBuffer(channel, buffer);
                if (writeResult != InitResult.DONE) {
                    return writeResult;
                }
            }
            return this.authOp.processOp(channel);
        }
    }

    static class SendNameOp
    extends ClientInitOp {
        String serviceName;

        SendNameOp(ClientHandshake initState, String serviceName) {
            super(initState);
            this.serviceName = serviceName;
        }

        @Override
        protected InitResult processOp(IOAdapter ioAdapter) throws IOException {
            byte[] message = null;
            try {
                message = SendNameOp.serviceRequestMessage(this.serviceName);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException("Unable to encode requested service name");
            }
            ioAdapter.write(message);
            byte[] responseBytes = new byte[1];
            int result2 = ioAdapter.read(responseBytes);
            if (result2 < 0) {
                throw new IOException("No service response byte: " + result2);
            }
            ServiceDispatcher.Response response = ServiceDispatcher.Response.get(responseBytes[0]);
            if (response == null) {
                throw new IOException("Unexpected read response byte: " + responseBytes[0]);
            }
            this.setResponse(response);
            return InitResult.DONE;
        }

        private static byte[] serviceRequestMessage(String serviceName) {
            byte[] serviceNameBytes = StringUtils.toASCII(serviceName);
            if (serviceNameBytes.length > 127) {
                throw new IllegalArgumentException("The provided service name is too long: " + serviceName);
            }
            int length = REQUEST_PREFIX_BYTES.length + 1 + serviceNameBytes.length;
            ByteBuffer buffer = ByteBuffer.allocate(length);
            buffer.put(REQUEST_PREFIX_BYTES).put((byte)serviceNameBytes.length).put(serviceNameBytes);
            return buffer.array();
        }
    }

    static class ReceiveNameOp
    extends ServerInitOp {
        private final int INITIAL_BUFFER_SIZE = ServiceHandshake.access$000().length + 1;
        private ByteBuffer buffer = ByteBuffer.allocate(this.INITIAL_BUFFER_SIZE);

        ReceiveNameOp(ServerHandshake initState) {
            super(initState);
        }

        @Override
        protected InitResult processOp(DataChannel channel) throws IOException {
            InitResult readResult = this.fillBuffer(channel, this.buffer);
            if (readResult != InitResult.DONE) {
                return readResult;
            }
            this.buffer.flip();
            if (this.buffer.capacity() == this.INITIAL_BUFFER_SIZE) {
                String prefix = StringUtils.fromASCII(this.buffer.array(), 0, ServiceHandshake.REQUEST_PREFIX.length());
                if (!prefix.equals(ServiceHandshake.REQUEST_PREFIX)) {
                    this.initState.logMsg(Level.WARNING, true, "Malformed service request: " + prefix);
                    channel.write(ServiceDispatcher.Response.FORMAT_ERROR.byteBuffer());
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                byte nameLength = this.buffer.get(this.INITIAL_BUFFER_SIZE - 1);
                if (nameLength <= 0) {
                    this.initState.logMsg(Level.WARNING, true, "Bad service service name length: " + nameLength);
                    channel.write(ServiceDispatcher.Response.FORMAT_ERROR.byteBuffer());
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                ByteBuffer newBuffer = ByteBuffer.allocate(this.INITIAL_BUFFER_SIZE + nameLength);
                newBuffer.put(this.buffer);
                this.buffer = newBuffer;
                return this.processOp(channel);
            }
            String request = StringUtils.fromASCII(this.buffer.array());
            this.initState.setServiceName(request.substring(ServiceHandshake.REQUEST_PREFIX.length() + 1));
            return InitResult.DONE;
        }
    }

    public static abstract class ClientInitOp {
        private ServiceDispatcher.Response response;
        protected final ClientHandshake initState;

        protected ClientInitOp(ClientHandshake initState) {
            this.initState = initState;
        }

        protected abstract InitResult processOp(IOAdapter var1) throws IOException;

        ServiceDispatcher.Response getResponse() {
            return this.response;
        }

        protected void setResponse(ServiceDispatcher.Response response) {
            this.response = response;
        }
    }

    public static abstract class ServerInitOp {
        protected final ServerHandshake initState;

        protected ServerInitOp(ServerHandshake initState) {
            this.initState = initState;
        }

        protected abstract InitResult processOp(DataChannel var1) throws IOException;

        protected InitResult fillBuffer(DataChannel channel, ByteBuffer buffer) throws IOException {
            while (buffer.remaining() > 0) {
                int count = channel.read(buffer);
                if (count < 0) {
                    this.initState.logMsg(Level.WARNING, true, "Premature EOF on channel: " + channel + ", service: " + this.initState.getServiceName() + " - read() returned: " + count);
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                if (count != 0) continue;
                return InitResult.READ;
            }
            return InitResult.DONE;
        }

        protected InitResult sendBuffer(DataChannel channel, ByteBuffer buffer) throws IOException {
            int tryCount = 0;
            while (buffer.remaining() > 0) {
                int count = channel.write(buffer);
                if (count < 0) {
                    this.initState.logMsg(Level.WARNING, true, "Premature EOF on channel: " + channel + " write() returned: " + count);
                    this.closeChannel(channel);
                    return InitResult.FAIL;
                }
                if (count == 0) {
                    if (++tryCount <= 10) continue;
                    this.initState.logMsg(Level.WARNING, true, "Failed to write to channel. Send buffer size: " + channel.getSocketChannel().socket().getSendBufferSize());
                    throw EnvironmentFailureException.unexpectedState("Failed to write to channel");
                }
                tryCount = 0;
            }
            return InitResult.DONE;
        }

        void closeChannel(Channel channel) {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e1) {
                    this.initState.logMsg(Level.WARNING, false, "Exception during cleanup: " + e1.getMessage());
                }
            }
        }
    }

    public static class ClientHandshake {
        private String serviceName;
        private AuthenticationMethod[] authInfo;
        private IOAdapter ioAdapter;

        ClientHandshake(String serviceName, AuthenticationMethod[] authInfo, IOAdapter ioAdapter) {
            this.authInfo = authInfo;
            this.serviceName = serviceName;
            this.ioAdapter = ioAdapter;
        }

        ServiceDispatcher.Response process() throws IOException {
            SendNameOp nameOp = new SendNameOp(this, this.serviceName);
            InitResult nameResult = nameOp.processOp(this.ioAdapter);
            if (nameResult == InitResult.FAIL) {
                return ServiceDispatcher.Response.INVALID;
            }
            if (nameOp.getResponse() != ServiceDispatcher.Response.AUTHENTICATE) {
                return nameOp.getResponse();
            }
            DoAuthenticateOp authOp = new DoAuthenticateOp(this, this.authInfo);
            InitResult authResult = authOp.processOp(this.ioAdapter);
            if (authResult == InitResult.FAIL) {
                return ServiceDispatcher.Response.INVALID;
            }
            return authOp.getResponse();
        }
    }

    public static class ServerHandshake {
        private final DataChannel channel;
        private final ServiceDispatcher dispatcher;
        private final AuthenticationMethod[] authInfo;
        private ServerInitOp currentOp;
        private String serviceName;

        ServerHandshake(DataChannel dataChannel, ServiceDispatcher dispatcher, AuthenticationMethod[] authInfo) {
            this.channel = dataChannel;
            this.dispatcher = dispatcher;
            this.authInfo = authInfo;
            this.currentOp = new ReceiveNameOp(this);
        }

        DataChannel getChannel() {
            return this.channel;
        }

        void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        String getServiceName() {
            return this.serviceName;
        }

        InitResult process() throws IOException {
            InitResult result2 = this.currentOp.processOp(this.channel);
            if (result2 != InitResult.DONE) {
                return result2;
            }
            if (this.channel.isTrustCapable()) {
                if (this.channel.isTrusted()) {
                    return InitResult.DONE;
                }
                this.logMsg(Level.WARNING, false, "DataChannel is trust-capable but is not trusted");
            }
            if (this.currentOp instanceof RequireAuthenticateOp || this.authInfo == null) {
                return InitResult.DONE;
            }
            this.currentOp = new RequireAuthenticateOp(this, this.authInfo);
            return this.currentOp.processOp(this.channel);
        }

        void logMsg(Level level, boolean noteError, String msg) {
            this.dispatcher.logMsg(level, noteError, msg);
        }
    }

    public static enum InitResult {
        FAIL,
        READ,
        DONE,
        REJECT;

    }
}

