/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.PackedObsoleteInfo;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.INList;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.dbi.TTL;
import com.sleepycat.je.evictor.Evictor;
import com.sleepycat.je.evictor.OffHeapCache;
import com.sleepycat.je.latch.LatchContext;
import com.sleepycat.je.latch.LatchFactory;
import com.sleepycat.je.latch.LatchSupport;
import com.sleepycat.je.latch.LatchTable;
import com.sleepycat.je.latch.SharedLatch;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogItem;
import com.sleepycat.je.log.LogParams;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.Provisional;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.WholeEntry;
import com.sleepycat.je.log.entry.BINDeltaLogEntry;
import com.sleepycat.je.log.entry.INLogEntry;
import com.sleepycat.je.log.entry.LNLogEntry;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.BINDeltaBloomFilter;
import com.sleepycat.je.tree.INKeyRep;
import com.sleepycat.je.tree.INLongRep;
import com.sleepycat.je.tree.INTargetRep;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.TreeWalkerStatsAccumulator;
import com.sleepycat.je.tree.dupConvert.DBIN;
import com.sleepycat.je.tree.dupConvert.DIN;
import com.sleepycat.je.tree.dupConvert.DupConvert;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.SizeofMarker;
import com.sleepycat.je.utilint.TestHook;
import com.sleepycat.je.utilint.TestHookExecute;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IN
extends Node
implements Comparable<IN>,
LatchContext {
    private static final String BEGIN_TAG = "<in>";
    private static final String END_TAG = "</in>";
    private static final String TRACE_SPLIT = "Split:";
    private static final String TRACE_DELETE = "Delete:";
    private static final int BYTES_PER_LSN_ENTRY = 4;
    public static final int MAX_FILE_OFFSET = 0xFFFFFE;
    private static final int THREE_BYTE_NEGATIVE_ONE = 0xFFFFFF;
    private static final INLongRep.EmptyRep EMPTY_OFFHEAP_BIN_IDS = new INLongRep.EmptyRep(3, true);
    public static final int DBMAP_LEVEL = 131072;
    public static final int MAIN_LEVEL = 65536;
    public static final int LEVEL_MASK = 65535;
    public static final int MIN_LEVEL = -1;
    public static final int BIN_LEVEL = 65537;
    public static final int EXACT_MATCH = 65536;
    public static final int INSERT_SUCCESS = 131072;
    public static final long NON_EVICTABLE_IN = 0x4000000000000000L;
    private static final int IN_DIRTY_BIT = 1;
    private static final int IN_RECALC_TOGGLE_BIT = 2;
    private static final int IN_IS_ROOT_BIT = 4;
    private static final int IN_HAS_CACHED_CHILDREN_BIT = 8;
    private static final int IN_PRI2_LRU_BIT = 16;
    private static final int IN_DELTA_BIT = 32;
    private static final int IN_FETCHED_COLD_BIT = 64;
    private static final int IN_FETCHED_COLD_OFFHEAP_BIT = 128;
    private static final int IN_RESIDENT_BIT = 256;
    private static final int IN_PROHIBIT_NEXT_DELTA_BIT = 512;
    private static final int IN_EXPIRATION_IN_HOURS = 1024;
    private static final boolean traceLRU = false;
    private static final boolean traceDeltas = false;
    private static final Level traceLevel = Level.INFO;
    DatabaseImpl databaseImpl;
    private int level;
    long nodeId;
    int flags;
    private byte[] identifierKey;
    int nEntries;
    byte[] entryStates;
    INKeyRep entryKeys;
    byte[] keyPrefix;
    long baseFileNumber;
    byte[] entryLsnByteArray;
    long[] entryLsnLongArray;
    public static boolean disableCompactLsns;
    INTargetRep entryTargets;
    private INLongRep offHeapBINIds = EMPTY_OFFHEAP_BIN_IDS;
    long inMemorySize;
    private int accumulatedDelta = 0;
    public static final int ACCUMULATED_LIMIT_DEFAULT = 1000;
    public static int ACCUMULATED_LIMIT;
    private IN nextLRUNode = null;
    private IN prevLRUNode = null;
    long lastFullVersion = -1L;
    private PackedObsoleteInfo provisionalObsolete;
    private boolean needDupKeyConversion;
    private int pinCount = 0;
    private SharedLatch latch;
    private IN parent;
    private TestHook fetchINHook;

    public IN() {
        this.init(null, Key.EMPTY_KEY, 0, 0);
    }

    public IN(DatabaseImpl dbImpl, byte[] identifierKey, int capacity, int level) {
        this.nodeId = dbImpl.getEnv().getNodeSequence().getNextLocalNodeId();
        this.init(dbImpl, identifierKey, capacity, IN.generateLevel(dbImpl.getId(), level));
        this.initMemorySize();
    }

    public IN(SizeofMarker marker) {
        this.entryTargets = null;
        this.entryKeys = null;
        this.keyPrefix = null;
        this.entryLsnByteArray = null;
        this.entryLsnLongArray = null;
        this.entryStates = null;
        this.latch = LatchFactory.createSharedLatch(LatchSupport.DUMMY_LATCH_CONTEXT, this.isAlwaysLatchedExclusively());
        this.latch.acquireExclusive();
        this.latch.release();
        this.latch.acquireExclusive();
        this.latch.release();
    }

    IN createNewInstance(byte[] identifierKey, int maxEntries, int level) {
        return new IN(this.databaseImpl, identifierKey, maxEntries, level);
    }

    protected void init(DatabaseImpl db, byte[] identifierKey, int initialCapacity, int level) {
        this.setDatabase(db);
        this.latch = LatchFactory.createSharedLatch(this, this.isAlwaysLatchedExclusively());
        this.flags = 0;
        this.nEntries = 0;
        this.identifierKey = identifierKey;
        this.entryTargets = INTargetRep.NONE;
        this.entryKeys = new INKeyRep.Default(initialCapacity);
        this.keyPrefix = null;
        this.baseFileNumber = -1L;
        if (disableCompactLsns) {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[initialCapacity];
        } else {
            this.entryLsnByteArray = new byte[initialCapacity << 2];
            this.entryLsnLongArray = null;
        }
        this.entryStates = new byte[initialCapacity];
        this.level = level;
    }

    @Override
    public final boolean isIN() {
        return true;
    }

    @Override
    public final boolean isUpperIN() {
        return !this.isBIN();
    }

    @Override
    public final String getLatchName() {
        return this.shortClassName() + this.getNodeId();
    }

    @Override
    public final int getLatchTimeoutMs() {
        return this.databaseImpl.getEnv().getLatchTimeoutMs();
    }

    @Override
    public final LatchTable getLatchTable() {
        return LatchSupport.btreeLatchTable;
    }

    boolean isAlwaysLatchedExclusively() {
        return false;
    }

    public final boolean latchNoWait(CacheMode cacheMode) {
        if (!this.latch.acquireExclusiveNoWait()) {
            return false;
        }
        this.updateLRU(cacheMode);
        return true;
    }

    public void latch(CacheMode cacheMode) {
        this.latch.acquireExclusive();
        this.updateLRU(cacheMode);
    }

    @Override
    public final void latch() {
        this.latch(CacheMode.DEFAULT);
    }

    @Override
    public void latchShared(CacheMode cacheMode) {
        this.latch.acquireShared();
        this.updateLRU(cacheMode);
    }

    @Override
    public final void latchShared() {
        this.latchShared(CacheMode.DEFAULT);
    }

    public final void latchNoUpdateLRU(DatabaseImpl db) {
        if (this.databaseImpl == null) {
            this.databaseImpl = db;
        }
        this.latch.acquireExclusive();
    }

    public final void latchNoUpdateLRU() {
        assert (this.databaseImpl != null);
        this.latch.acquireExclusive();
    }

    @Override
    public final void releaseLatch() {
        this.latch.release();
    }

    public final void releaseLatchIfOwner() {
        this.latch.releaseIfOwner();
    }

    public final boolean isLatchOwner() {
        return this.latch.isOwner();
    }

    public final boolean isLatchExclusiveOwner() {
        return this.latch.isExclusiveOwner();
    }

    public final int getLatchNWaiters() {
        return this.latch.getNWaiters();
    }

    public final void updateLRU(CacheMode cacheMode) {
        if (!this.getInListResident()) {
            return;
        }
        switch (cacheMode) {
            case UNCHANGED: 
            case MAKE_COLD: {
                break;
            }
            case DEFAULT: 
            case EVICT_LN: 
            case EVICT_BIN: 
            case KEEP_HOT: {
                this.setFetchedCold(false);
                this.setFetchedColdOffHeap(false);
                if (!this.isBIN() && this.hasCachedChildrenFlag()) break;
                assert (this.isBIN() || !this.hasCachedChildren());
                this.getEvictor().moveBack(this);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public IN getParent() {
        return this.parent;
    }

    public void setParent(IN in) {
        assert (in != null);
        if (this.parent != null && !this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState();
        }
        this.parent = in;
    }

    public final IN latchParent() {
        assert (this.latch.isOwner());
        assert (!this.isRoot());
        assert (this.getParent() != null);
        while (true) {
            IN p = this.getParent();
            if (p.latch.acquireExclusiveNoWait()) {
                return p;
            }
            this.pin();
            try {
                this.latch.release();
                p.latch.acquireExclusive();
                this.latch.acquireExclusive();
            }
            finally {
                this.unpin();
            }
            if (this.getParent() == p) {
                return p;
            }
            p.latch.release();
        }
    }

    public int getKnownChildIndex(Node child) {
        for (int i = 0; i < this.nEntries; ++i) {
            if (this.getTarget(i) != child) continue;
            return i;
        }
        throw EnvironmentFailureException.unexpectedState();
    }

    public final synchronized void pin() {
        assert (this.isLatchOwner());
        assert (this.pinCount >= 0);
        ++this.pinCount;
    }

    public final synchronized void unpin() {
        assert (this.pinCount > 0);
        --this.pinCount;
    }

    public final synchronized boolean isPinned() {
        assert (this.isLatchExclusiveOwner());
        assert (this.pinCount >= 0);
        return this.pinCount > 0;
    }

    public final DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public final void setDatabase(DatabaseImpl db) {
        this.databaseImpl = db;
    }

    public final DatabaseId getDatabaseId() {
        return this.databaseImpl.getId();
    }

    @Override
    public final EnvironmentImpl getEnvImplForFatalException() {
        return this.databaseImpl.getEnv();
    }

    public final EnvironmentImpl getEnv() {
        return this.databaseImpl.getEnv();
    }

    final Evictor getEvictor() {
        return this.databaseImpl.getEnv().getEvictor();
    }

    final OffHeapCache getOffHeapCache() {
        return this.databaseImpl.getEnv().getOffHeapCache();
    }

    public final Comparator<byte[]> getKeyComparator() {
        return this.databaseImpl.getKeyComparator();
    }

    @Override
    public final int getLevel() {
        return this.level;
    }

    public final int getNormalizedLevel() {
        return this.level & 0xFFFF;
    }

    private static int generateLevel(DatabaseId dbId, int newLevel) {
        if (dbId.equals(DbTree.ID_DB_ID)) {
            return newLevel | 0x20000;
        }
        return newLevel | 0x10000;
    }

    public final long getNodeId() {
        return this.nodeId;
    }

    final void setNodeId(long nid) {
        this.nodeId = nid;
    }

    public final int hashCode() {
        return (int)(this.getNodeId() ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof IN)) {
            return false;
        }
        IN in = (IN)obj;
        return this.getNodeId() == in.getNodeId();
    }

    @Override
    public final int compareTo(IN argIN) {
        long argNodeId = argIN.getNodeId();
        long myNodeId = this.getNodeId();
        if (myNodeId < argNodeId) {
            return -1;
        }
        if (myNodeId > argNodeId) {
            return 1;
        }
        return 0;
    }

    public final boolean getDirty() {
        return (this.flags & 1) != 0;
    }

    public final void setDirty(boolean dirty) {
        this.flags = dirty ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    @Override
    public final boolean isBINDelta() {
        assert (this.isUpperIN() || this.isLatchOwner());
        return (this.flags & 0x20) != 0;
    }

    @Override
    public final boolean isBINDelta(boolean checkLatched) {
        assert (!checkLatched || this.isUpperIN() || this.isLatchOwner());
        return (this.flags & 0x20) != 0;
    }

    final void setBINDelta(boolean delta) {
        this.flags = delta ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean getFetchedCold() {
        return (this.flags & 0x40) != 0;
    }

    public final void setFetchedCold(boolean val) {
        this.flags = val ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean getFetchedColdOffHeap() {
        return (this.flags & 0x80) != 0;
    }

    public final void setFetchedColdOffHeap(boolean val) {
        this.flags = val ? (this.flags |= 0x80) : (this.flags &= 0xFFFFFF7F);
    }

    public final boolean getRecalcToggle() {
        return (this.flags & 2) != 0;
    }

    public final void setRecalcToggle(boolean toggle) {
        this.flags = toggle ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean isRoot() {
        return (this.flags & 4) != 0;
    }

    final void setIsRoot(boolean isRoot) {
        this.setIsRootFlag(isRoot);
        this.setDirty(true);
    }

    private void setIsRootFlag(boolean isRoot) {
        this.flags = isRoot ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean hasCachedChildrenFlag() {
        return (this.flags & 8) != 0;
    }

    private void setHasCachedChildrenFlag(boolean value) {
        this.flags = value ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isInPri2LRU() {
        return (this.flags & 0x10) != 0;
    }

    public final void setInPri2LRU(boolean value) {
        this.flags = value ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public boolean isExpirationInHours() {
        return (this.flags & 0x400) != 0;
    }

    void setExpirationInHours(boolean value) {
        this.flags = value ? (this.flags |= 0x400) : (this.flags &= 0xFFFFFBFF);
    }

    public final byte[] getIdentifierKey() {
        return this.identifierKey;
    }

    public final void setIdentifierKey(byte[] key, boolean makeDirty) {
        assert (!this.isBINDelta());
        this.identifierKey = key;
        if (makeDirty) {
            this.setDirty(true);
        }
    }

    public final int getNEntries() {
        return this.nEntries;
    }

    public int getMaxEntries() {
        return this.entryStates.length;
    }

    public final byte getState(int idx) {
        return this.entryStates[idx];
    }

    final boolean isDirty(int idx) {
        return (this.entryStates[idx] & 2) != 0;
    }

    public final boolean isEntryPendingDeleted(int idx) {
        return (this.entryStates[idx] & 8) != 0;
    }

    public final void setPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 8);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    final void clearPendingDeleted(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFF7);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    public final boolean isEntryKnownDeleted(int idx) {
        return (this.entryStates[idx] & 1) != 0;
    }

    public final void setKnownDeleted(int idx) {
        assert (this.isBIN());
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 1);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] & 0xFFFFFFF7);
        int n3 = idx;
        this.entryStates[n3] = (byte)(this.entryStates[n3] | 2);
        this.setDirty(true);
    }

    public final void setKnownDeletedAndEvictLN(int index) {
        assert (this.isBIN());
        this.setKnownDeleted(index);
        LN oldLN = (LN)this.getTarget(index);
        if (oldLN != null) {
            this.updateMemorySize(oldLN, null);
            oldLN.releaseMemoryBudget();
        }
        this.setTarget(index, null);
    }

    final void clearKnownDeleted(int idx) {
        assert (this.isBIN());
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFE);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    static boolean isStateKnownDeleted(byte state) {
        return (state & 1) != 0;
    }

    static boolean isStatePendingDeleted(byte state) {
        return (state & 8) != 0;
    }

    public final boolean isEmbeddedLN(int idx) {
        return (this.entryStates[idx] & 0x10) != 0;
    }

    public static boolean isEmbeddedLN(byte state) {
        return (state & 0x10) != 0;
    }

    private void setEmbeddedLN(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 0x10);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    private void clearEmbeddedLN(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFEF);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    public final boolean isNoDataLN(int idx) {
        return (this.entryStates[idx] & 0x20) != 0;
    }

    public static boolean isNoDataLN(byte state) {
        return (state & 0x20) != 0;
    }

    void setNoDataLN(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 0x20);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    private void clearNoDataLN(int idx) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFDF);
        int n2 = idx;
        this.entryStates[n2] = (byte)(this.entryStates[n2] | 2);
        this.setDirty(true);
    }

    public final boolean haveEmbeddedData(int idx) {
        return this.isEmbeddedLN(idx) && !this.isNoDataLN(idx);
    }

    public final int getNumEmbeddedLNs() {
        int res = 0;
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (!this.isEmbeddedLN(i)) continue;
            ++res;
        }
        return res;
    }

    public final INKeyRep getKeyVals() {
        return this.entryKeys;
    }

    public final byte[] getKeyPrefix() {
        return this.keyPrefix;
    }

    public final boolean hasKeyPrefix() {
        return this.keyPrefix != null;
    }

    final void setKeyPrefix(byte[] keyPrefix) {
        assert (this.databaseImpl != null);
        int prevLength = this.keyPrefix == null ? 0 : this.keyPrefix.length;
        this.keyPrefix = keyPrefix;
        int currLength = keyPrefix == null ? 0 : keyPrefix.length;
        this.updateMemorySize(prevLength, currLength);
    }

    public final byte[] getKey(int idx) {
        assert (idx < this.nEntries);
        byte[] key = this.entryKeys.getFullKey(this.keyPrefix, idx, this.haveEmbeddedData(idx));
        assert (key != null);
        return key;
    }

    public final byte[] getData(int idx) {
        if (this.haveEmbeddedData(idx)) {
            return this.entryKeys.getData(idx);
        }
        if (this.isNoDataLN(idx)) {
            return Key.EMPTY_KEY;
        }
        return null;
    }

    int getStoredKeySize(int idx) {
        return this.entryKeys.size(idx);
    }

    private boolean updateLNSlotKey(int idx, byte[] key, byte[] data) {
        assert (this.isBIN());
        boolean haveEmbeddedData = this.haveEmbeddedData(idx);
        if (data == null) {
            if (this.isEmbeddedLN(idx)) {
                this.clearEmbeddedLN(idx);
                this.clearNoDataLN(idx);
            }
        } else {
            if (!this.isEmbeddedLN(idx)) {
                this.setEmbeddedLN(idx);
            }
            if (data.length == 0) {
                this.setNoDataLN(idx);
            } else {
                this.clearNoDataLN(idx);
            }
        }
        if (key != null && (this.databaseImpl.allowsKeyUpdates() || DupConvert.needsConversion(this.databaseImpl)) && !Arrays.equals(key, this.getKey(idx))) {
            this.setDirty(true);
            return this.setKey(idx, key, data, false);
        }
        if (haveEmbeddedData) {
            this.setDirty(true);
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 2);
            INKeyRep.Type oldRepType = (INKeyRep.Type)((Object)this.entryKeys.getType());
            this.entryKeys = this.entryKeys.setData(idx, data, this);
            return oldRepType != this.entryKeys.getType();
        }
        if (data != null && data.length != 0) {
            this.setDirty(true);
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 2);
            key = this.entryKeys.getKey(idx, false);
            INKeyRep.Type oldRepType = (INKeyRep.Type)((Object)this.entryKeys.getType());
            this.entryKeys = this.entryKeys.set(idx, key, data, this);
            return oldRepType != this.entryKeys.getType();
        }
        return false;
    }

    private boolean insertKey(int idx, byte[] key, byte[] data) {
        if (this.nEntries == 1 && !this.isBINDelta()) {
            this.setIdentifierKey(key, true);
        }
        return this.setKey(idx, key, data, true);
    }

    private boolean idKeyIsSlotKey() {
        return true;
    }

    private boolean updateKey(int idx, byte[] key, byte[] data) {
        return this.setKey(idx, key, data, false);
    }

    public boolean setKey(int idx, byte[] key, byte[] data, boolean isInsertion) {
        int n = idx;
        this.entryStates[n] = (byte)(this.entryStates[n] | 2);
        this.setDirty(true);
        if (this.databaseImpl.getKeyPrefixing() && this.keyPrefix != null) {
            int newPrefixLen = Key.getKeyPrefixLength(this.keyPrefix, this.keyPrefix.length, key);
            if (newPrefixLen < this.keyPrefix.length) {
                byte[] newPrefix;
                byte[] byArray = newPrefix = isInsertion ? Key.createKeyPrefix(this.keyPrefix, key) : this.computeKeyPrefix(idx);
                if (newPrefix != null) {
                    newPrefix = Key.createKeyPrefix(newPrefix, key);
                }
                this.recalcSuffixes(newPrefix, key, data, idx);
                return true;
            }
            INKeyRep.Type prevRepType = (INKeyRep.Type)((Object)this.entryKeys.getType());
            byte[] suffix = IN.computeKeySuffix(this.keyPrefix, key);
            this.entryKeys = this.entryKeys.set(idx, suffix, data, this);
            return prevRepType != this.entryKeys.getType();
        }
        if (this.keyPrefix != null) {
            this.recalcSuffixes(null, key, data, idx);
            return true;
        }
        INKeyRep.Type oldRepType = (INKeyRep.Type)((Object)this.entryKeys.getType());
        this.entryKeys = this.entryKeys.set(idx, key, data, this);
        return oldRepType != this.entryKeys.getType();
    }

    private static byte[] computeKeySuffix(byte[] prefix, byte[] key) {
        int prefixLen;
        int n = prefixLen = prefix == null ? 0 : prefix.length;
        if (prefixLen == 0) {
            return key;
        }
        int suffixLen = key.length - prefixLen;
        byte[] ret = new byte[suffixLen];
        System.arraycopy(key, prefixLen, ret, 0, suffixLen);
        return ret;
    }

    private void recalcSuffixes(byte[] newPrefix, byte[] key, byte[] data, int idx) {
        for (int i = 0; i < this.nEntries; ++i) {
            byte[] curKey = i == idx ? key : this.getKey(i);
            byte[] curData = null;
            if (i == idx) {
                curData = data;
            } else if (this.haveEmbeddedData(i)) {
                curData = this.entryKeys.getData(i);
            }
            byte[] suffix = IN.computeKeySuffix(newPrefix, curKey);
            this.entryKeys = this.entryKeys.set(i, suffix, curData, this);
        }
        this.setKeyPrefix(newPrefix);
    }

    public final void recalcKeyPrefix() {
        assert (!this.isBINDelta());
        this.recalcSuffixes(this.computeKeyPrefix(-1), null, null, -1);
    }

    private byte[] computeKeyPrefix(int excludeIdx) {
        if (!this.databaseImpl.getKeyPrefixing() || this.nEntries <= 1) {
            return null;
        }
        int firstIdx = excludeIdx == 0 ? 1 : 0;
        byte[] curPrefixKey = this.getKey(firstIdx);
        int prefixLen = curPrefixKey.length;
        boolean byteOrdered = false;
        if (byteOrdered) {
            byte[] lastKey;
            int newPrefixLen;
            int lastIdx = this.nEntries - 1;
            if (lastIdx == excludeIdx) {
                --lastIdx;
            }
            if (lastIdx > firstIdx && (newPrefixLen = Key.getKeyPrefixLength(curPrefixKey, prefixLen, lastKey = this.getKey(lastIdx))) < prefixLen) {
                curPrefixKey = lastKey;
                prefixLen = newPrefixLen;
            }
        } else {
            for (int i = firstIdx + 1; i < this.nEntries; ++i) {
                byte[] curKey;
                int newPrefixLen;
                if (i == excludeIdx || (newPrefixLen = Key.getKeyPrefixLength(curPrefixKey, prefixLen, curKey = this.getKey(i))) >= prefixLen) continue;
                curPrefixKey = curKey;
                prefixLen = newPrefixLen;
            }
        }
        byte[] ret = new byte[prefixLen];
        System.arraycopy(curPrefixKey, 0, ret, 0, prefixLen);
        return ret;
    }

    final boolean verifyKeyPrefix() {
        byte[] computedKeyPrefix = this.computeKeyPrefix(-1);
        if (this.keyPrefix == null) {
            return computedKeyPrefix == null;
        }
        if (computedKeyPrefix == null || computedKeyPrefix.length < this.keyPrefix.length) {
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        for (int i = 0; i < this.keyPrefix.length; ++i) {
            if (this.keyPrefix[i] == computedKeyPrefix[i]) continue;
            System.out.println("VerifyKeyPrefix failed");
            System.out.println(this.dumpString(0, false));
            return false;
        }
        return true;
    }

    public final boolean isKeyInBounds(byte[] key) {
        assert (!this.isBINDelta());
        if (this.nEntries < 2) {
            return false;
        }
        Comparator<byte[]> comparator = this.getKeyComparator();
        int cmp = this.entryKeys.compareKeys(key, this.keyPrefix, 0, this.haveEmbeddedData(0), comparator);
        if (cmp < 0) {
            return false;
        }
        int idx = this.nEntries - 1;
        cmp = this.entryKeys.compareKeys(key, this.keyPrefix, idx, this.haveEmbeddedData(idx), comparator);
        return cmp <= 0;
    }

    public final long getLsn(int idx) {
        if (this.entryLsnLongArray == null) {
            int offset = idx << 2;
            int fileOffset = this.getFileOffset(offset);
            if (fileOffset == -1) {
                return -1L;
            }
            return DbLsn.makeLsn(this.baseFileNumber + (long)this.getFileNumberOffset(offset), fileOffset);
        }
        return this.entryLsnLongArray[idx];
    }

    public void setLsn(int idx, long lsn) {
        this.setLsn(idx, lsn, true);
    }

    private void setLsn(int idx, long lsn, boolean check) {
        if (!check || this.shouldUpdateLsn(this.getLsn(idx), lsn)) {
            int oldSize = this.computeLsnOverhead();
            this.setLsnInternal(idx, lsn);
            this.updateMemorySize(this.computeLsnOverhead() - oldSize);
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 2);
            this.setDirty(true);
        }
    }

    final void setLsnInternal(int idx, long value) {
        if (this.entryLsnLongArray != null) {
            this.entryLsnLongArray[idx] = value;
            return;
        }
        int offset = idx << 2;
        if (value == -1L) {
            this.setFileNumberOffset(offset, (byte)0);
            this.setFileOffset(offset, -1);
            return;
        }
        long thisFileNumber = DbLsn.getFileNumber(value);
        if (this.baseFileNumber == -1L) {
            this.baseFileNumber = thisFileNumber;
            this.setFileNumberOffset(offset, (byte)0);
        } else {
            long fileNumberDifference;
            if (thisFileNumber < this.baseFileNumber) {
                if (!this.adjustFileNumbers(thisFileNumber)) {
                    this.mutateToLongArray(idx, value);
                    return;
                }
                this.baseFileNumber = thisFileNumber;
            }
            if ((fileNumberDifference = thisFileNumber - this.baseFileNumber) > 127L) {
                this.mutateToLongArray(idx, value);
                return;
            }
            this.setFileNumberOffset(offset, (byte)(thisFileNumber - this.baseFileNumber));
        }
        int fileOffset = (int)DbLsn.getFileOffset(value);
        if (fileOffset > 0xFFFFFE) {
            this.mutateToLongArray(idx, value);
            return;
        }
        this.setFileOffset(offset, fileOffset);
    }

    private boolean adjustFileNumbers(long newBaseFileNumber) {
        long oldBaseFileNumber = this.baseFileNumber;
        for (int i = 0; i < this.entryLsnByteArray.length; i += 4) {
            if (this.getFileOffset(i) == -1) continue;
            long curEntryFileNumber = oldBaseFileNumber + (long)this.getFileNumberOffset(i);
            long newCurEntryFileNumberOffset = curEntryFileNumber - newBaseFileNumber;
            if (newCurEntryFileNumberOffset > 127L) {
                long undoOffset = oldBaseFileNumber - newBaseFileNumber;
                for (int j = i - 4; j >= 0; j -= 4) {
                    if (this.getFileOffset(j) == -1) continue;
                    this.setFileNumberOffset(j, (byte)((long)this.getFileNumberOffset(j) - undoOffset));
                }
                return false;
            }
            this.setFileNumberOffset(i, (byte)newCurEntryFileNumberOffset);
        }
        return true;
    }

    private void setFileNumberOffset(int offset, byte fileNumberOffset) {
        this.entryLsnByteArray[offset] = fileNumberOffset;
    }

    private byte getFileNumberOffset(int offset) {
        return this.entryLsnByteArray[offset];
    }

    private void setFileOffset(int offset, int fileOffset) {
        this.put3ByteInt(offset + 1, fileOffset);
    }

    private int getFileOffset(int offset) {
        return this.get3ByteInt(offset + 1);
    }

    private void put3ByteInt(int offset, int value) {
        this.entryLsnByteArray[offset++] = (byte)value;
        this.entryLsnByteArray[offset++] = (byte)(value >>> 8);
        this.entryLsnByteArray[offset] = (byte)(value >>> 16);
    }

    private int get3ByteInt(int offset) {
        int ret = this.entryLsnByteArray[offset++] & 0xFF;
        ret += (this.entryLsnByteArray[offset++] & 0xFF) << 8;
        if ((ret += (this.entryLsnByteArray[offset] & 0xFF) << 16) == 0xFFFFFF) {
            ret = -1;
        }
        return ret;
    }

    private void mutateToLongArray(int idx, long value) {
        int nElts = this.entryLsnByteArray.length >> 2;
        long[] newArr = new long[nElts];
        for (int i = 0; i < nElts; ++i) {
            newArr[i] = this.getLsn(i);
        }
        newArr[idx] = value;
        this.entryLsnLongArray = newArr;
        this.entryLsnByteArray = null;
    }

    private final boolean shouldUpdateLsn(long oldLsn, long newLsn) {
        if (oldLsn == newLsn) {
            return false;
        }
        if (newLsn == -1L && this.getEnv().isReadOnly()) {
            return true;
        }
        if (this.databaseImpl.isDeferredWriteMode()) {
            if (oldLsn != -1L && DbLsn.isTransientOrNull(newLsn)) {
                throw EnvironmentFailureException.unexpectedState("DeferredWrite LSN update not allowed oldLsn = " + DbLsn.getNoFormatString(oldLsn) + " newLsn = " + DbLsn.getNoFormatString(newLsn));
            }
        } else if (DbLsn.isTransientOrNull(newLsn)) {
            throw EnvironmentFailureException.unexpectedState("LSN update not allowed oldLsn = " + DbLsn.getNoFormatString(oldLsn) + " newLsn = " + DbLsn.getNoFormatString(newLsn));
        }
        return true;
    }

    final long[] getEntryLsnLongArray() {
        return this.entryLsnLongArray;
    }

    final byte[] getEntryLsnByteArray() {
        return this.entryLsnByteArray;
    }

    final void initEntryLsn(int capacity) {
        this.entryLsnLongArray = null;
        this.entryLsnByteArray = new byte[capacity << 2];
        this.baseFileNumber = -1L;
    }

    boolean isLastLoggedSizeStored(int idx) {
        return false;
    }

    boolean mayHaveLastLoggedSizeStored() {
        return false;
    }

    public void setLastLoggedSize(int idx, int lastLoggedSize) {
    }

    public void clearLastLoggedSize(int idx) {
    }

    void setLastLoggedSizeUnconditional(int idx, int lastLoggedSize) {
    }

    public int getLastLoggedSize(int idx) {
        return 0;
    }

    public void setOffHeapBINId(int idx, int val, boolean pri2, boolean dirty) {
        assert (this.getNormalizedLevel() == 2);
        assert (val >= 0);
        this.setOffHeapBINPri2(idx, pri2);
        this.setOffHeapBINDirty(idx, dirty);
        long newVal = val + 1;
        long oldVal = this.offHeapBINIds.get(idx);
        if (oldVal == newVal) {
            return;
        }
        assert (oldVal == 0L);
        this.offHeapBINIds = this.offHeapBINIds.set(idx, newVal, this);
    }

    public void clearOffHeapBINId(int idx) {
        assert (this.getNormalizedLevel() == 2);
        this.setOffHeapBINPri2(idx, false);
        this.setOffHeapBINDirty(idx, false);
        long oldVal = this.offHeapBINIds.get(idx);
        if (oldVal == 0L) {
            return;
        }
        this.offHeapBINIds = this.offHeapBINIds.set(idx, 0L, this);
        if (this.getInListResident() && this.getNormalizedLevel() == 2 && this.offHeapBINIds.isEmpty()) {
            this.getEvictor().moveToPri1LRU(this);
        }
    }

    public int getOffHeapBINId(int idx) {
        return (int)this.offHeapBINIds.get(idx) - 1;
    }

    public boolean hasOffHeapBINIds() {
        return !this.offHeapBINIds.isEmpty();
    }

    public long getOffHeapBINIdsMemorySize() {
        return this.offHeapBINIds.getMemorySize();
    }

    private void setOffHeapBINDirty(int idx, boolean val) {
        if (val) {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 4);
        } else {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFB);
        }
    }

    public boolean isOffHeapBINDirty(int idx) {
        return (this.entryStates[idx] & 4) != 0;
    }

    private void setOffHeapBINPri2(int idx, boolean val) {
        if (val) {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] | 0x40);
        } else {
            int n = idx;
            this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFBF);
        }
    }

    public boolean isOffHeapBINPri2(int idx) {
        return (this.entryStates[idx] & 0x40) != 0;
    }

    public final INTargetRep getTargets() {
        return this.entryTargets;
    }

    void setTarget(int idx, Node target) {
        assert (this.isLatchExclusiveOwner()) : "Not latched for write " + this.getClass().getName() + " id=" + this.getNodeId();
        Node curChild = (Node)this.entryTargets.get(idx);
        this.entryTargets = (INTargetRep)this.entryTargets.set(idx, target, this);
        if (target != null && target.isIN()) {
            ((IN)target).setParent(this);
        }
        if (this.isUpperIN()) {
            if (target == null) {
                if (curChild != null && this.hasCachedChildrenFlag() && !this.hasCachedChildren()) {
                    this.setHasCachedChildrenFlag(false);
                    if (!this.isDIN()) {
                        this.getEvictor().addBack(this);
                    }
                }
            } else if (curChild == null && !this.hasCachedChildrenFlag()) {
                this.setHasCachedChildrenFlag(true);
                this.getEvictor().remove(this);
            }
        }
    }

    public final Node getTarget(int idx) {
        return (Node)this.entryTargets.get(idx);
    }

    final IN fetchINWithNoLatch(int idx, byte[] searchKey, CacheMode cacheMode) {
        return this.fetchINWithNoLatch(idx, searchKey, null, cacheMode);
    }

    final IN fetchINWithNoLatch(SearchResult result2, byte[] searchKey, CacheMode cacheMode) {
        return this.fetchINWithNoLatch(result2.index, searchKey, result2, cacheMode);
    }

    private IN fetchINWithNoLatch(int idx, byte[] searchKey, SearchResult result2, CacheMode cacheMode) {
        assert (this.isUpperIN());
        assert (this.isLatchOwner());
        EnvironmentImpl envImpl = this.getEnv();
        OffHeapCache ohCache = envImpl.getOffHeapCache();
        boolean isMiss = false;
        boolean success = false;
        IN child = (IN)this.entryTargets.get(idx);
        if (child == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                throw EnvironmentFailureException.unexpectedState(this.makeFetchErrorMsg("NULL_LSN in upper IN", lsn, idx));
            }
            byte[] ohBytes = null;
            if (this.getNormalizedLevel() == 2) {
                ohBytes = ohCache.getBINBytes(this, idx);
            }
            this.pin();
            try {
                WholeEntry wholeEntry;
                this.releaseLatch();
                TestHookExecute.doHookIfSet(this.fetchINHook);
                if (ohBytes != null) {
                    child = ohCache.materializeBIN(envImpl, ohBytes);
                } else {
                    wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn, this.getLastLoggedSize(idx));
                    LogEntry logEntry = wholeEntry.getEntry();
                    child = (IN)logEntry.getResolvedItem(this.databaseImpl);
                    isMiss = true;
                }
                this.latch(CacheMode.UNCHANGED);
                if (idx >= this.nEntries || this.getLsn(idx) != lsn || this.databaseImpl.isDeferredWriteMode() && this.entryTargets.get(idx) != null) {
                    if (searchKey == null) {
                        wholeEntry = null;
                        return wholeEntry;
                    }
                    idx = this.findEntry(searchKey, false, false);
                    if (!(idx != 0 && idx != this.nEntries - 1 || this.isKeyInBounds(searchKey))) {
                        wholeEntry = null;
                        return wholeEntry;
                    }
                }
                if (result2 != null) {
                    result2.index = idx;
                }
                if (this.entryTargets.get(idx) != null) {
                    child = (IN)this.entryTargets.get(idx);
                } else {
                    if (this.getLsn(idx) != lsn) {
                        wholeEntry = null;
                        return wholeEntry;
                    }
                    if (ohBytes != null && ohCache.haveBINBytesChanged(this, idx, ohBytes)) {
                        wholeEntry = null;
                        return wholeEntry;
                    }
                    if (ohBytes == null && this.getOffHeapBINId(idx) >= 0) {
                        wholeEntry = null;
                        return wholeEntry;
                    }
                    child.latchNoUpdateLRU(this.databaseImpl);
                    if (ohBytes != null) {
                        child.postLoadInit(this, idx);
                    } else {
                        child.postFetchInit(this.databaseImpl, lsn);
                    }
                    this.attachNode(idx, child, null);
                    child.releaseLatch();
                }
                success = true;
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, this.makeFetchErrorMsg(null, lsn, idx), e);
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(this.makeFetchErrorMsg(null, lsn, idx));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, this.makeFetchErrorMsg(e.toString(), lsn, idx), e);
            }
            finally {
                if (!success) {
                    if (child != null) {
                        child.incFetchStats(envImpl, isMiss);
                    }
                    this.releaseLatchIfOwner();
                }
                this.unpin();
            }
        }
        assert (this.hasCachedChildren() == this.hasCachedChildrenFlag());
        child.incFetchStats(envImpl, isMiss);
        return child;
    }

    public IN fetchIN(int idx, CacheMode cacheMode) {
        assert (this.isUpperIN());
        if (!this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState("EX-latch not held before fetch");
        }
        EnvironmentImpl envImpl = this.getEnv();
        OffHeapCache ohCache = envImpl.getOffHeapCache();
        boolean isMiss = false;
        IN child = (IN)this.entryTargets.get(idx);
        if (child == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                throw EnvironmentFailureException.unexpectedState(this.makeFetchErrorMsg("NULL_LSN in upper IN", lsn, idx));
            }
            try {
                byte[] ohBytes = null;
                if (this.getNormalizedLevel() == 2 && (ohBytes = ohCache.getBINBytes(this, idx)) != null) {
                    child = ohCache.materializeBIN(envImpl, ohBytes);
                }
                if (child == null) {
                    WholeEntry wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn, this.getLastLoggedSize(idx));
                    LogEntry logEntry = wholeEntry.getEntry();
                    child = (IN)logEntry.getResolvedItem(this.databaseImpl);
                    isMiss = true;
                }
                child.latchNoUpdateLRU(this.databaseImpl);
                if (ohBytes != null) {
                    child.postLoadInit(this, idx);
                } else {
                    child.postFetchInit(this.databaseImpl, lsn);
                }
                this.attachNode(idx, child, null);
                child.releaseLatch();
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, this.makeFetchErrorMsg(null, lsn, idx), e);
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(this.makeFetchErrorMsg(null, lsn, idx));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, this.makeFetchErrorMsg(e.toString(), lsn, idx), e);
            }
        }
        assert (this.hasCachedChildren() == this.hasCachedChildrenFlag());
        child.incFetchStats(envImpl, isMiss);
        return child;
    }

    public IN loadIN(int idx, CacheMode cacheMode) {
        assert (this.isUpperIN());
        if (!this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState("EX-latch not held before load");
        }
        IN child = (IN)this.entryTargets.get(idx);
        if (child != null) {
            return child;
        }
        if (this.getNormalizedLevel() != 2) {
            return null;
        }
        EnvironmentImpl envImpl = this.getEnv();
        OffHeapCache ohCache = envImpl.getOffHeapCache();
        long lsn = this.getLsn(idx);
        try {
            byte[] ohBytes = ohCache.getBINBytes(this, idx);
            if (ohBytes == null) {
                return null;
            }
            child = ohCache.materializeBIN(envImpl, ohBytes);
            child.latchNoUpdateLRU(this.databaseImpl);
            child.postLoadInit(this, idx);
            this.attachNode(idx, child, null);
            child.releaseLatch();
            return child;
        }
        catch (RuntimeException e) {
            throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, this.makeFetchErrorMsg(e.toString(), lsn, idx), e);
        }
    }

    public final LN fetchLN(int idx, CacheMode cacheMode) {
        return (LN)this.fetchLN(idx, cacheMode, false);
    }

    public final Node fetchLNOrDIN(int idx, CacheMode cacheMode) {
        return this.fetchLN(idx, cacheMode, true);
    }

    private Node fetchLN(int idx, CacheMode cacheMode, boolean dupConvert) {
        assert (this.isBIN());
        if (!this.isLatchExclusiveOwner()) {
            throw EnvironmentFailureException.unexpectedState("EX-latch not held before fetch");
        }
        if (this.isEntryKnownDeleted(idx)) {
            return null;
        }
        BIN bin = (BIN)this;
        EnvironmentImpl envImpl = this.getEnv();
        OffHeapCache ohCache = envImpl.getOffHeapCache();
        boolean isMiss = false;
        Node child = (Node)this.entryTargets.get(idx);
        if (child == null) {
            long lsn = this.getLsn(idx);
            if (lsn == -1L) {
                throw EnvironmentFailureException.unexpectedState(this.makeFetchErrorMsg("NULL_LSN without KnownDeleted", lsn, idx));
            }
            if (this.isEmbeddedLN(idx) || this.databaseImpl.isLNImmediatelyObsolete() && !dupConvert) {
                throw EnvironmentFailureException.unexpectedState("May not fetch immediately obsolete LN");
            }
            try {
                byte[] lnSlotKey = null;
                child = ohCache.loadLN(bin, idx, cacheMode);
                if (child == null) {
                    WholeEntry wholeEntry = envImpl.getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn, this.getLastLoggedSize(idx));
                    this.setLastLoggedSize(idx, wholeEntry.getHeader().getEntrySize());
                    LogEntry logEntry = wholeEntry.getEntry();
                    if (logEntry instanceof LNLogEntry) {
                        LNLogEntry lnEntry = (LNLogEntry)wholeEntry.getEntry();
                        lnEntry.postFetchInit(this.databaseImpl);
                        lnSlotKey = lnEntry.getKey();
                        if (cacheMode != CacheMode.EVICT_LN && cacheMode != CacheMode.EVICT_BIN && cacheMode != CacheMode.UNCHANGED && cacheMode != CacheMode.MAKE_COLD) {
                            this.getEvictor().moveToPri1LRU(this);
                        }
                    }
                    child = (Node)logEntry.getResolvedItem(this.databaseImpl);
                    isMiss = true;
                }
                child.postFetchInit(this.databaseImpl, lsn);
                this.attachNode(idx, child, lnSlotKey);
            }
            catch (FileNotFoundException e) {
                if (!bin.isDeleted(idx) && !bin.isProbablyExpired(idx)) {
                    throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_FILE_NOT_FOUND, this.makeFetchErrorMsg(null, lsn, idx), e);
                }
                return null;
            }
            catch (EnvironmentFailureException e) {
                e.addErrorMessage(this.makeFetchErrorMsg(null, lsn, idx));
                throw e;
            }
            catch (RuntimeException e) {
                throw new EnvironmentFailureException(envImpl, EnvironmentFailureReason.LOG_INTEGRITY, this.makeFetchErrorMsg(e.toString(), lsn, idx), e);
            }
        }
        if (child.isLN()) {
            LN ln = (LN)child;
            if (cacheMode != CacheMode.UNCHANGED && cacheMode != CacheMode.MAKE_COLD) {
                ln.setFetchedCold(false);
            }
            ohCache.freeRedundantLN(bin, idx, ln, cacheMode);
        }
        child.incFetchStats(envImpl, isMiss);
        return child;
    }

    public final LN getLN(int idx, CacheMode cacheMode) {
        OffHeapCache ohCache;
        assert (this.isBIN());
        LN ln = (LN)this.entryTargets.get(idx);
        if (ln == null) {
            return null;
        }
        if (cacheMode != CacheMode.UNCHANGED && cacheMode != CacheMode.MAKE_COLD) {
            ln.setFetchedCold(false);
        }
        if ((ohCache = this.getOffHeapCache()).isEnabled()) {
            ohCache.freeRedundantLN((BIN)this, idx, ln, cacheMode);
        }
        return ln;
    }

    @Override
    public final void postFetchInit(DatabaseImpl db, long fetchedLsn) {
        assert (this.isLatchExclusiveOwner());
        this.commonInit(db);
        this.setLastLoggedLsn(fetchedLsn);
        this.convertDupKeys();
        this.addToMainCache();
        if (this.isBIN()) {
            this.setFetchedCold(true);
        }
        if (db.isDeferredWriteMode()) {
            this.mutateToFullBIN(false);
        }
    }

    private void postLoadInit(IN parent, int idx) {
        assert (this.isLatchExclusiveOwner());
        this.commonInit(parent.databaseImpl);
        this.addToMainCache();
        if (this.isBIN()) {
            this.setFetchedCold(true);
            this.setFetchedColdOffHeap(true);
        }
        this.getEnv().getOffHeapCache().postBINLoad(parent, idx, (BIN)this);
    }

    public final void postRecoveryInit(DatabaseImpl db, long lastLoggedLsn) {
        this.commonInit(db);
        this.setLastLoggedLsn(lastLoggedLsn);
    }

    private void commonInit(DatabaseImpl db) {
        this.setDatabase(db);
        this.initMemorySize();
    }

    private void addToMainCache() {
        this.getEnv().getInMemoryINs().add(this);
        if (!this.isDIN() && !this.isDBIN()) {
            if (this.isUpperIN()) {
                // empty if block
            }
            this.getEvictor().addBack(this);
        }
        if (!(this instanceof DBIN) && !(this instanceof DIN)) {
            this.getEnv().lazyCompress(this);
        }
    }

    private void convertDupKeys() {
        if (!this.needDupKeyConversion) {
            return;
        }
        this.needDupKeyConversion = false;
        DupConvert.convertInKeys(this.databaseImpl, this);
    }

    @Override
    final void incFetchStats(EnvironmentImpl envImpl, boolean isMiss) {
        Evictor e = envImpl.getEvictor();
        if (this.isBIN()) {
            e.incBINFetchStats(isMiss, this.isBINDelta(false));
        } else {
            e.incUINFetchStats(isMiss);
        }
    }

    public String makeFetchErrorMsg(String msg, long lsn, int idx) {
        long expirationTime;
        byte state;
        byte by = state = idx >= 0 ? this.entryStates[idx] : (byte)0;
        if (this.isBIN() && idx >= 0) {
            BIN bin = (BIN)this;
            expirationTime = TTL.expirationToSystemTime(bin.getExpiration(idx), this.isExpirationInHours());
        } else {
            expirationTime = 0L;
        }
        return IN.makeFetchErrorMsg(msg, this, lsn, state, expirationTime);
    }

    static String makeFetchErrorMsg(String msg, IN in, long lsn, byte state, long expirationTime) {
        StringBuilder sb = new StringBuilder();
        if (in == null) {
            sb.append("fetchRoot of ");
        } else if (in.isBIN()) {
            sb.append("fetchLN of ");
        } else {
            sb.append("fetchIN of ");
        }
        if (lsn == -1L) {
            sb.append("null lsn");
        } else {
            sb.append(DbLsn.getNoFormatString(lsn));
        }
        if (in != null) {
            sb.append(" parent IN=").append(in.getNodeId());
            sb.append(" IN class=").append(in.getClass().getName());
            sb.append(" lastFullLsn=");
            sb.append(DbLsn.getNoFormatString(in.getLastFullLsn()));
            sb.append(" lastLoggedLsn=");
            sb.append(DbLsn.getNoFormatString(in.getLastLoggedLsn()));
            sb.append(" parent.getDirty()=").append(in.getDirty());
        }
        sb.append(" state=").append(state);
        sb.append(" expires=");
        if (expirationTime != 0L) {
            sb.append(TTL.formatExpirationTime(expirationTime));
        } else {
            sb.append("never");
        }
        if (msg != null) {
            sb.append(" ").append(msg);
        }
        return sb.toString();
    }

    public final int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact) {
        return this.findEntry(key, indicateIfDuplicate, exact, null);
    }

    public final int findEntry(byte[] key, boolean indicateIfDuplicate, boolean exact, Comparator<byte[]> comparator) {
        boolean entryZeroSpecialCompare;
        assert (this.idKeyIsSlotKey());
        int high = this.nEntries - 1;
        int low = 0;
        int middle = 0;
        if (comparator == null) {
            comparator = this.databaseImpl.getKeyComparator();
        }
        boolean bl = entryZeroSpecialCompare = this.isUpperIN() && !exact && !indicateIfDuplicate;
        assert (this.nEntries >= 0);
        while (low <= high) {
            middle = (high + low) / 2;
            int s = middle == 0 && entryZeroSpecialCompare ? 1 : this.entryKeys.compareKeys(key, this.keyPrefix, middle, this.haveEmbeddedData(middle), comparator);
            if (s < 0) {
                high = middle - 1;
                continue;
            }
            if (s > 0) {
                low = middle + 1;
                continue;
            }
            int ret = indicateIfDuplicate ? middle | 0x10000 : middle;
            if (ret >= 0 && exact && this.isEntryKnownDeleted(ret & 0xFFFF)) {
                return -1;
            }
            return ret;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public final boolean insertEntry(Node child, byte[] key, long childLsn) throws DatabaseException {
        assert (!this.isBINDelta());
        int res = this.insertEntry1(child, key, null, childLsn, (byte)2, false);
        return (res & 0x20000) != 0;
    }

    public final int insertEntry1(Node child, byte[] key, byte[] data, long childLsn, boolean blindInsertion) {
        return this.insertEntry1(child, key, data, childLsn, (byte)2, blindInsertion);
    }

    public final int insertEntry1(Node child, byte[] key, byte[] data, long childLsn, byte state, boolean blindInsertion) {
        int index = this.findEntry(key, true, false);
        if (index >= 0 && (index & 0x10000) != 0) {
            return index & 0xFFFEFFFF;
        }
        if (this.isBINDelta()) {
            boolean doBlindInsertion;
            BIN bin = (BIN)this;
            boolean bl = doBlindInsertion = this.nEntries < this.getMaxEntries();
            if (doBlindInsertion && !blindInsertion && bin.mayHaveKeyInFullBin(key)) {
                doBlindInsertion = false;
            }
            if (!doBlindInsertion) {
                this.mutateToFullBIN(true);
                index = this.findEntry(key, true, false);
                if (index >= 0 && (index & 0x10000) != 0) {
                    return index & 0xFFFEFFFF;
                }
            } else {
                this.getEvictor().incBinDeltaBlindOps();
            }
        }
        if (this.nEntries >= this.getMaxEntries()) {
            throw EnvironmentFailureException.unexpectedState(this.getEnv(), "Node " + this.getNodeId() + " should have been split before calling insertEntry is BIN-delta: " + this.isBINDelta() + " num entries: " + this.nEntries + " max entries: " + this.getMaxEntries());
        }
        if (++index < this.nEntries) {
            int oldSize = this.computeLsnOverhead();
            this.shiftEntriesRight(index);
            this.updateMemorySize(this.computeLsnOverhead() - oldSize);
        } else {
            ++this.nEntries;
        }
        if (this.isBINDelta()) {
            ((BIN)this).incFullBinNEntries();
        }
        int oldSize = this.computeLsnOverhead();
        if (data == null || this.databaseImpl.isDeferredWriteMode()) {
            this.setTarget(index, child);
        }
        this.setLsnInternal(index, childLsn);
        boolean multiSlotChange = this.insertKey(index, key, data);
        this.entryStates[index] = state;
        if (data != null) {
            this.setEmbeddedLN(index);
            if (data.length == 0) {
                this.setNoDataLN(index);
            }
        }
        this.adjustCursorsForInsert(index);
        this.updateMemorySize(oldSize, this.getEntryInMemorySize(index) + (long)this.computeLsnOverhead());
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        }
        this.setDirty(true);
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
        return index | 0x20000;
    }

    public void deleteEntry(int index) {
        this.deleteEntry(index, true, true);
    }

    void deleteEntry(int index, boolean makeDirty, boolean validate) {
        assert (!this.isBINDelta());
        assert (index >= 0 && index < this.nEntries);
        assert (!validate || this.validateSubtreeBeforeDelete(index));
        if (makeDirty) {
            this.setDirty(true);
        }
        if (this.isDirty(index)) {
            this.setProhibitNextDelta(true);
        }
        Node child = this.getTarget(index);
        OffHeapCache ohCache = this.getEnv().getOffHeapCache();
        int level = this.getNormalizedLevel();
        if (level == 1) {
            ohCache.freeLN((BIN)this, index);
        } else if (level == 2) {
            ohCache.freeBIN((BIN)child, this, index);
        }
        if (child != null && child.isIN()) {
            IN childIN = (IN)child;
            this.getEnv().getInMemoryINs().remove(childIN);
        }
        this.updateMemorySize(this.getEntryInMemorySize(index), 0L);
        int oldLSNArraySize = this.computeLsnOverhead();
        this.setTarget(index, null);
        this.copyEntries(index + 1, index, this.nEntries - index - 1);
        --this.nEntries;
        this.clearEntry(this.nEntries);
        this.updateMemorySize(oldLSNArraySize, this.computeLsnOverhead());
        assert (this.isBIN() || this.hasCachedChildrenFlag() == this.hasCachedChildren());
        this.traceDelete(Level.FINEST, index);
    }

    void clearEntry(int idx) {
        this.entryTargets = (INTargetRep)this.entryTargets.set(idx, null, this);
        this.entryKeys = (INKeyRep)this.entryKeys.set(idx, null, this);
        this.offHeapBINIds = this.offHeapBINIds.set(idx, 0L, this);
        this.setLsnInternal(idx, -1L);
        this.entryStates[idx] = 0;
    }

    public final void updateEntry(int idx, long newLSN, long newVLSN, int newSize) {
        this.setLsn(idx, newLSN);
        if (this.isBIN()) {
            if (this.isEmbeddedLN(idx)) {
                ((BIN)this).setCachedVLSN(idx, newVLSN);
            } else {
                this.setLastLoggedSize(idx, newSize);
            }
        }
        this.setDirty(true);
    }

    final void applyDeltaSlot(int idx, Node node, long lsn, int lastLoggedSize, byte state, byte[] key, byte[] data) {
        assert (this.isBIN());
        assert (!this.isBINDelta());
        assert (lsn != -1L || (state & 1) != 0);
        assert (node == null || data == null);
        assert (!this.getInListResident());
        ((BIN)this).freeOffHeapLN(idx);
        this.setLsn(idx, lsn, false);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.setTarget(idx, node);
        this.updateLNSlotKey(idx, key, data);
        assert (this.isEmbeddedLN(idx) == IN.isEmbeddedLN(state));
        assert (this.isNoDataLN(idx) == IN.isNoDataLN(state));
        this.entryStates[idx] = state;
        this.setDirty(true);
    }

    public final void insertRecord(int idx, LN newLN, long newLSN, int newSize, byte[] newKey, byte[] newData, int expiration, boolean expirationInHours) {
        assert (this.isBIN());
        BIN bin = (BIN)this;
        bin.freeOffHeapLN(idx);
        long oldSlotSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, newLSN);
        boolean multiSlotChange = this.updateLNSlotKey(idx, newKey, newData);
        if (this.isEmbeddedLN(idx)) {
            this.clearLastLoggedSize(idx);
            bin.setCachedVLSN(idx, newLN.getVLSNSequence());
            if (this.databaseImpl.isDeferredWriteMode()) {
                this.setTarget(idx, newLN);
            }
        } else {
            this.setTarget(idx, newLN);
            this.setLastLoggedSize(idx, newSize);
        }
        bin.setExpiration(idx, expiration, expirationInHours);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSlotSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSlotSize, newSlotSize);
        }
        this.clearKnownDeleted(idx);
        this.clearPendingDeleted(idx);
        this.setDirty(true);
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    public final void updateRecord(int idx, long oldMemSize, long newLSN, long newVLSN, int newSize, byte[] newKey, byte[] newData, int expiration, boolean expirationInHours) {
        assert (this.isBIN());
        BIN bin = (BIN)this;
        bin.freeOffHeapLN(idx);
        long oldSlotSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, newLSN);
        boolean multiSlotChange = this.updateLNSlotKey(idx, newKey, newData);
        if (this.isEmbeddedLN(idx)) {
            this.clearLastLoggedSize(idx);
            ((BIN)this).setCachedVLSN(idx, newVLSN);
        } else {
            this.setLastLoggedSize(idx, newSize);
        }
        bin.setExpiration(idx, expiration, expirationInHours);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSlotSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSlotSize, newSlotSize);
            Node newLN = (Node)this.entryTargets.get(idx);
            long newMemSize = newLN != null ? newLN.getMemorySizeIncludedByParent() : 0L;
            this.updateMemorySize(oldMemSize, newMemSize);
        }
        this.setDirty(true);
    }

    public final void deleteRecord(int idx, long oldMemSize, long newLSN, long newVLSN, int newSize) {
        assert (this.isBIN());
        BIN bin = (BIN)this;
        bin.freeOffHeapLN(idx);
        this.setLsn(idx, newLSN);
        if (this.isEmbeddedLN(idx)) {
            this.clearLastLoggedSize(idx);
            bin.setCachedVLSN(idx, newVLSN);
        } else {
            this.setLastLoggedSize(idx, newSize);
        }
        if (this.entryTargets.get(idx) != null) {
            assert (oldMemSize != 0L);
            Node newLN = (Node)this.entryTargets.get(idx);
            long newMemSize = newLN.getMemorySizeIncludedByParent();
            this.updateMemorySize(oldMemSize, newMemSize);
        } else assert (oldMemSize == 0L);
        this.setPendingDeleted(idx);
        this.setDirty(true);
    }

    public final void recoverRecord(int idx, long lsn, boolean knownDeleted, boolean pendingDeleted, byte[] key, byte[] data, long vlsn, int logrecSize, int expiration, boolean expirationInHours) {
        assert (this.isBIN());
        BIN bin = (BIN)this;
        bin.freeOffHeapLN(idx);
        if (lsn == -1L) {
            this.setKnownDeletedAndEvictLN(idx);
            this.setLsnInternal(idx, -1L);
            bin.queueSlotDeletion(idx);
            return;
        }
        if (key == null && this.databaseImpl.allowsKeyUpdates() && !knownDeleted) {
            try {
                WholeEntry wholeEntry = this.getEnv().getLogManager().getLogEntryAllowInvisibleAtRecovery(lsn, this.getLastLoggedSize(idx));
                LNLogEntry logrec = (LNLogEntry)wholeEntry.getEntry();
                logrec.postFetchInit(this.getDatabase());
                key = logrec.getKey();
                logrecSize = wholeEntry.getHeader().getEntrySize();
            }
            catch (FileNotFoundException e) {
                throw new EnvironmentFailureException(this.getEnv(), EnvironmentFailureReason.LOG_FILE_NOT_FOUND, this.makeFetchErrorMsg(null, lsn, idx), e);
            }
        }
        long oldSlotSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, null);
        boolean multiSlotChange = this.updateLNSlotKey(idx, key, data);
        if (this.isEmbeddedLN(idx)) {
            this.clearLastLoggedSize(idx);
            bin.setCachedVLSN(idx, vlsn);
        } else {
            this.setLastLoggedSize(idx, logrecSize);
        }
        if (knownDeleted) {
            assert (!pendingDeleted);
            this.setKnownDeleted(idx);
            bin.queueSlotDeletion(idx);
        } else {
            this.clearKnownDeleted(idx);
            if (pendingDeleted) {
                this.setPendingDeleted(idx);
                bin.queueSlotDeletion(idx);
            } else {
                this.clearPendingDeleted(idx);
            }
        }
        bin.setExpiration(idx, expiration, expirationInHours);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSlotSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSlotSize, newSlotSize);
        }
        this.setDirty(true);
    }

    public final void recoverIN(int idx, Node node, long lsn, int lastLoggedSize) {
        long oldSlotSize = this.getEntryInMemorySize(idx);
        Node child = this.getTarget(idx);
        assert (child == null || !((IN)child).getInListResident() || child == node);
        this.setLsn(idx, lsn);
        this.setLastLoggedSize(idx, lastLoggedSize);
        this.setTarget(idx, node);
        long newSlotSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSlotSize, newSlotSize);
        this.setDirty(true);
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    public final void attachNode(int idx, Node node, byte[] newKey) {
        assert (!(node instanceof IN) || ((IN)node).isLatchExclusiveOwner());
        long oldSlotSize = this.getEntryInMemorySize(idx);
        assert (this.getTarget(idx) == null);
        this.setTarget(idx, node);
        boolean multiSlotChange = false;
        if (this.isBIN() && newKey != null) {
            assert (!this.haveEmbeddedData(idx));
            multiSlotChange = this.updateLNSlotKey(idx, newKey, null);
        }
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSlotSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSlotSize, newSlotSize);
        }
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    public final void detachNode(int idx, boolean updateLsn, long newLsn) {
        long oldSlotSize = this.getEntryInMemorySize(idx);
        Node child = this.getTarget(idx);
        if (updateLsn) {
            this.setLsn(idx, newLsn);
            this.setDirty(true);
        }
        this.setTarget(idx, null);
        long newSlotSize = this.getEntryInMemorySize(idx);
        this.updateMemorySize(oldSlotSize, newSlotSize);
        if (child != null && child.isIN()) {
            this.getEnv().getInMemoryINs().remove((IN)child);
        }
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    public final void convertKey(int idx, byte[] newKey) {
        long oldSlotSize = this.getEntryInMemorySize(idx);
        boolean multiSlotChange = this.updateKey(idx, newKey, null);
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSlotSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSlotSize, newSlotSize);
        }
        this.setDirty(true);
        assert (this.isBIN() || this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    void copyEntries(int from, int to, int n) {
        this.entryTargets = (INTargetRep)this.entryTargets.copy(from, to, n, this);
        this.entryKeys = (INKeyRep)this.entryKeys.copy(from, to, n, this);
        this.offHeapBINIds = this.offHeapBINIds.copy(from, to, n, this);
        System.arraycopy(this.entryStates, from, this.entryStates, to, n);
        if (this.entryLsnLongArray == null) {
            int fromOff = from << 2;
            int toOff = to << 2;
            int nBytes = n << 2;
            System.arraycopy(this.entryLsnByteArray, fromOff, this.entryLsnByteArray, toOff, nBytes);
        } else {
            System.arraycopy(this.entryLsnLongArray, from, this.entryLsnLongArray, to, n);
        }
    }

    public final boolean needsSplitting() {
        if (this.isBINDelta()) {
            BIN bin = (BIN)this;
            int fullBinNEntries = bin.getFullBinNEntries();
            int fullBinMaxEntries = bin.getFullBinMaxEntries();
            if (fullBinNEntries < 0) {
                this.mutateToFullBIN(false);
            } else {
                assert (fullBinNEntries > 0);
                return fullBinMaxEntries - fullBinNEntries < 1;
            }
        }
        return this.getMaxEntries() - this.nEntries < 1;
    }

    public final IN split(IN parent, int childIndex, IN grandParent, int maxEntries) {
        return this.splitInternal(parent, childIndex, grandParent, maxEntries, -1);
    }

    IN splitSpecial(IN parent, int parentIndex, IN grandParent, int maxEntriesPerNode, byte[] key, boolean leftSide) {
        int index = this.findEntry(key, false, false);
        if (leftSide && index == 0) {
            return this.splitInternal(parent, parentIndex, grandParent, maxEntriesPerNode, 1);
        }
        if (!leftSide && index == this.nEntries - 1) {
            return this.splitInternal(parent, parentIndex, grandParent, maxEntriesPerNode, this.nEntries - 1);
        }
        return this.split(parent, parentIndex, grandParent, maxEntriesPerNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final IN splitInternal(IN parent, int childIndex, IN grandParent, int maxEntries, int splitIndex) throws DatabaseException {
        int high;
        int low;
        assert (!this.isBINDelta());
        if (this.identifierKey == null) {
            throw EnvironmentFailureException.unexpectedState();
        }
        int idKeyIndex = this.findEntry(this.identifierKey, false, false);
        if (splitIndex < 0) {
            splitIndex = this.nEntries / 2;
        }
        if (idKeyIndex < splitIndex) {
            low = splitIndex;
            high = this.nEntries;
        } else {
            low = 0;
            high = splitIndex;
        }
        byte[] newIdKey = this.getKey(low);
        IN newSibling = this.createNewInstance(newIdKey, Math.max(maxEntries, high - low + 1), this.level);
        newSibling.latch(CacheMode.UNCHANGED);
        try {
            boolean addedNewSiblingToCompressorQueue = false;
            int newSiblingNEntries = high - low;
            boolean haveCachedChildren = this.hasCachedChildrenFlag();
            assert (this.isBIN() || haveCachedChildren == this.hasCachedChildren());
            BIN bin = this.isBIN() ? (BIN)this : null;
            for (int i = low; i < high; ++i) {
                if (!addedNewSiblingToCompressorQueue && bin != null && bin.isDefunct(i)) {
                    addedNewSiblingToCompressorQueue = true;
                    this.getEnv().addToCompressorQueue((BIN)newSibling);
                }
                newSibling.appendEntryFromOtherNode(this, i);
                this.clearEntry(i);
            }
            if (low == 0) {
                this.shiftEntriesLeft(newSiblingNEntries);
            }
            this.nEntries -= newSiblingNEntries;
            this.setDirty(true);
            if (this.isUpperIN() && haveCachedChildren) {
                this.setHasCachedChildrenFlag(this.hasCachedChildren());
            }
            assert (this.isBIN() || this.hasCachedChildrenFlag() == this.hasCachedChildren());
            assert (this.isBIN() || newSibling.hasCachedChildrenFlag() == newSibling.hasCachedChildren());
            this.adjustCursors(newSibling, low, high);
            byte[] newKeyPrefix = this.computeKeyPrefix(-1);
            this.recalcSuffixes(newKeyPrefix, null, null, -1);
            this.entryKeys = (INKeyRep)this.entryKeys.compact(this);
            if (newSibling.getNEntries() > 1) {
                byte[] newSiblingPrefix = newSibling.computeKeyPrefix(-1);
                newSibling.recalcSuffixes(newSiblingPrefix, null, null, -1);
                newSibling.initMemorySize();
            }
            assert (this.idKeyIsSlotKey());
            assert (newSibling.idKeyIsSlotKey());
            EnvironmentImpl env = this.getEnv();
            INList inMemoryINs = env.getInMemoryINs();
            long oldMemorySize = this.inMemorySize;
            long newSize = this.computeMemorySize();
            this.updateMemorySize(oldMemorySize, newSize);
            long newSiblingLsn = newSibling.optionalLogProvisionalNoCompress(parent);
            long myNewLsn = this.optionalLogProvisionalNoCompress(parent);
            assert (this.nEntries > 0);
            if (low == 0) {
                parent.prepareForSlotReuse(childIndex);
                parent.updateSplitSlot(childIndex, newSibling, newSiblingLsn, newIdKey);
                boolean inserted = parent.insertEntry(this, this.getKey(0), myNewLsn);
                assert (inserted);
            } else {
                parent.updateSplitSlot(childIndex, this, myNewLsn, this.getKey(0));
                boolean inserted = parent.insertEntry(newSibling, newIdKey, newSiblingLsn);
                assert (inserted);
            }
            inMemoryINs.add(newSibling);
            long parentLsn = parent.isRoot() ? parent.optionalLog() : parent.optionalLogProvisional(grandParent);
            env.getCheckpointer().coordinateSplitWithCheckpoint(newSibling);
            assert (!this.isDIN() && !this.isDBIN());
            if (this.isBIN() || !newSibling.hasCachedChildrenFlag()) {
                if (this.isUpperIN()) {
                    // empty if block
                }
                this.getEvictor().addBack(newSibling);
            }
            if (this.isUpperIN() && haveCachedChildren && !this.hasCachedChildrenFlag()) {
                this.getEvictor().addBack(this);
            }
            this.traceSplit(Level.FINE, parent, newSibling, parentLsn, myNewLsn, newSiblingLsn, splitIndex, idKeyIndex, childIndex);
        }
        finally {
            newSibling.releaseLatch();
        }
        return newSibling;
    }

    void appendEntryFromOtherNode(IN from, int fromIdx) {
        assert (!this.isBINDelta());
        Node target = (Node)from.entryTargets.get(fromIdx);
        int ohBinId = from.getOffHeapBINId(fromIdx);
        boolean ohBinPri2 = from.isOffHeapBINPri2(fromIdx);
        boolean ohBinDirty = from.isOffHeapBINDirty(fromIdx);
        long lsn = from.getLsn(fromIdx);
        byte state = from.entryStates[fromIdx];
        byte[] key = from.getKey(fromIdx);
        byte[] data = from.haveEmbeddedData(fromIdx) ? from.getData(fromIdx) : null;
        long oldSize = this.computeLsnOverhead();
        ++this.nEntries;
        int idx = this.nEntries - 1;
        if (target != null && target.isIN()) {
            IN in = (IN)target;
            in.latchNoUpdateLRU(this.databaseImpl);
            this.setTarget(idx, target);
            in.releaseLatch();
        } else {
            this.setTarget(idx, target);
        }
        boolean multiSlotChange = this.insertKey(idx, key, data);
        this.setLsnInternal(idx, lsn);
        this.entryStates[idx] = state;
        if (ohBinId >= 0) {
            this.setOffHeapBINId(idx, ohBinId, ohBinPri2, ohBinDirty);
            this.getOffHeapCache().setOwner(ohBinId, this);
        }
        if (multiSlotChange) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        } else {
            long newSize = this.getEntryInMemorySize(idx) + (long)this.computeLsnOverhead();
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
    }

    private void updateSplitSlot(int idx, IN child, long lsn, byte[] key) {
        assert (this.isUpperIN());
        long oldSize = this.getEntryInMemorySize(idx);
        this.setLsn(idx, lsn);
        this.setTarget(idx, child);
        if (idx == 0) {
            int s = this.entryKeys.compareKeys(key, this.keyPrefix, idx, this.haveEmbeddedData(idx), this.getKeyComparator());
            boolean multiSlotChange = false;
            if (s < 0) {
                multiSlotChange = this.updateKey(idx, key, null);
            }
            if (multiSlotChange) {
                this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
            } else {
                long newSize = this.getEntryInMemorySize(idx);
                this.updateMemorySize(oldSize, newSize);
            }
        } else {
            long newSize = this.getEntryInMemorySize(idx);
            this.updateMemorySize(oldSize, newSize);
        }
        this.setDirty(true);
        assert (this.hasCachedChildren() == this.hasCachedChildrenFlag());
    }

    private void shiftEntriesRight(int index) {
        this.copyEntries(index, index + 1, this.nEntries - index);
        this.clearEntry(index);
        ++this.nEntries;
        this.setDirty(true);
    }

    private void shiftEntriesLeft(int byHowMuch) {
        this.copyEntries(byHowMuch, 0, this.nEntries - byHowMuch);
        for (int i = this.nEntries - byHowMuch; i < this.nEntries; ++i) {
            this.clearEntry(i);
        }
        this.setDirty(true);
    }

    void adjustCursors(IN newSibling, int newSiblingLow, int newSiblingHigh) {
    }

    void adjustCursorsForInsert(int insertIndex) {
    }

    public void prepareForSlotReuse(int idx) {
        OffHeapCache ohCache;
        if (this.databaseImpl.isDeferredWriteMode()) {
            this.setLsn(idx, -1L, false);
        }
        if ((ohCache = this.getOffHeapCache()).isEnabled() && this.getNormalizedLevel() == 2) {
            ohCache.freeBIN((BIN)this.getTarget(idx), this, idx);
        }
    }

    public long getInMemorySize() {
        return this.inMemorySize;
    }

    private void initMemorySize() {
        this.entryKeys = (INKeyRep)this.entryKeys.compact(this);
        this.inMemorySize = this.computeMemorySize();
    }

    public long computeMemorySize() {
        long calcMemorySize = this.getFixedMemoryOverhead();
        calcMemorySize += (long)MemoryBudget.byteArraySize(this.entryStates.length);
        calcMemorySize += (long)this.computeLsnOverhead();
        for (int i = 0; i < this.nEntries; ++i) {
            calcMemorySize += this.getEntryInMemorySize(i);
        }
        if (this.keyPrefix != null) {
            calcMemorySize += (long)MemoryBudget.byteArraySize(this.keyPrefix.length);
        }
        if (this.provisionalObsolete != null) {
            calcMemorySize += (long)this.provisionalObsolete.getMemorySize();
        }
        calcMemorySize += this.entryTargets.calculateMemorySize();
        calcMemorySize += this.entryKeys.calculateMemorySize();
        if (this.offHeapBINIds != null) {
            calcMemorySize += this.offHeapBINIds.getMemorySize();
        }
        return calcMemorySize;
    }

    protected long getFixedMemoryOverhead() {
        return MemoryBudget.IN_FIXED_OVERHEAD;
    }

    private int computeLsnOverhead() {
        return this.entryLsnLongArray == null ? MemoryBudget.byteArraySize(this.entryLsnByteArray.length) : MemoryBudget.ARRAY_OVERHEAD + this.entryLsnLongArray.length * 8;
    }

    private long getEntryInMemorySize(int idx) {
        Node target;
        byte[] key;
        long ret = 0L;
        if (!this.entryKeys.accountsForKeyByteMemUsage() && (key = (byte[])this.entryKeys.get(idx)) != null) {
            ret += (long)MemoryBudget.byteArraySize(key.length);
        }
        if ((target = (Node)this.entryTargets.get(idx)) != null) {
            ret += target.getMemorySizeIncludedByParent();
        }
        return ret;
    }

    public long compactMemory() {
        long oldSize = this.inMemorySize;
        INKeyRep oldKeyRep = this.entryKeys;
        this.entryTargets = (INTargetRep)this.entryTargets.compact(this);
        this.entryKeys = (INKeyRep)this.entryKeys.compact(this);
        this.offHeapBINIds = this.offHeapBINIds.compact(this, EMPTY_OFFHEAP_BIN_IDS);
        if (this.entryKeys != oldKeyRep) {
            this.updateMemorySize(this.inMemorySize, this.computeMemorySize());
        }
        return oldSize - this.inMemorySize;
    }

    public long getBudgetedMemorySize() {
        return this.inMemorySize - (long)this.accumulatedDelta;
    }

    public long resetAndGetMemorySize() {
        this.accumulatedDelta = 0;
        return this.inMemorySize;
    }

    protected void updateMemorySize(long oldSize, long newSize) {
        long delta = newSize - oldSize;
        this.updateMemorySize(delta);
    }

    void updateMemorySize(Node oldNode, Node newNode) {
        long delta = 0L;
        if (newNode != null) {
            delta = newNode.getMemorySizeIncludedByParent();
        }
        if (oldNode != null) {
            delta -= oldNode.getMemorySizeIncludedByParent();
        }
        this.updateMemorySize(delta);
    }

    void updateMemorySize(long delta) {
        if (delta == 0L) {
            return;
        }
        this.inMemorySize += delta;
        if (this.getInListResident()) {
            assert (this.inMemorySize >= this.getFixedMemoryOverhead() || !this.getEnv().isValid()) : "delta: " + delta + " inMemorySize: " + this.inMemorySize + " overhead: " + this.getFixedMemoryOverhead() + " computed: " + this.computeMemorySize() + " dump: " + this.toString() + this.assertPrintMemorySize();
            this.accumulatedDelta = (int)((long)this.accumulatedDelta + delta);
            if (this.accumulatedDelta > ACCUMULATED_LIMIT || this.accumulatedDelta < -ACCUMULATED_LIMIT) {
                this.updateMemoryBudget();
            }
        }
    }

    public void updateMemoryBudget() {
        EnvironmentImpl env = this.getEnv();
        env.getInMemoryINs().memRecalcUpdate(this, this.accumulatedDelta);
        env.getMemoryBudget().updateTreeMemoryUsage(this.accumulatedDelta);
        this.accumulatedDelta = 0;
    }

    public long getTreeAdminMemorySize() {
        return 0L;
    }

    protected long printMemorySize() {
        long inOverhead = this.getFixedMemoryOverhead();
        long statesOverhead = MemoryBudget.byteArraySize(this.entryStates.length);
        int lsnOverhead = this.computeLsnOverhead();
        int entryOverhead = 0;
        for (int i = 0; i < this.nEntries; ++i) {
            entryOverhead = (int)((long)entryOverhead + this.getEntryInMemorySize(i));
        }
        int keyPrefixOverhead = this.keyPrefix != null ? MemoryBudget.byteArraySize(this.keyPrefix.length) : 0;
        int provisionalOverhead = this.provisionalObsolete != null ? this.provisionalObsolete.getMemorySize() : 0;
        long targetRepOverhead = this.entryTargets.calculateMemorySize();
        long keyRepOverhead = this.entryKeys.calculateMemorySize();
        long total = inOverhead + statesOverhead + (long)lsnOverhead + (long)entryOverhead + (long)keyPrefixOverhead + (long)provisionalOverhead + targetRepOverhead + keyRepOverhead;
        long offHeapBINIdOverhead = this.offHeapBINIds.getMemorySize();
        System.out.println(" nEntries:" + this.nEntries + "/" + this.entryStates.length + " in: " + inOverhead + " states: " + statesOverhead + " entry: " + entryOverhead + " lsn: " + lsnOverhead + " keyPrefix: " + keyPrefixOverhead + " provisional: " + provisionalOverhead + " targetRep(" + this.entryTargets.getType() + "): " + targetRepOverhead + " keyRep(" + this.entryKeys.getType() + "): " + keyRepOverhead + " offHeapBINIds: " + offHeapBINIdOverhead + " Total: " + total + " inMemorySize: " + this.inMemorySize);
        return total;
    }

    private boolean assertPrintMemorySize() {
        this.printMemorySize();
        return true;
    }

    public boolean verifyMemorySize() {
        long calcMemorySize = this.computeMemorySize();
        if (calcMemorySize != this.inMemorySize) {
            String msg = "-Warning: Out of sync. Should be " + calcMemorySize + " / actual: " + this.inMemorySize + " node: " + this.getNodeId();
            LoggerUtils.envLogMsg(Level.INFO, this.getEnv(), msg);
            System.out.println(msg);
            this.printMemorySize();
            return false;
        }
        return true;
    }

    protected void updateRepCacheStats(boolean increment) {
        assert (this.isBIN());
        this.entryKeys.updateCacheStats(increment, this);
        this.entryTargets.updateCacheStats(increment, this);
    }

    protected int getCompactMaxKeyLength() {
        return this.getEnv().getCompactMaxKeyLength();
    }

    public void setInListResident(boolean resident) {
        if (!resident) {
            this.entryTargets.updateCacheStats(false, this);
            this.entryKeys.updateCacheStats(false, this);
        }
        this.flags = resident ? (this.flags |= 0x100) : (this.flags &= 0xFFFFFEFF);
        if (resident) {
            this.entryTargets.updateCacheStats(true, this);
            this.entryKeys.updateCacheStats(true, this);
        }
    }

    public boolean getInListResident() {
        return (this.flags & 0x100) != 0;
    }

    public IN getPrevLRUNode() {
        return this.prevLRUNode;
    }

    public void setPrevLRUNode(IN node) {
        this.prevLRUNode = node;
    }

    public IN getNextLRUNode() {
        return this.nextLRUNode;
    }

    public void setNextLRUNode(IN node) {
        this.nextLRUNode = node;
    }

    public long partialEviction() {
        return 0L;
    }

    public boolean hasCachedChildren() {
        assert (this.isLatchOwner());
        for (int i = 0; i < this.getNEntries(); ++i) {
            if (this.entryTargets.get(i) == null) continue;
            return true;
        }
        return false;
    }

    public void setProhibitNextDelta(boolean val) {
        if (!this.isBIN()) {
            return;
        }
        this.flags = val ? (this.flags |= 0x200) : (this.flags &= 0xFFFFFDFF);
    }

    public boolean getProhibitNextDelta() {
        return (this.flags & 0x200) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean validateSubtreeBeforeDelete(int index) throws DatabaseException {
        if (index >= this.nEntries) {
            return true;
        }
        IN child = this.fetchIN(index, CacheMode.UNCHANGED);
        boolean needToLatch = !child.isLatchExclusiveOwner();
        try {
            if (needToLatch) {
                child.latch(CacheMode.UNCHANGED);
            }
            boolean bl = child.isValidForDelete();
            return bl;
        }
        finally {
            if (needToLatch && this.isLatchOwner()) {
                child.releaseLatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean isValidForDelete() throws DatabaseException {
        assert (!this.isBINDelta());
        if (this.nEntries > 1) {
            return false;
        }
        if (this.nEntries == 1) {
            boolean needToLatch;
            IN child = this.fetchIN(0, CacheMode.UNCHANGED);
            boolean bl = needToLatch = !child.isLatchExclusiveOwner();
            if (needToLatch) {
                child.latch(CacheMode.UNCHANGED);
            }
            boolean ret = false;
            try {
                if (child.isBINDelta()) {
                    boolean bl2 = false;
                    return bl2;
                }
                ret = child.isValidForDelete();
            }
            finally {
                if (needToLatch) {
                    child.releaseLatch();
                }
            }
            return ret;
        }
        return true;
    }

    @Override
    final void rebuildINList(INList inList) throws DatabaseException {
        this.initMemorySize();
        inList.add(this);
        boolean hasCachedChildren = false;
        for (int i = 0; i < this.nEntries; ++i) {
            Node n = this.getTarget(i);
            if (n != null) {
                n.rebuildINList(inList);
                hasCachedChildren = true;
            }
            if (this.getOffHeapBINId(i) < 0) continue;
            hasCachedChildren = true;
        }
        if (this.isUpperIN()) {
            if (hasCachedChildren) {
                this.setHasCachedChildrenFlag(true);
            } else {
                this.setHasCachedChildrenFlag(false);
                if (!this.isDIN()) {
                    this.getEvictor().addBack(this);
                }
            }
        } else if (this.isBIN() && !this.isDBIN()) {
            this.getEvictor().addBack(this);
        }
    }

    void accumulateStats(TreeWalkerStatsAccumulator acc) {
        acc.processIN(this, this.getNodeId(), this.getLevel());
    }

    public void setLastLoggedLsn(long lsn) {
        if (this.isBIN()) {
            if (this.getLastFullLsn() == -1L) {
                this.setLastFullLsn(lsn);
            } else {
                ((BIN)this).setLastDeltaLsn(lsn);
            }
        } else {
            this.setLastFullLsn(lsn);
        }
    }

    public final long getLastLoggedLsn() {
        if (this.isBIN()) {
            return this.getLastDeltaLsn() != -1L ? this.getLastDeltaLsn() : this.getLastFullLsn();
        }
        return this.getLastFullLsn();
    }

    public final void setLastFullLsn(long lsn) {
        this.lastFullVersion = lsn;
    }

    public final long getLastFullLsn() {
        return this.lastFullVersion;
    }

    public long getLastDeltaLsn() {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logDirtyChildren() throws DatabaseException {
        assert (!this.isBINDelta());
        EnvironmentImpl envImpl = this.getDatabase().getEnv();
        for (int i = 0; i < this.getNEntries(); ++i) {
            IN child = (IN)this.getTarget(i);
            if (child == null) continue;
            child.latch(CacheMode.UNCHANGED);
            try {
                if (!child.getDirty()) continue;
                child.logDirtyChildren();
                long childLsn = child.log(false, true, true, this);
                this.updateEntry(i, childLsn, -1L, 0);
                continue;
            }
            finally {
                child.releaseLatch();
            }
        }
    }

    public final long log() {
        return IN.logInternal(this, null, false, true, Provisional.NO, false, null);
    }

    public final long log(boolean allowDeltas, boolean isProvisional, boolean backgroundIO, IN parent) {
        return IN.logInternal(this, null, allowDeltas, true, isProvisional ? Provisional.YES : Provisional.NO, backgroundIO, parent);
    }

    public final long log(boolean allowDeltas, Provisional provisional, boolean backgroundIO, IN parent) {
        return IN.logInternal(this, null, allowDeltas, true, provisional, backgroundIO, parent);
    }

    public final long optionalLog() {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return this.getLastLoggedLsn();
        }
        return IN.logInternal(this, null, false, true, Provisional.NO, false, null);
    }

    public long optionalLogProvisional(IN parent) {
        return this.optionalLogProvisional(parent, true);
    }

    long optionalLogProvisionalNoCompress(IN parent) {
        return this.optionalLogProvisional(parent, false);
    }

    private long optionalLogProvisional(IN parent, boolean allowCompress) {
        if (this.databaseImpl.isDeferredWriteMode()) {
            return this.getLastLoggedLsn();
        }
        return IN.logInternal(this, null, false, allowCompress, Provisional.YES, false, parent);
    }

    public static long logEntry(INLogEntry<BIN> logEntry, Provisional provisional, boolean backgroundIO, IN parent) {
        return IN.logInternal(null, logEntry, true, false, provisional, backgroundIO, parent);
    }

    private static long logInternal(IN node, INLogEntry<?> logEntry, boolean allowDeltas, boolean allowCompress, Provisional provisional, boolean backgroundIO, IN parent) {
        boolean isDelta;
        BIN bin;
        boolean countObsoleteNow;
        assert (node == null || node.isLatchExclusiveOwner());
        assert (parent == null || parent.isLatchExclusiveOwner());
        assert (node != null || parent != null);
        assert (node == null != (logEntry == null));
        DatabaseImpl dbImpl = node != null ? node.getDatabase() : parent.getDatabase();
        EnvironmentImpl envImpl = dbImpl.getEnv();
        boolean bl = countObsoleteNow = provisional != Provisional.YES || dbImpl.isTemporary();
        boolean isBin = node != null ? node.isBIN() : parent.getNormalizedLevel() == 2;
        BIN bIN = bin = node != null && isBin ? (BIN)node : null;
        if (isBin) {
            if (logEntry != null) {
                isDelta = logEntry.isBINDelta();
            } else {
                if (allowCompress) {
                    envImpl.lazyCompress(bin, false);
                }
                boolean bl2 = isDelta = bin.isBINDelta() || allowDeltas && bin.shouldLogDelta();
                assert (!isDelta || !bin.isDeltaProhibited());
                if (allowCompress && !isDelta) {
                    envImpl.lazyCompress(bin, true);
                }
                if (dbImpl.isDeferredWriteMode()) {
                    bin.logDirtyChildren();
                }
                logEntry = isDelta ? new BINDeltaLogEntry(bin) : new INLogEntry<BIN>(bin);
            }
        } else {
            assert (node != null);
            isDelta = false;
            logEntry = new INLogEntry<IN>(node);
        }
        LogParams params = new LogParams();
        params.entry = logEntry;
        params.provisional = provisional;
        params.repContext = ReplicationContext.NO_REPLICATE;
        params.nodeDb = dbImpl;
        params.backgroundIO = backgroundIO;
        long oldLsn = isDelta ? -1L : logEntry.getPrevFullLsn();
        long auxOldLsn = logEntry.getPrevDeltaLsn();
        if (countObsoleteNow) {
            params.oldLsn = oldLsn;
            params.auxOldLsn = auxOldLsn;
            params.packedObsoleteInfo = node != null ? node.provisionalObsolete : null;
        }
        LogItem item = envImpl.getLogManager().log(params);
        if (node != null) {
            node.setDirty(false);
        }
        if (countObsoleteNow) {
            if (node != null) {
                node.discardProvisionalObsolete();
            }
        } else if (parent != null) {
            parent.trackProvisionalObsolete(node, oldLsn);
            parent.trackProvisionalObsolete(node, auxOldLsn);
        }
        if (bin != null) {
            if (isDelta) {
                bin.setLastDeltaLsn(item.lsn);
            } else {
                bin.setLastFullLsn(item.lsn);
                bin.setLastDeltaLsn(-1L);
            }
            bin.setProhibitNextDelta(false);
        } else if (node != null) {
            node.setLastFullLsn(item.lsn);
        }
        Evictor evictor = envImpl.getEvictor();
        if (node != null && evictor.getUseDirtyLRUSet()) {
            evictor.moveToPri1LRU(node);
        }
        return item.lsn;
    }

    void trackProvisionalObsolete(IN childIN, long obsoleteLsn) {
        int oldMemSize;
        boolean addChildLsn;
        boolean moveChildInfo = childIN != null && childIN.provisionalObsolete != null;
        boolean bl = addChildLsn = obsoleteLsn != -1L;
        if (!moveChildInfo && !addChildLsn) {
            return;
        }
        int n = oldMemSize = this.provisionalObsolete != null ? this.provisionalObsolete.getMemorySize() : 0;
        if (moveChildInfo) {
            if (this.provisionalObsolete != null) {
                this.provisionalObsolete.copyObsoleteInfo(childIN.provisionalObsolete);
            } else {
                this.provisionalObsolete = childIN.provisionalObsolete;
            }
            childIN.updateMemorySize(0 - childIN.provisionalObsolete.getMemorySize());
            childIN.provisionalObsolete = null;
        }
        if (addChildLsn) {
            if (this.provisionalObsolete == null) {
                this.provisionalObsolete = new PackedObsoleteInfo();
            }
            this.provisionalObsolete.addObsoleteInfo(obsoleteLsn);
        }
        this.updateMemorySize(oldMemSize, this.provisionalObsolete != null ? (long)this.provisionalObsolete.getMemorySize() : 0L);
    }

    private void discardProvisionalObsolete() throws DatabaseException {
        if (this.provisionalObsolete != null) {
            this.updateMemorySize(0 - this.provisionalObsolete.getMemorySize());
            this.provisionalObsolete = null;
        }
    }

    public void mutateToFullBIN(boolean leaveFreeSlot) {
    }

    private int getNEntriesToWrite(boolean deltasOnly) {
        if (!deltasOnly) {
            return this.nEntries;
        }
        return this.getNDeltas();
    }

    public final int getNDeltas() {
        int n = 0;
        for (int i = 0; i < this.nEntries; ++i) {
            if (!this.isDirty(i)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public final LogEntryType getGenericLogType() {
        return this.getLogType();
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN;
    }

    @Override
    public int getLogSize() {
        return this.getLogSize(false);
    }

    public final int getLogSize(boolean deltasOnly) {
        BIN bin = this.isBIN() ? (BIN)this : null;
        boolean haveVLSNCache = bin != null && bin.isVLSNCachingEnabled();
        int size = 0;
        boolean haveExpiration = false;
        if (bin != null) {
            int base = bin.getExpirationBase();
            haveExpiration = base != -1;
            size += LogUtils.getPackedIntLogSize(base);
        }
        size += LogUtils.getPackedLongLogSize(this.nodeId);
        size += LogUtils.getByteArrayLogSize(this.identifierKey);
        if (this.keyPrefix != null) {
            size += LogUtils.getByteArrayLogSize(this.keyPrefix);
        }
        ++size;
        int nEntriesToWrite = this.getNEntriesToWrite(deltasOnly);
        int maxEntriesToWrite = !deltasOnly ? this.getMaxEntries() : bin.getDeltaCapacity(nEntriesToWrite);
        size += LogUtils.getPackedIntLogSize(nEntriesToWrite);
        size += LogUtils.getPackedIntLogSize(this.level);
        size += LogUtils.getPackedIntLogSize(maxEntriesToWrite);
        boolean compactLsnsRep = this.entryLsnLongArray == null;
        size += LogUtils.getBooleanLogSize();
        if (compactLsnsRep) {
            size += 4;
        }
        for (int i = 0; i < this.nEntries; ++i) {
            if (deltasOnly && !this.isDirty(i)) continue;
            size += LogUtils.getByteArrayLogSize((byte[])this.entryKeys.get(i)) + (compactLsnsRep ? 4 : LogUtils.getLongLogSize()) + 1;
            if (this.isLastLoggedSizeStored(i)) {
                size += LogUtils.getPackedIntLogSize(this.getLastLoggedSize(i));
            }
            if (haveVLSNCache && this.isEmbeddedLN(i)) {
                size += LogUtils.getPackedLongLogSize(bin.getCachedVLSN(i));
            }
            if (!haveExpiration) continue;
            size += LogUtils.getPackedIntLogSize(bin.getExpirationOffset(i));
        }
        if (deltasOnly) {
            size += LogUtils.getPackedIntLogSize(bin.getFullBinNEntries());
            size += LogUtils.getPackedIntLogSize(bin.getFullBinMaxEntries());
            size += bin.getBloomFilterLogSize();
        }
        return size;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        this.serialize(logBuffer, false, true);
    }

    public void writeToLog(ByteBuffer logBuffer, boolean deltasOnly) {
        this.serialize(logBuffer, deltasOnly, !deltasOnly);
    }

    public final void serialize(ByteBuffer logBuffer, boolean deltasOnly, boolean clearDirtyBits) {
        assert (!deltasOnly || this.isBIN());
        BIN bin = this.isBIN() ? (BIN)this : null;
        byte[] bloomFilter = deltasOnly ? bin.createBloomFilter() : null;
        boolean haveExpiration = false;
        if (bin != null) {
            int base = bin.getExpirationBase();
            haveExpiration = base != -1;
            LogUtils.writePackedInt(logBuffer, base);
        }
        LogUtils.writePackedLong(logBuffer, this.nodeId);
        LogUtils.writeByteArray(logBuffer, this.identifierKey);
        boolean hasKeyPrefix = this.keyPrefix != null;
        boolean mayHaveLastLoggedSize = this.mayHaveLastLoggedSizeStored();
        boolean haveVLSNCache = bin != null && bin.isVLSNCachingEnabled();
        byte booleans = (byte)(this.isRoot() ? 1 : 0);
        booleans = (byte)(booleans | (hasKeyPrefix ? 2 : 0));
        booleans = (byte)(booleans | (mayHaveLastLoggedSize ? 4 : 0));
        booleans = (byte)(booleans | (bloomFilter != null ? 8 : 0));
        booleans = (byte)(booleans | (haveVLSNCache ? 16 : 0));
        booleans = (byte)(booleans | (this.isExpirationInHours() ? 32 : 0));
        logBuffer.put(booleans);
        if (hasKeyPrefix) {
            LogUtils.writeByteArray(logBuffer, this.keyPrefix);
        }
        int nEntriesToWrite = this.getNEntriesToWrite(deltasOnly);
        int maxEntriesToWrite = !deltasOnly ? this.getMaxEntries() : bin.getDeltaCapacity(nEntriesToWrite);
        LogUtils.writePackedInt(logBuffer, nEntriesToWrite);
        LogUtils.writePackedInt(logBuffer, this.level);
        LogUtils.writePackedInt(logBuffer, maxEntriesToWrite);
        boolean compactLsnsRep = this.entryLsnLongArray == null;
        LogUtils.writeBoolean(logBuffer, compactLsnsRep);
        if (compactLsnsRep) {
            LogUtils.writeInt(logBuffer, (int)this.baseFileNumber);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            if (deltasOnly && !this.isDirty(i)) continue;
            LogUtils.writeByteArray(logBuffer, (byte[])this.entryKeys.get(i));
            assert (this.checkForNullLSN(i)) : "logging IN " + this.getNodeId() + " with null lsn child  db=" + this.databaseImpl.getDebugName() + " isDeferredWriteMode=" + this.databaseImpl.isDeferredWriteMode() + " isTemporary=" + this.databaseImpl.isTemporary();
            if (compactLsnsRep) {
                int offset = i << 2;
                int fileOffset = this.getFileOffset(offset);
                logBuffer.put(this.getFileNumberOffset(offset));
                logBuffer.put((byte)(fileOffset & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 8 & 0xFF));
                logBuffer.put((byte)(fileOffset >>> 16 & 0xFF));
            } else {
                LogUtils.writeLong(logBuffer, this.entryLsnLongArray[i]);
            }
            logBuffer.put((byte)(this.entryStates[i] & 0xFFFFFFBB));
            if (clearDirtyBits) {
                int n = i;
                this.entryStates[n] = (byte)(this.entryStates[n] & 0xFFFFFFFD);
            }
            if (this.isLastLoggedSizeStored(i)) {
                LogUtils.writePackedInt(logBuffer, this.getLastLoggedSize(i));
            }
            if (haveVLSNCache && this.isEmbeddedLN(i)) {
                LogUtils.writePackedLong(logBuffer, bin.getCachedVLSN(i));
            }
            if (!haveExpiration) continue;
            LogUtils.writePackedInt(logBuffer, bin.getExpirationOffset(i));
        }
        if (deltasOnly) {
            LogUtils.writePackedInt(logBuffer, bin.getFullBinNEntries());
            LogUtils.writePackedInt(logBuffer, bin.getFullBinMaxEntries());
            if (bloomFilter != null) {
                BINDeltaBloomFilter.writeToLog(bloomFilter, logBuffer);
            }
        }
    }

    private boolean checkForNullLSN(int index) {
        boolean ok = this.isBIN() ? this.getLsn(index) != -1L || (this.entryStates[index] & 1) != 0 : this.getLsn(index) != -1L;
        return ok;
    }

    public boolean mayHaveExpirationValues(ByteBuffer itemBuffer, int entryVersion) {
        if (!this.isBIN() || entryVersion < 12) {
            return false;
        }
        itemBuffer.mark();
        int expirationBase = LogUtils.readPackedInt(itemBuffer);
        itemBuffer.reset();
        return expirationBase != -1;
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, int entryVersion) {
        this.materialize(itemBuffer, entryVersion, false, true);
    }

    public void readFromLog(ByteBuffer itemBuffer, int entryVersion, boolean deltasOnly) {
        this.materialize(itemBuffer, entryVersion, deltasOnly, !deltasOnly);
    }

    public final void materialize(ByteBuffer itemBuffer, int entryVersion, boolean deltasOnly, boolean clearDirtyBits) {
        boolean haveVLSNCache;
        boolean hasBloomFilter;
        boolean mayHaveLastLoggedSize;
        assert (!deltasOnly || this.isBIN());
        BIN bin = this.isBIN() ? (BIN)this : null;
        boolean unpacked = entryVersion < 6;
        boolean haveExpiration = false;
        if (bin != null && entryVersion >= 12) {
            int base = LogUtils.readPackedInt(itemBuffer);
            haveExpiration = base != -1;
            bin.setExpirationBase(base);
        }
        this.nodeId = LogUtils.readLong(itemBuffer, unpacked);
        this.identifierKey = LogUtils.readByteArray(itemBuffer, unpacked);
        byte booleans = itemBuffer.get();
        this.setIsRootFlag((booleans & 1) != 0);
        if ((booleans & 2) != 0) {
            this.keyPrefix = LogUtils.readByteArray(itemBuffer, unpacked);
        }
        boolean bl = mayHaveLastLoggedSize = (booleans & 4) != 0;
        assert (!mayHaveLastLoggedSize || entryVersion >= 9);
        boolean bl2 = hasBloomFilter = (booleans & 8) != 0;
        assert (!hasBloomFilter || entryVersion >= 10 && deltasOnly);
        boolean bl3 = haveVLSNCache = (booleans & 0x10) != 0;
        assert (!haveVLSNCache || entryVersion >= 11);
        this.setExpirationInHours((booleans & 0x20) != 0);
        this.nEntries = LogUtils.readInt(itemBuffer, unpacked);
        this.level = LogUtils.readInt(itemBuffer, unpacked);
        int length = LogUtils.readInt(itemBuffer, unpacked);
        this.entryTargets = INTargetRep.NONE;
        this.entryKeys = new INKeyRep.Default(length);
        this.baseFileNumber = -1L;
        long storedBaseFileNumber = -1L;
        if (disableCompactLsns) {
            this.entryLsnByteArray = null;
            this.entryLsnLongArray = new long[length];
        } else {
            this.entryLsnByteArray = new byte[length << 2];
            this.entryLsnLongArray = null;
        }
        this.entryStates = new byte[length];
        boolean compactLsnsRep = false;
        if (entryVersion > 1 && (compactLsnsRep = LogUtils.readBoolean(itemBuffer))) {
            storedBaseFileNumber = this.baseFileNumber = (long)LogUtils.readInt(itemBuffer);
        }
        for (int i = 0; i < this.nEntries; ++i) {
            long lsn;
            this.entryKeys = (INKeyRep)this.entryKeys.set(i, LogUtils.readByteArray(itemBuffer, unpacked), this);
            if (compactLsnsRep) {
                byte fileNumberOffset = itemBuffer.get();
                int fileOffset = itemBuffer.get() & 0xFF;
                fileOffset |= (itemBuffer.get() & 0xFF) << 8;
                lsn = (fileOffset |= (itemBuffer.get() & 0xFF) << 16) == 0xFFFFFF ? -1L : DbLsn.makeLsn(storedBaseFileNumber + (long)fileNumberOffset, fileOffset);
            } else {
                lsn = LogUtils.readLong(itemBuffer);
            }
            this.setLsnInternal(i, lsn);
            byte entryState = itemBuffer.get();
            if (clearDirtyBits) {
                entryState = (byte)(entryState & 0xFFFFFFFD);
            }
            if (entryVersion < 9) {
                entryState = (byte)(entryState & 0xFFFFFFBB);
            }
            if (entryVersion < 9 && lsn == -1L) {
                entryState = (byte)(entryState | 1);
            }
            this.entryStates[i] = entryState;
            if (mayHaveLastLoggedSize && !this.isEmbeddedLN(i)) {
                this.setLastLoggedSizeUnconditional(i, LogUtils.readPackedInt(itemBuffer));
            }
            if (haveVLSNCache && this.isEmbeddedLN(i)) {
                bin.setCachedVLSNUnconditional(i, LogUtils.readPackedLong(itemBuffer));
            }
            if (!haveExpiration) continue;
            bin.setExpirationOffset(i, LogUtils.readPackedInt(itemBuffer));
        }
        if (deltasOnly) {
            this.setBINDelta(true);
            if (entryVersion >= 10) {
                bin.setFullBinNEntries(LogUtils.readPackedInt(itemBuffer));
                bin.setFullBinMaxEntries(LogUtils.readPackedInt(itemBuffer));
                if (hasBloomFilter) {
                    bin.bloomFilter = BINDeltaBloomFilter.readFromLog(itemBuffer, entryVersion);
                }
            }
        }
        this.needDupKeyConversion = entryVersion < 8;
    }

    @Override
    public final boolean logicalEquals(Loggable other) {
        return false;
    }

    @Override
    public final void dumpLog(StringBuilder sb, boolean verbose) {
        boolean compactLsnsRep;
        BIN bin;
        sb.append(this.beginTag());
        sb.append("<nodeId val=\"");
        sb.append(this.nodeId);
        sb.append("\"/>");
        sb.append(Key.dumpString(this.identifierKey, "idKey", 0));
        sb.append("<isRoot val=\"");
        sb.append(this.isRoot());
        sb.append("\"/>");
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level));
        sb.append("\"/>");
        if (this.keyPrefix != null) {
            sb.append(Key.dumpString(this.keyPrefix, "keyPrefix", 0));
        }
        sb.append("<entries numEntries=\"");
        sb.append(this.nEntries);
        sb.append("\" length=\"");
        sb.append(this.getMaxEntries());
        BIN bIN = bin = this.isBIN() ? (BIN)this : null;
        if (this.isBINDelta(false)) {
            sb.append("\" numFullBinEntries=\"");
            sb.append(bin.getFullBinNEntries());
            sb.append("\" maxFullBinEntries=\"");
            sb.append(bin.getFullBinMaxEntries());
        }
        boolean bl = compactLsnsRep = this.entryLsnLongArray == null;
        if (compactLsnsRep) {
            sb.append("\" baseFileNumber=\"");
            sb.append(this.baseFileNumber);
        }
        sb.append("\">");
        if (verbose) {
            for (int i = 0; i < this.nEntries; ++i) {
                sb.append("<ref");
                this.dumpSlotState(sb, i, bin);
                sb.append(">");
                sb.append(Key.dumpString(this.getKey(i), 0));
                if (this.isEmbeddedLN(i)) {
                    sb.append(Key.dumpString(this.getData(i), "data", 0));
                }
                sb.append(DbLsn.toString(this.getLsn(i)));
                sb.append("</ref>");
            }
        }
        sb.append("</entries>");
        if (this.isBINDelta(false) && bin.bloomFilter != null) {
            BINDeltaBloomFilter.dumpLog(bin.bloomFilter, sb, verbose);
        }
        this.dumpLogAdditional(sb);
        sb.append(this.endTag());
    }

    protected void dumpLogAdditional(StringBuilder sb) {
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    @Override
    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuilder sb = new StringBuilder();
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.beginTag());
            sb.append('\n');
        }
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append("<nodeId val=\"");
            sb.append(this.nodeId);
            sb.append("\"/>");
        } else {
            sb.append(this.nodeId);
        }
        sb.append('\n');
        BIN bin = null;
        if (this.isBIN()) {
            bin = (BIN)this;
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<idkey>");
        sb.append(this.identifierKey == null ? "" : Key.dumpString(this.identifierKey, 0));
        sb.append("</idkey>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<prefix>");
        sb.append(this.keyPrefix == null ? "" : Key.dumpString(this.keyPrefix, 0));
        sb.append("</prefix>\n");
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<dirty val=\"").append(this.getDirty()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<level val=\"");
        sb.append(Integer.toHexString(this.level)).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isRoot val=\"").append(this.isRoot()).append("\"/>");
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<isBINDelta val=\"").append(this.isBINDelta(false)).append("\"/>");
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<prohibitNextDelta val=\"").append(this.getProhibitNextDelta()).append("\"/>");
        if (bin != null) {
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<cursors val=\"").append(bin.nCursors()).append("\"/>");
            sb.append(TreeUtils.indent(nSpaces + 2));
            sb.append("<deltas val=\"").append(bin.getNDeltas()).append("\"/>");
        }
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("<entries nEntries=\"");
        sb.append(this.nEntries);
        sb.append("\">");
        sb.append('\n');
        for (int i = 0; i < this.nEntries; ++i) {
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("<entry id=\"").append(i).append("\"");
            this.dumpSlotState(sb, i, bin);
            sb.append(">\n");
            if (this.getLsn(i) == -1L) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<lsn/>");
            } else {
                sb.append(DbLsn.dumpString(this.getLsn(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.entryKeys.get(i) == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<key/>");
            } else {
                sb.append(Key.dumpString((byte[])this.entryKeys.get(i), nSpaces + 6));
            }
            sb.append('\n');
            if (this.getOffHeapBINId(i) >= 0) {
                sb.append("<ohBIN id=\"").append(i).append("\"");
                sb.append(this.getOffHeapBINId(i)).append(">\n");
            }
            if (bin != null && bin.getOffHeapLNId(i) != 0L) {
                sb.append("<ohLN id=\"").append(i).append("\"");
                sb.append(bin.getOffHeapLNId(i)).append(">\n");
            }
            if (this.entryTargets.get(i) == null) {
                sb.append(TreeUtils.indent(nSpaces + 6));
                sb.append("<target/>");
            } else {
                sb.append(((Node)this.entryTargets.get(i)).dumpString(nSpaces + 6, true));
            }
            sb.append('\n');
            sb.append(TreeUtils.indent(nSpaces + 4));
            sb.append("</entry>");
            sb.append('\n');
        }
        sb.append(TreeUtils.indent(nSpaces + 2));
        sb.append("</entries>");
        sb.append('\n');
        if (dumpTags) {
            sb.append(TreeUtils.indent(nSpaces));
            sb.append(this.endTag());
        }
        return sb.toString();
    }

    private void dumpSlotState(StringBuilder sb, int i, BIN bin) {
        sb.append(" kd=\"").append(this.isEntryKnownDeleted(i));
        sb.append("\" pd=\"").append(this.isEntryPendingDeleted(i));
        sb.append("\" dirty=\"").append(this.isDirty(i));
        sb.append("\" embedded=\"").append(this.isEmbeddedLN(i));
        sb.append("\" noData=\"").append(this.isNoDataLN(i));
        if (bin != null) {
            sb.append("\" logSize=\"");
            sb.append(bin.getLastLoggedSizeUnconditional(i));
            long vlsn = bin.getCachedVLSN(i);
            if (!VLSN.isNull(vlsn)) {
                sb.append("\" vlsn=\"").append(vlsn);
            }
        }
        if (bin != null && bin.getExpiration(i) != 0) {
            sb.append("\" expires=\"");
            sb.append(TTL.formatExpiration(bin.getExpiration(i), bin.isExpirationInHours()));
        }
        sb.append("\"");
    }

    public String toSafeString(int ... slotIndexes) {
        BIN bin = this.isBIN() ? (BIN)this : null;
        StringBuilder sb = new StringBuilder();
        sb.append("IN nodeId=").append(this.getNodeId());
        sb.append(" lastLoggedLSN=");
        sb.append(DbLsn.getNoFormatString(this.getLastLoggedLsn()));
        sb.append(" lastFulLSN=");
        sb.append(DbLsn.getNoFormatString(this.getLastFullLsn()));
        sb.append(" level=").append(Integer.toHexString(this.getLevel()));
        sb.append(" flags=").append(Integer.toHexString(this.flags));
        sb.append(" isBINDelta=").append(this.isBINDelta());
        sb.append(" nSlots=").append(this.getNEntries());
        if (slotIndexes != null) {
            for (int i : slotIndexes) {
                sb.append(" slot-").append(i).append(":[");
                sb.append("lsn=");
                sb.append(DbLsn.getNoFormatString(this.getLsn(i)));
                sb.append(" offset=");
                sb.append(DbLsn.getFileOffset(this.getLsn(i)));
                if (bin != null) {
                    sb.append(" offset+logSize=");
                    sb.append(DbLsn.getFileOffset(this.getLsn(i)) + (long)bin.getLastLoggedSizeUnconditional(i));
                }
                this.dumpSlotState(sb, i, bin);
                sb.append("]");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.dumpString(0, true);
    }

    public String shortClassName() {
        return "IN";
    }

    private void traceSplit(Level level, IN parent, IN newSibling, long parentLsn, long myNewLsn, long newSiblingLsn, int splitIndex, int idKeyIndex, int childIndex) {
        Logger logger = this.getEnv().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_SPLIT);
            sb.append(" parent=");
            sb.append(parent.getNodeId());
            sb.append(" child=");
            sb.append(this.getNodeId());
            sb.append(" newSibling=");
            sb.append(newSibling.getNodeId());
            sb.append(" parentLsn = ");
            sb.append(DbLsn.getNoFormatString(parentLsn));
            sb.append(" childLsn = ");
            sb.append(DbLsn.getNoFormatString(myNewLsn));
            sb.append(" newSiblingLsn = ");
            sb.append(DbLsn.getNoFormatString(newSiblingLsn));
            sb.append(" splitIdx=");
            sb.append(splitIndex);
            sb.append(" idKeyIdx=");
            sb.append(idKeyIndex);
            sb.append(" childIdx=");
            sb.append(childIndex);
            LoggerUtils.logMsg(logger, this.databaseImpl.getEnv(), level, sb.toString());
        }
    }

    private void traceDelete(Level level, int index) {
        Logger logger = this.databaseImpl.getEnv().getLogger();
        if (logger.isLoggable(level)) {
            StringBuilder sb = new StringBuilder();
            sb.append(TRACE_DELETE);
            sb.append(" in=").append(this.getNodeId());
            sb.append(" index=");
            sb.append(index);
            LoggerUtils.logMsg(logger, this.databaseImpl.getEnv(), level, sb.toString());
        }
    }

    public final void setFetchINHook(TestHook hook) {
        this.fetchINHook = hook;
    }

    static {
        ACCUMULATED_LIMIT = 1000;
    }
}

