/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.util.Splitter;
import com.sleepycat.je.utilint.CmdUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbFilterStats {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbFilterStats.class) + "\n      [-f <projection file>]     # use file for projection list\n      [-p \"<list of columns>\"]   # use specified projection list\n      <stat file> [<stat file>]  # list of statistic file names";
    private static final String DELIMITER = ",";
    private File projectionFile = null;
    private String projectionArg = null;
    private final List<File> inputFiles = new ArrayList<File>();
    private final List<String> projList = new ArrayList<String>();
    private String header = null;
    private String[] fileColHeader = null;
    private final StringBuffer rowBuf = new StringBuffer();
    private final Map<String, String> valMap = new HashMap<String, String>();
    private final Splitter tokenizer = new Splitter(',');

    public static void main(String[] argv) {
        DbFilterStats dbf = new DbFilterStats();
        int retstatus = dbf.execute(argv) ? 0 : -1;
        System.exit(retstatus);
    }

    public boolean execute(String[] argv) {
        boolean retcode = true;
        if (argv.length == 0) {
            System.err.println(USAGE);
            return retcode;
        }
        try {
            DbFilterStats dbf = new DbFilterStats();
            dbf.parseArgs(argv);
            dbf.validateParams();
            dbf.processFiles();
        }
        catch (IllegalArgumentException e) {
            retcode = false;
        }
        return retcode;
    }

    private void processFiles() {
        for (File f : this.inputFiles) {
            this.processFile(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(File statFile) {
        BufferedReader fr = null;
        ArrayList<String> outProj = null;
        try {
            String row;
            fr = new BufferedReader(new FileReader(statFile));
            while ((row = fr.readLine()) != null) {
                String[] cols = this.parseRow(row, false);
                if (outProj == null) {
                    outProj = new ArrayList<String>();
                    HashMap<String, String> colNameMap = new HashMap<String, String>();
                    for (String cname : cols) {
                        colNameMap.put(cname, cname);
                    }
                    for (String projName : this.projList) {
                        if (colNameMap.get(projName) != null) {
                            outProj.add(projName);
                            continue;
                        }
                        for (String colName : cols) {
                            if (!colName.startsWith(projName)) continue;
                            outProj.add(colName);
                        }
                    }
                    if (this.header != null && this.header.equals(row)) continue;
                    this.outputRow(outProj);
                    this.header = row;
                    this.fileColHeader = cols;
                    continue;
                }
                if (cols.length != this.fileColHeader.length) {
                    this.printFatal("Invalid stat file " + statFile.getAbsolutePath() + " header/columns are not equal.");
                }
                this.valMap.clear();
                for (int i = 0; i < cols.length; ++i) {
                    this.valMap.put(this.fileColHeader[i], cols[i]);
                }
                this.rowBuf.setLength(0);
                for (String pname : outProj) {
                    String value;
                    if (this.rowBuf.length() != 0) {
                        this.rowBuf.append(DELIMITER);
                    }
                    if ((value = this.valMap.get(pname)) != null) {
                        this.rowBuf.append(value);
                        continue;
                    }
                    this.rowBuf.append(" ");
                }
                System.out.println(this.rowBuf.toString());
            }
        }
        catch (FileNotFoundException e) {
            this.printFatal("Error occured accessing stat file " + statFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.printFatal("IOException occured accessing stat file " + statFile.getAbsolutePath() + " exception " + e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void outputRow(List<String> cvals) {
        this.rowBuf.setLength(0);
        for (String val : cvals) {
            if (this.rowBuf.length() != 0) {
                this.rowBuf.append(DELIMITER);
            }
            this.rowBuf.append(val);
        }
        System.out.println(this.rowBuf.toString());
    }

    private void parseArgs(String[] argv) {
        int argc = 0;
        int nArgs = argv.length;
        this.inputFiles.clear();
        while (argc < nArgs) {
            String thisArg;
            if ((thisArg = argv[argc++]).equals("-f")) {
                if (argc < nArgs) {
                    this.projectionFile = new File(argv[argc++]);
                    continue;
                }
                this.printUsage("-f requires an argument");
                continue;
            }
            if (thisArg.equals("-p")) {
                if (argc < nArgs) {
                    this.projectionArg = argv[argc++];
                    continue;
                }
                this.printUsage("-p requires an argument");
                continue;
            }
            this.inputFiles.add(new File(thisArg));
        }
    }

    private void validateParams() {
        this.projList.clear();
        if (this.inputFiles.size() == 0) {
            this.printUsage("requires statistic file argument");
        }
        for (File f : this.inputFiles) {
            if (!f.exists()) {
                this.printFatal("Specified stat file " + f.getAbsolutePath() + " does not exist.");
            }
            if (!f.isDirectory()) continue;
            this.printFatal("Specified stat file " + f.getAbsolutePath() + " is not a file.");
        }
        if (this.projectionFile == null && this.projectionArg == null) {
            this.printUsage("requires either -p or -f argument");
        }
        if (this.projectionArg != null) {
            this.addProjections(this.projectionArg);
        }
        if (this.projectionFile != null) {
            if (!this.projectionFile.exists()) {
                this.printFatal("Specified projection file " + this.projectionFile.getAbsolutePath() + " does not exist.");
            }
            if (this.projectionFile.isDirectory()) {
                this.printFatal("Specified projection file " + this.projectionFile.getAbsolutePath() + " is not a file.");
            }
            this.formProjections(this.projectionFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formProjections(File projFile) {
        BufferedReader fr = null;
        try {
            fr = new BufferedReader(new FileReader(projFile));
            String row = fr.readLine();
            if (row == null) {
                this.printFatal("Invalid projection file " + projFile.getAbsolutePath());
            }
            this.addProjections(row);
        }
        catch (FileNotFoundException e) {
            this.printFatal("Error occured accessing projection file " + projFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.printFatal("IOException occured accessing projection file " + projFile.getAbsolutePath() + e);
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String[] parseRow(String row, boolean trimIt) {
        String[] vals = this.tokenizer.tokenize(row);
        if (trimIt) {
            for (int i = 0; i < vals.length; ++i) {
                vals[i] = vals[i].trim();
            }
        }
        return vals;
    }

    private void addProjections(String collist) {
        String[] names;
        for (String name : names = this.parseRow(collist, true)) {
            if (name.length() == 0) {
                this.printFatal("Projection list contained a empty entry.");
            }
            this.projList.add(name);
        }
    }

    private void printUsage(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        throw new IllegalArgumentException(msg);
    }

    private void printFatal(String msg) {
        System.err.println(msg);
        throw new IllegalArgumentException(msg);
    }
}

