/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.util;

import com.sleepycat.je.DbInternal;
import com.sleepycat.je.Environment;
import com.sleepycat.je.JEVersion;
import com.sleepycat.je.ThreadInterruptedException;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.log.entry.RestoreRequired;
import com.sleepycat.je.util.LogVerificationException;
import com.sleepycat.je.util.LogVerificationReadableByteChannel;
import com.sleepycat.je.util.verify.VerifierUtils;
import com.sleepycat.je.utilint.CmdUtil;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.PropUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class DbVerifyLog {
    private static final String USAGE = "usage: " + CmdUtil.getJavaCommand(DbVerifyLog.class) + "\n   [-h <dir>]       # environment home directory\n   [-s <file>]      # starting (minimum) file number\n   [-e <file>]      # ending (one past the maximum) file number\n   [-d <millis>]    # delay in ms between reads (default is zero)\n   [-V]             # print JE version number";
    private final EnvironmentImpl envImpl;
    private final int readBufferSize;
    private volatile boolean stopVerify = false;
    private long delayMs = 0L;

    public DbVerifyLog(Environment env) {
        this(env, 0);
    }

    public DbVerifyLog(Environment env, int readBufferSize) {
        this(DbInternal.getNonNullEnvImpl(env), readBufferSize);
    }

    public DbVerifyLog(EnvironmentImpl envImpl, int readBufferSize) {
        this.readBufferSize = readBufferSize > 0 ? readBufferSize : envImpl.getConfigManager().getInt(EnvironmentParams.LOG_ITERATOR_READ_SIZE);
        this.envImpl = envImpl;
    }

    public void verifyAll() throws LogVerificationException, IOException {
        if (this.stopVerify) {
            return;
        }
        LoggerUtils.envLogMsg(Level.INFO, this.envImpl, "Start verify of data files");
        this.verify(0L, Long.MAX_VALUE);
        LoggerUtils.envLogMsg(Level.INFO, this.envImpl, "End verify of data files");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void verify(long startFile, long endFile) throws LogVerificationException, IOException {
        block22: {
            try {
                fileManager = this.envImpl.getFileManager();
                homeDir = this.envImpl.getEnvironmentHome();
                fileNames = fileManager.listFileNames(startFile, endFile - 1L);
                buf = ByteBuffer.allocateDirect(this.readBufferSize);
                var9_8 = fileNames;
                var10_9 = var9_8.length;
                var11_10 = 0;
lbl9:
                // 2 sources

                while (true) {
                    if (var11_10 >= var10_9) return;
                    fileName = var9_8[var11_10];
                    if (this.stopVerify) {
                        return;
                    }
                    file = new File(homeDir, fileName);
                    try {
                        fis = new FileInputStream(file);
                    }
                    catch (FileNotFoundException fne) {
                        break block22;
                    }
                    fic = fis.getChannel();
                    vic = new LogVerificationReadableByteChannel(this.envImpl, (ReadableByteChannel)fic, fileName);
                    ioe = null;
                    ** try [egrp 2[TRYBLOCK] [4, 6 : 131->155)] { 
lbl24:
                    // 1 sources

                    break;
lbl25:
                    // 1 sources

                    catch (IOException e) {
                        ioe = e;
                        throw ioe;
                    }
                    break;
                }
            }
            catch (LogVerificationException lve) {
                VerifierUtils.createMarkerFileFromException(RestoreRequired.FailureType.LOG_CHECKSUM, lve, this.envImpl, EnvironmentFailureReason.LOG_CHECKSUM);
                throw lve;
            }
            while (vic.read(buf) != -1) {
                buf.clear();
                if (this.stopVerify) {
                    return;
                }
                if (this.delayMs <= 0L) continue;
                try {
                    Thread.sleep(this.delayMs);
                }
                catch (InterruptedException e) {
                    throw new ThreadInterruptedException(this.envImpl, (Throwable)e);
                }
            }
            break block22;
lbl45:
            // 1 sources

            finally {
                block24: {
                    try {
                        fis.close();
                        vic.close();
                    }
                    catch (IOException e) {
                        if (ioe != null) break block24;
                        throw e;
                    }
                }
            }
        }
        ++var11_10;
        ** while (true)
    }

    public static void main(String[] argv) {
        try {
            File envHome = new File(".");
            long startFile = 0L;
            long endFile = Long.MAX_VALUE;
            long delayMs = 0L;
            for (int whichArg = 0; whichArg < argv.length; ++whichArg) {
                String arg;
                int slashOff;
                String nextArg = argv[whichArg];
                if (nextArg.equals("-h")) {
                    envHome = new File(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-s")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    startFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-e")) {
                    if ((slashOff = (arg = CmdUtil.getArg(argv, ++whichArg)).indexOf("/")) >= 0) {
                        arg = arg.substring(0, slashOff);
                    }
                    endFile = CmdUtil.readLongNumber(arg);
                    continue;
                }
                if (nextArg.equals("-d")) {
                    delayMs = CmdUtil.readLongNumber(CmdUtil.getArg(argv, ++whichArg));
                    continue;
                }
                if (nextArg.equals("-V")) {
                    System.out.println(JEVersion.CURRENT_VERSION);
                    System.exit(0);
                    continue;
                }
                DbVerifyLog.printUsageAndExit("Unknown argument: " + nextArg);
            }
            EnvironmentImpl envImpl = CmdUtil.makeUtilityEnvironment(envHome, true);
            DbVerifyLog verifier = new DbVerifyLog(envImpl, 0);
            verifier.setReadDelay(delayMs, TimeUnit.MILLISECONDS);
            verifier.verify(startFile, endFile);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            DbVerifyLog.printUsageAndExit(e.toString());
        }
    }

    private static void printUsageAndExit(String msg) {
        if (msg != null) {
            System.err.println(msg);
        }
        System.err.println(USAGE);
        System.exit(1);
    }

    public void setReadDelay(long delay, TimeUnit unit) {
        this.delayMs = PropUtil.durationToMillis(delay, unit);
    }

    public void setStopVerifyFlag(boolean val) {
        this.stopVerify = val;
    }
}

