/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

import java.util.Iterator;
import java.util.SortedSet;

public class FormatUtil {
    public static String asHexString(SortedSet<Long> set) {
        long rstart;
        if (set.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator i = set.iterator();
        long rend = rstart = ((Long)i.next()).longValue();
        while (i.hasNext()) {
            long f = (Long)i.next();
            if (f == rend + 1L) {
                ++rend;
                continue;
            }
            FormatUtil.flushRange(sb, rstart, rend);
            rstart = rend = f;
        }
        FormatUtil.flushRange(sb, rstart, rend);
        return sb.toString();
    }

    private static void flushRange(StringBuilder sb, long rstart, long rend) {
        if (rstart == -1L) {
            return;
        }
        if (rstart == rend) {
            sb.append(" 0x").append(Long.toHexString(rstart));
        } else {
            sb.append(" 0x").append(Long.toHexString(rstart)).append("-").append("0x").append(Long.toHexString(rend));
        }
    }
}

