/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.model;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.Entity;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.KeyField;
import com.sleepycat.persist.model.NotPersistent;
import com.sleepycat.persist.model.NotTransient;
import com.sleepycat.persist.model.Persistent;
import com.sleepycat.persist.model.PrimaryKey;
import com.sleepycat.persist.model.PrimaryKeyMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKey;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnnotationModel
extends EntityModel {
    private Map<String, ClassMetadata> classMap = new HashMap<String, ClassMetadata>();
    private Map<String, EntityInfo> entityMap = new HashMap<String, EntityInfo>();
    private Set<String> registeredSpecialClasses = new HashSet<String>();

    @Override
    public synchronized Set<String> getKnownClasses() {
        return Collections.unmodifiableSet(new HashSet<String>(this.classMap.keySet()));
    }

    @Override
    public Set<String> getKnownSpecialClasses() {
        return Collections.unmodifiableSet(this.registeredSpecialClasses);
    }

    @Override
    public synchronized EntityMetadata getEntityMetadata(String className) {
        this.getClassMetadata(className);
        EntityInfo info = this.entityMap.get(className);
        if (info != null) {
            return new EntityMetadata(className, info.priKey, Collections.unmodifiableMap(info.secKeys));
        }
        return null;
    }

    @Override
    public synchronized ClassMetadata getClassMetadata(String className) {
        ClassMetadata metadata = this.classMap.get(className);
        if (metadata == null) {
            String proxiedClassName;
            int version;
            boolean isEntity;
            Class type;
            try {
                type = this.resolveClass(className);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            if (type.isEnum() || type.isArray()) {
                this.registeredSpecialClasses.add(className);
            }
            Entity entity = type.getAnnotation(Entity.class);
            Persistent persistent = type.getAnnotation(Persistent.class);
            if (entity == null && persistent == null) {
                return null;
            }
            if (type.isEnum() || type.isInterface() || type.isPrimitive()) {
                throw new IllegalArgumentException("@Entity and @Persistent not allowed for enum, interface, or primitive type: " + type.getName());
            }
            if (entity != null && persistent != null) {
                throw new IllegalArgumentException("Both @Entity and @Persistent are not allowed: " + type.getName());
            }
            if (entity != null) {
                isEntity = true;
                version = entity.version();
                proxiedClassName = null;
            } else {
                isEntity = false;
                version = persistent.version();
                Class proxiedClass = persistent.proxyFor();
                proxiedClassName = proxiedClass != Void.TYPE ? proxiedClass.getName() : null;
            }
            ArrayList<Field> fields = new ArrayList<Field>();
            boolean nonDefaultRules = this.getInstanceFields(fields, type);
            ArrayList<FieldMetadata> nonDefaultFields = null;
            if (nonDefaultRules) {
                nonDefaultFields = new ArrayList(fields.size());
                for (Field field2 : fields) {
                    nonDefaultFields.add(new FieldMetadata(field2.getName(), field2.getType().getName(), type.getName()));
                }
                nonDefaultFields = Collections.unmodifiableCollection(nonDefaultFields);
            }
            metadata = new ClassMetadata(className, version, proxiedClassName, isEntity, this.getPrimaryKey(type, fields), this.getSecondaryKeys(type, fields), this.getCompositeKeyFields(type, fields), nonDefaultFields);
            this.classMap.put(className, metadata);
            this.updateEntityInfo(metadata);
        }
        return metadata;
    }

    private boolean getInstanceFields(List<Field> fields, Class<?> type) {
        boolean nonDefaultRules = false;
        for (Field field2 : type.getDeclaredFields()) {
            int mods;
            boolean notTransient;
            boolean notPersistent = field2.getAnnotation(NotPersistent.class) != null;
            boolean bl = notTransient = field2.getAnnotation(NotTransient.class) != null;
            if (notPersistent && notTransient) {
                throw new IllegalArgumentException("Both @NotTransient and @NotPersistent not allowed");
            }
            if (notPersistent || notTransient) {
                nonDefaultRules = true;
            }
            if (!(Modifier.isStatic(mods = field2.getModifiers()) || notPersistent || Modifier.isTransient(mods) && !notTransient)) {
                fields.add(field2);
                continue;
            }
            if (field2.getAnnotation(PrimaryKey.class) == null && field2.getAnnotation(SecondaryKey.class) == null && field2.getAnnotation(KeyField.class) == null) continue;
            throw new IllegalArgumentException("@PrimaryKey, @SecondaryKey and @KeyField not allowed on non-persistent field");
        }
        return nonDefaultRules;
    }

    private PrimaryKeyMetadata getPrimaryKey(Class<?> type, List<Field> fields) {
        Field foundField = null;
        String sequence = null;
        for (Field field2 : fields) {
            PrimaryKey priKey = field2.getAnnotation(PrimaryKey.class);
            if (priKey == null) continue;
            if (foundField != null) {
                throw new IllegalArgumentException("Only one @PrimaryKey allowed: " + type.getName());
            }
            foundField = field2;
            sequence = priKey.sequence();
            if (sequence.length() != 0) continue;
            sequence = null;
        }
        if (foundField != null) {
            return new PrimaryKeyMetadata(foundField.getName(), foundField.getType().getName(), type.getName(), sequence);
        }
        return null;
    }

    private Map<String, SecondaryKeyMetadata> getSecondaryKeys(Class<?> type, List<Field> fields) {
        Map<String, SecondaryKeyMetadata> map = null;
        for (Field field2 : fields) {
            Class relatedClass;
            String keyName;
            SecondaryKey secKey = field2.getAnnotation(SecondaryKey.class);
            if (secKey == null) continue;
            Relationship rel = secKey.relate();
            String elemClassName = null;
            if (rel == Relationship.ONE_TO_MANY || rel == Relationship.MANY_TO_MANY) {
                elemClassName = this.getElementClass(field2);
            }
            if ((keyName = secKey.name()).length() == 0) {
                keyName = field2.getName();
            }
            String relatedEntity = (relatedClass = secKey.relatedEntity()) != Void.TYPE ? relatedClass.getName() : null;
            DeleteAction deleteAction = relatedEntity != null ? secKey.onRelatedEntityDelete() : null;
            SecondaryKeyMetadata metadata = new SecondaryKeyMetadata(field2.getName(), field2.getType().getName(), type.getName(), elemClassName, keyName, rel, relatedEntity, deleteAction);
            if (map == null) {
                map = new HashMap();
            }
            if (map.put(keyName, metadata) == null) continue;
            throw new IllegalArgumentException("Only one @SecondaryKey with the same name allowed: " + type.getName() + '.' + keyName);
        }
        if (map != null) {
            map = Collections.unmodifiableMap(map);
        }
        return map;
    }

    private String getElementClass(Field field2) {
        Class<?> cls = field2.getType();
        if (cls.isArray()) {
            return cls.getComponentType().getName();
        }
        if (Collection.class.isAssignableFrom(cls)) {
            Type[] typeArgs = null;
            if (field2.getGenericType() instanceof ParameterizedType) {
                typeArgs = ((ParameterizedType)field2.getGenericType()).getActualTypeArguments();
            }
            if (typeArgs == null || typeArgs.length != 1 || !(typeArgs[0] instanceof Class)) {
                throw new IllegalArgumentException("Collection typed secondary key field must have a single generic type argument and a wildcard or type bound is not allowed: " + field2.getDeclaringClass().getName() + '.' + field2.getName());
            }
            return ((Class)typeArgs[0]).getName();
        }
        throw new IllegalArgumentException("ONE_TO_MANY or MANY_TO_MANY secondary key field must have an array or Collection type: " + field2.getDeclaringClass().getName() + '.' + field2.getName());
    }

    private List<FieldMetadata> getCompositeKeyFields(Class<?> type, List<Field> fields) {
        List list = null;
        for (Field field2 : fields) {
            KeyField keyField = field2.getAnnotation(KeyField.class);
            if (keyField == null) continue;
            int value = keyField.value();
            if (value < 1 || value > fields.size()) {
                throw new IllegalArgumentException("Unreasonable @KeyField index value " + value + ": " + type.getName());
            }
            if (list == null) {
                list = new ArrayList(fields.size());
            }
            if (value <= list.size() && list.get(value - 1) != null) {
                throw new IllegalArgumentException("@KeyField index value " + value + " is used more than once: " + type.getName());
            }
            while (value > list.size()) {
                list.add(null);
            }
            FieldMetadata metadata = new FieldMetadata(field2.getName(), field2.getType().getName(), type.getName());
            list.set(value - 1, metadata);
        }
        if (list != null) {
            if (list.size() < fields.size()) {
                throw new IllegalArgumentException("@KeyField is missing on one or more instance fields: " + type.getName());
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) != null) continue;
                throw new IllegalArgumentException("@KeyField is missing for index value " + (i + 1) + ": " + type.getName());
            }
        }
        if (list != null) {
            list = Collections.unmodifiableList(list);
        }
        return list;
    }

    private void updateEntityInfo(ClassMetadata metadata) {
        String entityClass = null;
        PrimaryKeyMetadata priKey = null;
        HashMap<String, SecondaryKeyMetadata> secKeys = new HashMap<String, SecondaryKeyMetadata>();
        ClassMetadata data = metadata;
        while (data != null) {
            Class cls;
            Map<String, SecondaryKeyMetadata> classSecKeys;
            if (data.isEntityClass()) {
                if (entityClass != null) {
                    throw new IllegalArgumentException("An entity class may not be derived from another entity class: " + entityClass + ' ' + data.getClassName());
                }
                entityClass = data.getClassName();
            }
            if (priKey == null) {
                priKey = data.getPrimaryKey();
            }
            if ((classSecKeys = data.getSecondaryKeys()) != null) {
                for (SecondaryKeyMetadata secKey : classSecKeys.values()) {
                    secKeys.put(secKey.getKeyName(), secKey);
                }
            }
            try {
                cls = this.resolveClass(data.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw DbCompat.unexpectedException(e);
            }
            cls = cls.getSuperclass();
            if (cls != Object.class) {
                data = this.getClassMetadata(cls.getName());
                if (data != null) continue;
                throw new IllegalArgumentException("Persistent class has non-persistent superclass: " + cls.getName());
            }
            data = null;
        }
        if (entityClass != null) {
            EntityInfo info = this.entityMap.get(entityClass);
            if (info == null) {
                info = new EntityInfo();
                this.entityMap.put(entityClass, info);
            }
            if (priKey == null) {
                throw new IllegalArgumentException("Entity class has no primary key: " + entityClass);
            }
            info.priKey = priKey;
            info.secKeys.putAll(secKeys);
        }
    }

    private static class EntityInfo {
        PrimaryKeyMetadata priKey;
        Map<String, SecondaryKeyMetadata> secKeys = new HashMap<String, SecondaryKeyMetadata>();

        private EntityInfo() {
        }
    }
}

