/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.asyncfile;

import de.sciss.asyncfile.AsyncFileSystem;
import de.sciss.asyncfile.AsyncFileSystemProvider;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.asyncfile.DesktopFile;
import de.sciss.asyncfile.DesktopFile$;
import de.sciss.asyncfile.DesktopFileSystemProvider$;
import de.sciss.asyncfile.DesktopWritableFile;
import de.sciss.asyncfile.FileInfo;
import de.sciss.asyncfile.FileNotFoundException;
import de.sciss.asyncfile.Watch;
import de.sciss.asyncfile.impl.WatcherImpl$;
import de.sciss.model.Model;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015d\u0001B\n\u0015\u0005mA\u0001\u0002\t\u0001\u0003\u0006\u0004%\u0019!\t\u0005\tU\u0001\u0011\t\u0011)A\u0005E!)1\u0006\u0001C\u0001Y!)\u0001\u0007\u0001C!c!)Q\u0007\u0001C!m!)!\t\u0001C!m!)1\t\u0001C!\t\")\u0011\n\u0001C!\u0015\")1\f\u0001C!9\"9q\rAI\u0001\n\u0003A\u0007\"B:\u0001\t\u0003\"\b\"B<\u0001\t\u0003B\b\"\u0002>\u0001\t\u0003Z\b\"B?\u0001\t\u0003r\bbBA\u0005\u0001\u0011\u0005\u00131\u0002\u0005\b\u0003C\u0001A\u0011IA\u0012\u0011\u001d\t)\u0005\u0001C!\u0003\u000fBq!!\u0016\u0001\t\u0013\t9FA\tEKN\\Go\u001c9GS2,7+_:uK6T!!\u0006\f\u0002\u0013\u0005\u001c\u0018P\\2gS2,'BA\f\u0019\u0003\u0015\u00198-[:t\u0015\u0005I\u0012A\u00013f\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uqR\"\u0001\u000b\n\u0005}!\"aD!ts:\u001cg)\u001b7f'f\u001cH/Z7\u0002!\u0015DXmY;uS>t7i\u001c8uKb$X#\u0001\u0012\u0011\u0005\rBS\"\u0001\u0013\u000b\u0005\u00152\u0013AC2p]\u000e,(O]3oi*\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*I\t\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0012Kb,7-\u001e;j_:\u001cuN\u001c;fqR\u0004\u0013A\u0002\u001fj]&$h\bF\u0001.)\tqs\u0006\u0005\u0002\u001e\u0001!)\u0001e\u0001a\u0002E\u0005A\u0001O]8wS\u0012,'/F\u00013!\ti2'\u0003\u00025)\t9\u0012i]=oG\u001aKG.Z*zgR,W\u000e\u0015:pm&$WM]\u0001\u0007g\u000eDW-\\3\u0016\u0003]\u0002\"\u0001O \u000f\u0005ej\u0004C\u0001\u001e'\u001b\u0005Y$B\u0001\u001f\u001b\u0003\u0019a$o\\8u}%\u0011aHJ\u0001\u0007!J,G-\u001a4\n\u0005\u0001\u000b%AB*ue&twM\u0003\u0002?M\u0005!a.Y7f\u0003\u001d\u0011X\r\\3bg\u0016$\u0012!\u0012\t\u0003\r\u001ek\u0011AJ\u0005\u0003\u0011\u001a\u0012A!\u00168ji\u0006Aq\u000e]3o%\u0016\fG\r\u0006\u0002L#B\u00191\u0005\u0014(\n\u00055##A\u0002$viV\u0014X\r\u0005\u0002\u001e\u001f&\u0011\u0001\u000b\u0006\u0002\u0019\u0003NLhn\u0019*fC\u0012\f'\r\\3CsR,7\t[1o]\u0016d\u0007\"\u0002*\t\u0001\u0004\u0019\u0016aA;sSB\u0011A+W\u0007\u0002+*\u0011akV\u0001\u0004]\u0016$(\"\u0001-\u0002\t)\fg/Y\u0005\u00035V\u00131!\u0016*J\u0003%y\u0007/\u001a8Xe&$X\rF\u0002^C\n\u00042a\t'_!\tir,\u0003\u0002a)\tA\u0012i]=oG^\u0013\u0018\u000e^1cY\u0016\u0014\u0015\u0010^3DQ\u0006tg.\u001a7\t\u000bIK\u0001\u0019A*\t\u000f\rL\u0001\u0013!a\u0001I\u00061\u0011\r\u001d9f]\u0012\u0004\"AR3\n\u0005\u00194#a\u0002\"p_2,\u0017M\\\u0001\u0014_B,gn\u0016:ji\u0016$C-\u001a4bk2$HEM\u000b\u0002S*\u0012AM[\u0016\u0002WB\u0011A.]\u0007\u0002[*\u0011an\\\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u001d\u0014\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u000b5\\G)\u001b:\u0015\u0005U4\bcA\u0012M\u000b\")!k\u0003a\u0001'\u00061Qn\u001b#jeN$\"!^=\t\u000bIc\u0001\u0019A*\u0002\r\u0011,G.\u001a;f)\t)H\u0010C\u0003S\u001b\u0001\u00071+\u0001\u0003j]\u001a|GcA@\u0002\bA!1\u0005TA\u0001!\ri\u00121A\u0005\u0004\u0003\u000b!\"\u0001\u0003$jY\u0016LeNZ8\t\u000bIs\u0001\u0019A*\u0002\u000f1L7\u000f\u001e#jeR!\u0011QBA\u0010!\u0011\u0019C*a\u0004\u0011\u000b\u0005E\u00111D*\u000e\u0005\u0005M!\u0002BA\u000b\u0003/\t\u0011\"[7nkR\f'\r\\3\u000b\u0007\u0005ea%\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0014\t\u00191+Z9\t\u000bI{\u0001\u0019A*\u0002\u0013]\fGo\u00195GS2,GCBA\u0013\u0003\u007f\t\t\u0005\u0005\u0004\u0002(\u00055\u0012\u0011G\u0007\u0003\u0003SQ1!a\u000b\u0017\u0003\u0015iw\u000eZ3m\u0013\u0011\ty#!\u000b\u0003\u000b5{G-\u001a7\u0011\t\u0005M\u0012\u0011\b\b\u0004;\u0005U\u0012bAA\u001c)\u0005)q+\u0019;dQ&!\u00111HA\u001f\u0005\u00111\u0015\u000e\\3\u000b\u0007\u0005]B\u0003C\u0003S!\u0001\u00071\u000b\u0003\u0005\u0002DA\u0001\n\u00111\u0001e\u0003\u0019iw\u000eZ5gs\u0006Aq/\u0019;dQ\u0012K'\u000f\u0006\u0004\u0002J\u0005E\u00131\u000b\t\u0007\u0003O\ti#a\u0013\u0011\t\u0005M\u0012QJ\u0005\u0005\u0003\u001f\niD\u0001\u0003CCN,\u0007\"\u0002*\u0012\u0001\u0004\u0019\u0006\u0002CA\"#A\u0005\t\u0019\u00013\u0002\u000f\u001d,GOR5mKR!\u0011\u0011LA2!\u0011\tY&!\u0019\u000e\u0005\u0005u#bAA0/\u0006\u0011\u0011n\\\u0005\u0005\u0003w\ti\u0006C\u0003S%\u0001\u00071\u000b")
public final class DesktopFileSystem
extends AsyncFileSystem {
    private final ExecutionContext executionContext;

    @Override
    public ExecutionContext executionContext() {
        return this.executionContext;
    }

    @Override
    public AsyncFileSystemProvider provider() {
        return DesktopFileSystemProvider$.MODULE$;
    }

    @Override
    public String scheme() {
        return this.provider().scheme();
    }

    @Override
    public String name() {
        return this.provider().name();
    }

    @Override
    public void release() {
    }

    @Override
    public Future<AsyncReadableByteChannel> openRead(URI uri) {
        Future<AsyncReadableByteChannel> future;
        File f = this.getFile(uri);
        Try tr = Try$.MODULE$.apply((Function0<DesktopFile> & Serializable)() -> DesktopFile$.MODULE$.openRead(f, this));
        Try try_ = tr;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DesktopFile ch = (DesktopFile)success.value();
            future = Future$.MODULE$.successful(ch);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            future = Future$.MODULE$.failed(ex);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    @Override
    public Future<AsyncWritableByteChannel> openWrite(URI uri, boolean append) {
        Future<AsyncWritableByteChannel> future;
        File f = this.getFile(uri);
        Try tr = Try$.MODULE$.apply((Function0<DesktopWritableFile> & Serializable)() -> DesktopFile$.MODULE$.openWrite(f, append, this));
        Try try_ = tr;
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            DesktopWritableFile ch = (DesktopWritableFile)success.value();
            future = Future$.MODULE$.successful(ch);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable ex = failure.exception();
            future = Future$.MODULE$.failed(ex);
        } else {
            throw new MatchError(try_);
        }
        return future;
    }

    @Override
    public boolean openWrite$default$2() {
        return false;
    }

    @Override
    public Future<BoxedUnit> mkDir(URI uri) {
        File f = this.getFile(uri);
        boolean res = f.mkdir();
        return res ? Future$.MODULE$.unit() : Future$.MODULE$.failed(new IOException(new StringBuilder(27).append("Could not create directory ").append(uri).toString()));
    }

    @Override
    public Future<BoxedUnit> mkDirs(URI uri) {
        File f = this.getFile(uri);
        boolean res = f.mkdirs();
        return res ? Future$.MODULE$.unit() : Future$.MODULE$.failed(new IOException(new StringBuilder(29).append("Could not create directories ").append(uri).toString()));
    }

    @Override
    public Future<BoxedUnit> delete(URI uri) {
        File f = this.getFile(uri);
        boolean res = f.delete();
        return res ? Future$.MODULE$.unit() : Future$.MODULE$.failed(new IOException(new StringBuilder(22).append("Could not delete file ").append(uri).toString()));
    }

    @Override
    public Future<FileInfo> info(URI uri) {
        Future<FileInfo> future;
        File f = this.getFile(uri);
        if (f.exists()) {
            int flags = 0;
            if (f.isFile()) {
                flags |= 1;
            }
            if (f.isDirectory()) {
                flags |= 2;
            }
            if (f.isHidden()) {
                flags |= 4;
            }
            if (f.canRead()) {
                flags |= 8;
            }
            if (f.canWrite()) {
                flags |= 0x10;
            }
            if (f.canExecute()) {
                flags |= 0x20;
            }
            FileInfo info = new FileInfo(uri, flags, f.lastModified(), f.length());
            future = Future$.MODULE$.successful(info);
        } else {
            future = Future$.MODULE$.failed(new FileNotFoundException(uri));
        }
        return future;
    }

    @Override
    public Future<Seq<URI>> listDir(URI uri) {
        File f = this.getFile(uri);
        File[] arr = f.listFiles();
        Vector res = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps(arr)).map((Function1<File, URI> & Serializable)x$1 -> x$1.toURI()).toVector();
        return Future$.MODULE$.successful(res);
    }

    @Override
    public Model<Watch.File> watchFile(URI uri, boolean modify) {
        return WatcherImpl$.MODULE$.fileModel(uri, modify);
    }

    @Override
    public Model<Watch.Base> watchDir(URI uri, boolean modify) {
        return WatcherImpl$.MODULE$.dirModel(uri, modify);
    }

    private File getFile(URI uri) {
        return new File(uri);
    }

    public DesktopFileSystem(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

