/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.asyncfile.impl;

import de.sciss.asyncfile.DesktopFileSystem;
import de.sciss.asyncfile.DesktopWritableFile;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001B\r\u001b\u0005\rB\u0001b\u0012\u0001\u0003\u0006\u0004%\t\u0001\u0013\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u0013\"AQ\n\u0001B\u0001B\u0003%a\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!A\u0006A!A!\u0002\u0013I\u0006\"\u0002/\u0001\t\u0003i\u0006B\u00023\u0001A\u0003%Q\r\u0003\u0004i\u0001\u0001\u0006K!\u001b\u0005\u0007Y\u0002\u0001\u000b\u0015\u0002#\t\r5\u0004\u0001\u0015)\u0003E\u0011!q\u0007\u0001#b!\n\u0013y\u0007\"\u0002;\u0001\t\u0003)\b\"\u0002<\u0001\t\u00039\b\"\u0002>\u0001\t\u0003Y\b\"\u0002@\u0001\t\u0013y\bbBA\u0001\u0001\u0011\u0005\u00111\u0001\u0005\b\u0003/\u0001A\u0011AA\r\u0011\u0019\ty\u0002\u0001C\u0001k\"1\u0011\u0011\u0005\u0001\u0005\u0002UDq!a\t\u0001\t\u0003\t)\u0003C\u0004\u0002*\u0001!\t!a\u000b\t\r\u00055\u0002\u0001\"\u0003\u0000\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\u000f\u0001\t\u0003\tiDA\bEKN\\Go\u001c9GS2,\u0017*\u001c9m\u0015\tYB$\u0001\u0003j[Bd'BA\u000f\u001f\u0003%\t7/\u001f8dM&dWM\u0003\u0002 A\u0005)1oY5tg*\t\u0011%\u0001\u0002eK\u000e\u00011\u0003\u0002\u0001%U9\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016-\u001b\u0005a\u0012BA\u0017\u001d\u0005M!Um]6u_B<&/\u001b;bE2,g)\u001b7f!\u0011yc\u0007\u000f \u000e\u0003AR!!\r\u001a\u0002\u0011\rD\u0017M\u001c8fYNT!a\r\u001b\u0002\u00079LwNC\u00016\u0003\u0011Q\u0017M^1\n\u0005]\u0002$!E\"p[BdW\r^5p]\"\u000bg\u000e\u001a7feB\u0011\u0011\bP\u0007\u0002u)\u00111\bN\u0001\u0005Y\u0006tw-\u0003\u0002>u\t9\u0011J\u001c;fO\u0016\u0014\bcA C\t6\t\u0001I\u0003\u0002BM\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\r\u0003%a\u0002)s_6L7/\u001a\t\u0003K\u0015K!A\u0012\u0014\u0003\u0007%sG/\u0001\u0006gS2,7+_:uK6,\u0012!\u0013\t\u0003W)K!a\u0013\u000f\u0003#\u0011+7o\u001b;pa\u001aKG.Z*zgR,W.A\u0006gS2,7+_:uK6\u0004\u0013\u0001\u00029fKJ\u0004\"aL(\n\u0005A\u0003$aF!ts:\u001c\u0007N]8o_V\u001ch)\u001b7f\u0007\"\fgN\\3m\u0003\u00051\u0007CA*W\u001b\u0005!&BA+5\u0003\tIw.\u0003\u0002X)\n!a)\u001b7f\u0003!\u0011X-\u00193P]2L\bCA\u0013[\u0013\tYfEA\u0004C_>dW-\u00198\u0002\rqJg.\u001b;?)\u0015q\u0006-\u00192d!\ty\u0006!D\u0001\u001b\u0011\u00159e\u00011\u0001J\u0011\u0015ie\u00011\u0001O\u0011\u0015\tf\u00011\u0001S\u0011\u0015Af\u00011\u0001Z\u0003\u0011\u0019\u0018P\\2\u0011\u0005e2\u0017BA4;\u0005\u0019y%M[3di\u0006Iq\f]8tSRLwN\u001c\t\u0003K)L!a\u001b\u0014\u0003\t1{gnZ\u0001\u0007?N$\u0018\r^3\u0002\u0019}#\u0018M]4fiN#\u0018\r^3\u0002\u0013}\u001bGn\\:fIB\u0013X#\u00019\u0011\u0007}\u0012\u0015\u000f\u0005\u0002&e&\u00111O\n\u0002\u0005+:LG/\u0001\u0005q_NLG/[8o+\u0005I\u0017\u0001\u00049pg&$\u0018n\u001c8`I\u0015\fHCA9y\u0011\u0015IX\u00021\u0001j\u0003\u00151\u0018\r\\;f\u0003\u0011\u00198.\u001b9\u0015\u0005Ed\b\"B?\u000f\u0001\u0004I\u0017a\u00017f]\u0006Q1\r[3dWN#\u0018\r^3\u0015\u0003E\fAA]3bIR!\u0011QAA\u0006!\u0011y\u0014q\u0001#\n\u0007\u0005%\u0001I\u0001\u0004GkR,(/\u001a\u0005\b\u0003\u001b\u0001\u0002\u0019AA\b\u0003\r!7\u000f\u001e\t\u0005\u0003#\t\u0019\"D\u00013\u0013\r\t)B\r\u0002\u000b\u0005f$XMQ;gM\u0016\u0014\u0018!B<sSR,G\u0003BA\u0003\u00037Aq!!\b\u0012\u0001\u0004\ty!A\u0002te\u000e\fAa]5{K\u0006I!/Z7bS:LgnZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0003O\u0001BaPA\u0004c\u00061\u0011n](qK:,\u0012!W\u0001\u000ee\u0016\f7\r[3e)\u0006\u0014x-\u001a;\u0002\u0013\r|W\u000e\u001d7fi\u0016$G#B9\u00024\u0005]\u0002BBA\u001b/\u0001\u0007\u0001(A\u0002sKNDa!!\u000f\u0018\u0001\u0004q\u0014A\u00019s\u0003\u00191\u0017-\u001b7fIR)\u0011/a\u0010\u0002\\!9\u0011\u0011\t\rA\u0002\u0005\r\u0013!A3\u0011\t\u0005\u0015\u0013Q\u000b\b\u0005\u0003\u000f\n\tF\u0004\u0003\u0002J\u0005=SBAA&\u0015\r\tiEI\u0001\u0007yI|w\u000e\u001e \n\u0003\u001dJ1!a\u0015'\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0016\u0002Z\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003'2\u0003BBA\u001d1\u0001\u0007a\b")
public final class DesktopFileImpl
implements DesktopWritableFile,
CompletionHandler<Integer, Promise<Object>> {
    private Promise<BoxedUnit> _closedPr;
    private final DesktopFileSystem fileSystem;
    private final AsynchronousFileChannel peer;
    private final File f;
    private final boolean readOnly;
    private final Object sync;
    private long _position;
    private int _state;
    private int _targetState;
    private volatile boolean bitmap$0;

    @Override
    public DesktopFileSystem fileSystem() {
        return this.fileSystem;
    }

    private Promise<BoxedUnit> _closedPr$lzycompute() {
        DesktopFileImpl desktopFileImpl = this;
        synchronized (desktopFileImpl) {
            if (!this.bitmap$0) {
                this._closedPr = Promise$.MODULE$.apply();
                this.bitmap$0 = true;
            }
        }
        return this._closedPr;
    }

    private Promise<BoxedUnit> _closedPr() {
        return !this.bitmap$0 ? this._closedPr$lzycompute() : this._closedPr;
    }

    @Override
    public long position() {
        long l2;
        Object object = this.sync;
        synchronized (object) {
            l2 = this._position;
        }
        return l2;
    }

    @Override
    public void position_$eq(long value) {
        Object object = this.sync;
        synchronized (object) {
            this._position = value;
        }
    }

    @Override
    public void skip(long len) {
        Object object = this.sync;
        synchronized (object) {
            this._position += len;
        }
    }

    private void checkState() {
        int n = this._state;
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                throw new ReadPendingException();
            }
            case 2: {
                throw new WritePendingException();
            }
            case 3: {
                throw new ClosedChannelException();
            }
            default: {
                throw new MatchError(BoxesRunTime.boxToInteger(n));
            }
        }
    }

    @Override
    public Future<Object> read(ByteBuffer dst) {
        Future<Object> future;
        Object object = this.sync;
        synchronized (object) {
            this.checkState();
            this._state = 1;
            Promise pr = Promise$.MODULE$.apply();
            this.peer.read(dst, this._position, pr, this);
            future = pr.future();
        }
        return future;
    }

    @Override
    public Future<Object> write(ByteBuffer src) {
        Future<Object> future;
        if (this.readOnly) {
            throw new IOException(new StringBuilder(33).append("File ").append(this.f).append(" was opened for reading only").toString());
        }
        Object object = this.sync;
        synchronized (object) {
            this.checkState();
            this._state = 2;
            Promise pr = Promise$.MODULE$.apply();
            this.peer.write(src, this._position, pr, this);
            future = pr.future();
        }
        return future;
    }

    @Override
    public long size() {
        long l2;
        Object object = this.sync;
        synchronized (object) {
            l2 = this.peer.size();
        }
        return l2;
    }

    @Override
    public long remaining() {
        long l2;
        Object object = this.sync;
        synchronized (object) {
            l2 = this.size() - this.position();
        }
        return l2;
    }

    @Override
    public Future<BoxedUnit> close() {
        Future<BoxedUnit> future;
        Object object = this.sync;
        synchronized (object) {
            Future<BoxedUnit> future2;
            int n = this._state;
            switch (n) {
                case 0: {
                    this._state = 3;
                    future2 = this.liftedTree1$1();
                    break;
                }
                case 1: 
                case 2: {
                    this._targetState = 3;
                    future2 = this._closedPr().future();
                    break;
                }
                case 3: {
                    future2 = Future$.MODULE$.unit();
                    break;
                }
                default: {
                    throw new MatchError(BoxesRunTime.boxToInteger(n));
                }
            }
            future = future2;
        }
        return future;
    }

    @Override
    public boolean isOpen() {
        boolean bl;
        Object object = this.sync;
        synchronized (object) {
            bl = this._state != 3 && this._targetState != 3;
        }
        return bl;
    }

    private void reachedTarget() {
        this._state = this._targetState;
        if (this._state == 3) {
            try {
                this.peer.close();
                this._closedPr().success(BoxedUnit.UNIT);
            }
            catch (Throwable throwable) {
                Option<Throwable> option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable ex = option.get();
                    this._closedPr().failure(ex);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
    }

    @Override
    public void completed(Integer res, Promise<Object> pr) {
        Object object = this.sync;
        synchronized (object) {
            this._position += (long)Predef$.MODULE$.Integer2int(res);
            this.liftedTree2$1(pr, res);
        }
    }

    @Override
    public void failed(Throwable e, Promise<Object> pr) {
        Object object = this.sync;
        synchronized (object) {
            try {
                this.reachedTarget();
            }
            finally {
                pr.failure(e);
            }
        }
    }

    private final /* synthetic */ Future liftedTree1$1() {
        Future<BoxedUnit> future;
        try {
            this.peer.close();
            future = Future$.MODULE$.unit();
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            Throwable ex = option.get();
            Future future2 = Future$.MODULE$.failed(ex);
            future = future2;
        }
        return future;
    }

    private final /* synthetic */ void liftedTree2$1(Promise pr$1, Integer res$1) {
        try {
            this.reachedTarget();
            pr$1.success(BoxesRunTime.boxToInteger(Predef$.MODULE$.Integer2int(res$1)));
        }
        catch (Throwable throwable) {
            Option<Throwable> option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable ex = option.get();
                pr$1.failure(ex);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public DesktopFileImpl(DesktopFileSystem fileSystem, AsynchronousFileChannel peer, File f, boolean readOnly) {
        this.fileSystem = fileSystem;
        this.peer = peer;
        this.f = f;
        this.readOnly = readOnly;
        this.sync = new Object();
        this._position = 0L;
        this._state = 0;
        this._targetState = 0;
    }
}

