/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile;

import de.sciss.asyncfile.AsyncFile$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncAudioFile;
import de.sciss.audiofile.AsyncBufferBidi;
import de.sciss.audiofile.AsyncBufferBidiFactory;
import de.sciss.audiofile.AsyncBufferReader;
import de.sciss.audiofile.AsyncBufferReaderFactory;
import de.sciss.audiofile.AsyncBufferWriter;
import de.sciss.audiofile.AsyncBufferWriterFactory;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFile;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFilePlatform;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$;
import de.sciss.audiofile.BufferReader;
import de.sciss.audiofile.BufferReaderFactory;
import de.sciss.audiofile.BufferWriter;
import de.sciss.audiofile.BufferWriterFactory;
import de.sciss.audiofile.ReaderFactory;
import de.sciss.audiofile.ReaderFactoryPlatform;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.log.Logger;
import de.sciss.log.Logger$;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Try;

public final class AudioFile$
implements ReaderFactory,
AudioFilePlatform {
    public static final AudioFile$ MODULE$ = new AudioFile$();
    private static boolean _useDirect;
    private static final String KEY_DIRECT_MEMORY;
    private static final Logger log;
    private static volatile boolean bitmap$0;

    static {
        ReaderFactoryPlatform.$init$(MODULE$);
        AudioFilePlatform.$init$(MODULE$);
        KEY_DIRECT_MEMORY = "AudioFile.DirectMemory";
        log = new Logger("AudioFile", Logger$.MODULE$.$lessinit$greater$default$2(), Logger$.MODULE$.$lessinit$greater$default$3(), Logger$.MODULE$.$lessinit$greater$default$4());
    }

    @Override
    public AudioFile openRead(File f) throws IOException {
        return AudioFilePlatform.openRead$(this, f);
    }

    @Override
    public AudioFile openWrite(File f, AudioFileSpec spec) throws IOException {
        return AudioFilePlatform.openWrite$((AudioFilePlatform)this, f, spec);
    }

    @Override
    public AudioFile openWrite(String path, AudioFileSpec spec) throws IOException {
        return AudioFilePlatform.openWrite$((AudioFilePlatform)this, path, spec);
    }

    @Override
    public AudioFileSpec readSpec(File f) throws IOException {
        return AudioFilePlatform.readSpec$((AudioFilePlatform)this, f);
    }

    @Override
    public AudioFileSpec readSpec(String path) throws IOException {
        return AudioFilePlatform.readSpec$((AudioFilePlatform)this, path);
    }

    @Override
    public Option<AudioFileType.CanIdentify> identify(File f) throws IOException {
        return AudioFilePlatform.identify$((AudioFilePlatform)this, f);
    }

    @Override
    public Option<AudioFileType> identify(String path) throws IOException {
        return AudioFilePlatform.identify$((AudioFilePlatform)this, path);
    }

    @Override
    public AudioFile openFileWithReader(File f, AudioFileType.CanRead reader) {
        return AudioFilePlatform.openFileWithReader$(this, f, reader);
    }

    @Override
    public final AudioFile openRead(String path) throws IOException {
        return ReaderFactoryPlatform.openRead$(this, path);
    }

    @Override
    public AudioFile openRead(InputStream is) throws IOException {
        DataInputStream dis = this.dataInput(is);
        AudioFileType.CanRead hr = this.createHeaderReader(dis);
        return this.finishOpenStreamRead(dis, hr);
    }

    public AudioFile openWrite(OutputStream os, AudioFileSpec spec) throws IOException {
        AudioFileType.CanWrite hw = this.createHeaderWriter(spec);
        DataOutputStream dos = this.dataOutput(os);
        WritableAudioFileHeader afh = hw.write(dos, spec);
        ByteBuffer buf2 = this.createBuffer(afh);
        SampleFormat sf = spec.sampleFormat();
        BufferWriter bw = (BufferWriter)sf.writerFactory().map((Function1<BufferWriterFactory, BufferWriter> & Serializable)x$1 -> x$1.apply(Channels.newChannel(dos), buf2, spec.numChannels())).getOrElse((Function0<Nothing$> & Serializable)() -> MODULE$.noEncoder(sf));
        return new AudioFile.WritableStreamImpl(dos, afh, bw);
    }

    public AudioFileSpec readSpec(DataInputStream dis) throws IOException {
        AudioFileType.CanRead hr = this.createHeaderReader(dis);
        return hr.read(dis).spec();
    }

    public Option<AudioFileType.CanIdentify> identify(DataInputStream dis) throws IOException {
        return AudioFileType$.MODULE$.known().find((Function1<AudioFileType.CanIdentify, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(AudioFile$.$anonfun$identify$1(dis, f)));
    }

    public Future<AsyncAudioFile> openReadAsync(URI uri, ExecutionContext executionContext) throws IOException {
        return AsyncFile$.MODULE$.openRead(uri, executionContext).flatMap((Function1<AsyncReadableByteChannel, Future> & Serializable)ch -> MODULE$.createHeaderReaderAsync((AsyncReadableByteChannel)ch, executionContext).flatMap((Function1<AudioFileType.CanRead, Future> & Serializable)hr -> MODULE$.finishOpenStreamReadAsync((Option<URI>)new Some<URI>(uri), (AsyncReadableByteChannel)ch, (AudioFileType.CanRead)hr, executionContext).map((Function1<AsyncAudioFile, AsyncAudioFile> & Serializable)aaf -> aaf, executionContext), executionContext), executionContext);
    }

    public Future<AsyncAudioFile> openReadAsync(AsyncReadableByteChannel ch, ExecutionContext ec) throws IOException {
        return this.createHeaderReaderAsync(ch, ec).flatMap((Function1<AudioFileType.CanRead, Future> & Serializable)hr -> MODULE$.finishOpenStreamReadAsync(None$.MODULE$, ch, (AudioFileType.CanRead)hr, ec).map((Function1<AsyncAudioFile, AsyncAudioFile> & Serializable)aaf -> aaf, ec), ec);
    }

    public Future<AsyncAudioFile> openWriteAsync(URI uri, AudioFileSpec spec, ExecutionContext executionContext) throws IOException {
        return AsyncFile$.MODULE$.openWrite(uri, executionContext).flatMap((Function1<AsyncWritableByteChannel, Future> & Serializable)ch -> MODULE$.finishOpenStreamWriteAsync((Option<URI>)new Some<URI>(uri), (AsyncWritableByteChannel)ch, spec, executionContext).map((Function1<AsyncAudioFile, AsyncAudioFile> & Serializable)aaf -> aaf, executionContext), executionContext);
    }

    public Future<AsyncAudioFile> openWriteAsync(AsyncWritableByteChannel ch, AudioFileSpec spec, ExecutionContext ec) throws IOException {
        return this.finishOpenStreamWriteAsync(None$.MODULE$, ch, spec, ec);
    }

    public Future<AudioFileSpec> readSpecAsync(URI uri, ExecutionContext executionContext) throws IOException {
        Future<AsyncReadableByteChannel> futChan = AsyncFile$.MODULE$.openRead(uri, executionContext);
        return futChan.flatMap((Function1<AsyncReadableByteChannel, Future> & Serializable)ch -> {
            Future<AudioFileType.CanRead> futHR = MODULE$.createHeaderReaderAsync((AsyncReadableByteChannel)ch, executionContext);
            Future futAFH = futHR.flatMap((Function1<AudioFileType.CanRead, Future> & Serializable)x$2 -> x$2.readAsync((AsyncReadableByteChannel)ch), executionContext);
            Future futSpec = futAFH.map((Function1<AudioFileHeader, AudioFileSpec> & Serializable)x$3 -> x$3.spec(), executionContext);
            return futSpec.andThen(new Serializable((AsyncReadableByteChannel)ch){
                private static final long serialVersionUID = 0L;
                private final AsyncReadableByteChannel ch$3;

                public final <A1 extends Try<AudioFileSpec>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    return (B1)this.ch$3.close();
                }

                public final boolean isDefinedAt(Try<AudioFileSpec> x1) {
                    Try<AudioFileSpec> try_ = x1;
                    return true;
                }
                {
                    this.ch$3 = ch$3;
                }
            }, executionContext);
        }, executionContext);
    }

    public double[][] buffer(int numChannels, int bufFrames) {
        return (double[][])Array$.MODULE$.ofDim(numChannels, bufFrames, ClassTag$.MODULE$.Double());
    }

    public int buffer$default$2() {
        return 8192;
    }

    public String KEY_DIRECT_MEMORY() {
        return KEY_DIRECT_MEMORY;
    }

    public Logger log() {
        return log;
    }

    private boolean _useDirect$lzycompute() {
        AudioFile$ audioFile$ = this;
        synchronized (audioFile$) {
            if (!bitmap$0) {
                _useDirect = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)scala.sys.package$.MODULE$.props().getOrElse(this.KEY_DIRECT_MEMORY(), (Function0<String> & Serializable)() -> "false")));
                bitmap$0 = true;
            }
        }
        return _useDirect;
    }

    private boolean _useDirect() {
        if (!bitmap$0) {
            return this._useDirect$lzycompute();
        }
        return _useDirect;
    }

    public ByteBuffer allocByteBuffer(int size) {
        if (this._useDirect()) {
            return ByteBuffer.allocateDirect(size);
        }
        return ByteBuffer.allocate(size);
    }

    public ByteBuffer createBuffer(AudioFileHeader afh) {
        AudioFileSpec spec = afh.spec();
        int frameSize = (spec.sampleFormat().bitsPerSample() >> 3) * spec.numChannels();
        int bufFrames = package$.MODULE$.max(1, 65536 / package$.MODULE$.max(1, frameSize));
        int bufSize = bufFrames * frameSize;
        ByteBuffer byteBuf = this.allocByteBuffer(bufSize);
        return byteBuf.order(afh.byteOrder());
    }

    public Nothing$ noDecoder(Object msg) {
        throw this.noDecoderE(msg);
    }

    public Nothing$ noEncoder(Object msg) {
        throw this.noEncoderE(msg);
    }

    public IOException noDecoderE(Object msg) {
        return new IOException(new StringBuilder(15).append("No decoder for ").append(msg).toString());
    }

    public IOException noEncoderE(Object msg) {
        return new IOException(new StringBuilder(15).append("No encoder for ").append(msg).toString());
    }

    public AudioFile openStreamWithReader(InputStream is, AudioFileType.CanRead reader) {
        DataInputStream dis = this.dataInput(is);
        return this.finishOpenStreamRead(dis, reader);
    }

    private AudioFile finishOpenStreamRead(DataInputStream dis, AudioFileType.CanRead hr) {
        AudioFileHeader afh = hr.read(dis);
        ByteBuffer buf2 = this.createBuffer(afh);
        AudioFileSpec spec = afh.spec();
        SampleFormat sf = spec.sampleFormat();
        BufferReader br = (BufferReader)sf.readerFactory().map((Function1<BufferReaderFactory, BufferReader> & Serializable)x$4 -> x$4.apply(Channels.newChannel(dis), buf2, spec.numChannels())).getOrElse((Function0<Nothing$> & Serializable)() -> MODULE$.noDecoder(sf));
        return new AudioFile.ReadableStreamImpl(dis, afh, br);
    }

    public AudioFileType.CanRead createHeaderReader(DataInputStream dis) throws IOException {
        AudioFileType.CanIdentify fileType = (AudioFileType.CanIdentify)this.identify(dis).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new IOException("Unrecognized audio file format");
        });
        AudioFileType.CanIdentify canIdentify = fileType;
        if (canIdentify instanceof AudioFileType.CanRead) {
            AudioFileType.CanIdentify canIdentify2 = canIdentify;
            return (AudioFileType.CanRead)((Object)canIdentify2);
        }
        throw this.noDecoder(fileType);
    }

    private DataInputStream dataInput(InputStream is) {
        return new DataInputStream(is);
    }

    private DataOutputStream dataOutput(OutputStream os) {
        return new DataOutputStream(new BufferedOutputStream(os, 1024));
    }

    public AudioFileType.CanWrite createHeaderWriter(AudioFileSpec spec) {
        AudioFileType audioFileType = spec.fileType();
        if (audioFileType instanceof AudioFileType.CanWrite) {
            AudioFileType.CanWrite canWrite = (AudioFileType.CanWrite)audioFileType;
            return canWrite;
        }
        throw this.noEncoder(audioFileType);
    }

    public Future<AudioFileType.CanRead> createHeaderReaderAsync(AsyncReadableByteChannel ch, ExecutionContext ec) {
        long mark = ch.position();
        byte[] arr = new byte[128];
        ByteBuffer bb = ByteBuffer.wrap(arr);
        Future<Object> fut0 = ch.read(bb);
        Future<Object> fut = fut0.andThen(new Serializable(ch, mark){
            private static final long serialVersionUID = 0L;
            private final AsyncReadableByteChannel ch$4;
            private final long mark$1;

            public final <A1 extends Try<Object>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                this.ch$4.position_$eq(this.mark$1);
                return (B1)BoxedUnit.UNIT;
            }

            public final boolean isDefinedAt(Try<Object> x1) {
                Try<Object> try_ = x1;
                return true;
            }
            {
                this.ch$4 = ch$4;
                this.mark$1 = mark$1;
            }
        }, ec);
        return fut.map((Function1<Object, AudioFileType.CanRead> & Serializable)len -> AudioFile$.$anonfun$createHeaderReaderAsync$1(arr, BoxesRunTime.unboxToInt(len)), ec);
    }

    public Future<AsyncAudioFile> finishOpenStreamReadAsync(Option<URI> uri, AsyncReadableByteChannel ch, AudioFileType.CanRead hr, ExecutionContext ec) {
        Future<AudioFileHeader> afhFut = hr.readAsync(ch);
        return afhFut.map((Function1<AudioFileHeader, AudioFile.AsyncReadableImpl> & Serializable)afh -> {
            ByteBuffer buf2 = MODULE$.createBuffer((AudioFileHeader)afh);
            AudioFileSpec spec = afh.spec();
            SampleFormat sf = spec.sampleFormat();
            AsyncBufferReader br = (AsyncBufferReader)sf.asyncReaderFactory().map((Function1<AsyncBufferReaderFactory, AsyncBufferReader> & Serializable)x$5 -> x$5.apply(ch, buf2, spec.numChannels(), ec)).getOrElse((Function0<Nothing$> & Serializable)() -> MODULE$.noDecoder(sf));
            return new AudioFile.AsyncReadableImpl(uri, ch, (AudioFileHeader)afh, br);
        }, ec);
    }

    public Future<AsyncAudioFile> finishOpenStreamWriteAsync(Option<URI> uri, AsyncWritableByteChannel ch, AudioFileSpec spec, ExecutionContext ec) {
        AudioFileType.CanWrite hw = this.createHeaderWriter(spec);
        Future<AsyncWritableAudioFileHeader> afhFut = hw.writeAsync(ch, spec);
        return afhFut.map((Function1<AsyncWritableAudioFileHeader, AsyncAudioFile> & Serializable)afh -> {
            ByteBuffer buf2 = MODULE$.createBuffer((AudioFileHeader)afh);
            SampleFormat sf = spec.sampleFormat();
            Option<AsyncBufferBidiFactory> option = sf.asyncBidiFactory();
            if (option instanceof Some) {
                Some some = (Some)option;
                AsyncBufferBidiFactory bbf = (AsyncBufferBidiFactory)some.value();
                AsyncBufferBidi bb = bbf.apply(ch, buf2, spec.numChannels(), ec);
                return new AudioFile.AsyncBidiImpl(uri, ch, (AsyncWritableAudioFileHeader)afh, bb);
            }
            if (None$.MODULE$.equals(option)) {
                AsyncBufferWriter bw = (AsyncBufferWriter)sf.asyncWriterFactory().map((Function1<AsyncBufferWriterFactory, AsyncBufferWriter> & Serializable)x$6 -> x$6.apply(ch, buf2, spec.numChannels(), ec)).getOrElse((Function0<Nothing$> & Serializable)() -> MODULE$.noEncoder(sf));
                return new AudioFile.AsyncWritableImpl(uri, ch, (AsyncWritableAudioFileHeader)afh, bw);
            }
            throw new MatchError(option);
        }, ec);
    }

    public static final /* synthetic */ boolean $anonfun$identify$1(DataInputStream dis$1, AudioFileType.CanIdentify f) {
        boolean bl;
        dis$1.mark(1024);
        try {
            try {
                bl = f.identify(dis$1);
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        finally {
            dis$1.reset();
        }
        return bl;
    }

    public static final /* synthetic */ AudioFileType.CanRead $anonfun$createHeaderReaderAsync$1(byte[] arr$1, int len) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(arr$1, 0, len));
        AudioFileType.CanIdentify fileType = (AudioFileType.CanIdentify)MODULE$.identify(dis).getOrElse((Function0<Nothing$> & Serializable)() -> {
            throw new IOException("Unrecognized audio file format");
        });
        AudioFileType.CanIdentify canIdentify = fileType;
        if (canIdentify instanceof AudioFileType.CanRead) {
            AudioFileType.CanIdentify canIdentify2 = canIdentify;
            return (AudioFileType.CanRead)((Object)canIdentify2);
        }
        throw MODULE$.noDecoder(fileType);
    }

    private AudioFile$() {
    }
}

