/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile;

import de.sciss.audiofile.AudioFileHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteOrder;
import scala.runtime.Nothing$;

public final class AudioFileHeader$ {
    public static final AudioFileHeader$ MODULE$ = new AudioFileHeader$();

    public Nothing$ opNotSupported() {
        throw new IOException("Operation not supported");
    }

    public int readLittleUShort(DataInput din) throws IOException {
        int i = din.readUnsignedShort();
        return i >> 8 | (i & 0xFF) << 8;
    }

    public int readLittleInt(DataInput din) throws IOException {
        int i = din.readInt();
        return i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24;
    }

    public float readLittleFloat(DataInput din) throws IOException {
        int i = din.readInt();
        return Float.intBitsToFloat(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public long readLittleLong(DataInput din) throws IOException {
        long n = din.readLong();
        return n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56;
    }

    public void writeLittleShort(DataOutput dout, int i) throws IOException {
        dout.writeShort(i >> 8 | (i & 0xFF) << 8);
    }

    public void writeLittleInt(DataOutput dout, int i) throws IOException {
        dout.writeInt(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public void writeLittleFloat(DataOutput dout, float f) throws IOException {
        int i = Float.floatToIntBits(f);
        dout.writeInt(i >> 24 & 0xFF | i >> 8 & 0xFF00 | i << 8 & 0xFF0000 | i << 24);
    }

    public void writeLittleLong(DataOutput dout, long n) throws IOException {
        dout.writeLong(n >> 56 & 0xFFL | n >> 40 & 0xFF00L | n >> 24 & 0xFF0000L | n >> 8 & 0xFF000000L | n << 8 & 0xFF00000000L | n << 24 & 0xFF0000000000L | n << 40 & 0xFF000000000000L | n << 56);
    }

    public String readNullTermString(DataInput din) throws IOException {
        StringBuffer buf2 = new StringBuffer();
        byte b = din.readByte();
        while (b != 0) {
            buf2.append((char)b);
            b = din.readByte();
        }
        return buf2.toString();
    }

    public Nothing$ formatError(String detail) {
        throw new IOException(new StringBuilder(32).append("A header format error occurred: ").append(detail).toString());
    }

    public Nothing$ encodingError() {
        throw new IOException("File has unsupported encoding");
    }

    public Nothing$ incompleteError() {
        throw new IOException("Header data is incomplete");
    }

    public AudioFileHeader.DataInputReader dataInputReader(DataInput din, ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            return new AudioFileHeader.LittleDataInputReader(din);
        }
        return new AudioFileHeader.BigDataInputReader(din);
    }

    public AudioFileHeader.DataInputReader nativeDataInputReader(DataInput din) {
        return this.dataInputReader(din, ByteOrder.nativeOrder());
    }

    public AudioFileHeader.DataOutputWriter dataOutputWriter(DataOutput dout, ByteOrder byteOrder) {
        ByteOrder byteOrder2 = byteOrder;
        ByteOrder byteOrder3 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            return new AudioFileHeader.LittleDataOutputWriter(dout);
        }
        return new AudioFileHeader.BigDataOutputWriter(dout);
    }

    public AudioFileHeader.DataOutputWriter nativeDataOutputWriter(DataOutput dout) {
        return this.dataOutputWriter(dout, ByteOrder.nativeOrder());
    }

    private AudioFileHeader$() {
    }
}

