/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile.impl;

import de.sciss.asyncfile.AsyncReadableByteBuffer;
import de.sciss.asyncfile.AsyncReadableByteBuffer$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFileHeader$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$AIFF$;
import de.sciss.audiofile.ReadableAudioFileHeader;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.SampleFormat$Double$;
import de.sciss.audiofile.SampleFormat$Float$;
import de.sciss.audiofile.SampleFormat$Int16$;
import de.sciss.audiofile.SampleFormat$Int24$;
import de.sciss.audiofile.SampleFormat$Int32$;
import de.sciss.audiofile.SampleFormat$Int8$;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.audiofile.impl.AIFFHeader;
import de.sciss.audiofile.impl.BasicHeader;
import de.sciss.audiofile.impl.NonUpdatingWritableHeader;
import de.sciss.serial.impl.ByteArrayOutputStream;
import de.sciss.serial.impl.ByteArrayOutputStream$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

public final class AIFFHeader$
implements BasicHeader {
    public static final AIFFHeader$ MODULE$ = new AIFFHeader$();
    private static final byte[] fl32_HUMAN;
    private static final byte[] fl64_HUMAN;
    private static final byte[] in16_HUMAN;
    private static final double LN2R;

    static {
        BasicHeader.$init$(MODULE$);
        fl32_HUMAN = new byte[]{102, 108, 51, 50, 12, 51, 50, 45, 98, 105, 116, 32, 102, 108, 111, 97, 116, 0};
        fl64_HUMAN = new byte[]{102, 108, 54, 52, 12, 54, 52, 45, 98, 105, 116, 32, 102, 108, 111, 97, 116, 0};
        in16_HUMAN = new byte[]{115, 111, 119, 116, 12, 49, 54, 45, 98, 105, 116, 32, 105, 110, 116, 32, 32, 0};
        LN2R = 1.0 / package$.MODULE$.log(2.0);
    }

    @Override
    public final AudioFileHeader read(RandomAccessFile raf) throws IOException {
        return BasicHeader.read$((BasicHeader)this, raf);
    }

    @Override
    public final AudioFileHeader read(DataInputStream dis) throws IOException {
        return BasicHeader.read$((BasicHeader)this, dis);
    }

    private final int FORM_MAGIC() {
        return 1179603533;
    }

    private final int AIFF_MAGIC() {
        return 1095321158;
    }

    private final int AIFC_MAGIC() {
        return 1095321155;
    }

    private final int COMM_MAGIC() {
        return 1129270605;
    }

    private final int SSND_MAGIC() {
        return 1397968452;
    }

    private final int FVER_MAGIC() {
        return 1180058962;
    }

    private final int NONE_MAGIC() {
        return 1313820229;
    }

    private final int fl32_MAGIC() {
        return 1718367026;
    }

    private final int FL32_MAGIC() {
        return 1179398962;
    }

    private final int fl64_MAGIC() {
        return 1718367796;
    }

    private final int FL64_MAGIC() {
        return 1179399732;
    }

    private final int in16_MAGIC() {
        return 1768829238;
    }

    private final int in24_MAGIC() {
        return 1768829492;
    }

    private final int in32_MAGIC() {
        return 1768829746;
    }

    private final int in16LE_MAGIC() {
        return 1936684916;
    }

    private final int AIFCVersion1() {
        return -1568648896;
    }

    private final byte[] fl32_HUMAN() {
        return fl32_HUMAN;
    }

    private final byte[] fl64_HUMAN() {
        return fl64_HUMAN;
    }

    private final byte[] in16_HUMAN() {
        return in16_HUMAN;
    }

    private final double LN2R() {
        return LN2R;
    }

    @Override
    public boolean identify(DataInputStream dis) throws IOException {
        int cookie = dis.readInt();
        if (cookie == 1179603533) {
            dis.readInt();
            int magic = dis.readInt();
            return magic == 1095321155 || magic == 1095321158;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioFileHeader readDataInput(DataInput din) throws IOException {
        formMagic = din.readInt();
        if (formMagic != 1179603533) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not FORM magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(formMagic))).toString());
        }
        din.readInt();
        var5_3 = din.readInt();
        switch (var5_3) {
            case 1095321155: {
                v0 = true;
                break;
            }
            case 1095321158: {
                v0 = false;
                break;
            }
            default: {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(26).append("Not AIFF or AIFC magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(var5_3))).toString());
            }
        }
        isAIFC = v0;
        chunkLen = 0;
        afh = null;
        ssndFound = false;
        try {
            block21: while (!ssndFound) {
                v1 /* !! */  = chunkLen != 0 ? BoxesRunTime.boxToInteger(din.skipBytes(chunkLen)) : BoxedUnit.UNIT;
                magic = din.readInt();
                chunkLen = din.readInt() + 1 & -2;
                var10_9 = magic;
                switch (var10_9) {
                    case 1129270605: {
                        numChannels = din.readShort();
                        numFrames = (long)din.readInt() & 0xFFFFFFFFL;
                        bitsPerSample = din.readShort();
                        l1 = din.readLong();
                        l2 = din.readUnsignedShort();
                        l3 = l1 & 0xFFFFFFFFFFFFL;
                        i1 = ((int)(l1 >> 48) & 32767) - 16382;
                        sampleRate = ((double)l3 * package$.MODULE$.pow(2.0, i1 - 48) + (double)l2 * package$.MODULE$.pow(2.0, i1 - 64)) * (double)package$.MODULE$.signum(l1);
                        chunkLen -= 18;
                        if (!isAIFC) ** GOTO lbl70
                        chunkLen -= 4;
                        var25_20 = din.readInt();
                        switch (var25_20) {
                            case 1313820229: {
                                v2 = new Tuple2<ByteOrder, SampleFormat>(ByteOrder.BIG_ENDIAN, this.intSampleFormat(bitsPerSample));
                                ** GOTO lbl71
                            }
                            case 1768829238: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Int16$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int16$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1768829492: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Int24$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int24$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1768829746: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Int32$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int32$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1718367026: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Float$>(ByteOrder.BIG_ENDIAN, SampleFormat$Float$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1179398962: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Float$>(ByteOrder.BIG_ENDIAN, SampleFormat$Float$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1718367796: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Double$>(ByteOrder.BIG_ENDIAN, SampleFormat$Double$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1179399732: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Double$>(ByteOrder.BIG_ENDIAN, SampleFormat$Double$.MODULE$);
                                ** GOTO lbl71
                            }
                            case 1936684916: {
                                v2 = new Tuple2<ByteOrder, SampleFormat$Int16$>(ByteOrder.LITTLE_ENDIAN, SampleFormat$Int16$.MODULE$);
                                ** GOTO lbl71
                            }
                            default: {
                                throw new IOException(new StringBuilder(28).append("Unsupported AIFF encoding (").append(var25_20).append(")").toString());
                            }
                        }
lbl70:
                        // 1 sources

                        v2 = var24_19 = new Tuple2<ByteOrder, SampleFormat>(ByteOrder.BIG_ENDIAN, this.intSampleFormat(bitsPerSample));
lbl71:
                        // 10 sources

                        if (var24_19 == null) {
                            throw new MatchError(var24_19);
                        }
                        byteOrder = (ByteOrder)var24_19._1();
                        sampleFormat = var24_19._2();
                        var23_18 = new Tuple2<ByteOrder, SampleFormat>(byteOrder, sampleFormat);
                        byteOrder = var23_18._1();
                        sampleFormat = var23_18._2();
                        spec = new AudioFileSpec(AudioFileType$AIFF$.MODULE$, sampleFormat, numChannels, sampleRate, new Some<ByteOrder>(byteOrder), numFrames);
                        afh = new ReadableAudioFileHeader(spec, byteOrder);
                        continue block21;
                    }
                    case 1397968452: {
                        i1 = din.readInt();
                        din.readInt();
                        din.skipBytes(i1);
                        ssndFound = true;
                        continue block21;
                    }
                }
            }
        }
        catch (EOFException v3) {}
        if (afh == null) {
            throw new IOException("AIFF header misses COMM chunk");
        }
        if (!ssndFound) {
            throw new IOException("AIFF header misses SSND chunk");
        }
        return afh;
    }

    public Future<AudioFileHeader> readAsync(AsyncReadableByteChannel ch) {
        AsyncReadableByteBuffer ab = new AsyncReadableByteBuffer(ch, AsyncReadableByteBuffer$.MODULE$.$lessinit$greater$default$2());
        return ab.ensure(12).flatMap((Function1<BoxedUnit, Future> & Serializable)x$2 -> {
            boolean bl;
            int formMagic = ab.buffer().getInt();
            if (formMagic != 1179603533) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not FORM magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(formMagic))).toString());
            }
            ab.buffer().getInt();
            int n = ab.buffer().getInt();
            switch (n) {
                case 1095321155: {
                    bl = true;
                    break;
                }
                case 1095321158: {
                    bl = false;
                    break;
                }
                default: {
                    throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(26).append("Not AIFF or AIFC magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(n))).toString());
                }
            }
            boolean isAIFC = bl;
            return AIFFHeader$.readChunk$1(null, ab, isAIFC);
        }, ab.executionContext());
    }

    private SampleFormat intSampleFormat(int bitsPerSample) {
        int n = bitsPerSample;
        switch (n) {
            case 8: {
                return SampleFormat$Int8$.MODULE$;
            }
            case 16: {
                return SampleFormat$Int16$.MODULE$;
            }
            case 24: {
                return SampleFormat$Int24$.MODULE$;
            }
            case 32: {
                return SampleFormat$Int32$.MODULE$;
            }
        }
        throw new IOException(new StringBuilder(44).append("Unsupported AIFF encoding (").append(n).append(" bits-per-sample)").toString());
    }

    @Override
    public WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
        AIFFHeader.WriteHeaderResult writeRes = this.writeDataOutput(raf, spec, false);
        return new AIFFHeader.WritableFileHeader(raf, writeRes.spec1(), writeRes.otherLen(), writeRes.commLen());
    }

    @Override
    public WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
        AIFFHeader.WriteHeaderResult writeRes = this.writeDataOutput(dos, spec, true);
        return new NonUpdatingWritableHeader(writeRes.spec1());
    }

    public Future<AsyncWritableAudioFileHeader> writeAsync(AsyncWritableByteChannel ch, AudioFileSpec spec) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(ByteArrayOutputStream$.MODULE$.$lessinit$greater$default$1());
        DataOutputStream dout = new DataOutputStream(bs);
        AIFFHeader.WriteHeaderResult writeRes = this.writeDataOutput(dout, spec, false);
        ByteBuffer dst = ByteBuffer.wrap(bs.buffer(), 0, bs.size());
        Future<Object> fut = ch.write(dst);
        return fut.map((Function1<Object, AIFFHeader.AsyncWritableFileHeader> & Serializable)x$7 -> AIFFHeader$.$anonfun$writeAsync$1(ch, writeRes, BoxesRunTime.unboxToInt(x$7)), ch.fileSystem().executionContext());
    }

    private AIFFHeader.WriteHeaderResult writeDataOutput(DataOutput dout, AudioFileSpec spec, boolean writeSize) throws IOException {
        Object object;
        boolean bl;
        ByteOrder byteOrder;
        SampleFormat smpForm = spec.sampleFormat();
        int bitsPerSample = smpForm.bitsPerSample();
        double sr = spec.sampleRate();
        long numFrames = writeSize ? spec.numFrames() : 0L;
        int numChannels = spec.numChannels();
        ByteOrder byteOrder2 = byteOrder = (ByteOrder)spec.byteOrder().getOrElse((Function0<ByteOrder> & Serializable)() -> ByteOrder.BIG_ENDIAN);
        ByteOrder byteOrder3 = ByteOrder.LITTLE_ENDIAN;
        if (!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null)) {
            SampleFormat sampleFormat = smpForm;
            SampleFormat$Int16$ sampleFormat$Int16$ = SampleFormat$Int16$.MODULE$;
            if (sampleFormat == null ? sampleFormat$Int16$ != null : !sampleFormat.equals(sampleFormat$Int16$)) {
                throw new IOException("AIFF little endian only supported for Int16");
            }
            bl = true;
        } else {
            bl = false;
        }
        boolean le16 = bl;
        SampleFormat sampleFormat = smpForm;
        SampleFormat$Float$ sampleFormat$Float$ = SampleFormat$Float$.MODULE$;
        if (!(sampleFormat != null ? !sampleFormat.equals(sampleFormat$Float$) : sampleFormat$Float$ != null)) {
            object = this.fl32_HUMAN();
        } else {
            SampleFormat sampleFormat2 = smpForm;
            SampleFormat$Double$ sampleFormat$Double$ = SampleFormat$Double$.MODULE$;
            object = !(sampleFormat2 != null ? !sampleFormat2.equals(sampleFormat$Double$) : sampleFormat$Double$ != null) ? this.fl64_HUMAN() : (Object)(le16 ? this.in16_HUMAN() : null);
        }
        byte[] aifcExt = object;
        boolean isAIFC = aifcExt != null;
        int otherLen = isAIFC ? 24 : 12;
        int commLen = isAIFC ? 26 + aifcExt.length : 26;
        long ssndLen = (long)(bitsPerSample >> 3) * numFrames * (long)numChannels + 16L;
        long fileLen = (long)(otherLen + commLen) + ssndLen;
        dout.writeInt(1179603533);
        dout.writeInt((int)(fileLen - 8L));
        if (isAIFC) {
            dout.writeInt(1095321155);
            dout.writeInt(1180058962);
            dout.writeInt(4);
            dout.writeInt(-1568648896);
        } else {
            dout.writeInt(1095321158);
        }
        dout.writeInt(1129270605);
        dout.writeInt(commLen - 8);
        dout.writeShort(numChannels);
        dout.writeInt((int)numFrames);
        dout.writeShort(isAIFC ? 16 : bitsPerSample);
        int srs = sr < 0.0 ? 128 : 0;
        double sra = package$.MODULE$.abs(sr);
        int srl = (int)(package$.MODULE$.log(sra) * this.LN2R() + (double)16383) & 0xFFFF;
        double sre = sra * (double)(1 << 16414 - srl);
        dout.writeShort(((srs | srl >> 8) & 0xFF) << 8 | srl & 0xFF);
        dout.writeInt((int)sre);
        dout.writeInt((int)(sre % 1.0 * (double)0x100000000L));
        if (isAIFC) {
            dout.write(aifcExt);
        }
        dout.writeInt(1397968452);
        dout.writeInt((int)(ssndLen - 8L));
        dout.writeInt(0);
        dout.writeInt(0);
        long x$1 = 0L;
        Some<ByteOrder> x$2 = new Some<ByteOrder>(byteOrder);
        AudioFileType x$3 = spec.copy$default$1();
        SampleFormat x$4 = spec.copy$default$2();
        int x$5 = spec.copy$default$3();
        double x$6 = spec.copy$default$4();
        AudioFileSpec spec1 = spec.copy(x$3, x$4, x$5, x$6, x$2, 0L);
        return new AIFFHeader.WriteHeaderResult(otherLen, commLen, spec1);
    }

    private static final Future readChunk$1(AudioFileHeader afh, AsyncReadableByteBuffer ab$1, boolean isAIFC$1) {
        return ab$1.ensure(8).flatMap((Function1<BoxedUnit, Future> & Serializable)x$3 -> {
            int magic = ab$1.buffer().getInt();
            IntRef chunkLen = IntRef.create(ab$1.buffer().getInt() + 1 & 0xFFFFFFFE);
            int n = magic;
            switch (n) {
                case 1129270605: {
                    return ab$1.ensure(isAIFC$1 ? 22 : 18).flatMap((Function1<BoxedUnit, Future> & Serializable)x$4 -> {
                        Tuple2<ByteOrder, SampleFormat> tuple2;
                        double sampleRate;
                        long numFrames;
                        short numChannels;
                        block13: {
                            Tuple2<ByteOrder, SampleFormat> tuple22;
                            short bitsPerSample;
                            block12: {
                                numChannels = ab$1.buffer().getShort();
                                numFrames = (long)ab$1.buffer().getInt() & 0xFFFFFFFFL;
                                bitsPerSample = ab$1.buffer().getShort();
                                long l1 = ab$1.buffer().getLong();
                                int l2 = ab$1.buffer().getShort() & 0xFFFF;
                                long l3 = l1 & 0xFFFFFFFFFFFFL;
                                int i1 = ((int)(l1 >> 48) & Short.MAX_VALUE) - 16382;
                                sampleRate = ((double)l3 * package$.MODULE$.pow(2.0, i1 - 48) + (double)l2 * package$.MODULE$.pow(2.0, i1 - 64)) * (double)package$.MODULE$.signum(l1);
                                chunkLen$1.elem -= 18;
                                if (!isAIFC$1) break block12;
                                chunkLen$1.elem -= 4;
                                int n = ab$1.buffer().getInt();
                                switch (n) {
                                    case 1313820229: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat>(ByteOrder.BIG_ENDIAN, MODULE$.intSampleFormat(bitsPerSample));
                                        break block13;
                                    }
                                    case 1768829238: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Int16$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int16$.MODULE$);
                                        break block13;
                                    }
                                    case 1768829492: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Int24$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int24$.MODULE$);
                                        break block13;
                                    }
                                    case 1768829746: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Int32$>(ByteOrder.BIG_ENDIAN, SampleFormat$Int32$.MODULE$);
                                        break block13;
                                    }
                                    case 1718367026: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Float$>(ByteOrder.BIG_ENDIAN, SampleFormat$Float$.MODULE$);
                                        break block13;
                                    }
                                    case 1179398962: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Float$>(ByteOrder.BIG_ENDIAN, SampleFormat$Float$.MODULE$);
                                        break block13;
                                    }
                                    case 1718367796: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Double$>(ByteOrder.BIG_ENDIAN, SampleFormat$Double$.MODULE$);
                                        break block13;
                                    }
                                    case 1179399732: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Double$>(ByteOrder.BIG_ENDIAN, SampleFormat$Double$.MODULE$);
                                        break block13;
                                    }
                                    case 1936684916: {
                                        tuple22 = new Tuple2<ByteOrder, SampleFormat$Int16$>(ByteOrder.LITTLE_ENDIAN, SampleFormat$Int16$.MODULE$);
                                        break block13;
                                    }
                                    default: {
                                        throw new IOException(new StringBuilder(28).append("Unsupported AIFF encoding (").append(n).append(")").toString());
                                    }
                                }
                            }
                            tuple22 = tuple2 = new Tuple2<ByteOrder, SampleFormat>(ByteOrder.BIG_ENDIAN, MODULE$.intSampleFormat(bitsPerSample));
                        }
                        if (tuple2 == null) {
                            throw new MatchError(tuple2);
                        }
                        ByteOrder byteOrder = tuple2._1();
                        SampleFormat sampleFormat = (SampleFormat)tuple2._2();
                        Tuple2<ByteOrder, SampleFormat> tuple23 = new Tuple2<ByteOrder, SampleFormat>(byteOrder, sampleFormat);
                        ByteOrder byteOrder2 = tuple23._1();
                        SampleFormat sampleFormat2 = tuple23._2();
                        AudioFileSpec spec = new AudioFileSpec(AudioFileType$AIFF$.MODULE$, sampleFormat2, numChannels, sampleRate, new Some<ByteOrder>(byteOrder2), numFrames);
                        ReadableAudioFileHeader _afh = new ReadableAudioFileHeader(spec, byteOrder2);
                        ab$1.skip(chunkLen$1.elem);
                        return AIFFHeader$.readChunk$1(_afh, ab$1, isAIFC$1);
                    }, ab$1.executionContext());
                }
                case 1397968452: {
                    return ab$1.ensure(4).map((Function1<BoxedUnit, AudioFileHeader> & Serializable)x$6 -> {
                        int i1 = ab$1.buffer().getInt();
                        ab$1.buffer().getInt();
                        ab$1.skip(i1);
                        ab$1.purge();
                        if (afh != null) {
                            return afh;
                        }
                        throw new IOException("AIFF header misses COMM chunk");
                    }, ab$1.executionContext());
                }
            }
            ab$1.skip(chunkLen.elem);
            return AIFFHeader$.readChunk$1(afh, ab$1, isAIFC$1);
        }, ab$1.executionContext());
    }

    public static final /* synthetic */ AIFFHeader.AsyncWritableFileHeader $anonfun$writeAsync$1(AsyncWritableByteChannel ch$1, AIFFHeader.WriteHeaderResult writeRes$1, int x$7) {
        return new AIFFHeader.AsyncWritableFileHeader(ch$1, writeRes$1.spec1(), writeRes$1.otherLen(), writeRes$1.commLen());
    }

    private AIFFHeader$() {
    }
}

