/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile.impl;

import de.sciss.asyncfile.AsyncReadableByteBuffer;
import de.sciss.asyncfile.AsyncReadableByteBuffer$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFileHeader$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$IRCAM$;
import de.sciss.audiofile.ReadableAudioFileHeader;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.SampleFormat$Double$;
import de.sciss.audiofile.SampleFormat$Float$;
import de.sciss.audiofile.SampleFormat$Int16$;
import de.sciss.audiofile.SampleFormat$Int24$;
import de.sciss.audiofile.SampleFormat$Int32$;
import de.sciss.audiofile.SampleFormat$Int8$;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.audiofile.impl.NonUpdatingWritableHeader;
import de.sciss.serial.impl.ByteArrayOutputStream;
import de.sciss.serial.impl.ByteArrayOutputStream$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class IRCAMHeader$ {
    public static final IRCAMHeader$ MODULE$ = new IRCAMHeader$();

    private final int IRCAM_VAXLE_MAGIC() {
        return 1688404224;
    }

    private final int IRCAM_VAXBE_MAGIC() {
        return 107364;
    }

    private final int IRCAM_SUNBE_MAGIC() {
        return 1688404480;
    }

    private final int IRCAM_SUNLE_MAGIC() {
        return 172900;
    }

    private final int IRCAM_MIPSLE_MAGIC() {
        return 1688404736;
    }

    private final int IRCAM_MIPSBE_MAGIC() {
        return 238436;
    }

    private final int IRCAM_NEXTBE_MAGIC() {
        return 1688404992;
    }

    private final int BICSF_END() {
        return 0;
    }

    private final int BICSF_LINKCODE() {
        return 3;
    }

    private final int BICSF_VIRTUALCODE() {
        return 4;
    }

    public boolean identify(DataInputStream dis) throws IOException {
        int magic = dis.readInt();
        return magic == 1688404224 || magic == 107364 || magic == 1688404480 || magic == 172900 || magic == 1688404736 || magic == 238436 || magic == 1688404992;
    }

    public AudioFileHeader read(RandomAccessFile raf) throws IOException {
        return this.readDataInput(raf, raf.length());
    }

    public AudioFileHeader read(DataInputStream dis) throws IOException {
        return this.readDataInput(dis, dis.available());
    }

    private AudioFileHeader readDataInput(DataInput din, long fileLen) throws IOException {
        SampleFormat sampleFormat;
        AudioFileHeader.DataInputReader dataInputReader;
        int ircamMagic = din.readInt();
        if (ircamMagic == 1688404224 || ircamMagic == 172900 || ircamMagic == 1688404736) {
            dataInputReader = new AudioFileHeader.LittleDataInputReader(din);
        } else if (ircamMagic == 107364 || ircamMagic == 1688404480 || ircamMagic == 238436 || ircamMagic == 1688404992) {
            dataInputReader = new AudioFileHeader.BigDataInputReader(din);
        } else {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(19).append("Not IRCAM magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(ircamMagic))).toString());
        }
        AudioFileHeader.LittleDataInputReader reader = dataInputReader;
        float sampleRate = reader.readFloat();
        int numChannels = reader.readInt();
        int n = reader.readInt();
        switch (n) {
            case 1: {
                sampleFormat = SampleFormat$Int8$.MODULE$;
                break;
            }
            case 2: {
                sampleFormat = SampleFormat$Int16$.MODULE$;
                break;
            }
            case 3: {
                sampleFormat = SampleFormat$Int24$.MODULE$;
                break;
            }
            case 262148: {
                sampleFormat = SampleFormat$Int32$.MODULE$;
                break;
            }
            case 4: {
                sampleFormat = SampleFormat$Float$.MODULE$;
                break;
            }
            case 8: {
                sampleFormat = SampleFormat$Double$.MODULE$;
                break;
            }
            default: {
                throw new IOException(new StringBuilder(29).append("Unsupported IRCAM encoding (").append(n).append(")").toString());
            }
        }
        SampleFormat sampleFormat2 = sampleFormat;
        boolean done = false;
        long pos = 16L;
        while (!done) {
            int i = reader.readInt();
            int sz = i & 0xFFFF;
            int id = i >> 16;
            if (id == 0) {
                done = true;
            } else {
                if (id == 3) {
                    throw new IOException("Unsupported IRCAM feature (LINKCODE)");
                }
                if (id == 4) {
                    throw new IOException("Unsupported IRCAM feature (VIRTUALCODE)");
                }
            }
            Serializable serializable = sz > 0 ? BoxesRunTime.boxToInteger(din.skipBytes(sz)) : BoxedUnit.UNIT;
            pos += (long)(4 + sz);
        }
        long dataOffset = pos + 1023L & (0x3FFL ^ 0xFFFFFFFFFFFFFFFFL);
        int skp = (int)(dataOffset - pos);
        Serializable serializable = skp > 0 ? BoxesRunTime.boxToInteger(din.skipBytes(skp)) : BoxedUnit.UNIT;
        int frameSize = (sampleFormat2.bitsPerSample() + 7 >> 3) * numChannels;
        long numFrames = package$.MODULE$.max(0L, fileLen - dataOffset) / (long)frameSize;
        AudioFileSpec spec = new AudioFileSpec(AudioFileType$IRCAM$.MODULE$, sampleFormat2, numChannels, sampleRate, new Some<ByteOrder>(reader.byteOrder()), numFrames);
        return new ReadableAudioFileHeader(spec, reader.byteOrder());
    }

    public Future<AudioFileHeader> readAsync(AsyncReadableByteChannel ch) {
        AsyncReadableByteBuffer ab = new AsyncReadableByteBuffer(ch, AsyncReadableByteBuffer$.MODULE$.$lessinit$greater$default$2());
        return ab.ensure(16).flatMap((Function1<BoxedUnit, Future> & Serializable)x$1 -> {
            SampleFormat sampleFormat;
            Object object;
            int ircamMagic = ab.buffer().getInt();
            if (ircamMagic == 1688404224 || ircamMagic == 172900 || ircamMagic == 1688404736) {
                object = ab.buffer().order(ByteOrder.LITTLE_ENDIAN);
            } else {
                if (ircamMagic != 107364 && ircamMagic != 1688404480 && ircamMagic != 238436 && ircamMagic != 1688404992) {
                    throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(19).append("Not IRCAM magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(ircamMagic))).toString());
                }
                object = BoxedUnit.UNIT;
            }
            float sampleRate = ab.buffer().getFloat();
            int numChannels = ab.buffer().getInt();
            int n = ab.buffer().getInt();
            switch (n) {
                case 1: {
                    sampleFormat = SampleFormat$Int8$.MODULE$;
                    break;
                }
                case 2: {
                    sampleFormat = SampleFormat$Int16$.MODULE$;
                    break;
                }
                case 3: {
                    sampleFormat = SampleFormat$Int24$.MODULE$;
                    break;
                }
                case 262148: {
                    sampleFormat = SampleFormat$Int32$.MODULE$;
                    break;
                }
                case 4: {
                    sampleFormat = SampleFormat$Float$.MODULE$;
                    break;
                }
                case 8: {
                    sampleFormat = SampleFormat$Double$.MODULE$;
                    break;
                }
                default: {
                    throw new IOException(new StringBuilder(29).append("Unsupported IRCAM encoding (").append(n).append(")").toString());
                }
            }
            SampleFormat sampleFormat2 = sampleFormat;
            return IRCAMHeader$.readChunk$1(ab, ch, sampleFormat2, numChannels, sampleRate);
        }, ab.executionContext());
    }

    public WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
        AudioFileSpec spec1 = this.writeDataOutput(raf, spec);
        return new NonUpdatingWritableHeader(spec1);
    }

    public WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
        AudioFileSpec spec1 = this.writeDataOutput(dos, spec);
        return new NonUpdatingWritableHeader(spec1);
    }

    public Future<AsyncWritableAudioFileHeader> writeAsync(AsyncWritableByteChannel ch, AudioFileSpec spec) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(ByteArrayOutputStream$.MODULE$.$lessinit$greater$default$1());
        DataOutputStream dout = new DataOutputStream(bs);
        AudioFileSpec spec1 = this.writeDataOutput(dout, spec);
        ByteBuffer dst = ByteBuffer.wrap(bs.buffer(), 0, bs.size());
        Future<Object> fut = ch.write(dst);
        return fut.map((Function1<Object, NonUpdatingWritableHeader> & Serializable)x$3 -> IRCAMHeader$.$anonfun$writeAsync$1(spec1, BoxesRunTime.unboxToInt(x$3)), ch.fileSystem().executionContext());
    }

    private AudioFileSpec writeDataOutput(DataOutput dout, AudioFileSpec spec) throws IOException {
        ByteOrder byteOrder;
        AudioFileHeader.DataOutputWriter writer = AudioFileHeader$.MODULE$.dataOutputWriter(dout, (ByteOrder)spec.byteOrder().getOrElse((Function0<ByteOrder> & Serializable)() -> ByteOrder.nativeOrder()));
        ByteOrder byteOrder2 = byteOrder = (ByteOrder)spec.byteOrder().getOrElse((Function0<ByteOrder> & Serializable)() -> ByteOrder.nativeOrder());
        ByteOrder byteOrder3 = ByteOrder.LITTLE_ENDIAN;
        dout.writeInt(!(byteOrder2 != null ? !byteOrder2.equals(byteOrder3) : byteOrder3 != null) ? 1688404224 : 1688404480);
        writer.writeFloat((float)spec.sampleRate());
        writer.writeInt(spec.numChannels());
        SampleFormat sampleFormat = spec.sampleFormat();
        SampleFormat$Int32$ sampleFormat$Int32$ = SampleFormat$Int32$.MODULE$;
        writer.writeInt(!(sampleFormat != null ? !sampleFormat.equals(sampleFormat$Int32$) : sampleFormat$Int32$ != null) ? 262148 : spec.sampleFormat().bitsPerSample() >> 3);
        long pos = 16L;
        writer.writeInt(0);
        long dataOffset = (pos += 4L) + 1023L & (0x3FFL ^ 0xFFFFFFFFFFFFFFFFL);
        int skp = (int)(dataOffset - pos);
        if (skp > 0) {
            dout.write(new byte[skp]);
        }
        Some<ByteOrder> x$1 = new Some<ByteOrder>(byteOrder);
        AudioFileType x$2 = spec.copy$default$1();
        SampleFormat x$3 = spec.copy$default$2();
        int x$4 = spec.copy$default$3();
        double x$5 = spec.copy$default$4();
        long x$6 = spec.copy$default$6();
        return spec.copy(x$2, x$3, x$4, x$5, x$1, x$6);
    }

    private static final Future readChunk$1(AsyncReadableByteBuffer ab$1, AsyncReadableByteChannel ch$1, SampleFormat sampleFormat$1, int numChannels$1, float sampleRate$1) {
        return ab$1.ensure(4).flatMap((Function1<BoxedUnit, Future> & Serializable)x$2 -> {
            block5: {
                int i = ab$1.buffer().getInt();
                int sz = i & 0xFFFF;
                int id = i >> 16;
                if (id == 0) {
                    if (sz > 0) {
                        ab$1.skip(sz);
                    }
                    ab$1.purge();
                    long pos = ch$1.position();
                    long dataOffset = pos + 1023L & (0x3FFL ^ 0xFFFFFFFFFFFFFFFFL);
                    int skp = (int)(dataOffset - pos);
                    if (skp > 0) {
                        ab$1.skip(skp);
                    }
                    ab$1.purge();
                    int frameSize = (sampleFormat$1.bitsPerSample() + 7 >> 3) * numChannels$1;
                    long fileLen = ch$1.size();
                    long numFrames = package$.MODULE$.max(0L, fileLen - dataOffset) / (long)frameSize;
                    AudioFileSpec spec = new AudioFileSpec(AudioFileType$IRCAM$.MODULE$, sampleFormat$1, numChannels$1, sampleRate$1, new Some<ByteOrder>(ab$1.buffer().order()), numFrames);
                    ReadableAudioFileHeader afh = new ReadableAudioFileHeader(spec, ab$1.buffer().order());
                    return Future$.MODULE$.successful(afh);
                }
                if (id == 3) {
                    throw new IOException("Unsupported IRCAM feature (LINKCODE)");
                }
                if (id == 4) {
                    throw new IOException("Unsupported IRCAM feature (VIRTUALCODE)");
                }
                if (sz <= 0) break block5;
                ab$1.skip(sz);
            }
            return IRCAMHeader$.readChunk$1(ab$1, ch$1, sampleFormat$1, numChannels$1, sampleRate$1);
        }, ab$1.executionContext());
    }

    public static final /* synthetic */ NonUpdatingWritableHeader $anonfun$writeAsync$1(AudioFileSpec spec1$1, int x$3) {
        return new NonUpdatingWritableHeader(spec1$1);
    }

    private IRCAMHeader$() {
    }
}

