/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile.impl;

import de.sciss.asyncfile.AsyncReadableByteBuffer;
import de.sciss.asyncfile.AsyncReadableByteBuffer$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFileHeader$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType$NeXT$;
import de.sciss.audiofile.ReadableAudioFileHeader;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.SampleFormat$Double$;
import de.sciss.audiofile.SampleFormat$Float$;
import de.sciss.audiofile.SampleFormat$Int16$;
import de.sciss.audiofile.SampleFormat$Int24$;
import de.sciss.audiofile.SampleFormat$Int32$;
import de.sciss.audiofile.SampleFormat$Int8$;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.audiofile.impl.NeXTHeader;
import de.sciss.audiofile.impl.NonUpdatingWritableHeader;
import de.sciss.serial.impl.ByteArrayOutputStream;
import de.sciss.serial.impl.ByteArrayOutputStream$;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Some;
import scala.concurrent.Future;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class NeXTHeader$ {
    public static final NeXTHeader$ MODULE$ = new NeXTHeader$();

    private final int SND_MAGIC() {
        return 779316836;
    }

    public boolean identify(DataInputStream dis) throws IOException {
        return dis.readInt() == 779316836;
    }

    public AudioFileHeader read(RandomAccessFile raf) throws IOException {
        return this.readDataInput(raf, raf.length());
    }

    public AudioFileHeader read(DataInputStream dis) throws IOException {
        return this.readDataInput(dis, dis.available());
    }

    private AudioFileHeader readDataInput(DataInput din, long fileLen) throws IOException {
        SampleFormat sampleFormat;
        int sndMagic = din.readInt();
        if (sndMagic != 779316836) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not NeXT magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(sndMagic))).toString());
        }
        int dataOffset = din.readInt();
        int dataSize_$qmark = din.readInt();
        int n = din.readInt();
        switch (n) {
            case 2: {
                sampleFormat = SampleFormat$Int8$.MODULE$;
                break;
            }
            case 3: {
                sampleFormat = SampleFormat$Int16$.MODULE$;
                break;
            }
            case 4: {
                sampleFormat = SampleFormat$Int24$.MODULE$;
                break;
            }
            case 5: {
                sampleFormat = SampleFormat$Int32$.MODULE$;
                break;
            }
            case 6: {
                sampleFormat = SampleFormat$Float$.MODULE$;
                break;
            }
            case 7: {
                sampleFormat = SampleFormat$Double$.MODULE$;
                break;
            }
            default: {
                throw new IOException(new StringBuilder(28).append("Unsupported NeXT encoding (").append(n).append(")").toString());
            }
        }
        SampleFormat sampleFormat2 = sampleFormat;
        double sampleRate = din.readInt();
        int numChannels = din.readInt();
        int skp = dataOffset - 24;
        Serializable serializable = skp > 0 ? BoxesRunTime.boxToInteger(din.skipBytes(skp)) : BoxedUnit.UNIT;
        int frameSize = (sampleFormat2.bitsPerSample() + 7 >> 3) * numChannels;
        long dataSize = dataSize_$qmark == -1 ? fileLen - (long)dataOffset : (long)dataSize_$qmark;
        long numFrames = package$.MODULE$.max(0L, dataSize) / (long)frameSize;
        AudioFileSpec spec = new AudioFileSpec(AudioFileType$NeXT$.MODULE$, sampleFormat2, numChannels, sampleRate, new Some<ByteOrder>(ByteOrder.BIG_ENDIAN), numFrames);
        return new ReadableAudioFileHeader(spec, ByteOrder.BIG_ENDIAN);
    }

    public Future<AudioFileHeader> readAsync(AsyncReadableByteChannel ch) {
        AsyncReadableByteBuffer ab = new AsyncReadableByteBuffer(ch, AsyncReadableByteBuffer$.MODULE$.$lessinit$greater$default$2());
        return ab.ensure(24).map((Function1<BoxedUnit, ReadableAudioFileHeader> & Serializable)x$1 -> {
            SampleFormat sampleFormat;
            int sndMagic = ab.buffer().getInt();
            if (sndMagic != 779316836) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not NeXT magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(sndMagic))).toString());
            }
            int dataOffset = ab.buffer().getInt();
            int dataSize_$qmark = ab.buffer().getInt();
            int n = ab.buffer().getInt();
            switch (n) {
                case 2: {
                    sampleFormat = SampleFormat$Int8$.MODULE$;
                    break;
                }
                case 3: {
                    sampleFormat = SampleFormat$Int16$.MODULE$;
                    break;
                }
                case 4: {
                    sampleFormat = SampleFormat$Int24$.MODULE$;
                    break;
                }
                case 5: {
                    sampleFormat = SampleFormat$Int32$.MODULE$;
                    break;
                }
                case 6: {
                    sampleFormat = SampleFormat$Float$.MODULE$;
                    break;
                }
                case 7: {
                    sampleFormat = SampleFormat$Double$.MODULE$;
                    break;
                }
                default: {
                    throw new IOException(new StringBuilder(28).append("Unsupported NeXT encoding (").append(n).append(")").toString());
                }
            }
            SampleFormat sampleFormat2 = sampleFormat;
            double sampleRate = ab.buffer().getInt();
            int numChannels = ab.buffer().getInt();
            int skp = dataOffset - 24;
            if (skp > 0) {
                ab.skip(skp);
            }
            int frameSize = (sampleFormat2.bitsPerSample() + 7 >> 3) * numChannels;
            ab.purge();
            long fileLen = ch.size();
            long dataSize = dataSize_$qmark == -1 ? fileLen - (long)dataOffset : (long)dataSize_$qmark;
            long numFrames = package$.MODULE$.max(0L, dataSize) / (long)frameSize;
            AudioFileSpec spec = new AudioFileSpec(AudioFileType$NeXT$.MODULE$, sampleFormat2, numChannels, sampleRate, new Some<ByteOrder>(ByteOrder.BIG_ENDIAN), numFrames);
            return new ReadableAudioFileHeader(spec, ByteOrder.BIG_ENDIAN);
        }, ab.executionContext());
    }

    public WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
        AudioFileSpec spec1 = this.writeDataOutput(raf, spec, false);
        return new NeXTHeader.WritableFileHeader(raf, spec1);
    }

    public WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
        AudioFileSpec spec1 = this.writeDataOutput(dos, spec, true);
        return new NonUpdatingWritableHeader(spec1);
    }

    public Future<AsyncWritableAudioFileHeader> writeAsync(AsyncWritableByteChannel ch, AudioFileSpec spec) {
        ByteArrayOutputStream bs = new ByteArrayOutputStream(ByteArrayOutputStream$.MODULE$.$lessinit$greater$default$1());
        DataOutputStream dout = new DataOutputStream(bs);
        AudioFileSpec spec1 = this.writeDataOutput(dout, spec, false);
        ByteBuffer dst = ByteBuffer.wrap(bs.buffer(), 0, bs.size());
        Future<Object> fut = ch.write(dst);
        return fut.map((Function1<Object, NeXTHeader.AsyncWritableFileHeader> & Serializable)x$2 -> NeXTHeader$.$anonfun$writeAsync$1(ch, spec1, BoxesRunTime.unboxToInt(x$2)), ch.fileSystem().executionContext());
    }

    /*
     * Unable to fully structure code
     */
    private AudioFileSpec writeDataOutput(DataOutput dout, AudioFileSpec spec, boolean writeSize) throws IOException {
        var7_4 = false;
        var8_5 = null;
        var9_6 = spec.byteOrder();
        if (!(var9_6 instanceof Some)) ** GOTO lbl-1000
        var7_4 = true;
        var8_5 = (Some)var9_6;
        var10_7 = (ByteOrder)var8_5.value();
        v0 = ByteOrder.BIG_ENDIAN;
        var11_8 = var10_7;
        if (!(v0 != null ? v0.equals(var11_8) == false : var11_8 != null)) {
            v1 = spec;
        } else if (None$.MODULE$.equals(var9_6)) {
            x$1 = new Some<ByteOrder>(ByteOrder.BIG_ENDIAN);
            x$2 = spec.copy$default$1();
            x$3 = spec.copy$default$2();
            x$4 = spec.copy$default$3();
            x$5 = spec.copy$default$4();
            x$6 = spec.copy$default$6();
            v1 = spec.copy(x$2, x$3, x$4, x$5, x$1, x$6);
        } else {
            if (var7_4) {
                other = (ByteOrder)var8_5.value();
                throw new IOException(new StringBuilder(23).append("Unsupported byte order ").append(other).toString());
            }
            throw new MatchError(var9_6);
        }
        res = v1;
        dataOffset = 28L;
        dout.writeInt(779316836);
        dout.writeInt((int)dataOffset);
        dataSize = writeSize != false ? spec.numFrames() * (long)((spec.sampleFormat().bitsPerSample() >> 3) * spec.numChannels()) : 0L;
        dout.writeInt((int)dataSize);
        var26_19 = spec.sampleFormat();
        if (SampleFormat$Int8$.MODULE$.equals(var26_19)) {
            v2 = 2;
        } else if (SampleFormat$Int16$.MODULE$.equals(var26_19)) {
            v2 = 3;
        } else if (SampleFormat$Int24$.MODULE$.equals(var26_19)) {
            v2 = 4;
        } else if (SampleFormat$Int32$.MODULE$.equals(var26_19)) {
            v2 = 5;
        } else if (SampleFormat$Float$.MODULE$.equals(var26_19)) {
            v2 = 6;
        } else if (SampleFormat$Double$.MODULE$.equals(var26_19)) {
            v2 = 7;
        } else {
            throw new MatchError(var26_19);
        }
        formatCode = v2;
        dout.writeInt(formatCode);
        dout.writeInt((int)(spec.sampleRate() + 0.5));
        dout.writeInt(spec.numChannels());
        dout.writeInt(0);
        return res;
    }

    public static final /* synthetic */ NeXTHeader.AsyncWritableFileHeader $anonfun$writeAsync$1(AsyncWritableByteChannel ch$2, AudioFileSpec spec1$1, int x$2) {
        return new NeXTHeader.AsyncWritableFileHeader(ch$2, spec1$1);
    }

    private NeXTHeader$() {
    }
}

