/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile.impl;

import de.sciss.asyncfile.AsyncReadableByteBuffer;
import de.sciss.asyncfile.AsyncReadableByteBuffer$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFileHeader$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$Wave64$;
import de.sciss.audiofile.ReadableAudioFileHeader;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.audiofile.impl.AbstractRIFFHeader;
import de.sciss.audiofile.impl.BasicHeader;
import de.sciss.audiofile.impl.Wave64Header;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

public final class Wave64Header$
implements AbstractRIFFHeader {
    public static final Wave64Header$ MODULE$ = new Wave64Header$();

    static {
        BasicHeader.$init$(MODULE$);
        AbstractRIFFHeader.$init$(MODULE$);
    }

    @Override
    public final ReadableAudioFileHeader createReader(AbstractRIFFHeader.FormatChunk fc, AudioFileType tpe, long chunkLen) {
        return AbstractRIFFHeader.createReader$(this, fc, tpe, chunkLen);
    }

    @Override
    public final AbstractRIFFHeader.FormatChunk readFormatChunk(DataInput din, int chunkRem) {
        return AbstractRIFFHeader.readFormatChunk$(this, din, chunkRem);
    }

    @Override
    public final Future<AbstractRIFFHeader.FormatChunk> readFormatChunkAsync(AsyncReadableByteBuffer ab, int chunkRem) {
        return AbstractRIFFHeader.readFormatChunkAsync$(this, ab, chunkRem);
    }

    @Override
    public final AudioFileSpec fixOutputSpec(AudioFileSpec spec) {
        return AbstractRIFFHeader.fixOutputSpec$(this, spec);
    }

    @Override
    public final WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
        return AbstractRIFFHeader.write$((AbstractRIFFHeader)this, dos, spec);
    }

    @Override
    public final WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
        return AbstractRIFFHeader.write$((AbstractRIFFHeader)this, raf, spec);
    }

    @Override
    public Future<AsyncWritableAudioFileHeader> writeAsync(AsyncWritableByteChannel ch, AudioFileSpec spec) {
        return AbstractRIFFHeader.writeAsync$(this, ch, spec);
    }

    @Override
    public final AudioFileHeader read(RandomAccessFile raf) throws IOException {
        return BasicHeader.read$((BasicHeader)this, raf);
    }

    @Override
    public final AudioFileHeader read(DataInputStream dis) throws IOException {
        return BasicHeader.read$((BasicHeader)this, dis);
    }

    private final long RIFF_MAGIC1() {
        return 8244233181932408593L;
    }

    private final long RIFF_MAGIC2() {
        return -6496960491292655616L;
    }

    private final long WAVE_MAGIC1() {
        return 8602286943506322193L;
    }

    private final long WAVE_MAGIC2() {
        return -8299851812298630262L;
    }

    private final long FMT_MAGIC1() {
        return 7380683049206076177L;
    }

    private final long FMT_MAGIC1_LE() {
        return 1284560478952254822L;
    }

    private final long FMT_MAGIC2() {
        return -8299851812298630262L;
    }

    private final long FMT_MAGIC2_LE() {
        return -8440996603401023092L;
    }

    private final long DATA_MAGIC1() {
        return 7233190440582566673L;
    }

    private final long DATA_MAGIC1_LE() {
        return 1284560480042770788L;
    }

    private final long DATA_MAGIC2() {
        return -8299851812298630262L;
    }

    private final long DATA_MAGIC2_LE() {
        return -8440996603401023092L;
    }

    private final long FACT_MAGIC1() {
        return 7377287018565128977L;
    }

    private final long FACT_MAGIC2() {
        return -8299851812298630262L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean identify(DataInputStream dis) throws IOException {
        if (dis.readLong() != 8244233181932408593L) return false;
        if (dis.readLong() != -6496960491292655616L) return false;
        dis.skipBytes(8);
        if (dis.readLong() != 8602286943506322193L) return false;
        if (dis.readLong() != -8299851812298630262L) return false;
        return true;
    }

    @Override
    public AudioFileHeader readDataInput(DataInput din) throws IOException {
        long riffMagic1 = din.readLong();
        long riffMagic2 = din.readLong();
        if (riffMagic1 != 8244233181932408593L || riffMagic2 != -6496960491292655616L) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(22).append("Not RIFF magic: 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(riffMagic1))).append(", 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(riffMagic2))).toString());
        }
        din.skipBytes(8);
        long waveMagic1 = din.readLong();
        long waveMagic2 = din.readLong();
        if (waveMagic1 != 8602286943506322193L || waveMagic2 != -8299851812298630262L) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(22).append("Not WAVE magic: 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(waveMagic1))).append(", 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(waveMagic2))).toString());
        }
        long chunkRem = 0L;
        AbstractRIFFHeader.FormatChunk fc = null;
        try {
            long chunkLen;
            while (true) {
                if (chunkRem > 0L) {
                    int skp = (int)package$.MODULE$.min(chunkRem, (long)Integer.MAX_VALUE);
                    din.skipBytes(skp);
                    chunkRem -= (long)skp;
                    continue;
                }
                long magic1 = din.readLong();
                long magic2 = din.readLong();
                chunkLen = AudioFileHeader$.MODULE$.readLittleLong(din) - 24L;
                chunkRem = chunkLen + 7L & 0xFFFFFFFFFFFFFFF8L;
                if (magic1 == 7380683049206076177L && magic2 == -8299851812298630262L) {
                    fc = this.readFormatChunk(din, (int)chunkRem);
                    chunkRem = fc.chunkSkip();
                    continue;
                }
                if (magic1 == 7233190440582566673L && magic2 == -8299851812298630262L) break;
            }
            return this.createReader(fc, AudioFileType$Wave64$.MODULE$, chunkLen);
        }
        catch (EOFException eOFException) {
            throw new IOException(new StringBuilder(31).append("Wave64").append(" header misses data chunk").toString());
        }
    }

    public Future<AudioFileHeader> readAsync(AsyncReadableByteChannel ch) {
        AsyncReadableByteBuffer ab = new AsyncReadableByteBuffer(ch, AsyncReadableByteBuffer$.MODULE$.$lessinit$greater$default$2());
        return ab.ensure(40).flatMap((Function1<BoxedUnit, Future> & Serializable)x$1 -> {
            long riffMagic1 = ab.buffer().getLong();
            long riffMagic2 = ab.buffer().getLong();
            if (riffMagic1 != 8244233181932408593L || riffMagic2 != -6496960491292655616L) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(22).append("Not RIFF magic: 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(riffMagic1))).append(", 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(riffMagic2))).toString());
            }
            ab.skip(8L);
            long waveMagic1 = ab.buffer().getLong();
            long waveMagic2 = ab.buffer().getLong();
            if (waveMagic1 != 8602286943506322193L || waveMagic2 != -8299851812298630262L) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(22).append("Not WAVE magic: 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(waveMagic1))).append(", 0x").append(RichLong$.MODULE$.toHexString$extension(Predef$.MODULE$.longWrapper(waveMagic2))).toString());
            }
            ab.buffer().order(ByteOrder.LITTLE_ENDIAN);
            return Wave64Header$.readChunk$1(null, ab);
        }, ab.executionContext());
    }

    @Override
    public final WritableAudioFileHeader createWriter(RandomAccessFile raf, AudioFileSpec spec, long factSmpNumOffset, long dataChunkLenOff) {
        return new Wave64Header.WritableFileHeader(raf, spec, factSmpNumOffset, dataChunkLenOff);
    }

    @Override
    public final AsyncWritableAudioFileHeader createAsyncWriter(AsyncWritableByteChannel ch, AudioFileSpec spec, long factSmpNumOffset, long dataChunkLenOff) {
        return new Wave64Header.AsyncWritableFileHeader(ch, spec, factSmpNumOffset, dataChunkLenOff);
    }

    @Override
    public final void writeRiffMagic(DataOutput dout, long fileSize) {
        dout.writeLong(8244233181932408593L);
        dout.writeLong(-6496960491292655616L);
        dout.writeLong(fileSize);
        dout.writeLong(8602286943506322193L);
        dout.writeLong(-8299851812298630262L);
    }

    @Override
    public final void writeFmtMagic(DataOutput dout, int fmtChunkSize) {
        dout.writeLong(7380683049206076177L);
        dout.writeLong(-8299851812298630262L);
        AudioFileHeader$.MODULE$.writeLittleLong(dout, fmtChunkSize);
    }

    @Override
    public final void writeFactChunk(DataOutput dout, long numFrames) {
        dout.writeLong(7377287018565128977L);
        dout.writeLong(-8299851812298630262L);
        AudioFileHeader$.MODULE$.writeLittleLong(dout, 32L);
        dout.writeLong(numFrames);
    }

    @Override
    public final void writeDataMagic(DataOutput dout, long dataChunkSize) {
        dout.writeLong(7233190440582566673L);
        dout.writeLong(-8299851812298630262L);
        AudioFileHeader$.MODULE$.writeLittleLong(dout, dataChunkSize);
    }

    @Override
    public final int cookieSize() {
        return 16;
    }

    @Override
    public final int chunkLenSize() {
        return 8;
    }

    @Override
    public final int chunkPad() {
        return 8;
    }

    private static final Future readChunk$1(AbstractRIFFHeader.FormatChunk fc, AsyncReadableByteBuffer ab$1) {
        return ab$1.ensure(24).flatMap((Function1<BoxedUnit, Future> & Serializable)x$2 -> {
            long magic1Le = ab$1.buffer().getLong();
            long magic2Le = ab$1.buffer().getLong();
            long chunkLen = ab$1.buffer().getLong() - 24L;
            long chunkRem = chunkLen + 7L & 0xFFFFFFFFFFFFFFF8L;
            if (magic1Le == 1284560478952254822L && magic2Le == -8440996603401023092L) {
                Future<AbstractRIFFHeader.FormatChunk> fcFut = MODULE$.readFormatChunkAsync(ab$1, (int)chunkRem);
                return fcFut.flatMap((Function1<AbstractRIFFHeader.FormatChunk, Future> & Serializable)fc1 -> {
                    int chunkRem1 = fc1.chunkSkip();
                    ab$1.skip(chunkRem1);
                    return Wave64Header$.readChunk$1(fc1, ab$1);
                }, ab$1.executionContext());
            }
            if (magic1Le == 1284560480042770788L && magic2Le == -8440996603401023092L) {
                ab$1.purge();
                if (fc != null) {
                    ReadableAudioFileHeader afh = MODULE$.createReader(fc, AudioFileType$Wave64$.MODULE$, chunkLen);
                    return Future$.MODULE$.successful(afh);
                }
                return Future$.MODULE$.failed(new IOException("Wave64 header misses FMT chunk"));
            }
            ab$1.skip(chunkRem);
            return Wave64Header$.readChunk$1(fc, ab$1);
        }, ab$1.executionContext());
    }

    private Wave64Header$() {
    }
}

