/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiofile.impl;

import de.sciss.asyncfile.AsyncReadableByteBuffer;
import de.sciss.asyncfile.AsyncReadableByteBuffer$;
import de.sciss.asyncfile.AsyncReadableByteChannel;
import de.sciss.asyncfile.AsyncWritableByteChannel;
import de.sciss.audiofile.AsyncWritableAudioFileHeader;
import de.sciss.audiofile.AudioFileHeader;
import de.sciss.audiofile.AudioFileHeader$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$Wave$;
import de.sciss.audiofile.ReadableAudioFileHeader;
import de.sciss.audiofile.WritableAudioFileHeader;
import de.sciss.audiofile.impl.AbstractRIFFHeader;
import de.sciss.audiofile.impl.BasicHeader;
import de.sciss.audiofile.impl.WaveHeader;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Function1;
import scala.Predef$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class WaveHeader$
implements AbstractRIFFHeader {
    public static final WaveHeader$ MODULE$ = new WaveHeader$();
    private static final int cookieSize;
    private static final int chunkLenSize;
    private static final int chunkPad;

    static {
        BasicHeader.$init$(MODULE$);
        AbstractRIFFHeader.$init$(MODULE$);
        cookieSize = 4;
        chunkLenSize = 4;
        chunkPad = 2;
    }

    @Override
    public final ReadableAudioFileHeader createReader(AbstractRIFFHeader.FormatChunk fc, AudioFileType tpe, long chunkLen) {
        return AbstractRIFFHeader.createReader$(this, fc, tpe, chunkLen);
    }

    @Override
    public final AbstractRIFFHeader.FormatChunk readFormatChunk(DataInput din, int chunkRem) {
        return AbstractRIFFHeader.readFormatChunk$(this, din, chunkRem);
    }

    @Override
    public final Future<AbstractRIFFHeader.FormatChunk> readFormatChunkAsync(AsyncReadableByteBuffer ab, int chunkRem) {
        return AbstractRIFFHeader.readFormatChunkAsync$(this, ab, chunkRem);
    }

    @Override
    public final AudioFileSpec fixOutputSpec(AudioFileSpec spec) {
        return AbstractRIFFHeader.fixOutputSpec$(this, spec);
    }

    @Override
    public final WritableAudioFileHeader write(DataOutputStream dos, AudioFileSpec spec) throws IOException {
        return AbstractRIFFHeader.write$((AbstractRIFFHeader)this, dos, spec);
    }

    @Override
    public final WritableAudioFileHeader write(RandomAccessFile raf, AudioFileSpec spec) throws IOException {
        return AbstractRIFFHeader.write$((AbstractRIFFHeader)this, raf, spec);
    }

    @Override
    public Future<AsyncWritableAudioFileHeader> writeAsync(AsyncWritableByteChannel ch, AudioFileSpec spec) {
        return AbstractRIFFHeader.writeAsync$(this, ch, spec);
    }

    @Override
    public final AudioFileHeader read(RandomAccessFile raf) throws IOException {
        return BasicHeader.read$((BasicHeader)this, raf);
    }

    @Override
    public final AudioFileHeader read(DataInputStream dis) throws IOException {
        return BasicHeader.read$((BasicHeader)this, dis);
    }

    private final int RIFF_MAGIC() {
        return 1380533830;
    }

    private final int WAVE_MAGIC() {
        return 1463899717;
    }

    private final int FMT_MAGIC() {
        return 1718449184;
    }

    private final int FMT_MAGIC_LE() {
        return 544501094;
    }

    private final int FACT_MAGIC() {
        return 1717658484;
    }

    private final int DATA_MAGIC() {
        return 1684108385;
    }

    private final int DATA_MAGIC_LE() {
        return 1635017060;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean identify(DataInputStream dis) throws IOException {
        if (dis.readInt() != 1380533830) return false;
        dis.readInt();
        if (dis.readInt() != 1463899717) return false;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public AudioFileHeader readDataInput(DataInput din) throws IOException {
        int riffMagic = din.readInt();
        if (riffMagic != 1380533830) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not RIFF magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(riffMagic))).toString());
        }
        din.readInt();
        int waveMagic = din.readInt();
        if (waveMagic != 1463899717) {
            throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not WAVE magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(waveMagic))).toString());
        }
        int chunkRem = 0;
        AbstractRIFFHeader.FormatChunk fc = null;
        try {
            block6: while (true) {
                Serializable serializable = chunkRem > 0 ? BoxesRunTime.boxToInteger(din.skipBytes(chunkRem)) : BoxedUnit.UNIT;
                int magic = din.readInt();
                int chunkLen = AudioFileHeader$.MODULE$.readLittleInt(din);
                chunkRem = chunkLen + 1 & 0xFFFFFFFE;
                int n = magic;
                switch (n) {
                    case 1718449184: {
                        fc = this.readFormatChunk(din, chunkRem);
                        chunkRem = fc.chunkSkip();
                        continue block6;
                    }
                    case 1684108385: {
                        return this.createReader(fc, AudioFileType$Wave$.MODULE$, chunkLen);
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            throw new IOException(new StringBuilder(29).append("WAVE").append(" header misses data chunk").toString());
        }
    }

    public Future<AudioFileHeader> readAsync(AsyncReadableByteChannel ch) {
        AsyncReadableByteBuffer ab = new AsyncReadableByteBuffer(ch, AsyncReadableByteBuffer$.MODULE$.$lessinit$greater$default$2());
        return ab.ensure(12).flatMap((Function1<BoxedUnit, Future> & Serializable)x$4 -> {
            int riffMagic = ab.buffer().getInt();
            if (riffMagic != 1380533830) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not RIFF magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(riffMagic))).toString());
            }
            ab.buffer().getInt();
            int waveMagic = ab.buffer().getInt();
            if (waveMagic != 1463899717) {
                throw AudioFileHeader$.MODULE$.formatError(new StringBuilder(18).append("Not WAVE magic: 0x").append(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(waveMagic))).toString());
            }
            ab.buffer().order(ByteOrder.LITTLE_ENDIAN);
            return WaveHeader$.readChunk$1(null, ab);
        }, ab.executionContext());
    }

    @Override
    public final WritableAudioFileHeader createWriter(RandomAccessFile raf, AudioFileSpec spec, long factSmpNumOffset, long dataChunkLenOff) {
        return new WaveHeader.WritableFileHeader(raf, spec, factSmpNumOffset, dataChunkLenOff);
    }

    @Override
    public final AsyncWritableAudioFileHeader createAsyncWriter(AsyncWritableByteChannel ch, AudioFileSpec spec, long factSmpNumOffset, long dataChunkLenOff) {
        return new WaveHeader.AsyncWritableFileHeader(ch, spec, factSmpNumOffset, dataChunkLenOff);
    }

    @Override
    public final void writeRiffMagic(DataOutput dout, long fileSize) {
        dout.writeInt(1380533830);
        AudioFileHeader$.MODULE$.writeLittleInt(dout, (int)(fileSize - 8L));
        dout.writeInt(1463899717);
    }

    @Override
    public final void writeFmtMagic(DataOutput dout, int fmtChunkSize) {
        dout.writeInt(1718449184);
        AudioFileHeader$.MODULE$.writeLittleInt(dout, fmtChunkSize - 8);
    }

    @Override
    public final void writeFactChunk(DataOutput dout, long numFrames) {
        dout.writeInt(1717658484);
        AudioFileHeader$.MODULE$.writeLittleInt(dout, 4);
        AudioFileHeader$.MODULE$.writeLittleInt(dout, (int)numFrames);
    }

    @Override
    public final void writeDataMagic(DataOutput dout, long dataChunkSize) {
        dout.writeInt(1684108385);
        AudioFileHeader$.MODULE$.writeLittleInt(dout, (int)(dataChunkSize - 8L));
    }

    @Override
    public final int cookieSize() {
        return cookieSize;
    }

    @Override
    public final int chunkLenSize() {
        return chunkLenSize;
    }

    @Override
    public final int chunkPad() {
        return chunkPad;
    }

    private static final Future readChunk$1(AbstractRIFFHeader.FormatChunk fc, AsyncReadableByteBuffer ab$2) {
        return ab$2.ensure(8).flatMap((Function1<BoxedUnit, Future> & Serializable)x$5 -> {
            int magicLe = ab$2.buffer().getInt();
            int chunkLen = ab$2.buffer().getInt();
            int chunkRem = chunkLen + 1 & 0xFFFFFFFE;
            int n = magicLe;
            switch (n) {
                case 544501094: {
                    Future<AbstractRIFFHeader.FormatChunk> fcFut = MODULE$.readFormatChunkAsync(ab$2, chunkRem);
                    return fcFut.flatMap((Function1<AbstractRIFFHeader.FormatChunk, Future> & Serializable)fc1 -> {
                        int chunkRem1 = fc1.chunkSkip();
                        ab$2.skip(chunkRem1);
                        return WaveHeader$.readChunk$1(fc1, ab$2);
                    }, ab$2.executionContext());
                }
                case 1635017060: {
                    ab$2.purge();
                    if (fc != null) {
                        ReadableAudioFileHeader afh = MODULE$.createReader(fc, AudioFileType$Wave$.MODULE$, chunkLen);
                        return Future$.MODULE$.successful(afh);
                    }
                    return Future$.MODULE$.failed(new IOException("WAVE header misses FMT chunk"));
                }
            }
            ab$2.skip(chunkRem);
            return WaveHeader$.readChunk$1(fc, ab$2);
        }, ab$2.executionContext());
    }

    private WaveHeader$() {
    }
}

