/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.audiowidgets.j.ui;

import de.sciss.audiowidgets.Util$;
import java.awt.Color;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import scala.math.package$;

public final class NimbusHelper$ {
    public static final NimbusHelper$ MODULE$ = new NimbusHelper$();
    private static UIDefaults nimbusDefaults;
    private static final int STATE_ENABLED;
    private static final int STATE_OVER;
    private static final int STATE_FOCUSED;
    private static final int STATE_PRESSED;
    private static final boolean isDark;
    private static final Color defaultFocusColor;
    private static final Color defaultSelectionBackgroundColor;
    private static final Color defaultBaseColor;
    private static final Color defaultControlHighlightColor;
    private static final Color defaultTextColor;
    private static final Color defaultSelectedTextColor;
    private static final float[] hsbArr;
    private static volatile boolean bitmap$0;

    static {
        STATE_ENABLED = 1;
        STATE_OVER = 2;
        STATE_FOCUSED = 4;
        STATE_PRESSED = 8;
        isDark = Util$.MODULE$.isDarkSkin();
        defaultFocusColor = MODULE$.isDark() ? new Color(48, 77, 130) : new Color(115, 164, 209, 255);
        defaultSelectionBackgroundColor = new Color(57, 105, 138, 255);
        defaultBaseColor = MODULE$.isDark() ? new Color(32, 36, 40) : new Color(51, 98, 140, 255);
        defaultControlHighlightColor = MODULE$.isDark() ? new Color(16, 16, 16) : new Color(233, 236, 242, 255);
        defaultTextColor = MODULE$.isDark() ? new Color(220, 220, 220) : Color.black;
        defaultSelectedTextColor = MODULE$.isDark() ? Color.black : Color.white;
        hsbArr = new float[3];
    }

    /*
     * WARNING - void declaration
     */
    public Color focusColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("nimbusFocus");
        return c == null ? this.defaultFocusColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color baseColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("nimbusBase");
        return c == null ? this.defaultBaseColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color textColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("text");
        return c == null ? this.defaultTextColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color selectedTextColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("selectedText");
        return c == null ? this.defaultSelectedTextColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color controlHighlightColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("controlHighlight");
        return c == null ? this.defaultControlHighlightColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color selectionBackgroundColor() {
        void var1_1;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("nimbusSelectionBackground");
        return c == null ? this.defaultSelectionBackgroundColor() : var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Color blueGreyColor(Color base) {
        void var2_2;
        Color c = this.nimbusDefaults() == null ? null : this.nimbusDefaults().getColor("nimbusBlueGrey");
        return c == null ? this.defaultBlueGreyColor(base) : var2_2;
    }

    private Color defaultBlueGreyColor(Color base) {
        return this.isDark() ? base : this.adjustColor(base, 0.032459438f, -0.52518797f, 0.19607842f, 0);
    }

    public Color adjustColor(Color c, float hueOffset, float satOffset, float briOffset, int alphaOffset) {
        boolean sameAlpha;
        boolean sameColor = hueOffset == 0.0f && satOffset == 0.0f && briOffset == 0.0f;
        boolean bl = sameAlpha = alphaOffset == 0;
        if (sameColor) {
            if (sameAlpha) {
                return c;
            }
            int cAlpha = c.getAlpha();
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), package$.MODULE$.max(0, package$.MODULE$.min(255, cAlpha + alphaOffset)));
        }
        Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), this.hsbArr());
        float hue = this.hsbArr()[0] + hueOffset;
        float sat = package$.MODULE$.max(0.0f, package$.MODULE$.min(1.0f, this.hsbArr()[1] + satOffset));
        float bri = package$.MODULE$.max(0.0f, package$.MODULE$.min(1.0f, this.hsbArr()[2] + briOffset));
        int rgb = Color.HSBtoRGB(hue, sat, bri);
        int cAlpha = c.getAlpha();
        int a = sameAlpha ? cAlpha : package$.MODULE$.max(0, package$.MODULE$.min(255, cAlpha + alphaOffset));
        int rgba = rgb & 0xFFFFFF | a << 24;
        return new Color(rgba, true);
    }

    public Color mixColorWithAlpha(Color base, Color mix) {
        if (mix == null) {
            return base;
        }
        int a0 = mix.getAlpha();
        if (a0 == 0) {
            return base;
        }
        if (a0 == 255) {
            return mix;
        }
        float wm = (float)a0 / (float)255;
        float wb = 1.0f - wm;
        int r = (int)((float)base.getRed() * wb + (float)mix.getRed() * wm + 0.5f);
        int g = (int)((float)base.getGreen() * wb + (float)mix.getGreen() * wm + 0.5f);
        int b = (int)((float)base.getBlue() * wb + (float)mix.getBlue() * wm + 0.5f);
        return new Color(r, g, b);
    }

    public final int STATE_ENABLED() {
        return STATE_ENABLED;
    }

    public final int STATE_OVER() {
        return STATE_OVER;
    }

    public final int STATE_FOCUSED() {
        return STATE_FOCUSED;
    }

    public final int STATE_PRESSED() {
        return STATE_PRESSED;
    }

    private UIDefaults nimbusDefaults$lzycompute() {
        NimbusHelper$ nimbusHelper$ = this;
        synchronized (nimbusHelper$) {
            if (!bitmap$0) {
                LookAndFeel current = UIManager.getLookAndFeel();
                String string = current.getName().toLowerCase();
                String string2 = "nimbus";
                nimbusDefaults = !(string != null ? !string.equals(string2) : string2 != null) ? current.getDefaults() : null;
                bitmap$0 = true;
            }
        }
        return nimbusDefaults;
    }

    private UIDefaults nimbusDefaults() {
        return !bitmap$0 ? this.nimbusDefaults$lzycompute() : nimbusDefaults;
    }

    public boolean isNimbus() {
        return this.nimbusDefaults() != null;
    }

    private final boolean isDark() {
        return isDark;
    }

    public boolean isDarkSkin() {
        return this.isDark();
    }

    private final Color defaultFocusColor() {
        return defaultFocusColor;
    }

    private final Color defaultSelectionBackgroundColor() {
        return defaultSelectionBackgroundColor;
    }

    private final Color defaultBaseColor() {
        return defaultBaseColor;
    }

    private final Color defaultControlHighlightColor() {
        return defaultControlHighlightColor;
    }

    private final Color defaultTextColor() {
        return defaultTextColor;
    }

    private final Color defaultSelectedTextColor() {
        return defaultSelectedTextColor;
    }

    private final float[] hsbArr() {
        return hsbArr;
    }

    private NimbusHelper$() {
    }
}

