/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop;

import de.sciss.desktop.Desktop;
import de.sciss.desktop.Platform;
import de.sciss.desktop.impl.DummyPlatform$;
import java.awt.Desktop;
import java.awt.Image;
import java.io.File;
import java.io.Serializable;
import java.net.URI;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.collection.immutable.$colon$colon;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.ExecutionContext$Implicits$;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.util.Success;
import scala.util.Try;

public final class Desktop$ {
    public static final Desktop$ MODULE$;
    private static Platform platform;
    private static boolean isQuitSupported;
    private static final String osName;
    private static final boolean isLinux;
    private static final boolean isMac;
    private static final boolean isWindows;
    private static final int majorJavaVersion;
    private static final Object sync;
    private static IndexedSeq<Function0<Future<BoxedUnit>>> quitAcceptors;
    private static volatile byte bitmap$0;

    static {
        int i;
        MODULE$ = new Desktop$();
        osName = (String)scala.sys.package$.MODULE$.props().apply("os.name");
        isLinux = MODULE$.osName().contains("Linux");
        isMac = MODULE$.osName().contains("Mac");
        isWindows = MODULE$.osName().contains("Windows");
        String s = (String)scala.sys.package$.MODULE$.props().apply("java.version");
        String m = s.startsWith("1.") ? s.substring(2, 3) : ((i = s.indexOf(".")) > 0 ? s.substring(0, i) : s);
        majorJavaVersion = Desktop$.liftedTree1$1(m);
        sync = new Object();
        quitAcceptors = package$.MODULE$.Vector().empty();
    }

    private String osName() {
        return osName;
    }

    public boolean isLinux() {
        return isLinux;
    }

    public boolean isMac() {
        return isMac;
    }

    public boolean isWindows() {
        return isWindows;
    }

    private <A> A getModule(String name) {
        Class<?> clz = Class.forName(new StringBuilder(23).append("de.sciss.desktop.impl.").append(name).append("$").toString());
        return (A)clz.getField("MODULE$").get(null);
    }

    public int majorJavaVersion() {
        return majorJavaVersion;
    }

    private Platform platform$lzycompute() {
        Desktop$ desktop$ = this;
        synchronized (desktop$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                platform = this.liftedTree2$1();
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return platform;
    }

    public Platform platform() {
        return (byte)(bitmap$0 & 1) == 0 ? this.platform$lzycompute() : platform;
    }

    private boolean hasEAWT() {
        boolean bl;
        try {
            Class.forName("com.apple.eawt.Application");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    private boolean hasClassicEAWT() {
        boolean bl;
        try {
            Class.forName("com.apple.eawt.QuitResponse");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        return bl;
    }

    public void revealFile(File file) {
        this.platform().revealFile(file);
    }

    public void moveFileToTrash(File file) {
        this.platform().moveFileToTrash(file);
    }

    public void setDockBadge(Option<String> label) {
        this.platform().setDockBadge(label);
    }

    public void setDockImage(Image image) {
        this.platform().setDockImage(image);
    }

    public void requestUserAttention(boolean repeat) {
        this.platform().requestUserAttention(repeat);
    }

    public boolean requestUserAttention$default$1() {
        return false;
    }

    public void requestForeground(boolean allWindows) {
        this.platform().requestForeground(allWindows);
    }

    public boolean requestForeground$default$1() {
        return false;
    }

    private Desktop jDesktop() {
        return Desktop.getDesktop();
    }

    public void openFile(File file) {
        this.jDesktop().open(file);
    }

    public void editFile(File file) {
        this.jDesktop().edit(file);
    }

    public void printFile(File file) {
        this.jDesktop().print(file);
    }

    public void browseURI(URI uri) {
        this.jDesktop().browse(uri);
    }

    public void composeMail(Option<URI> uri) {
        Desktop desktop = this.jDesktop();
        uri.fold(() -> MODULE$.jDesktop().mail(), (Function1<URI, Object> & Serializable)x$1 -> {
            desktop.mail(x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Option<URI> composeMail$default$1() {
        return None$.MODULE$;
    }

    public PartialFunction<Desktop.Update, BoxedUnit> addListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        return this.platform().addListener(pf);
    }

    public void removeListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        this.platform().removeListener(pf);
    }

    private Object sync() {
        return sync;
    }

    private IndexedSeq<Function0<Future<BoxedUnit>>> quitAcceptors() {
        return quitAcceptors;
    }

    private void quitAcceptors_$eq(IndexedSeq<Function0<Future<BoxedUnit>>> x$1) {
        quitAcceptors = x$1;
    }

    private boolean isQuitSupported$lzycompute() {
        Desktop$ desktop$ = this;
        synchronized (desktop$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                isQuitSupported = this.initQuit();
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return isQuitSupported;
    }

    public boolean isQuitSupported() {
        return (byte)(bitmap$0 & 2) == 0 ? this.isQuitSupported$lzycompute() : isQuitSupported;
    }

    private boolean initQuit() {
        return this.platform().setQuitHandler((Function0<Future<BoxedUnit>>)(Function0<Future> & Serializable)() -> MODULE$.mayQuit());
    }

    public Function0<Future<BoxedUnit>> addQuitAcceptor(Function0<Future<BoxedUnit>> accept) {
        Function0<Future<BoxedUnit>> function0;
        Object object = this.sync();
        synchronized (object) {
            this.isQuitSupported();
            Function0<Future<BoxedUnit>> fun = accept;
            this.quitAcceptors_$eq((IndexedSeq)this.quitAcceptors().$colon$plus(fun));
            function0 = fun;
        }
        return function0;
    }

    public void removeQuitAcceptor(Function0<Future<BoxedUnit>> accept) {
        Object object = this.sync();
        synchronized (object) {
            int idx = this.quitAcceptors().indexOf(accept);
            if (idx >= 0) {
                this.quitAcceptors_$eq((IndexedSeq)this.quitAcceptors().patch(idx, package$.MODULE$.Nil(), 1));
            }
        }
    }

    public Future<BoxedUnit> mayQuit() {
        IndexedSeq<Function0<Future<BoxedUnit>>> indexedSeq;
        Object object = this.sync();
        synchronized (object) {
            indexedSeq = this.quitAcceptors();
        }
        IndexedSeq<Function0<Future<BoxedUnit>>> allAcc = indexedSeq;
        return this.loop$1(Future$.MODULE$.successful(BoxedUnit.UNIT), allAcc.toList());
    }

    private static final /* synthetic */ int liftedTree1$1(String m$1) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m$1));
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    private final /* synthetic */ Platform liftedTree2$1() {
        Platform platform;
        block5: {
            try {
                if (this.isLinux()) {
                    platform = (Platform)this.getModule("LinuxPlatform");
                    break block5;
                }
                if (this.isMac() && this.hasEAWT()) {
                    platform = this.hasClassicEAWT() ? (Platform)this.getModule("MacPlatform") : (this.majorJavaVersion() >= 9 ? (Platform)this.getModule("MacJava9Platform") : DummyPlatform$.MODULE$);
                    break block5;
                }
                if (this.majorJavaVersion() >= 9) {
                    platform = (Platform)this.getModule("Java9Platform");
                    break block5;
                }
                platform = DummyPlatform$.MODULE$;
            }
            catch (Throwable throwable) {
                platform = DummyPlatform$.MODULE$;
            }
        }
        return platform;
    }

    private final Future loop$1(Future in, List rem) {
        Future future;
        block2: {
            List list;
            block3: {
                Future future2;
                List tail;
                Function0 head;
                while (true) {
                    Some some;
                    Try try_;
                    list = rem;
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list2 = list;
                    if (!(nil$ != null ? !((Object)nil$).equals(list2) : list2 != null)) {
                        future = in;
                        break block2;
                    }
                    if (!(list instanceof $colon$colon)) break block3;
                    $colon$colon $colon$colon = ($colon$colon)list;
                    head = (Function0)$colon$colon.head();
                    tail = $colon$colon.next$access$1();
                    Option option = in.value();
                    if (!(option instanceof Some) || !((try_ = (Try)(some = (Some)option).value()) instanceof Success)) break;
                    Success success = (Success)try_;
                    BoxedUnit boxedUnit = (BoxedUnit)success.value();
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    BoxedUnit boxedUnit3 = boxedUnit;
                    if (boxedUnit2 != null ? !((Object)boxedUnit2).equals(boxedUnit3) : boxedUnit3 != null) break;
                    Future andThen = (Future)head.apply();
                    rem = tail;
                    in = andThen;
                }
                future = future2 = in.flatMap((Function1<BoxedUnit, Future> & Serializable)x$1 -> {
                    Future andThen = (Future)head.apply();
                    return this.loop$1(andThen, tail);
                }, ExecutionContext$Implicits$.MODULE$.global());
                break block2;
            }
            throw new MatchError(list);
        }
        return future;
    }

    private Desktop$() {
    }
}

