/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop;

import de.sciss.desktop.Window;
import de.sciss.swingplus.DoClickAction;
import de.sciss.swingplus.DoClickAction$;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.RichChar$;
import scala.swing.AbstractButton;
import scala.swing.Action;
import scala.swing.Action$;
import scala.swing.Component;
import scala.swing.Swing$;
import scala.swing.TabbedPane;
import scala.swing.TabbedPane$selection$;
import scala.swing.event.Key$;
import scala.swing.event.Key$Modifier$;

public final class Util$ {
    public static final Util$ MODULE$ = new Util$();

    public void centerOnScreen(Window w) {
        this.placeWindow(w, 0.5f, 0.5f, 0);
    }

    public void delay(int millis, Function0<BoxedUnit> block) {
        Timer timer = new Timer(millis, Swing$.MODULE$.ActionListener((Function1<ActionEvent, BoxedUnit>)(Function1<ActionEvent, Object> & Serializable)x$1 -> {
            block.apply$mcV$sp();
            return BoxedUnit.UNIT;
        }));
        timer.setRepeats(false);
        timer.start();
    }

    public void fixSize(Component c) {
        Dimension d = c.preferredSize();
        c.preferredSize_$eq(d);
        c.minimumSize_$eq(d);
        c.maximumSize_$eq(d);
    }

    public void fixWidth(Component c, int width) {
        Dimension pref = c.preferredSize();
        int w = width < 0 ? pref.width : width;
        Dimension min = c.minimumSize();
        Dimension max = c.maximumSize();
        pref.width = w;
        min.width = w;
        max.width = w;
        c.preferredSize_$eq(pref);
        c.minimumSize_$eq(min);
        c.maximumSize_$eq(max);
    }

    public int fixWidth$default$2() {
        return -1;
    }

    public void sameWidths(Seq<Component> c) {
        IntRef w = IntRef.create(0);
        c.foreach((Function1<Component, Object> & Serializable)comp -> {
            Util$.$anonfun$sameWidths$1(w, comp);
            return BoxedUnit.UNIT;
        });
        c.foreach((Function1<Component, Object> & Serializable)comp -> {
            Util$.$anonfun$sameWidths$2(w, comp);
            return BoxedUnit.UNIT;
        });
    }

    public Rectangle maximumWindowBounds() {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        return ge.getMaximumWindowBounds();
    }

    public void placeWindow(Window w, float horizontal, float vertical, int padding) {
        Rectangle bs = this.maximumWindowBounds();
        Dimension b = w.size();
        int x = (int)(horizontal * (float)(bs.width - padding * 2 - b.width)) + bs.x + padding;
        int y = (int)(vertical * (float)(bs.height - padding * 2 - b.height)) + bs.y + padding;
        w.location_$eq(new Point(x, y));
    }

    public String wordWrap(String s, int margin) {
        int sz = s.length();
        if (sz <= margin) {
            return s;
        }
        int i = 0;
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        while (i < sz) {
            int j = s.lastIndexOf(" ", i + margin);
            boolean found = j > i;
            int k = found ? j : i + margin;
            sb.append(s.substring(i, package$.MODULE$.min(sz, k)));
            i = found ? k + 1 : k;
            Serializable serializable = i < sz ? sb.append('\n') : BoxedUnit.UNIT;
        }
        return sb.toString();
    }

    public int wordWrap$default$2() {
        return 80;
    }

    public String formatClassName(Class<?> x) {
        String cn0 = x.getName();
        int i = cn0.lastIndexOf(46);
        String cn = cn0.substring(i + 1);
        int len = cn.length();
        scala.collection.mutable.StringBuilder b = new scala.collection.mutable.StringBuilder(len + len / 2);
        boolean wasUpper = true;
        for (int j = 0; j < len; ++j) {
            char c = cn.charAt(j);
            boolean isUpper = RichChar$.MODULE$.isUpper$extension(Predef$.MODULE$.charWrapper(c));
            Serializable serializable = !wasUpper && isUpper ? b.append(' ') : BoxedUnit.UNIT;
            b.append(c);
            wasUpper = isUpper;
        }
        return b.result();
    }

    public String formatException(Throwable e, int margin, int stackTraceLines) {
        Serializable serializable;
        Serializable serializable2;
        String loc;
        String message;
        String name = e == null ? "Exception" : this.formatClassName(e.getClass());
        scala.collection.mutable.StringBuilder strBuf = new scala.collection.mutable.StringBuilder(name);
        String string = e == null ? null : (message = (loc = e.getLocalizedMessage()) == null ? e.getMessage() : loc);
        if (message != null) {
            strBuf.append(":\n");
            serializable2 = strBuf.append(this.wordWrap(message, margin));
        } else {
            serializable2 = BoxedUnit.UNIT;
        }
        if (stackTraceLines > 0) {
            String stackS = ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps(e.getStackTrace())).take(stackTraceLines).map((Function1<StackTraceElement, String> & Serializable)x$2 -> new StringBuilder(6).append("   at ").append(x$2).toString()).mkString("\n");
            strBuf.append("\n");
            serializable = strBuf.append(stackS);
        } else {
            serializable = BoxedUnit.UNIT;
        }
        return strBuf.result();
    }

    public int formatException$default$2() {
        return 80;
    }

    public int formatException$default$3() {
        return 10;
    }

    public void setInitialFocus(Component c) {
        AncestorListener adapter = new AncestorListener(c){
            private final Component c$1;

            public void ancestorAdded(AncestorEvent e) {
                this.c$1.peer().removeAncestorListener(this);
                this.c$1.requestFocusInWindow();
            }

            public void ancestorMoved(AncestorEvent e) {
            }

            public void ancestorRemoved(AncestorEvent e) {
            }
            {
                this.c$1 = c$1;
            }
        };
        c.peer().addAncestorListener(adapter);
    }

    public void addGlobalKey(AbstractButton b, KeyStroke keyStroke) {
        DoClickAction click = DoClickAction$.MODULE$.apply(b);
        b.peer().getActionMap().put("click", click.peer());
        b.peer().getInputMap(2).put(keyStroke, "click");
    }

    public void addGlobalKeyWhenVisible(AbstractButton b, KeyStroke keyStroke) {
        Action click = Action$.MODULE$.apply(null, () -> {
            block0: {
                if (!b.showing()) break block0;
                b.doClick();
            }
        });
        b.peer().getActionMap().put("click", click.peer());
        b.peer().getInputMap(2).put(keyStroke, "click");
    }

    public void addGlobalAction(Component c, String name, KeyStroke keyStroke, Function0<BoxedUnit> body) {
        Action a = Action$.MODULE$.apply(null, body);
        c.peer().getActionMap().put(name, a.peer());
        c.peer().getInputMap(2).put(keyStroke, name);
    }

    public void addTabNavigation(TabbedPane tabs) {
        int mod = Key$Modifier$.MODULE$.Alt();
        this.addGlobalAction(tabs, "prev", KeyStroke.getKeyStroke(Key$.MODULE$.Left().id(), mod), () -> {
            TabbedPane$selection$ sel;
            int idx = (sel = tabs.selection()).index() - 1;
            sel.index_$eq(idx >= 0 ? idx : tabs.pages().size() - 1);
        });
        this.addGlobalAction(tabs, "next", KeyStroke.getKeyStroke(Key$.MODULE$.Right().id(), mod), () -> {
            TabbedPane$selection$ sel;
            int idx = (sel = tabs.selection()).index() + 1;
            sel.index_$eq(idx < tabs.pages().size() ? idx : 0);
        });
    }

    public String keyStrokeText(KeyStroke stroke) {
        Serializable serializable;
        int mod = stroke.getModifiers();
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        if (mod > 0) {
            sb.append(KeyEvent.getKeyModifiersText(mod));
            serializable = sb.append('+');
        } else {
            serializable = BoxedUnit.UNIT;
        }
        sb.append(KeyEvent.getKeyText(stroke.getKeyCode()));
        return sb.result();
    }

    public static final /* synthetic */ void $anonfun$sameWidths$1(IntRef w$1, Component comp) {
        Dimension pref = comp.preferredSize();
        w$1.elem = package$.MODULE$.max(w$1.elem, pref.width);
    }

    public static final /* synthetic */ void $anonfun$sameWidths$2(IntRef w$1, Component comp) {
        Dimension pref = comp.preferredSize();
        Dimension min = comp.minimumSize();
        Dimension max = comp.maximumSize();
        pref.width = w$1.elem;
        min.width = w$1.elem;
        max.width = w$1.elem;
        comp.preferredSize_$eq(pref);
        comp.minimumSize_$eq(min);
        comp.maximumSize_$eq(max);
    }

    private Util$() {
    }
}

