/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.desktop.impl;

import de.sciss.desktop.Desktop;
import de.sciss.desktop.Platform;
import de.sciss.file.package$RichFile$;
import java.awt.Image;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.concurrent.Future;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process;

public final class LinuxPlatform$
implements Platform {
    public static final LinuxPlatform$ MODULE$ = new LinuxPlatform$();
    private static final String[] execDirs = (String[])((Object[])new String[]{"/usr/local/bin", "/usr/bin"});

    public String toString() {
        return "LinuxPlatform";
    }

    private Option<File> findExec(String fileName) {
        String[] folders = execDirs;
        for (int i = 0; i < folders.length; ++i) {
            String folder = folders[i];
            File f = new File(folder, fileName);
            if (!f.canExecute()) continue;
            return new Some<File>(f);
        }
        return None$.MODULE$;
    }

    @Override
    public void revealFile(File file) {
        File fileAbs = package$RichFile$.MODULE$.absolute$extension(de.sciss.file.package$.MODULE$.RichFile(file));
        Option<File> option = this.findExec("nautilus");
        if (option instanceof Some) {
            Some some = (Some)option;
            File cmd2 = (File)some.value();
            scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{package$RichFile$.MODULE$.path$extension(de.sciss.file.package$.MODULE$.RichFile(cmd2)), package$RichFile$.MODULE$.path$extension(de.sciss.file.package$.MODULE$.RichFile(fileAbs))}))).run();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.findExec("xdg-open").foreach((Function1<File, Object> & Serializable)cmd -> {
                LinuxPlatform$.$anonfun$revealFile$1(fileAbs, cmd);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    private File xdgDataHome() {
        return (File)scala.sys.package$.MODULE$.env().get("XDG_DATA_HOME").fold((Function0<File> & Serializable)() -> package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(de.sciss.file.package$.MODULE$.userHome()), ".local")), "share"), (Function1<String, File> & Serializable)path -> de.sciss.file.package$.MODULE$.file((String)path));
    }

    private File createUniqueFile(File parent, String base, String ext) {
        String ext1 = ext.isEmpty() || ext.charAt(0) == '.' ? ext : new StringBuilder(1).append(".").append(ext).toString();
        return this.loop$1(1, base, ext1, parent);
    }

    private String escapedPath(File f) {
        String u = f.toURI().toString();
        Predef$.MODULE$.assert(u.startsWith("file:"));
        return u.substring(5);
    }

    @Override
    public void moveFileToTrash(File file) {
        block3: {
            File file2;
            File trash = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(this.xdgDataHome()), "Trash");
            Serializable serializable = !trash.exists() ? BoxesRunTime.boxToBoolean(trash.mkdirs()) : BoxedUnit.UNIT;
            File files2 = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(trash), "files");
            Serializable serializable2 = !files2.exists() ? BoxesRunTime.boxToBoolean(files2.mkdir()) : BoxedUnit.UNIT;
            File target0 = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(files2), package$RichFile$.MODULE$.name$extension(de.sciss.file.package$.MODULE$.RichFile(file)));
            if (!target0.exists()) {
                file2 = target0;
            } else {
                Tuple2<String, String> tuple2 = package$RichFile$.MODULE$.baseAndExt$extension(de.sciss.file.package$.MODULE$.RichFile(file));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String base = tuple2._1();
                String ext = tuple2._2();
                Tuple2<String, String> tuple22 = new Tuple2<String, String>(base, ext);
                Tuple2<String, String> tuple23 = tuple22;
                String base2 = tuple23._1();
                String ext2 = tuple23._2();
                file2 = this.createUniqueFile(files2, base2, ext2);
            }
            File targetFile = file2;
            File info = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(trash), "info");
            Serializable serializable3 = !info.exists() ? BoxesRunTime.boxToBoolean(info.mkdir()) : BoxedUnit.UNIT;
            File infoFile = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(info), new StringBuilder(10).append(package$RichFile$.MODULE$.name$extension(de.sciss.file.package$.MODULE$.RichFile(targetFile))).append(".trashinfo").toString());
            int mvRes = scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"mv", package$RichFile$.MODULE$.absolutePath$extension(de.sciss.file.package$.MODULE$.RichFile(file)), package$RichFile$.MODULE$.path$extension(de.sciss.file.package$.MODULE$.RichFile(targetFile))}))).$bang();
            if (mvRes != 0) break block3;
            String sourceEscape = this.escapedPath(package$RichFile$.MODULE$.absolute$extension(de.sciss.file.package$.MODULE$.RichFile(file)));
            String deletionDate = new SimpleDateFormat("YYYY-MM-DD'T'hh:mm:ss", Locale.US).format(new Date());
            String infoString = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(69).append("[Trash Info]\n           |Path=").append(sourceEscape).append("\n           |DeletionDate=").append(deletionDate).append("\n           |").toString()));
            FileOutputStream infoS = new FileOutputStream(infoFile);
            infoS.write(infoString.getBytes("UTF-8"));
            infoS.close();
        }
    }

    @Override
    public PartialFunction<Desktop.Update, BoxedUnit> addListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
        return pf;
    }

    @Override
    public void removeListener(PartialFunction<Desktop.Update, BoxedUnit> pf) {
    }

    @Override
    public void setDockImage(Image image) {
    }

    @Override
    public void setDockBadge(Option<String> label) {
    }

    @Override
    public void requestUserAttention(boolean repeat) {
    }

    @Override
    public void requestForeground(boolean allWindows) {
    }

    @Override
    public boolean setQuitHandler(Function0<Future<BoxedUnit>> test) {
        return false;
    }

    @Override
    public boolean setAboutHandler(Function0<BoxedUnit> action) {
        return false;
    }

    @Override
    public boolean setPreferencesHandler(Function0<BoxedUnit> action) {
        return false;
    }

    public static final /* synthetic */ void $anonfun$revealFile$1(File fileAbs$1, File cmd) {
        package$RichFile$.MODULE$.parentOption$extension(de.sciss.file.package$.MODULE$.RichFile(fileAbs$1)).foreach((Function1<File, Process> & Serializable)parent -> scala.sys.process.package$.MODULE$.stringSeqToProcess((Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{package$RichFile$.MODULE$.path$extension(de.sciss.file.package$.MODULE$.RichFile(cmd)), package$RichFile$.MODULE$.path$extension(de.sciss.file.package$.MODULE$.RichFile((File)parent))}))).run());
    }

    private final File loop$1(int count, String base$1, String ext1$1, File parent$1) {
        File test;
        while (true) {
            String name = new StringBuilder(1).append(base$1).append("-").append(count).append(ext1$1).toString();
            test = package$RichFile$.MODULE$.$div$extension(de.sciss.file.package$.MODULE$.RichFile(parent$1), name);
            if (!test.exists()) break;
            ++count;
        }
        return test;
    }

    private LinuxPlatform$() {
    }
}

