/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.dsp;

import scala.math.package$;

public final class Complex$ {
    public static final Complex$ MODULE$ = new Complex$();

    public void rect2Polar(double[] src, int srcOff, double[] dest, int destOff, int length) {
        if (src == dest && srcOff < destOff) {
            int i = srcOff + length;
            int j = destOff + length;
            while (i > srcOff) {
                double d1 = src[--i];
                double d2 = src[--i];
                dest[--j] = package$.MODULE$.atan2(d1, d2);
                dest[--j] = package$.MODULE$.sqrt(d1 * d1 + d2 * d2);
            }
        } else {
            int i = srcOff;
            int j = destOff;
            int stop = srcOff + length;
            while (i < stop) {
                double d2 = src[i];
                double d1 = src[++i];
                ++i;
                dest[j] = package$.MODULE$.sqrt(d1 * d1 + d2 * d2);
                dest[++j] = package$.MODULE$.atan2(d1, d2);
                ++j;
            }
        }
    }

    public void polar2Rect(double[] src, int srcOff, double[] dest, int destOff, int length) {
        if (src == dest && srcOff < destOff) {
            int i = srcOff + length;
            int j = destOff + length;
            while (i > srcOff) {
                double d1 = src[--i];
                double d2 = src[--i];
                dest[--j] = d2 * package$.MODULE$.sin(d1);
                dest[--j] = d2 * package$.MODULE$.cos(d1);
            }
        } else {
            int i = srcOff;
            int j = destOff;
            int stop = srcOff + length;
            while (i < stop) {
                double d2 = src[i];
                double d1 = src[++i];
                ++i;
                dest[j] = d2 * package$.MODULE$.cos(d1);
                dest[++j] = d2 * package$.MODULE$.sin(d1);
                ++j;
            }
        }
    }

    public void complexMult(double[] src1, int srcOff1, double[] src2, int srcOff2, double[] dest, int destOff, int length) {
        if (src1 == dest && srcOff1 < destOff || src2 == dest && srcOff2 < destOff) {
            int i = srcOff1 + length;
            int j = srcOff2 + length;
            int k = destOff + length;
            while (i > srcOff1) {
                double im1 = src1[--i];
                double re1 = src1[--i];
                double im2 = src2[--j];
                double re2 = src2[--j];
                dest[--k] = im1 * re2 + re1 * im2;
                dest[--k] = re1 * re2 - im1 * im2;
            }
        } else {
            int i = srcOff1;
            int j = srcOff2;
            int k = destOff;
            int stop = srcOff1 + length;
            while (i < stop) {
                double re1 = src1[i];
                double im1 = src1[++i];
                ++i;
                double re2 = src2[j];
                double im2 = src2[++j];
                ++j;
                dest[k] = re1 * re2 - im1 * im2;
                dest[++k] = im1 * re2 + re1 * im2;
                ++k;
            }
        }
    }

    public void unwrapPhases(double[] src, int srcOff, double[] dest, int destOff, int length) {
        int i = srcOff + 1;
        int j = destOff + 1;
        int k = 0;
        int stop = srcOff + length;
        double d1 = 0.0;
        double d3 = 0.0;
        while (i < stop) {
            double d2 = src[i];
            if (d2 - d1 > Math.PI) {
                d3 = (double)(--k) * (Math.PI * 2);
            } else if (d1 - d2 > Math.PI) {
                d3 = (double)(++k) * (Math.PI * 2);
            }
            dest[j] = d2 + d3;
            d1 = d2;
            i += 2;
            j += 2;
        }
    }

    public void wrapPhases(double[] src, int srcOff, double[] dest, int destOff, int length) {
        int i = srcOff + 1;
        int j = destOff + 1;
        int k = 0;
        int stop = srcOff + length;
        double d3 = 0.0;
        while (i < stop) {
            double d2 = src[i];
            while (d2 - d3 > Math.PI) {
                d3 = (double)(++k) * (Math.PI * 2);
            }
            while (d3 - d2 > Math.PI) {
                d3 = (double)(--k) * (Math.PI * 2);
            }
            dest[j] = d2 - d3;
            i += 2;
            j += 2;
        }
    }

    private Complex$() {
    }
}

