/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.dsp;

import de.sciss.dsp.ConstQ;
import de.sciss.dsp.ConstQ$Config$;
import de.sciss.dsp.ConstQ$ConfigBuilder$;
import de.sciss.dsp.Fourier;
import de.sciss.dsp.Fourier$;
import de.sciss.dsp.Util$;
import de.sciss.dsp.Window$Hamming$;
import scala.math.package$;

public final class ConstQ$ {
    public static final ConstQ$ MODULE$ = new ConstQ$();

    public int getNumKernelsF(double bandsPerOct, double maxFreq, double minFreq) {
        return (int)package$.MODULE$.ceil(bandsPerOct * Util$.MODULE$.log2(maxFreq / minFreq));
    }

    public int getNumKernels(int bandsPerOct, double maxFreq, double minFreq) {
        return this.getNumKernelsF(bandsPerOct, maxFreq, minFreq);
    }

    public double getBandsPerOct(int numKernels, double maxFreq, double minFreq) {
        return (double)numKernels / Util$.MODULE$.log2(maxFreq / minFreq);
    }

    public ConstQ apply(ConstQ.Config config) {
        return this.createInstance(config);
    }

    public ConstQ.Config apply$default$1() {
        return ConstQ$Config$.MODULE$.apply().build();
    }

    private ConstQ.Impl createInstance(ConstQ.Config config0) {
        ConstQ.Config config;
        double fs = config0.sampleRate();
        if (config0.maxFreq() <= fs / (double)2) {
            config = config0;
        } else {
            ConstQ.ConfigBuilder c = ConstQ$ConfigBuilder$.MODULE$.apply(config0);
            c.maxFreq_$eq(fs / (double)2);
            config = c.build();
        }
        ConstQ.Config config2 = config;
        double q = 1.0 / (package$.MODULE$.pow(2.0, 1.0 / config2.bandsPerOctF()) - 1.0);
        int numKernels = config2.numKernels();
        ConstQ.Kernel[] kernels = new ConstQ.Kernel[numKernels];
        double qN = q * config2.sampleRate();
        double maxKernLen = qN / config2.minFreq();
        double minKernLen = qN / config2.maxFreq();
        int fftSize = package$.MODULE$.min(config2.maxFFTSize(), Util$.MODULE$.nextPowerOfTwo((int)package$.MODULE$.ceil(maxKernLen)));
        int fftSizeC = fftSize << 1;
        double[] fftBuf = new double[fftSizeC];
        Fourier fft = Fourier$.MODULE$.apply(fftSize, config2.threading());
        boolean enW = config2.energyWeighted();
        double weight0 = enW ? 3.09 / (double)fftSize : 0.258 / ((double)fftSize * minKernLen);
        for (int ki = 0; ki < numKernels; ++ki) {
            double d;
            double idealKernLen = maxKernLen * package$.MODULE$.pow(2.0, (double)(-ki) / config2.bandsPerOctF());
            int idealKernLenI = (int)package$.MODULE$.ceil(idealKernLen);
            int kernelLen = package$.MODULE$.min(fftSize, idealKernLenI);
            int kernelLenE = kernelLen & ~1;
            double[] win = Window$Hamming$.MODULE$.create(kernelLen);
            double centerFreq = config2.minFreq() * package$.MODULE$.pow(2.0, (double)ki / config2.bandsPerOctF());
            double centerFreqN0 = centerFreq / fs;
            double centerFreqN = centerFreqN0 * -(Math.PI * 2);
            int centerOff = (int)package$.MODULE$.round(centerFreqN0 * (double)fftSize) << 1;
            if (enW) {
                double geom = idealKernLenI == kernelLen ? (double)kernelLen : package$.MODULE$.sqrt(idealKernLen * (double)kernelLen);
                d = weight0 / geom;
            } else {
                d = weight0;
            }
            double weight = d;
            int n = fftSizeC - kernelLenE;
            for (int m = kernelLenE; m < n; ++m) {
                fftBuf[m] = 0.0;
            }
            int j = fftSizeC - kernelLenE;
            for (int i = kernelLen - 1; i >= 0; --i) {
                double d1 = centerFreqN * (double)i;
                double cos = package$.MODULE$.cos(d1);
                double sin = package$.MODULE$.sin(d1);
                double d2 = win[i] * weight;
                fftBuf[j] = d2 * cos;
                fftBuf[++j] = d2 * sin;
                if (++j != fftSizeC) continue;
                j = 0;
            }
            fft.complexForward(fftBuf);
            double f1 = fftBuf[centerOff];
            double f2 = fftBuf[centerOff + 1];
            double magSqrCenter = f1 * f1 + f2 * f2;
            int i = centerOff - 2;
            double m1 = magSqrCenter;
            double m2 = magSqrCenter;
            boolean bl = true;
            while (bl && i >= 0) {
                double f12 = fftBuf[i];
                double f22 = fftBuf[i + 1];
                double m0 = f12 * f12 + f22 * f22;
                if (m0 > m1 && m1 < m2) {
                    bl = false;
                    continue;
                }
                m2 = m1;
                m1 = m0;
                i -= 2;
            }
            int specStart = i + 2;
            int i2 = centerOff + 2;
            double m12 = magSqrCenter;
            double m22 = magSqrCenter;
            continue = true;
            while (continue && i2 <= fftSize) {
                double f13 = fftBuf[i2];
                double f23 = fftBuf[i2 + 1];
                double m0 = f13 * f13 + f23 * f23;
                if (m0 > m12 && m12 < m22) {
                    continue = false;
                    continue;
                }
                m22 = m12;
                m12 = m0;
                i2 += 2;
            }
            int specStop = i2 - 2;
            kernels[ki] = new ConstQ.Kernel(specStart, new double[specStop - specStart], centerFreq);
            System.arraycopy(fftBuf, specStart, kernels[ki].data(), 0, specStop - specStart);
        }
        return new ConstQ.Impl(config2, kernels, fft, fftBuf);
    }

    private ConstQ$() {
    }
}

