/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.dsp;

import de.sciss.dsp.FastLog$;
import de.sciss.dsp.Util$;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u00051<Qa\u0006\r\t\u0002}1Q!\t\r\t\u0002\tBQ!K\u0001\u0005\u0002)BQaK\u0001\u0005\u000212AAP\u0001\u0007\u007f!A\u0001\t\u0002B\u0001B\u0003%\u0011\u0007\u0003\u0005B\t\t\u0005\t\u0015!\u00037\u0011\u0015IC\u0001\"\u0001C\u0011\u00159E\u0001\"\u0011I\u0011\u0015!F\u0001\"\u0011V\u0011\u0015yC\u0001\"\u00011\u0011\u0015!D\u0001\"\u00016\u0011\u001dqFA1A\u0005\nUBaa\u0018\u0003!\u0002\u00131\u0004b\u00021\u0005\u0005\u0004%I\u0001\r\u0005\u0007C\u0012\u0001\u000b\u0011B\u0019\t\u000f\t$!\u0019!C\u0005G\"1q\r\u0002Q\u0001\n\u0011DQ!\u000f\u0003\u0005\u0002!4q!\t\r\u0011\u0002G\u0005b\u0006C\u00030'\u0019\u0005\u0001\u0007C\u00035'\u0019\u0005Q\u0007C\u0003:'\u0019\u0005!(A\u0004GCN$Hj\\4\u000b\u0005eQ\u0012a\u00013ta*\u00111\u0004H\u0001\u0006g\u000eL7o\u001d\u0006\u0002;\u0005\u0011A-Z\u0002\u0001!\t\u0001\u0013!D\u0001\u0019\u0005\u001d1\u0015m\u001d;M_\u001e\u001c\"!A\u0012\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tq$A\u0003baBd\u0017\u0010F\u0002.U.\u0004\"\u0001I\n\u0014\u0005M\u0019\u0013\u0001\u00022bg\u0016,\u0012!\r\t\u0003IIJ!aM\u0013\u0003\r\u0011{WO\u00197f\u0003\u0005\tX#\u0001\u001c\u0011\u0005\u0011:\u0014B\u0001\u001d&\u0005\rIe\u000e^\u0001\u0005G\u0006d7\r\u0006\u00022w!)AH\u0006a\u0001c\u0005\u0019\u0011M]4*\u0005M!!\u0001B%na2\u001c2\u0001B\u0012.\u0003\u0015\u0011\u0017m]31\u0003\t\t\b\u0007F\u0002D\u000b\u001a\u0003\"\u0001\u0012\u0003\u000e\u0003\u0005AQ\u0001Q\u0004A\u0002EBQ!Q\u0004A\u0002Y\n\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0013B\u0011!*\u0015\b\u0003\u0017>\u0003\"\u0001T\u0013\u000e\u00035S!A\u0014\u0010\u0002\rq\u0012xn\u001c;?\u0013\t\u0001V%\u0001\u0004Qe\u0016$WMZ\u0005\u0003%N\u0013aa\u0015;sS:<'B\u0001)&\u0003\u0019)\u0017/^1mgR\u0011a+\u0017\t\u0003I]K!\u0001W\u0013\u0003\u000f\t{w\u000e\\3b]\")!,\u0003a\u00017\u0006!A\u000f[1u!\t!C,\u0003\u0002^K\t\u0019\u0011I\\=\u0002\u0007El\u0015'\u0001\u0003r\u001bF\u0002\u0013\u0001B6peJ\fQa[8se\u0002\nA\u0001Z1uCV\tA\rE\u0002%KFJ!AZ\u0013\u0003\u000b\u0005\u0013(/Y=\u0002\u000b\u0011\fG/\u0019\u0011\u0015\u0005EJ\u0007\"\u0002\u001f\u0013\u0001\u0004\t\u0004\"B\u0018\u0004\u0001\u0004\t\u0004\"\u0002\u001b\u0004\u0001\u00041\u0004")
public interface FastLog {
    public static FastLog apply(double base, int q) {
        return FastLog$.MODULE$.apply(base, q);
    }

    public double base();

    public int q();

    public double calc(double var1);

    private static final class Impl
    implements FastLog {
        private final double base0;
        private final int q0;
        private final int qM1;
        private final double korr;
        private final double[] data;

        public String toString() {
            return new StringBuilder(18).append("FastLog(base=").append(this.base()).append(", q=").append(this.q()).append(")").toString();
        }

        public boolean equals(Object that) {
            FastLog f;
            return that != null && that instanceof FastLog && (f = (FastLog)that).base() == this.base() && f.q() == this.q();
        }

        @Override
        public double base() {
            return this.base0;
        }

        @Override
        public int q() {
            return this.q0;
        }

        private int qM1() {
            return this.qM1;
        }

        private double korr() {
            return this.korr;
        }

        private double[] data() {
            return this.data;
        }

        @Override
        public double calc(double arg) {
            int raw = Float.floatToIntBits((float)arg);
            int exp = raw >> 23 & 0xFF;
            int mantissa = raw & 0x7FFFFF;
            return ((double)exp + this.data()[exp == 0 ? mantissa >> this.qM1() : (mantissa | 0x800000) >> this.q0]) * this.korr();
        }

        public Impl(double base0, int q0) {
            this.base0 = base0;
            this.q0 = q0;
            this.qM1 = q0 - 1;
            this.korr = Util$.MODULE$.Ln2() / package$.MODULE$.log(base0);
            int tabSize = 1 << 24 - q0;
            double[] arr = new double[tabSize];
            for (int i = 0; i < tabSize; ++i) {
                arr[i] = Util$.MODULE$.log2(i << q0) - (double)150;
            }
            this.data = arr;
        }
    }
}

