/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.dsp;

import de.sciss.dsp.Window$;
import scala.math.package$;

public final class WindowedSincFilter$ {
    public static final WindowedSincFilter$ MODULE$ = new WindowedSincFilter$();
    private static final int DefaultSamplesPerCrossing = 256;

    public int DefaultSamplesPerCrossing() {
        return DefaultSamplesPerCrossing;
    }

    public void createLPF(double[] impResp, double freq, int halfWinSize, double kaiserBeta, int samplesPerCrossing) {
        int i;
        double dNum = samplesPerCrossing;
        double smpRate = freq * 2.0;
        double normFactor = 1.0 / (double)(halfWinSize - 1);
        impResp[0] = smpRate;
        for (i = 1; i < halfWinSize; ++i) {
            double d = Math.PI * (double)i / dNum;
            impResp[i] = package$.MODULE$.sin(smpRate * d) / d;
        }
        double iBeta = 1.0 / Window$.MODULE$.calcBesselZero(kaiserBeta);
        i = 1;
        while (i < halfWinSize) {
            double d = (double)i * normFactor;
            int n = i++;
            impResp[n] = impResp[n] * (Window$.MODULE$.calcBesselZero(kaiserBeta * package$.MODULE$.sqrt(1.0 - d * d)) * iBeta);
        }
    }

    public int createLPF$default$5() {
        return this.DefaultSamplesPerCrossing();
    }

    public double createAntiAliasFilter(double[] impResp, double[] impRespD, int halfWinSize, double rollOff, double kaiserBeta, int samplesPerCrossing) {
        this.createLPF(impResp, 0.5 * rollOff, halfWinSize, kaiserBeta, samplesPerCrossing);
        if (impRespD != null) {
            int i;
            for (i = 0; i < halfWinSize - 1; ++i) {
                impRespD[i] = impResp[i + 1] - impResp[i];
            }
            impRespD[i] = -impResp[i];
        }
        double dcGain = 0.0;
        for (int j = samplesPerCrossing; j < halfWinSize; j += samplesPerCrossing) {
            dcGain += impResp[j];
        }
        dcGain = (double)2 * dcGain + impResp[0];
        return 1.0 / package$.MODULE$.abs(dcGain);
    }

    public int createAntiAliasFilter$default$6() {
        return this.DefaultSamplesPerCrossing();
    }

    private WindowedSincFilter$() {
    }
}

