/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.freesound;

import de.sciss.audiofile.AudioFileType$Wave$;
import de.sciss.audiofile.SampleFormat$Int16$;
import de.sciss.file.package$;
import de.sciss.file.package$RichFile$;
import de.sciss.freesound.FileType;
import de.sciss.freesound.FileType$FLAC$;
import de.sciss.freesound.FileType$MP3$;
import de.sciss.freesound.FileType$Ogg$;
import de.sciss.freesound.OggDecoder$;
import de.sciss.jump3r.Main;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import org.jflac.FLACDecoder;
import org.jflac.PCMProcessor;
import org.jflac.metadata.StreamInfo;
import org.jflac.util.ByteData;
import org.jflac.util.WavWriter;
import scala.runtime.BoxedUnit;

public final class Codec$ {
    public static final Codec$ MODULE$ = new Codec$();

    public void convertToWave(File in, FileType inType, File out) {
        FileType fileType = inType;
        if (FileType$FLAC$.MODULE$.equals(fileType)) {
            this.convertFLACToWave(in, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FileType$MP3$.MODULE$.equals(fileType)) {
            this.convertMP3ToWave(in, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (FileType$Ogg$.MODULE$.equals(fileType)) {
            this.convertOggToWave(in, out);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new UnsupportedOperationException(new StringBuilder(22).append("Codec conversion from ").append(inType).toString());
        }
    }

    public void convertMP3ToWave(File in, File out) {
        Main lame = new Main();
        String[] args = (String[])((Object[])new String[]{"--silent", "--decode", "--mp3input", package$RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(in)), package$RichFile$.MODULE$.path$extension(package$.MODULE$.RichFile(out))});
        lame.run(args);
    }

    public void convertFLACToWave(File in, File out) {
        try (FileInputStream is = new FileInputStream(in);
             FileOutputStream os = new FileOutputStream(out);){
            FLACDecoder d = new FLACDecoder(is);
            WavWriter w = new WavWriter(os);
            d.addPCMProcessor(new PCMProcessor(w){
                private final WavWriter w$1;

                public void processStreamInfo(StreamInfo info) {
                    this.w$1.writeHeader(info);
                }

                public void processPCM(ByteData data) {
                    this.w$1.writePCM(data);
                }
                {
                    this.w$1 = w$1;
                }
            });
            d.decode();
        }
    }

    public void convertOggToWave(File in, File out) {
        try (FileInputStream fis = new FileInputStream(in);){
            OggDecoder$.MODULE$.decode(fis, out, AudioFileType$Wave$.MODULE$, SampleFormat$Int16$.MODULE$);
        }
    }

    private Codec$() {
    }
}

