/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.freesound;

import com.jcraft.jogg.Packet;
import com.jcraft.jogg.Page;
import com.jcraft.jogg.StreamState;
import com.jcraft.jogg.SyncState;
import com.jcraft.jorbis.Block;
import com.jcraft.jorbis.Comment;
import com.jcraft.jorbis.DspState;
import com.jcraft.jorbis.Info;
import de.sciss.audiofile.AudioFile;
import de.sciss.audiofile.AudioFile$;
import de.sciss.audiofile.AudioFileSpec;
import de.sciss.audiofile.AudioFileSpec$;
import de.sciss.audiofile.AudioFileType;
import de.sciss.audiofile.AudioFileType$Wave$;
import de.sciss.audiofile.SampleFormat;
import de.sciss.audiofile.SampleFormat$Int16$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Option;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class OggDecoder$ {
    public static final OggDecoder$ MODULE$ = new OggDecoder$();

    public AudioFileSpec decode(InputStream is, File fOut, AudioFileType tpeOut, SampleFormat fmtOut) {
        AudioFileSpec audioFileSpec;
        SyncState sync2 = new SyncState();
        StreamState stream = new StreamState();
        Page page = new Page();
        Packet packet = new Packet();
        Info info = new Info();
        Comment comment = new Comment();
        DspState dsp = new DspState();
        Block block = new Block(dsp);
        sync2.init();
        AudioFile afOut = null;
        float[][][] _pcm = new float[1][][];
        double[][] bufAf = null;
        try {
            while (true) {
                boolean hasPage;
                int off = sync2.buffer(4096);
                byte[] buf2 = sync2.data;
                int len = is.read(buf2, off, 4096);
                sync2.wrote(len);
                boolean bl = hasPage = sync2.pageout(page) == 1;
                if (!hasPage && len == 4096) {
                    throw new IOException("Input does not appear to be an Ogg bit stream");
                }
                if (!hasPage) break;
                boolean eos = false;
                stream.init(page.serialno());
                info.init();
                comment.init();
                if (stream.pagein(page) < 0) {
                    throw new IOException("Error reading first page of Ogg bit stream data");
                }
                if (stream.packetout(packet) != 1) {
                    throw new IOException("Error reading initial header packet");
                }
                if (info.synthesis_headerin(comment, packet) < 0) {
                    throw new IOException("The Ogg bit stream does not contain Vorbis audio data");
                }
                int i = 0;
                while (i < 2) {
                    int result2 = 0;
                    do {
                        if ((result2 = sync2.pageout(page)) != 1) continue;
                        stream.pagein(page);
                        do {
                            if ((result2 = stream.packetout(packet)) == -1) {
                                throw new IOException("Corrupt secondary header");
                            }
                            if (result2 != 1) continue;
                            info.synthesis_headerin(comment, packet);
                            ++i;
                        } while (i < 2 && result2 != 0);
                    } while (i < 2 && result2 != 0);
                    byte[] buf3 = sync2.data;
                    int off2 = sync2.buffer(4096);
                    int len2 = is.read(buf3, off2, 4096);
                    if (len2 == 0 && i < 2) {
                        throw new IOException("End of file before finding all Vorbis headers!");
                    }
                    sync2.wrote(len2);
                }
                if (afOut == null) {
                    afOut = AudioFile$.MODULE$.openWrite(fOut, new AudioFileSpec(tpeOut, fmtOut, info.channels, info.rate, AudioFileSpec$.MODULE$.apply$default$5(), AudioFileSpec$.MODULE$.apply$default$6()));
                } else if (afOut.numChannels() != info.channels) {
                    throw new IOException(new StringBuilder(61).append("Cannot chain bit streams of varying number of channels (").append(afOut.numChannels()).append(" -> ").append(info.channels).append(")").toString());
                }
                int convSize = 4096;
                dsp.synthesis_init(info);
                block.init(dsp);
                int[] _index = new int[info.channels];
                while (!eos) {
                    int result0 = 0;
                    do {
                        if ((result0 = sync2.pageout(page)) == -1) {
                            System.err.println("Corrupt or missing data in bit stream; continuing...");
                        }
                        if (result0 != 1) continue;
                        stream.pagein(page);
                        int result1 = 0;
                        do {
                            if ((result1 = stream.packetout(packet)) == -1) {
                                // empty if block
                            }
                            if (result1 != 1) continue;
                            Serializable serializable = block.synthesis(packet) == 0 ? BoxesRunTime.boxToInteger(dsp.synthesis_blockin(block)) : BoxedUnit.UNIT;
                            int avail = 0;
                            do {
                                Serializable serializable2;
                                if ((avail = dsp.synthesis_pcmout(_pcm, _index)) > 0) {
                                    int chunk = package$.MODULE$.min(avail, convSize);
                                    int off3 = _index[0];
                                    float[][] bufOgg = _pcm[0];
                                    if (bufAf == null || ((void)bufAf[0]).length < bufOgg[0].length) {
                                        bufAf = (double[][])Array$.MODULE$.ofDim(_pcm[0].length, _pcm[0][0].length, ClassTag$.MODULE$.Double());
                                    }
                                    for (int ch = 0; ch < bufAf.length; ++ch) {
                                        double[] bufAfCh = bufAf[ch];
                                        float[] bufOggCh = bufOgg[ch];
                                        for (int i2 = 0; i2 < chunk; ++i2) {
                                            bufAfCh[i2] = bufOggCh[i2];
                                        }
                                    }
                                    afOut.write(bufAf, off3, chunk);
                                    serializable2 = BoxesRunTime.boxToInteger(dsp.synthesis_read(chunk));
                                    continue;
                                }
                                serializable2 = BoxedUnit.UNIT;
                            } while (avail > 0);
                        } while (result1 != 0);
                        if (page.eos() == 0) continue;
                        eos = true;
                    } while (!eos && result0 != 0);
                    if (eos) continue;
                    int off4 = sync2.buffer(4096);
                    byte[] buf4 = sync2.data;
                    int len3 = is.read(buf4, off4, 4096);
                    sync2.wrote(len3);
                    if (len3 != 0) continue;
                    eos = true;
                }
                stream.clear();
                block.clear();
                dsp.clear();
                info.clear();
            }
            sync2.clear();
            AudioFileSpec qual$1 = afOut.spec();
            long x$1 = afOut.numFrames();
            AudioFileType x$2 = qual$1.copy$default$1();
            SampleFormat x$3 = qual$1.copy$default$2();
            int x$4 = qual$1.copy$default$3();
            double x$5 = qual$1.copy$default$4();
            Option<ByteOrder> x$6 = qual$1.copy$default$5();
            audioFileSpec = qual$1.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        }
        finally {
            if (afOut != null) {
                afOut.close();
            }
        }
        return audioFileSpec;
    }

    public AudioFileType decode$default$3() {
        return AudioFileType$Wave$.MODULE$;
    }

    public SampleFormat decode$default$4() {
        return SampleFormat$Int16$.MODULE$;
    }

    private OggDecoder$() {
    }
}

