/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.freesound.impl;

import de.sciss.freesound.Auth;
import de.sciss.freesound.Client;
import de.sciss.freesound.Filter;
import de.sciss.freesound.Freesound$;
import de.sciss.freesound.QueryField;
import de.sciss.freesound.Sort;
import de.sciss.freesound.Sound;
import de.sciss.freesound.TextSearch;
import de.sciss.freesound.TextSearch$;
import de.sciss.freesound.impl.DownloadImpl$;
import de.sciss.freesound.impl.FreesoundImpl;
import de.sciss.freesound.impl.FreesoundImpl$Fmt$;
import de.sciss.freesound.impl.FreesoundImpl$JsonUTF$;
import de.sciss.processor.Processor;
import dispatch.Defaults$;
import dispatch.Http$;
import dispatch.Req;
import dispatch.url$;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.Calendar;
import org.json4s.JsonAST;
import org.json4s.JsonAST$JObject$;
import org.json4s.native.JsonMethods$;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class FreesoundImpl$ {
    public static final FreesoundImpl$ MODULE$ = new FreesoundImpl$();
    private static boolean DEBUG = false;

    public Client readClient(File f) {
        JsonAST.JValue json = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.file2JsonInput(f), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        return (Client)org.json4s.package$.MODULE$.jvalue2extractable(json).extract(FreesoundImpl$Fmt$.MODULE$.default(), ManifestFactory$.MODULE$.classType(Client.class));
    }

    public File readClient$default$1() {
        return de.sciss.file.package$.MODULE$.file("client.json");
    }

    public Auth readAuth(File f) {
        JsonAST.JValue json0 = JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.file2JsonInput(f), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
        JsonAST.JValue json = org.json4s.package$.MODULE$.jvalue2monadic(json0).camelizeKeys();
        return (Auth)org.json4s.package$.MODULE$.jvalue2extractable(json).extract(FreesoundImpl$Fmt$.MODULE$.default(), ManifestFactory$.MODULE$.classType(Auth.class));
    }

    public File readAuth$default$1() {
        return de.sciss.file.package$.MODULE$.file("auth.json");
    }

    public void writeAuth(File f, Auth auth) {
        String expiresS = FreesoundImpl$Fmt$.MODULE$.default().dateFormat().format(auth.expires());
        JsonAST.JObject json = JsonAST$JObject$.MODULE$.apply(ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("access_token"), new JsonAST.JString(auth.accessToken())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("expires"), new JsonAST.JString(expiresS)), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("refresh_token"), new JsonAST.JString(auth.refreshToken()))}));
        String s = JsonMethods$.MODULE$.pretty(JsonMethods$.MODULE$.render(json, FreesoundImpl$Fmt$.MODULE$.default()));
        try (FileOutputStream fos = new FileOutputStream(f);){
            fos.write(s.getBytes("UTF-8"));
        }
    }

    public File writeAuth$default$1() {
        return de.sciss.file.package$.MODULE$.file("auth.json");
    }

    public Future<Auth> getAuth(String code, Client client) {
        return this.getToken(code, false, client);
    }

    public Future<Auth> refreshAuth(Client client, Auth auth) {
        return this.getToken(auth.refreshToken(), true, client);
    }

    private Future<Auth> getToken(String code, boolean isRefresh, Client client) {
        Req req0 = url$.MODULE$.apply(Freesound$.MODULE$.urlGetAuth()).addParameter("client_id", client.id()).addParameter("client_secret", client.secret()).addParameter("grant_type", isRefresh ? "refresh_token" : "authorization_code").addParameter(isRefresh ? "refresh_token" : "code", code);
        Req req = req0.POST();
        Calendar now = Calendar.getInstance();
        Future<JsonAST.JValue> futJson = this.runJSON(req);
        return futJson.map((Function1<JsonAST.JValue, Auth> & Serializable)json0 -> {
            JsonAST.JValue json1 = org.json4s.package$.MODULE$.jvalue2monadic((JsonAST.JValue)json0).mapField((Function1<Tuple2<String, JsonAST.JValue>, Tuple2<String, JsonAST.JValue>>)(Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
                Tuple2<String, JsonAST.JString> tuple2 = x0$1;
                if (tuple2 == null) return tuple2;
                String string = tuple2._1();
                JsonAST.JValue jValue = tuple2._2();
                if (!"expires_in".equals(string)) return tuple2;
                if (!(jValue instanceof JsonAST.JInt)) return tuple2;
                JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                BigInt expiresIn = jInt.num();
                now.add(13, expiresIn.intValue());
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("expires"), new JsonAST.JString(FreesoundImpl$Fmt$.MODULE$.default().dateFormat().format(now.getTime())));
            });
            JsonAST.JValue json = org.json4s.package$.MODULE$.jvalue2monadic(json1).camelizeKeys();
            return (Auth)org.json4s.package$.MODULE$.jvalue2extractable(json).extract(FreesoundImpl$Fmt$.MODULE$.default(), ManifestFactory$.MODULE$.classType(Auth.class));
        }, Defaults$.MODULE$.executor());
    }

    public Future<IndexedSeq<Sound>> textSearch(String query2, Filter filter2, Sort sort, boolean groupByPack, int maxItems, Client client) {
        TextSearch options = new TextSearch(query2, filter2, sort, groupByPack, maxItems);
        return this.runTextSearch(options, 1, (IndexedSeq<Sound>)package$.MODULE$.Vector().empty(), client);
    }

    public Future<Object> textCount(String query2, Filter filter2, Client client) {
        String x$1 = query2;
        Filter x$2 = filter2;
        boolean x$3 = true;
        Sort x$4 = TextSearch$.MODULE$.apply$default$3();
        boolean x$5 = TextSearch$.MODULE$.apply$default$4();
        TextSearch options = new TextSearch(x$1, x$2, x$4, x$5, 1);
        Map params = options.toFields().iterator().map((Function1<QueryField, Tuple2> & Serializable)x0$1 -> {
            QueryField queryField2 = x0$1;
            if (queryField2 == null) {
                throw new MatchError(queryField2);
            }
            String key = queryField2.key();
            String value = queryField2.value();
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(key, value);
            return tuple2;
        }).toMap($less$colon$less$.MODULE$.refl());
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("token"), client.secret()));
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fields"), "id"));
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("page_size"), Integer.toString(options.maxItems())));
        Req req0 = url$.MODULE$.apply(Freesound$.MODULE$.urlTextSearch());
        Req req = req0.$less$less$qmark(params);
        Future<JsonAST.JValue> futJson = this.runJSON(req);
        return futJson.map((Function1<JsonAST.JValue, Object> & Serializable)json -> BoxesRunTime.boxToInteger(FreesoundImpl$.$anonfun$textCount$2(json)), Defaults$.MODULE$.executor());
    }

    private FreesoundImpl.ResultPage extractPage(JsonAST.JValue json) {
        JsonAST.JValue mapped = org.json4s.package$.MODULE$.jvalue2monadic(json).mapField((Function1<Tuple2<String, JsonAST.JValue>, Tuple2<String, JsonAST.JValue>>)(Function1<Tuple2, Tuple2> & Serializable)x0$1 -> {
            Tuple2<String, JsonAST.JValue> tuple2 = x0$1;
            if (tuple2 == null) return tuple2;
            String string = tuple2._1();
            JsonAST.JValue v0 = tuple2._2();
            if (!"results".equals(string)) return tuple2;
            return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("results"), org.json4s.package$.MODULE$.jvalue2monadic(v0).mapField((Function1<Tuple2<String, JsonAST.JValue>, Tuple2<String, JsonAST.JValue>>)(Function1<Tuple2, Tuple2> & Serializable)x0$2 -> {
                Tuple2<String, JsonAST.JValue> tuple2 = x0$2;
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("name".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("fileName", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("username".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("userName", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("geotag".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("geoTag", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("type".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("fileType", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("channels".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("numChannels", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("samplerate".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("sampleRate", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("bitdepth".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("bitDepth", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("bitrate".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("bitRate", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("filesize".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("fileSize", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("num_downloads".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("numDownloads", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("avg_rating".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("avgRating", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("num_ratings".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("numRatings", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue v = tuple2._2();
                    if ("num_comments".equals(string)) {
                        return new Tuple2<String, JsonAST.JValue>("numComments", v);
                    }
                }
                if (tuple2 != null) {
                    String string = tuple2._1();
                    JsonAST.JValue jValue = tuple2._2();
                    if ("pack".equals(string) && jValue instanceof JsonAST.JString) {
                        int n;
                        int i;
                        JsonAST.JString jString = (JsonAST.JString)jValue;
                        String uri = jString.s();
                        int j = uri.lastIndexOf(47, (i = uri.lastIndexOf(47)) - 1) + 1;
                        if (j >= i) {
                            n = 0;
                        } else {
                            String s = uri.substring(j, i);
                            n = BoxesRunTime.unboxToInt(Try$.MODULE$.apply(() -> StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s))).getOrElse(() -> 0));
                        }
                        int packId = n;
                        return new Tuple2<String, JsonAST.JInt>("packId", new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(packId)));
                    }
                }
                if (tuple2 == null) return tuple2;
                String string = tuple2._1();
                JsonAST.JValue jValue = tuple2._2();
                if (!"previews".equals(string)) return tuple2;
                if (!(jValue instanceof JsonAST.JObject)) return tuple2;
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List<Tuple2<String, JsonAST.JValue>> entries = jObject.obj();
                Option<Tuple2<String, JsonAST.JInt>> opt = entries.collectFirst(new Serializable(){
                    private static final long serialVersionUID = 0L;

                    /*
                     * WARNING - void declaration
                     * Enabled aggressive block sorting
                     */
                    public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var3_13;
                        A1 A1 = x1;
                        if (A1 != null) {
                            String string = A1._1();
                            JsonAST.JValue jValue = A1._2();
                            if ("preview-lq-ogg".equals(string) && jValue instanceof JsonAST.JString) {
                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                String s = jString.s();
                                int i = s.lastIndexOf(95) + 1;
                                int j = s.indexOf(45, i);
                                int userId = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(s.substring(i, j)));
                                Tuple2<String, JsonAST.JInt> tuple2 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("userId"), new JsonAST.JInt(BigInt$.MODULE$.int2bigInt(userId)));
                                return var3_13;
                            }
                        }
                        B1 B1 = function1.apply(x1);
                        return var3_13;
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                        Tuple2<String, JsonAST.JValue> tuple2 = x1;
                        if (tuple2 == null) return false;
                        String string = tuple2._1();
                        JsonAST.JValue jValue = tuple2._2();
                        if (!"preview-lq-ogg".equals(string)) return false;
                        if (!(jValue instanceof JsonAST.JString)) return false;
                        return true;
                    }
                });
                return opt.get();
            }));
        });
        return (FreesoundImpl.ResultPage)org.json4s.package$.MODULE$.jvalue2extractable(mapped).extract(FreesoundImpl$Fmt$.MODULE$.page(), ManifestFactory$.MODULE$.classType(FreesoundImpl.ResultPage.class));
    }

    public boolean DEBUG() {
        return DEBUG;
    }

    public void DEBUG_$eq(boolean x$1) {
        DEBUG = x$1;
    }

    private Future<JsonAST.JValue> runJSON(Req req) {
        block0: {
            if (!this.DEBUG()) break block0;
            Predef$.MODULE$.println(new StringBuilder(5).append("req: ").append(req.url()).toString());
        }
        return Future$.MODULE$.successful(BoxedUnit.UNIT).flatMap((Function1<BoxedUnit, Future> & Serializable)x$1 -> {
            void var2_2;
            Future jsonFut = (Future)scala.concurrent.package$.MODULE$.blocking((Function0<Future> & Serializable)() -> Http$.MODULE$.default().apply(dispatch.package$.MODULE$.implyRequestHandlerTuple(req).OK(FreesoundImpl$JsonUTF$.MODULE$), Defaults$.MODULE$.executor()));
            return var2_2;
        }, Defaults$.MODULE$.executor());
    }

    private Future<IndexedSeq<Sound>> runTextSearch(TextSearch options, int page, IndexedSeq<Sound> done, Client client) {
        int pageSize;
        int remain = options.maxItems() - done.size();
        Map params = options.toFields().iterator().map((Function1<QueryField, Tuple2> & Serializable)x0$1 -> {
            QueryField queryField2 = x0$1;
            if (queryField2 == null) {
                throw new MatchError(queryField2);
            }
            String key = queryField2.key();
            String value = queryField2.value();
            Tuple2<String, String> tuple2 = new Tuple2<String, String>(key, value);
            return tuple2;
        }).toMap($less$colon$less$.MODULE$.refl());
        String fields = "id,name,tags,description,username,created,license,pack,geotag,type,duration,channels,samplerate,bitdepth,bitrate,filesize,num_downloads,avg_rating,num_ratings,num_comments,previews";
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("token"), client.secret()));
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("fields"), fields));
        int pageSize0 = 50;
        int n = pageSize = page == 1 ? scala.math.package$.MODULE$.min(remain, pageSize0) : pageSize0;
        if (page > 1) {
            params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("page"), Integer.toString(page)));
        }
        params = (Map)params.$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("page_size"), Integer.toString(pageSize)));
        Req req0 = url$.MODULE$.apply(Freesound$.MODULE$.urlTextSearch());
        Req req = req0.$less$less$qmark(params);
        Future<JsonAST.JValue> futJson = this.runJSON(req);
        return futJson.flatMap((Function1<JsonAST.JValue, Future> & Serializable)json -> {
            FreesoundImpl.ResultPage res = MODULE$.extractPage((JsonAST.JValue)json);
            Vector<Sound> add = res.results().size() <= remain ? res.results() : res.results().take(remain);
            IndexedSeq done1 = (IndexedSeq)done.$plus$plus(add);
            int remain1 = scala.math.package$.MODULE$.min(res.count(), options.maxItems()) - done1.size();
            return remain1 == 0 ? Future$.MODULE$.successful(done1) : MODULE$.runTextSearch(options, page + 1, done1, client);
        }, Defaults$.MODULE$.executor());
    }

    public Processor<BoxedUnit> download(int id, File out, Auth auth) {
        return DownloadImpl$.MODULE$.sound(id, out, auth.accessToken());
    }

    public Processor<BoxedUnit> downloadUriToFile(URI uri, File out, Client client) {
        String uriS = uri.toString();
        Req req0 = url$.MODULE$.apply(uriS);
        Req req1 = req0.addHeader("Authorization", new StringBuilder(6).append("Token ").append(client.secret()).toString());
        int i = uriS.lastIndexOf(47) + 1;
        String info = uriS.substring(i);
        return DownloadImpl$.MODULE$.apply(req1, out, info);
    }

    public static final /* synthetic */ int $anonfun$textCount$2(JsonAST.JValue json) {
        Option option;
        JsonAST.JValue jValue = json;
        if (jValue instanceof JsonAST.JObject) {
            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
            List<Tuple2<String, JsonAST.JValue>> entries = jObject.obj();
            option = entries.collectFirst(new Serializable(){
                private static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 */
                public final <A1 extends Tuple2<String, JsonAST.JValue>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var3_10;
                    A1 A1 = x1;
                    if (A1 != null) {
                        String string = A1._1();
                        JsonAST.JValue jValue = A1._2();
                        if ("count".equals(string) && jValue instanceof JsonAST.JInt) {
                            JsonAST.JInt jInt = (JsonAST.JInt)jValue;
                            BigInt num = jInt.num();
                            Integer n = BoxesRunTime.boxToInteger(num.intValue());
                            return var3_10;
                        }
                    }
                    B1 B1 = function1.apply(x1);
                    return var3_10;
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Tuple2<String, JsonAST.JValue> x1) {
                    Tuple2<String, JsonAST.JValue> tuple2 = x1;
                    if (tuple2 == null) return false;
                    String string = tuple2._1();
                    JsonAST.JValue jValue = tuple2._2();
                    if (!"count".equals(string)) return false;
                    if (!(jValue instanceof JsonAST.JInt)) return false;
                    return true;
                }
            });
        } else {
            option = None$.MODULE$;
        }
        None$ numOpt = option;
        return BoxesRunTime.unboxToInt(numOpt.getOrElse((Function0<Nothing$> & Serializable)() -> scala.sys.package$.MODULE$.error("Could not determined 'count' parameter")));
    }

    private FreesoundImpl$() {
    }
}

