/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.Inlet;
import akka.stream.Outlet;
import de.sciss.fscape.Log$;
import de.sciss.fscape.Util$;
import de.sciss.fscape.stream.Allocator;
import de.sciss.fscape.stream.Blobs2D$;
import de.sciss.fscape.stream.Buf;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.impl.Handlers;
import de.sciss.fscape.stream.impl.Handlers$;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.fscape.stream.impl.shapes.In5Out4Shape;
import de.sciss.fscape.stream.package$;
import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\r-v!B7o\u0011\u00039h!B=o\u0011\u0003Q\bbBA\u0002\u0003\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u000f\tA\u0011AA\u0005\u0011%\t)%\u0001b\u0001\n\u001b\t9\u0005\u0003\u0005\u0002N\u0005\u0001\u000bQBA%\u000b\u0019\ty%\u0001\u0003\u0002R\u00191\u0011QO\u0001\u0007\u0003oB!\"!\"\b\u0005\u0003\u0005\u000b\u0011BAD\u0011)\tii\u0002B\u0001B\u0003-\u0011q\u0012\u0005\b\u0003\u00079A\u0011AAK\u0011%\tyj\u0002b\u0001\n\u0003\t\t\u000b\u0003\u0005\u00026\u001e\u0001\u000b\u0011BAR\u0011\u001d\t9l\u0002C\u0001\u0003s3a!!4\u0002\r\u0005=\u0007bBA\u0002\u001d\u0011\u0005\u0011\u0011\u001b\u0005\n\u0003+t\u0001\u0019!C\u0001\u0003/D\u0011\"a8\u000f\u0001\u0004%\t!!9\t\u0011\u00055h\u0002)Q\u0005\u00033D\u0011\"a<\u000f\u0001\u0004%\t!a6\t\u0013\u0005Eh\u00021A\u0005\u0002\u0005M\b\u0002CA|\u001d\u0001\u0006K!!7\t\u0013\u0005eh\u00021A\u0005\u0002\u0005]\u0007\"CA~\u001d\u0001\u0007I\u0011AA\u007f\u0011!\u0011\tA\u0004Q!\n\u0005e\u0007\"\u0003B\u0002\u001d\u0001\u0007I\u0011AAl\u0011%\u0011)A\u0004a\u0001\n\u0003\u00119\u0001\u0003\u0005\u0003\f9\u0001\u000b\u0015BAm\u0011%\u0011iA\u0004a\u0001\n\u0003\u0011y\u0001C\u0005\u0003\u00189\u0001\r\u0011\"\u0001\u0003\u001a!A!Q\u0004\b!B\u0013\u0011\t\u0002C\u0005\u0003 9\u0011\r\u0011\"\u0001\u0003\"!A!\u0011\u0006\b!\u0002\u0013\u0011\u0019\u0003C\u0004\u0003,9!\tE!\f\u0007\r\t\u0015\u0013A\u0002B$\u00111\tyJ\tB\u0001B\u0003%\u0011\u0011\u0011B(\u00111\t)I\tB\u0001B\u0003%\u0011q\u0011B)\u00111\tiI\tB\u0001B\u0003-\u0011q\u0012B*\u0011\u001d\t\u0019A\tC\u0001\u0005/B\u0001Ba\u0019#A\u0003%!Q\r\u0005\t\u0005\u000f\u0013\u0003\u0015!\u0003\u0003\n\"A!q\u0012\u0012!\u0002\u0013\u0011I\t\u0003\u0005\u0003\u0012\n\u0002\u000b\u0011\u0002BJ\u0011!\u0011IJ\tQ\u0001\n\t%\u0005\u0002\u0003BNE\u0001\u0006IA!(\t\u0011\t\r&\u0005)A\u0005\u0005KC\u0001Ba+#A\u0003%!Q\u0014\u0005\t\u0005[\u0013\u0003\u0015!\u0003\u0003&\"Y!q\u0016\u0012A\u0002\u0003\u0005\u000b\u0015\u0002BY\u0011-\u0011\u0019L\ta\u0001\u0002\u0003\u0006KA!\u0005\t\u0017\tU&\u00051A\u0001B\u0003&!\u0011\u0003\u0005\f\u0005o\u0013\u0003\u0019!A!B\u0013\u0011\t\u0002C\u0006\u0003:\n\u0002\r\u0011!Q!\n\tE\u0001bCA E\u0001\u0007\t\u0011)Q\u0005\u00033D1\"a\u0011#\u0001\u0004\u0005\t\u0015)\u0003\u0003\u0012!Y!1\u0018\u0012A\u0002\u0003\u0005\u000b\u0015\u0002B\t\u0011-\u0011iL\ta\u0001\u0002\u0003\u0006KA!\u0005\t\u0017\t}&\u00051A\u0001B\u0003&!\u0011\u0003\u0005\f\u0005\u0003\u0014\u0003\u0019!A!B\u0013\u0011\t\u0002\u0003\u0005\u0003D\n\u0002\u000b\u0015\u0002B\t\u0011-\u0011)M\ta\u0001\u0002\u0003\u0006KA!\u0005\t\u0017\t\u001d'\u00051A\u0001B\u0003&!\u0011\u0003\u0005\f\u0005\u0013\u0014\u0003\u0019!A!B\u0013\u0011\t\u0002C\u0006\u0003L\n\u0002\r\u0011!Q!\n\tE\u0001\u0002\u0003BgE\u0001\u0006KA!\u0005\t\u0017\t='\u00051A\u0001B\u0003&!\u0011\u0003\u0005\f\u0005#\u0014\u0003\u0019!A!B\u0013\u0011\t\u0002C\u0006\u0003T\n\u0002\r\u0011!Q!\n\tE\u0001b\u0003BkE\u0001\u0007\t\u0011)Q\u0005\u0005#A\u0001Ba6#A\u0003&!\u0011\u0003\u0005\t\u00053\u0014\u0003\u0015)\u0003\u0003\u0012!Y!1\u001c\u0012A\u0002\u0003\u0005\u000b\u0015\u0002Bo\u0011\u001d\u0011yN\tC)\u0005CDqAa9#\t\u0013\u0011)\u000fC\u0004\u0003n\n\"IAa\u0004\t\u000f\t=(\u0005\"\u0003\u0003\u0010!9!\u0011\u001f\u0012\u0005\n\t\u0005\bb\u0002BzE\u0011%!Q\u001f\u0005\b\u0005w\u0014C\u0011\u0002Bq\u0011\u001d\u0011iP\tC\u0005\u0005CDqAa@#\t\u0013\u0011\t\u000fC\u0004\u0004\u0002\t\"\tB!9\t\u000f\rE!\u0005\"\u0015\u0004\u0014!91\u0011\u0003\u0012\u0005\u0012\r]\u0002bBB&E\u0011%!Q\u001d\u0005\f\u0007\u001b\u0012\u0003\u0019!A!B\u0013\u0019y\u0005C\u0006\u0004R\t\u0002\r\u0011!Q!\n\t\r\u0002bCB*E\u0001\u0007\t\u0011)Q\u0005\u0005cC1b!\u0016#\u0001\u0004\u0005\t\u0015)\u0003\u00032\"A1q\u000b\u0012!B\u0013\u0011\t\u0002\u0003\u0005\u0004Z\t\u0002\u000b\u0015\u0002B\t\u0011\u001d\u0019YF\tC\u0005\u0005CDqa!\u0018#\t\u0013\u0011\t\u000fC\u0004\u0004`\t\"IA!9\t\u000f\r\u0005$\u0005\"\u0003\u0004d!91\u0011\u000f\u0012\u0005\n\rM\u0004bBB>E\u0011%1Q\u0010\u0005\n\u0007\u0007\u000b!\u0019!C\u0007\u0007\u000bC\u0001b!#\u0002A\u000351q\u0011\u0005\n\u0007\u0017\u000b!\u0019!C\u0007\u0007\u000bC\u0001b!$\u0002A\u000351q\u0011\u0005\n\u0007\u001f\u000b!\u0019!C\u0007\u0005CA\u0001b!%\u0002A\u00035!1\u0005\u0005\n\u0007'\u000b!\u0019!C\u0007\u0005CA\u0001b!&\u0002A\u00035!1\u0005\u0005\n\u0007/\u000b!\u0019!C\u0007\u00073C\u0001ba(\u0002A\u0003511\u0014\u0005\n\u0007C\u000b!\u0019!C\u0007\u0007GC\u0001b!+\u0002A\u000351QU\u0001\b\u00052|'m\u001d\u001aE\u0015\ty\u0007/\u0001\u0004tiJ,\u0017-\u001c\u0006\u0003cJ\faAZ:dCB,'BA:u\u0003\u0015\u00198-[:t\u0015\u0005)\u0018A\u00013f\u0007\u0001\u0001\"\u0001_\u0001\u000e\u00039\u0014qA\u00117pEN\u0014Di\u0005\u0002\u0002wB\u0011Ap`\u0007\u0002{*\ta0A\u0003tG\u0006d\u0017-C\u0002\u0002\u0002u\u0014a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001x\u0003\u0015\t\u0007\u000f\u001d7z)1\tY!!\r\u00026\u0005e\u0012QHA!)\u0011\ti!a\n\u0011\u0017q\fy!a\u0005\u0002\"\u0005M\u0011\u0011E\u0005\u0004\u0003#i(A\u0002+va2,G\u0007\u0005\u0003\u0002\u0016\u0005mab\u0001=\u0002\u0018%\u0019\u0011\u0011\u00048\u0002\u000fA\f7m[1hK&!\u0011QDA\u0010\u0005\u0011yU\u000f^%\u000b\u0007\u0005ea\u000e\u0005\u0003\u0002\u0016\u0005\r\u0012\u0002BA\u0013\u0003?\u0011AaT;u\t\"9\u0011\u0011F\u0002A\u0004\u0005-\u0012!\u00012\u0011\u0007a\fi#C\u0002\u000209\u0014qAQ;jY\u0012,'\u000fC\u0004\u00024\r\u0001\r!!\t\u0002\u0005%t\u0007bBA\u001c\u0007\u0001\u0007\u00111C\u0001\u0006o&$G\u000f\u001b\u0005\b\u0003w\u0019\u0001\u0019AA\n\u0003\u0019AW-[4ii\"9\u0011qH\u0002A\u0002\u0005\u0005\u0012A\u0002;ie\u0016\u001c\b\u000eC\u0004\u0002D\r\u0001\r!a\u0005\u0002\u0007A\fG-\u0001\u0003oC6,WCAA%\u001f\t\tY%I\u0001n\u0003\u0015q\u0017-\\3!\u0005\r\u0019\u0006\u000e\u001d\t\u0017\u0003'\ni&!\u0019\u0002p\u0005=\u0014\u0011MA8\u0003_\n\t'a\u001c\u0002b5\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0004tQ\u0006\u0004Xm\u001d\u0006\u0004\u00037r\u0017\u0001B5na2LA!a\u0018\u0002V\ta\u0011J\\\u001bPkR$4\u000b[1qKB!\u00111MA5\u001d\rA\u0018QM\u0005\u0004\u0003Or\u0017a\u0001\"vM&!\u00111NA7\u0005\u0005!%bAA4]B!\u00111MA9\u0013\u0011\t\u0019(!\u001c\u0003\u0003%\u0013Qa\u0015;bO\u0016\u001c2aBA=!\u0019\tY(! \u0002\u00026\u0011\u0011\u0011L\u0005\u0005\u0003\u007f\nIFA\u0005Ti\u0006<W-S7qYB\u0019\u00111\u0011\u0004\u000e\u0003\u0005\tQ\u0001\\1zKJ\u0004B!!\u0006\u0002\n&!\u00111RA\u0010\u0005\u0015a\u0015-_3s\u0003\u0005\t\u0007c\u0001=\u0002\u0012&\u0019\u00111\u00138\u0003\u0013\u0005cGn\\2bi>\u0014H\u0003BAL\u0003;#B!!'\u0002\u001cB\u0019\u00111Q\u0004\t\u000f\u00055%\u0002q\u0001\u0002\u0010\"9\u0011Q\u0011\u0006A\u0002\u0005\u001d\u0015!B:iCB,WCAAR!\u0011\t)+a*\u000e\u0003\u001dIA!!+\u0002,\n)1\u000b[1qK&!\u0011QVAX\u0005\u00159%/\u00199i\u0015\ry\u0017\u0011\u0017\u0006\u0003\u0003g\u000bA!Y6lC\u000611\u000f[1qK\u0002\n1b\u0019:fCR,Gj\\4jGR!\u00111XAa!\u0019\tY(!0\u0002$&!\u0011qXA-\u0005!qu\u000eZ3J[Bd\u0007bBAb\u001b\u0001\u0007\u0011QY\u0001\u0005CR$(\u000f\u0005\u0003\u0002H\u0006%WBAAX\u0013\u0011\tY-a,\u0003\u0015\u0005#HO]5ckR,7O\u0001\u0003CY>\u00147C\u0001\b|)\t\t\u0019\u000eE\u0002\u0002\u0004:\tA\u0001_'j]V\u0011\u0011\u0011\u001c\t\u0004y\u0006m\u0017bAAo{\n1Ai\\;cY\u0016\f\u0001\u0002_'j]~#S-\u001d\u000b\u0005\u0003G\fI\u000fE\u0002}\u0003KL1!a:~\u0005\u0011)f.\u001b;\t\u0013\u0005-\u0018#!AA\u0002\u0005e\u0017a\u0001=%c\u0005)\u00010T5oA\u0005!\u00010T1y\u0003!AX*\u0019=`I\u0015\fH\u0003BAr\u0003kD\u0011\"a;\u0015\u0003\u0003\u0005\r!!7\u0002\u000bal\u0015\r\u001f\u0011\u0002\tel\u0015N\\\u0001\ts6Kgn\u0018\u0013fcR!\u00111]A\u0000\u0011%\tYoFA\u0001\u0002\u0004\tI.A\u0003z\u001b&t\u0007%\u0001\u0003z\u001b\u0006D\u0018\u0001C=NCb|F%Z9\u0015\t\u0005\r(\u0011\u0002\u0005\n\u0003WT\u0012\u0011!a\u0001\u00033\fQ!_'bq\u0002\n\u0001B\\;n\u0019&tWm]\u000b\u0003\u0005#\u00012\u0001 B\n\u0013\r\u0011)\" \u0002\u0004\u0013:$\u0018\u0001\u00048v[2Kg.Z:`I\u0015\fH\u0003BAr\u00057A\u0011\"a;\u001e\u0003\u0003\u0005\rA!\u0005\u0002\u00139,X\u000eT5oKN\u0004\u0013\u0001\u00027j]\u0016,\"Aa\t\u0011\u000bq\u0014)C!\u0005\n\u0007\t\u001dRPA\u0003BeJ\f\u00170A\u0003mS:,\u0007%\u0001\u0005u_N#(/\u001b8h)\t\u0011y\u0003\u0005\u0003\u00032\t}b\u0002\u0002B\u001a\u0005w\u00012A!\u000e~\u001b\t\u00119DC\u0002\u0003:Y\fa\u0001\u0010:p_Rt\u0014b\u0001B\u001f{\u00061\u0001K]3eK\u001aLAA!\u0011\u0003D\t11\u000b\u001e:j]\u001eT1A!\u0010~\u0005\u0015aunZ5d'\r\u0011#\u0011\n\t\u0007\u0003w\u0012Y%!!\n\t\t5\u0013\u0011\f\u0002\t\u0011\u0006tG\r\\3sg&!\u0011qTA_\u0013\u0011\t))!0\n\t\tU\u0013QX\u0001\nC2dwnY1u_J$bA!\u0017\u0003`\t\u0005D\u0003\u0002B.\u0005;\u00022!a!#\u0011\u001d\tiI\na\u0002\u0003\u001fCq!a('\u0001\u0004\t\t\tC\u0004\u0002\u0006\u001a\u0002\r!a\"\u0002\u0007!Le\u000e\u0005\u0003\u0003h\t\u0005e\u0002\u0002B5\u0005{rAAa\u001b\u0003|9!!Q\u000eB=\u001d\u0011\u0011yGa\u001e\u000f\t\tE$Q\u000f\b\u0005\u0005k\u0011\u0019(C\u0001v\u0013\t\u0019H/\u0003\u0002re&\u0011q\u000e]\u0005\u0004\u00037r\u0017\u0002\u0002B@\u00033\n\u0001\u0002S1oI2,'o]\u0005\u0005\u0005\u0007\u0013)IA\u0004J]\u0012k\u0015-\u001b8\u000b\t\t}\u0014\u0011L\u0001\u0007Q^KG\r\u001e5\u0011\t\t\u001d$1R\u0005\u0005\u0005\u001b\u0013)I\u0001\u0004J]&\u000bU\u000f_\u0001\bQ\"+\u0017n\u001a5u\u0003\u001dAG\u000b\u001b:fg\"\u0004BAa\u001a\u0003\u0016&!!q\u0013BC\u0005\u0019Ie\u000eR!vq\u0006!\u0001\u000eU1e\u00031Aw*\u001e;Ok6\u0014En\u001c2t!\u0011\u00119Ga(\n\t\t\u0005&Q\u0011\u0002\t\u001fV$\u0018*T1j]\u0006Q\u0001nT;u\u0005>,h\u000eZ:\u0011\t\t\u001d$qU\u0005\u0005\u0005S\u0013)I\u0001\u0005PkR$U*Y5o\u0003-Aw*\u001e;Ok64VM\u001d;\u0002\u0019!|U\u000f\u001e,feRL7-Z:\u0002\r]LgNQ;g!\u0015a(QEAm\u0003\u001d9\u0018\u000e\u001a;i\u0013:\f\u0001\u0002[3jO\"$\u0018J\\\u0001\to&$G\u000f\u001b)bI\u0006I\u0001.Z5hQR\u0004\u0016\rZ\u0001\no&t7+\u001b>f\u0013:\f!b^5o'&TX\rU1e\u0003\u001d\u0011X-\u00193PM\u001a\fqA]3bIJ+W.A\u0003ti\u0006<W-\u0001\txe&$Xm\u00144g\u001dVl'\t\\8cg\u0006qqO]5uK>3gMQ8v]\u0012\u001c\u0018aE<sSR,wJ\u001a4Ok64VM\u001d;jG\u0016\u001c\u0018\u0001E<sSR,wJ\u001a4WKJ$\u0018nY3t\u0003!9(/\u001b;f%\u0016l\u0017\u0001E<sSR,'+Z7Ok6\u0014En\u001c2t\u000399(/\u001b;f%\u0016l'i\\;oIN\f1c\u001e:ji\u0016\u0014V-\u001c(v[Z+'\u000f^5dKN\f\u0001c\u001e:ji\u0016\u0014V-\u001c,feRL7-Z:\u00021]\u0014\u0018\u000e^3CY>\u0014g+\u001a:uS\u000e,7O\u00117pE&#\u00070\u0001\u000exe&$XM\u00117pEZ+'\u000f^5dKN4VM\u001d;fq&#\u00070A\u0003cY>\u00147\u000fE\u0003}\u0005K\t\u0019.A\u0004ti>\u0004\b/\u001a3\u0015\u0005\u0005\r\u0018A\u0005;ss>\u0013G/Y5o/&t\u0007+\u0019:b[N$\"Aa:\u0011\u0007q\u0014I/C\u0002\u0003lv\u0014qAQ8pY\u0016\fg.\u0001\u0006xS:\u0014UOZ*ju\u0016\f1B]3bI^KgnU5{K\u0006y1\r\\3be^Kg\u000eZ8x)\u0006LG.\u0001\bsK\u0006$\u0017J\u001c;p/&tGm\\<\u0015\t\u0005\r(q\u001f\u0005\b\u0005sl\u0005\u0019\u0001B\t\u0003\u0015\u0019\u0007.\u001e8l\u00035\u0001(o\\2fgN<\u0016N\u001c3po\u0006i\u0001O]8dKN\u001cx*\u001e;qkR\fQ\u0002\u001d:fa\u0006\u0014Xm\u0015;bO\u0016\u0014\u0014a\u00029s_\u000e,7o\u001d\u0015\u0004#\u000e\u0015\u0001\u0003BB\u0004\u0007\u001bi!a!\u0003\u000b\u0007\r-Q0\u0001\u0006b]:|G/\u0019;j_:LAaa\u0004\u0004\n\t9A/Y5me\u0016\u001c\u0017AB8o\t>tW\r\u0006\u0003\u0002d\u000eU\u0001bBB\f%\u0002\u00071\u0011D\u0001\u0007_V$H.\u001a;1\t\rm1Q\u0005\t\u0007\u0003\u000f\u001cib!\t\n\t\r}\u0011q\u0016\u0002\u0007\u001fV$H.\u001a;\u0011\t\r\r2Q\u0005\u0007\u0001\t1\u00199c!\u0006\u0002\u0002\u0003\u0005)\u0011AB\u0015\u0005\ryF%M\t\u0005\u0007W\u0019\t\u0004E\u0002}\u0007[I1aa\f~\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001`B\u001a\u0013\r\u0019)$ \u0002\u0004\u0003:LH\u0003BAr\u0007sAqaa\u000fT\u0001\u0004\u0019i$A\u0003j]2,G\u000f\r\u0003\u0004@\r\u001d\u0003CBAd\u0007\u0003\u001a)%\u0003\u0003\u0004D\u0005=&!B%oY\u0016$\b\u0003BB\u0012\u0007\u000f\"Ab!\u0013\u0004:\u0005\u0005\t\u0011!B\u0001\u0007S\u00111a\u0018\u00133\u0003!1G.^:i\u001fV$\u0018aC4sS\u00124\u0016n]5uK\u0012\u0004R\u0001 B\u0013\u0005O\f1\u0002\\5oKN$v\u000e\u0012:bo\u0006AQ\rZ4f-J$\b,\u0001\u0005fI\u001e,gK\u001d;Z\u00039qW/\u001c'j]\u0016\u001cHk\u001c#sC^\f\u0001B\\;n\u00052|'m]\u0001\u000bkB$\u0017\r^3TSj,\u0017A\u00034jY2$\u0006N]3tQ\u0006YA-\u001a;fGR\u0014En\u001c2t\u0003!1\u0017N\u001c3CY>\u0014G\u0003\u0003Bt\u0007K\u001aIg!\u001c\t\u000f\r\u001dd\f1\u0001\u0002T\u0006!!\r\\8c\u0011\u001d\u0019YG\u0018a\u0001\u0005#\t\u0011\u0001\u001f\u0005\b\u0007_r\u0006\u0019\u0001B\t\u0003\u0005I\u0018!E2p[B,H/Z#eO\u00164VM\u001d;fqRA\u00111]B;\u0007o\u001aI\bC\u0004\u0004h}\u0003\r!a5\t\u000f\r-t\f1\u0001\u0003\u0012!91qN0A\u0002\tE\u0011AD4fiN\u000bX/\u0019:f\u0013:$W\r\u001f\u000b\u0007\u0005#\u0019yh!!\t\u000f\r-\u0004\r1\u0001\u0003\u0012!91q\u000e1A\u0002\tE\u0011\u0001C3eO\u0016\u001cU\u000f^:\u0016\u0005\r\u001d\u0005#\u0002?\u0003&\t\r\u0012!C3eO\u0016\u001cU\u000f^:!\u00039)GmZ3PM\u001a\u001cX\r^%oM>\fq\"\u001a3hK>3gm]3u\u0013:4w\u000eI\u0001\u000fK\u0012<Wm\u001d+p\u0007>l\u0007/\u001e;f\u0003=)GmZ3t)>\u001cu.\u001c9vi\u0016\u0004\u0013A\u00048fS\u001eD'm\u001c:W_b,Gn]\u0001\u0010]\u0016Lw\r\u001b2peZ{\u00070\u001a7tA\u0005YQ*\u0019=Ok6d\u0015N\\3t+\t\u0019Yj\u0004\u0002\u0004\u001ev\u0011q\u0002i\u0001\r\u001b\u0006Dh*^7MS:,7\u000fI\u0001\f\u001b\u0006Dh*^7CY>\u00147/\u0006\u0002\u0004&>\u00111qU\u000f\u0003\u0007!\u0010A\"T1y\u001dVl'\t\\8cg\u0002\u0002")
public final class Blobs2D {
    public static Tuple4<Outlet<Buf>, Outlet<Buf>, Outlet<Buf>, Outlet<Buf>> apply(Outlet<Buf> in, Outlet<Buf> width, Outlet<Buf> height, Outlet<Buf> thresh, Outlet<Buf> pad, Builder b) {
        return Blobs2D$.MODULE$.apply(in, width, height, thresh, pad, b);
    }

    private static final class Blob {
        private double xMin = 0.0;
        private double xMax = 0.0;
        private double yMin = 0.0;
        private double yMax = 0.0;
        private int numLines = 0;
        private final int[] line = new int[4000];

        public double xMin() {
            return this.xMin;
        }

        public void xMin_$eq(double x$1) {
            this.xMin = x$1;
        }

        public double xMax() {
            return this.xMax;
        }

        public void xMax_$eq(double x$1) {
            this.xMax = x$1;
        }

        public double yMin() {
            return this.yMin;
        }

        public void yMin_$eq(double x$1) {
            this.yMin = x$1;
        }

        public double yMax() {
            return this.yMax;
        }

        public void yMax_$eq(double x$1) {
            this.yMax = x$1;
        }

        public int numLines() {
            return this.numLines;
        }

        public void numLines_$eq(int x$1) {
            this.numLines = x$1;
        }

        public int[] line() {
            return this.line;
        }

        public String toString() {
            return StringOps$.MODULE$.format$extension("Blob(xMin = %g, xMax = %g, yMin = %g, yMax = %g, numLines = %s)", ScalaRunTime$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToDouble(this.xMin()), BoxesRunTime.boxToDouble(this.xMax()), BoxesRunTime.boxToDouble(this.yMin()), BoxesRunTime.boxToDouble(this.yMax()), BoxesRunTime.boxToInteger(this.numLines())}));
        }
    }

    private static final class Logic
    extends Handlers<In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>> {
        private final Handlers.InDMain hIn = Handlers$.MODULE$.InDMain(this, ((In5Out4Shape)super.shape()).in0());
        private final Handlers.InIAux hWidth = Handlers$.MODULE$.InIAux(this, ((In5Out4Shape)super.shape()).in1(), x$1 -> scala.math.package$.MODULE$.max(1, x$1));
        private final Handlers.InIAux hHeight = Handlers$.MODULE$.InIAux(this, ((In5Out4Shape)super.shape()).in2(), x$2 -> scala.math.package$.MODULE$.max(1, x$2));
        private final Handlers.InDAux hThresh;
        private final Handlers.InIAux hPad;
        private final Handlers.OutIMain hOutNumBlobs;
        private final Handlers.OutDMain hOutBounds;
        private final Handlers.OutIMain hOutNumVert;
        private final Handlers.OutDMain hOutVertices;
        private double[] winBuf;
        private int widthIn;
        private int heightIn;
        private int widthPad;
        private int heightPad;
        private double thresh;
        private int pad;
        private int winSizeIn;
        private int winSizePad;
        private int readOff;
        private int readRem;
        private int stage;
        private int writeOffNumBlobs;
        private int writeOffBounds;
        private int writeOffNumVertices;
        private int writeOffVertices;
        private int writeRem;
        private int writeRemNumBlobs;
        private int writeRemBounds;
        private int writeRemNumVertices;
        private int writeRemVertices;
        private int writeBlobVerticesBlobIdx;
        private int writeBlobVerticesVertexIdx;
        private Blob[] blobs;
        private boolean[] gridVisited;
        private int[] linesToDraw;
        private double[] edgeVrtX;
        private double[] edgeVrtY;
        private int numLinesToDraw;
        private int numBlobs;

        @Override
        public void stopped() {
            super.stopped();
            this.winBuf = null;
            this.blobs = null;
            this.gridVisited = null;
            this.linesToDraw = null;
            this.edgeVrtX = null;
            this.edgeVrtY = null;
        }

        private boolean tryObtainWinParams() {
            boolean ok;
            block0: {
                double oldThresh;
                block1: {
                    boolean bl = ok = this.hWidth.hasNext() && this.hHeight.hasNext() && this.hThresh.hasNext() && this.hPad.hasNext();
                    if (!ok) break block0;
                    int oldSizeIn = this.winSizeIn;
                    int oldSizePad = this.winSizePad;
                    oldThresh = this.thresh;
                    this.widthIn = this.hWidth.next();
                    this.heightIn = this.hHeight.next();
                    this.thresh = this.hThresh.next();
                    this.pad = this.hPad.next();
                    int pad2 = this.pad * 2;
                    int _widthIn = this.widthIn;
                    int _heightIn = this.heightIn;
                    int _widthPad = _widthIn + pad2;
                    int _heightPad = _heightIn + pad2;
                    int _winSizeIn = _widthIn * _heightIn;
                    int _winSizePad = _widthPad * _heightPad;
                    this.widthPad = _widthPad;
                    this.heightPad = _heightPad;
                    this.winSizeIn = _winSizeIn;
                    this.winSizePad = _winSizePad;
                    if (_winSizePad == oldSizePad && _winSizeIn == oldSizeIn) break block1;
                    this.updateSize();
                    if (this.thresh == 0.0) break block0;
                    this.fillThresh();
                    break block0;
                }
                if (this.thresh == oldThresh) break block0;
                this.fillThresh();
            }
            return ok;
        }

        private int winBufSize() {
            return this.winSizeIn;
        }

        private int readWinSize() {
            return this.winSizeIn;
        }

        private void clearWindowTail() {
            int chunk = this.winSizeIn - this.readOff;
            int _pad = this.pad;
            double[] _bufOut = this.winBuf;
            int writeToWinOff = this.readOff;
            double _thresh = this.thresh;
            if (_pad == 0) {
                Util$.MODULE$.fill(_bufOut, writeToWinOff, chunk, _thresh);
                return;
            }
            int remain = chunk;
            int _width = this.widthIn;
            int _widthPad = this.widthPad;
            int x = writeToWinOff % _width;
            int y = writeToWinOff / _width;
            int _outOff = (y + _pad) * _widthPad + _pad;
            while (remain > 0) {
                int num = scala.math.package$.MODULE$.min(_width - x, remain);
                Util$.MODULE$.fill(_bufOut, _outOff + x, num, _thresh);
                remain -= num;
                x = 0;
                _outOff += _widthPad;
            }
        }

        private void readIntoWindow(int chunk) {
            int _pad = this.pad;
            double[] _bufIn = (double[])this.hIn.array();
            int inOff = this.hIn.offset();
            double[] _bufOut = this.winBuf;
            int writeToWinOff = this.readOff;
            if (_pad == 0) {
                Util$.MODULE$.copy(_bufIn, inOff, _bufOut, writeToWinOff, chunk);
            } else {
                int remain = chunk;
                int _inOff = inOff;
                int _width = this.widthIn;
                int _widthPad = this.widthPad;
                int x = writeToWinOff % _width;
                int y = writeToWinOff / _width;
                int _outOff = (y + _pad) * _widthPad + _pad;
                while (remain > 0) {
                    int num = scala.math.package$.MODULE$.min(_width - x, remain);
                    Util$.MODULE$.copy(_bufIn, _inOff, _bufOut, _outOff + x, num);
                    _inOff += num;
                    remain -= num;
                    x = 0;
                    _outOff += _widthPad;
                }
            }
            this.hIn.advance(chunk);
        }

        private void processWindow() {
            if (this.readOff < this.winSizeIn) {
                this.clearWindowTail();
            }
            this.detectBlobs();
            int _numBlobs = this.numBlobs;
            int vertexCount = 0;
            for (int i = 0; i < _numBlobs; ++i) {
                Blob b = this.blobs[i];
                vertexCount += b.numLines() * 2;
            }
            this.writeRemNumBlobs = this.hOutNumBlobs.isDone() ? 0 : 1;
            this.writeRemBounds = this.hOutBounds.isDone() ? 0 : _numBlobs * 4;
            this.writeRemNumVertices = this.hOutNumVert.isDone() ? 0 : _numBlobs;
            this.writeRemVertices = this.hOutVertices.isDone() ? 0 : vertexCount;
            this.writeRem = this.writeRemNumBlobs + this.writeRemBounds + this.writeRemNumVertices + this.writeRemVertices;
        }

        private void processOutput() {
            if (this.writeRemNumBlobs > 0 && this.hOutNumBlobs.hasNext()) {
                Predef$.MODULE$.assert(this.writeRemNumBlobs == 1);
                this.hOutNumBlobs.next(this.numBlobs);
                --this.writeRemNumBlobs;
                --this.writeRem;
            }
            if (this.writeRemBounds > 0 && this.hOutBounds.hasNext()) {
                int _offIn;
                int chunk = scala.math.package$.MODULE$.min(this.writeRemBounds, this.hOutBounds.available());
                Handlers.OutDMain out = this.hOutBounds;
                Blob[] _blobs = this.blobs;
                int stop = _offIn + chunk;
                int _pad = this.pad;
                for (_offIn = this.writeOffBounds; _offIn < stop; ++_offIn) {
                    double d;
                    int blobIdx = _offIn / 4;
                    Blob blob = _blobs[blobIdx];
                    int n = _offIn % 4;
                    switch (n) {
                        case 0: {
                            d = blob.xMin();
                            break;
                        }
                        case 1: {
                            d = blob.xMax();
                            break;
                        }
                        case 2: {
                            d = blob.yMin();
                            break;
                        }
                        case 3: {
                            d = blob.yMax();
                            break;
                        }
                        default: {
                            throw new MatchError(BoxesRunTime.boxToInteger(n));
                        }
                    }
                    double coord = d;
                    out.next(coord - (double)_pad);
                }
                this.writeRemBounds -= chunk;
                this.writeRem -= chunk;
                this.writeOffBounds += chunk;
            }
            if (this.writeRemNumVertices > 0 && this.hOutNumVert.hasNext()) {
                int _offIn;
                int chunk = scala.math.package$.MODULE$.min(this.writeRemNumVertices, this.hOutNumVert.available());
                Blob[] _blobs = this.blobs;
                Handlers.OutIMain out = this.hOutNumVert;
                int stop = _offIn + chunk;
                for (_offIn = this.writeOffNumVertices; _offIn < stop; ++_offIn) {
                    Blob blob = _blobs[_offIn];
                    out.next(blob.numLines());
                }
                this.writeRemNumVertices -= chunk;
                this.writeRem -= chunk;
                this.writeOffNumVertices += chunk;
            }
            if (this.writeRemVertices > 0 && this.hOutVertices.hasNext()) {
                int chunk = scala.math.package$.MODULE$.min(this.writeRemVertices, this.hOutVertices.available());
                Blob[] _blobs = this.blobs;
                Handlers.OutDMain out = this.hOutVertices;
                int _blobIdx = this.writeBlobVerticesBlobIdx;
                int _vIdx = this.writeBlobVerticesVertexIdx;
                double[] _edgeX = this.edgeVrtX;
                double[] _edgeY = this.edgeVrtY;
                int _pad = this.pad;
                int i = 0;
                while (i < chunk) {
                    Blob blob = _blobs[_blobIdx];
                    int vCount = blob.numLines() * 2;
                    int chunk2 = scala.math.package$.MODULE$.min(chunk - i, vCount - _vIdx);
                    if (chunk2 > 0) {
                        int stop2 = _vIdx + chunk2;
                        while (_vIdx < stop2) {
                            int lineIdx = blob.line()[_vIdx & ~1];
                            double[] table2 = _vIdx % 2 == 0 ? _edgeX : _edgeY;
                            double value = table2[lineIdx];
                            out.next(value - (double)_pad);
                            ++i;
                            ++_vIdx;
                        }
                        continue;
                    }
                    ++_blobIdx;
                    _vIdx = 0;
                }
                this.writeBlobVerticesBlobIdx = _blobIdx;
                this.writeBlobVerticesVertexIdx = _vIdx;
                this.writeRemVertices -= chunk;
                this.writeRem -= chunk;
                return;
            }
        }

        private void prepareStage2() {
            this.processWindow();
            this.writeOffNumBlobs = 0;
            this.writeOffBounds = 0;
            this.writeOffNumVertices = 0;
            this.writeOffVertices = 0;
            this.writeBlobVerticesBlobIdx = 0;
            this.writeBlobVerticesVertexIdx = 0;
        }

        @Override
        public void process() {
            block0: while (true) {
                Log$.MODULE$.stream().debug((Function0<String> & Serializable)() -> new StringBuilder(10).append("process() ").append(this).toString());
                if (this.stage == 0) {
                    if (!this.tryObtainWinParams()) {
                        return;
                    }
                    int _winBufSz = this.winBufSize();
                    if (this.winBuf == null || this.winBuf.length != _winBufSz) {
                        this.winBuf = _winBufSz == 0 ? null : new double[_winBufSz];
                    }
                    this.readOff = 0;
                    this.readRem = this.readWinSize();
                    this.stage = 1;
                }
                while (this.stage == 1) {
                    int remIn = this.hIn.available();
                    if (remIn == 0) {
                        return;
                    }
                    int numIn = scala.math.package$.MODULE$.min(remIn, this.readRem);
                    if (numIn > 0) {
                        this.readIntoWindow(numIn);
                    }
                    this.readOff += numIn;
                    this.readRem -= numIn;
                    if (!this.hIn.isDone() && this.readRem != 0) continue;
                    this.prepareStage2();
                    this.stage = 2;
                }
                while (true) {
                    if (this.stage != 2) continue block0;
                    int oldRem = this.writeRem;
                    if (this.writeRem > 0) {
                        this.processOutput();
                    }
                    if (this.writeRem == 0) {
                        if (this.hIn.isDone()) {
                            if (this.flushOut()) {
                                this.completeStage();
                            }
                            return;
                        }
                        this.stage = 0;
                        continue;
                    }
                    if (this.writeRem == oldRem) break block0;
                }
                break;
            }
        }

        @Override
        public void onDone(Outlet<?> outlet) {
            if (this.stage == 2) {
                Outlet<?> outlet2 = outlet;
                Outlet<Buf> outlet3 = this.hOutVertices.outlet();
                if (!(outlet2 != null ? !((Object)outlet2).equals(outlet3) : outlet3 != null)) {
                    this.writeRem -= this.writeRemVertices;
                    this.writeRemVertices = 0;
                } else {
                    Outlet<?> outlet4 = outlet;
                    Outlet<Buf> outlet5 = this.hOutBounds.outlet();
                    if (!(outlet4 != null ? !((Object)outlet4).equals(outlet5) : outlet5 != null)) {
                        this.writeRem -= this.writeRemBounds;
                        this.writeRemBounds = 0;
                    } else {
                        Outlet<?> outlet6 = outlet;
                        Outlet<Buf> outlet7 = this.hOutNumVert.outlet();
                        if (!(outlet6 != null ? !((Object)outlet6).equals(outlet7) : outlet7 != null)) {
                            this.writeRem -= this.writeRemNumVertices;
                            this.writeRemNumVertices = 0;
                        } else {
                            Outlet<?> outlet8 = outlet;
                            Outlet<Buf> outlet9 = this.hOutNumBlobs.outlet();
                            Predef$.MODULE$.assert(!(outlet8 != null ? !((Object)outlet8).equals(outlet9) : outlet9 != null));
                            this.writeRem -= this.writeRemNumBlobs;
                            this.writeRemNumBlobs = 0;
                        }
                    }
                }
                this.process();
                return;
            }
            if (this.hOutNumBlobs.isDone() && this.hOutBounds.isDone() && this.hOutNumVert.isDone() && this.hOutVertices.isDone()) {
                if (this.flushOut()) {
                    this.completeStage();
                    return;
                }
                return;
            }
        }

        @Override
        public void onDone(Inlet<?> inlet) {
            Inlet<?> inlet2 = inlet;
            Inlet<Buf> inlet3 = this.hIn.inlet();
            Predef$.MODULE$.assert(!(inlet2 != null ? !((Object)inlet2).equals(inlet3) : inlet3 != null));
            if (this.stage == 0 || this.stage == 1 && (long)this.readOff == 0L) {
                this.stage = 2;
                if (this.flushOut()) {
                    this.completeStage();
                    return;
                }
                return;
            }
            if (this.stage == 1) {
                this.prepareStage2();
                this.stage = 2;
                this.process();
                return;
            }
        }

        private boolean flushOut() {
            return this.hOutNumBlobs.flush() & this.hOutBounds.flush() & this.hOutNumVert.flush() & this.hOutVertices.flush();
        }

        private void updateSize() {
            int _winSize = this.winSizePad;
            int winSz2 = _winSize * 2;
            this.winBuf = new double[_winSize];
            this.gridVisited = new boolean[_winSize];
            this.linesToDraw = new int[winSz2];
            this.edgeVrtX = new double[winSz2];
            this.edgeVrtY = new double[winSz2];
            this.blobs = (Blob[])Array$.MODULE$.fill(1000, (Function0<Blob> & Serializable)() -> new Blob(), ClassTag$.MODULE$.apply(Blob.class));
        }

        private void fillThresh() {
            Util$.MODULE$.fill(this.winBuf, 0, this.winSizePad, this.thresh);
        }

        private void detectBlobs() {
            int x;
            boolean[] _visited = this.gridVisited;
            Arrays.fill(_visited, false);
            this.numLinesToDraw = 0;
            int _numBlobs = 0;
            Blob[] _blobs = this.blobs;
            int _width = this.widthPad;
            int _widthM = _width - 1;
            int _height = this.heightPad;
            int _heightM = _height - 1;
            double[] _edgeX = this.edgeVrtX;
            double[] _edgeY = this.edgeVrtY;
            int y = 0;
            int n = 0;
            for (x = 0; x < _width; ++x) {
                for (y = 0; y < _height; ++y) {
                    _edgeX[n] = x;
                    _edgeY[n] = y;
                    _edgeX[++n] = x;
                    _edgeY[n] = y;
                    ++n;
                }
            }
            for (x = 0; x < _widthM; ++x) {
                for (y = 0; y < _heightM; ++y) {
                    Blob blob;
                    boolean valid;
                    int sqrIdx;
                    int offset = x + _width * y;
                    if (_visited[offset] || (sqrIdx = this.getSquareIndex(x, y)) <= 0 || sqrIdx >= 15 || _numBlobs >= 1000 || !(valid = this.findBlob(blob = _blobs[_numBlobs], x, y))) continue;
                    ++_numBlobs;
                }
            }
            this.numLinesToDraw /= 2;
            this.numBlobs = _numBlobs;
        }

        private boolean findBlob(Blob blob, int x, int y) {
            boolean valid;
            block0: {
                blob.xMin_$eq(Double.POSITIVE_INFINITY);
                blob.xMax_$eq(Double.NEGATIVE_INFINITY);
                blob.yMin_$eq(Double.POSITIVE_INFINITY);
                blob.yMax_$eq(Double.NEGATIVE_INFINITY);
                blob.numLines_$eq(0);
                this.computeEdgeVertex(blob, x, y);
                boolean bl = valid = blob.xMin() < blob.xMax() && blob.yMin() < blob.yMax();
                if (!valid) break block0;
                blob.numLines_$eq(blob.numLines() / 2);
            }
            return valid;
        }

        private void computeEdgeVertex(Blob blob, int x, int y) {
            while (true) {
                int _width = this.widthPad;
                int _height = this.heightPad;
                boolean[] _visited = this.gridVisited;
                int offset = x + _width * y;
                if (_visited[offset]) {
                    return;
                }
                _visited[offset] = true;
                int sqrIdx = this.getSquareIndex(x, y);
                int n = 0;
                int iEdge = Blobs2D$.MODULE$.de$sciss$fscape$stream$Blobs2D$$edgeCuts()[sqrIdx][n];
                while (iEdge != -1) {
                    int v;
                    if (blob.numLines() == 4000) {
                        return;
                    }
                    int[] edgeOffInf = Blobs2D$.MODULE$.de$sciss$fscape$stream$Blobs2D$$edgeOffsetInfo()[iEdge];
                    int offX = edgeOffInf[0];
                    int offY = edgeOffInf[1];
                    int offAB = edgeOffInf[2];
                    this.linesToDraw[this.numLinesToDraw] = v = Logic.voxel$1(x + offX, y + offY, _height) + offAB;
                    ++this.numLinesToDraw;
                    blob.line()[blob.numLines()] = v;
                    blob.numLines_$eq(blob.numLines() + 1);
                    iEdge = Blobs2D$.MODULE$.de$sciss$fscape$stream$Blobs2D$$edgeCuts()[sqrIdx][++n];
                }
                int toCompute = Blobs2D$.MODULE$.de$sciss$fscape$stream$Blobs2D$$edgesToCompute()[sqrIdx];
                if (toCompute > 0) {
                    if ((toCompute & 1) > 0) {
                        double[] _buf = this.winBuf;
                        double t = (this.thresh - _buf[offset]) / (_buf[offset + 1] - _buf[offset]);
                        double value = (double)x * (1.0 - t) + t * (double)(x + 1);
                        int edgeIdx = Logic.voxel$1(x, y, _height);
                        this.edgeVrtX[edgeIdx] = value;
                        if (value < blob.xMin()) {
                            blob.xMin_$eq(value);
                        }
                        if (value > blob.xMax()) {
                            blob.xMax_$eq(value);
                        }
                    }
                    if ((toCompute & 2) > 0) {
                        double[] _buf = this.winBuf;
                        double t = (this.thresh - _buf[offset]) / (_buf[offset + _width] - _buf[offset]);
                        double value = (double)y * (1.0 - t) + t * (double)(y + 1);
                        int edgeIdx = Logic.voxel$1(x, y, _height) + 1;
                        this.edgeVrtY[edgeIdx] = value;
                        if (value < blob.yMin()) {
                            blob.yMin_$eq(value);
                        }
                        if (value > blob.yMax()) {
                            blob.yMax_$eq(value);
                        }
                    }
                }
                int neighVox = Blobs2D$.MODULE$.de$sciss$fscape$stream$Blobs2D$$neighborVoxels()[sqrIdx];
                if (x < _width - 2 && (neighVox & 1) > 0) {
                    this.computeEdgeVertex(blob, x + 1, y);
                }
                if (x > 0 && (neighVox & 2) > 0) {
                    this.computeEdgeVertex(blob, x - 1, y);
                }
                if (y < _height - 2 && (neighVox & 4) > 0) {
                    this.computeEdgeVertex(blob, x, y + 1);
                }
                if (y <= 0 || (neighVox & 8) <= 0) break;
                --y;
            }
        }

        private int getSquareIndex(int x, int y) {
            int res;
            block3: {
                int _width = this.widthPad;
                double[] _buf = this.winBuf;
                double _thresh = this.thresh;
                int offY = _width * y;
                int offY1 = offY + _width;
                int x1 = x + 1;
                res = 0;
                if (_buf[x + offY] > _thresh) {
                    res |= 1;
                }
                if (_buf[x1 + offY] > _thresh) {
                    res |= 2;
                }
                if (_buf[x1 + offY1] > _thresh) {
                    res |= 4;
                }
                if (!(_buf[x + offY1] > _thresh)) break block3;
                res |= 8;
            }
            return res;
        }

        private static final int voxel$1(int x, int y, int _height$1) {
            return (y + x * _height$1) * 2;
        }

        public Logic(In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape, int layer, Allocator a) {
            super("Blobs2D", layer, shape, a);
            Logic x$12 = this;
            Inlet<Buf> x$22 = ((In5Out4Shape)super.shape()).in3();
            Function1<Object, Object> x$32 = Handlers$.MODULE$.InDAux$default$3(x$12, x$22);
            this.hThresh = Handlers$.MODULE$.InDAux(x$12, x$22, x$32);
            this.hPad = Handlers$.MODULE$.InIAux(this, ((In5Out4Shape)super.shape()).in4(), x$3 -> scala.math.package$.MODULE$.max(0, x$3));
            this.hOutNumBlobs = Handlers$.MODULE$.OutIMain(this, ((In5Out4Shape)super.shape()).out0());
            this.hOutBounds = Handlers$.MODULE$.OutDMain(this, ((In5Out4Shape)super.shape()).out1());
            this.hOutNumVert = Handlers$.MODULE$.OutIMain(this, ((In5Out4Shape)super.shape()).out2());
            this.hOutVertices = Handlers$.MODULE$.OutDMain(this, ((In5Out4Shape)super.shape()).out3());
            this.stage = 0;
            this.writeRem = 0;
            this.writeBlobVerticesBlobIdx = 0;
            this.writeBlobVerticesVertexIdx = 0;
            this.numLinesToDraw = 0;
            this.numBlobs = 0;
        }
    }

    private static final class Stage
    extends StageImpl<In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>> {
        private final int layer;
        private final Allocator a;
        private final In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape;

        @Override
        public In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf> shape() {
            return this.shape;
        }

        @Override
        public NodeImpl<In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>> createLogic(Attributes attr) {
            return new Logic((In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>)this.shape(), this.layer, this.a);
        }

        public Stage(int layer, Allocator a) {
            this.layer = layer;
            this.a = a;
            super("Blobs2D");
            this.shape = new In5Out4Shape<Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf, Buf>(package$.MODULE$.InD(new StringBuilder(3).append(this.name()).append(".in").toString()), package$.MODULE$.InI(new StringBuilder(6).append(this.name()).append(".width").toString()), package$.MODULE$.InI(new StringBuilder(7).append(this.name()).append(".height").toString()), package$.MODULE$.InD(new StringBuilder(7).append(this.name()).append(".thresh").toString()), package$.MODULE$.InI(new StringBuilder(4).append(this.name()).append(".pad").toString()), package$.MODULE$.OutI(new StringBuilder(9).append(this.name()).append(".numBlobs").toString()), package$.MODULE$.OutD(new StringBuilder(7).append(this.name()).append(".bounds").toString()), package$.MODULE$.OutI(new StringBuilder(12).append(this.name()).append(".numVertices").toString()), package$.MODULE$.OutD(new StringBuilder(9).append(this.name()).append(".vertices").toString()));
        }
    }
}

