/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.FanInShape5;
import akka.stream.Outlet;
import de.sciss.fscape.DataType$;
import de.sciss.fscape.Util$;
import de.sciss.fscape.graph.GenWindow$Hamming$;
import de.sciss.fscape.stream.Allocator;
import de.sciss.fscape.stream.Buf;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.ConstQ$;
import de.sciss.fscape.stream.impl.Handlers;
import de.sciss.fscape.stream.impl.Handlers$;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.fscape.stream.impl.logic.FilterWindowedInAOutA;
import de.sciss.fscape.stream.impl.logic.WindowedInAOutB;
import de.sciss.fscape.stream.package$;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.IntFunctions$;
import de.sciss.numbers.RichDouble;
import de.sciss.transform4s.fft.DoubleFFT_1D;
import de.sciss.transform4s.fft.DoubleFFT_1D$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Ux!B\u00181\u0011\u0003Id!B\u001e1\u0011\u0003a\u0004\"B\"\u0002\t\u0003!\u0005\"B#\u0002\t\u00031\u0005bB1\u0002\u0005\u0004%iA\u0019\u0005\u0007K\u0006\u0001\u000bQB2\u0006\t\u0019\fAa\u001a\u0004\u0005q\u00061\u0011\u0010\u0003\u0006\u0002\u0006\u001d\u0011\t\u0011)A\u0005\u0003\u000fA!\"!\u0004\b\u0005\u0003\u0005\u000b1BA\b\u0011\u0019\u0019u\u0001\"\u0001\u0002\u0016!I\u0011qD\u0004C\u0002\u0013\u0005\u0011\u0011\u0005\u0005\t\u0003_9\u0001\u0015!\u0003\u0002$!9\u0011\u0011G\u0004\u0005\u0002\u0005MbABA#\u0003\u0019\t9\u0005\u0003\u0006\u0002J9\u0011)\u0019!C\u0001\u0003\u0017B!\"a\u0015\u000f\u0005\u0003\u0005\u000b\u0011BA'\u0011)\t)F\u0004BC\u0002\u0013\u0005\u0011q\u000b\u0005\u000b\u0003Kr!\u0011!Q\u0001\n\u0005e\u0003BCA4\u001d\t\u0015\r\u0011\"\u0001\u0002j!Q\u00111\u000e\b\u0003\u0002\u0003\u0006I!a\u0018\t\r\rsA\u0011AA7\r\u0019\t9(\u0001\u0004\u0002z!a\u0011q\u0004\f\u0003\u0002\u0003\u0006I!!\u0001\u0002\b\"a\u0011Q\u0001\f\u0003\u0002\u0003\u0006I!a\u0002\u0002\n\"a\u0011Q\u0002\f\u0003\u0002\u0003\u0006Y!a\u0004\u0002\f\"11I\u0006C\u0001\u0003\u001fC\u0001\"a'\u0017A\u0003%\u0011Q\u0014\u0005\t\u0003W3\u0002\u0015!\u0003\u0002.\"A\u00111\u0017\f!\u0002\u0013\ti\u000b\u0003\u0005\u00026Z\u0001\u000b\u0011BAO\u0011!\t9L\u0006Q!\n\u00055\u0003b\u0002/\u0017A\u0003&\u0011q\f\u0005\b=Z\u0001\u000b\u0015BA0\u0011\u001d\u0001g\u0003)Q\u0005\u0003\u001bB1\"!/\u0017\u0001\u0004\u0005\t\u0015)\u0003\u0002Z!Y\u00111\u0018\fA\u0002\u0003\u0005\u000b\u0015BA-\u0011-\tiL\u0006a\u0001\u0002\u0003\u0006K!a0\t\u000f\u0005\u0005g\u0003\"\u0015\u0002D\"9\u00111\u001a\f\u0005\u0012\u0005-\u0003bBAg-\u0011E\u0013q\u001a\u0005\b\u0003/4B\u0011KAh\u0011\u001d\tIN\u0006C\t\u00037Dq!a9\u0017\t\u0013\t\u0019\rC\u0004\u0002fZ!\t&a:\t\u000f\u00055h\u0003\"\u0015\u0002p\"9\u00111\u001f\f\u0005\u0012\u0005\r\u0017AB\"p]N$\u0018K\u0003\u00022e\u000511\u000f\u001e:fC6T!a\r\u001b\u0002\r\u0019\u001c8-\u00199f\u0015\t)d'A\u0003tG&\u001c8OC\u00018\u0003\t!Wm\u0001\u0001\u0011\u0005i\nQ\"\u0001\u0019\u0003\r\r{gn\u001d;R'\t\tQ\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003e\nQ!\u00199qYf$ba\u0012+W7v{FC\u0001%P!\tIEJ\u0004\u0002;\u0015&\u00111\nM\u0001\ba\u0006\u001c7.Y4f\u0013\tieJ\u0001\u0003PkR$%BA&1\u0011\u0015\u00016\u0001q\u0001R\u0003\u0005\u0011\u0007C\u0001\u001eS\u0013\t\u0019\u0006GA\u0004Ck&dG-\u001a:\t\u000bU\u001b\u0001\u0019\u0001%\u0002\u0005%t\u0007\"B,\u0004\u0001\u0004A\u0016a\u00024giNK'0\u001a\t\u0003\u0013fK!A\u0017(\u0003\t=+H/\u0013\u0005\u00069\u000e\u0001\r\u0001S\u0001\t[&tgI]3r\u001d\")al\u0001a\u0001\u0011\u0006AQ.\u0019=Ge\u0016\fh\nC\u0003a\u0007\u0001\u0007\u0001,\u0001\u0005ok6\u0014\u0015M\u001c3t\u0003\u0011q\u0017-\\3\u0016\u0003\r|\u0011\u0001Z\u0011\u0002_\u0005)a.Y7fA\t\u00191\u000b\u001b9\u0011\u0011!dg.\u001e8ok:l\u0011!\u001b\u0006\u0003c)T\u0011a[\u0001\u0005C.\\\u0017-\u0003\u0002nS\nYa)\u00198J]NC\u0017\r]36!\ty'O\u0004\u0002;a&\u0011\u0011\u000fM\u0001\u0004\u0005V4\u0017BA:u\u0005\u0005!%BA91!\tyg/\u0003\u0002xi\n\t\u0011JA\u0003Ti\u0006<Wm\u0005\u0002\buB!1P`A\u0001\u001b\u0005a(BA?1\u0003\u0011IW\u000e\u001d7\n\u0005}d(!C*uC\u001e,\u0017*\u001c9m!\r\t\u0019AB\u0007\u0002\u0003\u0005)A.Y=feB\u0019\u0011*!\u0003\n\u0007\u0005-aJA\u0003MCf,'/A\u0001b!\rQ\u0014\u0011C\u0005\u0004\u0003'\u0001$!C!mY>\u001c\u0017\r^8s)\u0011\t9\"!\b\u0015\t\u0005e\u00111\u0004\t\u0004\u0003\u00079\u0001bBA\u0007\u0015\u0001\u000f\u0011q\u0002\u0005\b\u0003\u000bQ\u0001\u0019AA\u0004\u0003\u0015\u0019\b.\u00199f+\t\t\u0019\u0003\u0005\u0003\u0002&\u0005\u001dR\"A\u0004\n\t\u0005%\u00121\u0006\u0002\u0006'\"\f\u0007/Z\u0005\u0004\u0003[I'!B$sCBD\u0017AB:iCB,\u0007%A\u0006de\u0016\fG/\u001a'pO&\u001cG\u0003BA\u001b\u0003w\u0001Ra_A\u001c\u0003GI1!!\u000f}\u0005!qu\u000eZ3J[Bd\u0007bBA\u001f\u001b\u0001\u0007\u0011qH\u0001\u0005CR$(\u000fE\u0002i\u0003\u0003J1!a\u0011j\u0005)\tE\u000f\u001e:jEV$Xm\u001d\u0002\u0007\u0017\u0016\u0014h.\u001a7\u0014\u00059i\u0014AB8gMN,G/\u0006\u0002\u0002NA\u0019a(a\u0014\n\u0007\u0005EsHA\u0002J]R\fqa\u001c4gg\u0016$\b%\u0001\u0003eCR\fWCAA-!\u0015q\u00141LA0\u0013\r\tif\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004}\u0005\u0005\u0014bAA2\u007f\t1Ai\\;cY\u0016\fQ\u0001Z1uC\u0002\nQA\u001a:fc:+\"!a\u0018\u0002\r\u0019\u0014X-\u001d(!)!\ty'!\u001d\u0002t\u0005U\u0004cAA\u0002\u001d!9\u0011\u0011J\u000bA\u0002\u00055\u0003bBA++\u0001\u0007\u0011\u0011\f\u0005\b\u0003O*\u0002\u0019AA0\u0005\u0015aunZ5d'\r1\u00121\u0010\t\t\u0003{\n\u0019)a\u0018\u0002\u00025\u0011\u0011q\u0010\u0006\u0004\u0003\u0003c\u0018!\u00027pO&\u001c\u0017\u0002BAC\u0003\u007f\u0012QCR5mi\u0016\u0014x+\u001b8e_^,G-\u00138B\u001fV$\u0018)\u0003\u0003\u0002 \u0005]\u0012\u0002BA\u0003\u0003oIA!!$\u00028\u0005I\u0011\r\u001c7pG\u0006$xN\u001d\u000b\u0007\u0003#\u000b9*!'\u0015\t\u0005M\u0015Q\u0013\t\u0004\u0003\u00071\u0002bBA\u00075\u0001\u000f\u0011q\u0002\u0005\b\u0003?Q\u0002\u0019AA\u0001\u0011\u001d\t)A\u0007a\u0001\u0003\u000f\tQ\u0001[*ju\u0016\u0004B!a(\u0002&:\u001910!)\n\u0007\u0005\rF0\u0001\u0005IC:$G.\u001a:t\u0013\u0011\t9+!+\u0003\r%s\u0017*Q;y\u0015\r\t\u0019\u000b`\u0001\nQ6KgN\u0012:fc:\u0003B!a(\u00020&!\u0011\u0011WAU\u0005\u0019Ie\u000eR!vq\u0006I\u0001.T1y\rJ,\u0017OT\u0001\u0007Q\n\u000bg\u000eZ:\u0002\tML'0Z\u0001\u0006S:\u0014UOZ\u0001\u0007_V$()\u001e4\u0002\u000f-,'O\\3mgB)a(a\u0017\u0002p\u000591\u000f^8qa\u0016$GCAAc!\rq\u0014qY\u0005\u0004\u0003\u0013|$\u0001B+oSR\f!b^5o\u0005V47+\u001b>f\u0003-\u0011X-\u00193XS:\u001c\u0016N_3\u0016\u0005\u0005E\u0007c\u0001 \u0002T&\u0019\u0011Q[ \u0003\t1{gnZ\u0001\roJLG/Z,j]NK'0Z\u0001\u0013iJLxJ\u0019;bS:<\u0016N\u001c)be\u0006l7\u000f\u0006\u0002\u0002^B\u0019a(a8\n\u0007\u0005\u0005xHA\u0004C_>dW-\u00198\u0002\u0019U\u0004H-\u0019;f\u0007>tg-[4\u0002\u001dI,\u0017\rZ%oi><\u0016N\u001c3poR!\u0011QYAu\u0011\u001d\tY\u000f\fa\u0001\u0003\u001b\n\u0011A\\\u0001\u0010oJLG/\u001a$s_6<\u0016N\u001c3poR!\u0011QYAy\u0011\u001d\tY/\fa\u0001\u0003\u001b\nQ\u0002\u001d:pG\u0016\u001c8oV5oI><\b")
public final class ConstQ {
    public static Outlet<Buf> apply(Outlet<Buf> in, Outlet<Buf> fftSize, Outlet<Buf> minFreqN, Outlet<Buf> maxFreqN, Outlet<Buf> numBands, Builder b) {
        return ConstQ$.MODULE$.apply(in, fftSize, minFreqN, maxFreqN, numBands, b);
    }

    private static final class Kernel {
        private final int offset;
        private final double[] data;
        private final double freqN;

        public int offset() {
            return this.offset;
        }

        public double[] data() {
            return this.data;
        }

        public double freqN() {
            return this.freqN;
        }

        public Kernel(int offset, double[] data, double freqN) {
            this.offset = offset;
            this.data = data;
            this.freqN = freqN;
        }
    }

    private static final class Logic
    extends FilterWindowedInAOutA<Object, FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf>> {
        private final Handlers.InIAux hSize = Handlers$.MODULE$.InIAux(this, ((FanInShape5)super.shape()).in1(), x$1 -> scala.math.package$.MODULE$.max(1, x$1));
        private final Handlers.InDAux hMinFreqN = Handlers$.MODULE$.InDAux(this, ((FanInShape5)super.shape()).in2(), x$2 -> new RichDouble(Implicits$.MODULE$.doubleNumberWrapper(x$2)).clip(1.0E-7, 0.5));
        private final Handlers.InDAux hMaxFreqN = Handlers$.MODULE$.InDAux(this, ((FanInShape5)super.shape()).in3(), x$3 -> new RichDouble(Implicits$.MODULE$.doubleNumberWrapper(x$3)).clip(1.0E-7, 0.5));
        private final Handlers.InIAux hBands = Handlers$.MODULE$.InIAux(this, ((FanInShape5)super.shape()).in4(), x$4 -> scala.math.package$.MODULE$.max(1, x$4));
        private int size = 0;
        private double minFreqN = -1.0;
        private double maxFreqN = -1.0;
        private int numBands = 0;
        private double[] inBuf;
        private double[] outBuf;
        private Kernel[] kernels;

        @Override
        public void stopped() {
            WindowedInAOutB.stopped$(this);
            this.inBuf = null;
            this.outBuf = null;
            this.kernels = null;
        }

        @Override
        public int winBufSize() {
            return 0;
        }

        @Override
        public long readWinSize() {
            return this.size;
        }

        @Override
        public long writeWinSize() {
            return this.numBands;
        }

        @Override
        public boolean tryObtainWinParams() {
            boolean ok;
            block5: {
                int _numBands;
                double _maxFreqN;
                double _minFreqN;
                boolean bl = ok = this.hSize.hasNext() && this.hMinFreqN.hasNext() && this.hMaxFreqN.hasNext() && this.hBands.hasNext();
                if (!ok) break block5;
                boolean needsUpdate = false;
                int _size = this.hSize.next();
                if (this.size != _size) {
                    this.size = _size;
                    needsUpdate = true;
                }
                if (this.minFreqN != (_minFreqN = this.hMinFreqN.next())) {
                    this.minFreqN = _minFreqN;
                    needsUpdate = true;
                }
                if (this.maxFreqN != (_maxFreqN = this.hMaxFreqN.next())) {
                    this.maxFreqN = _maxFreqN;
                    needsUpdate = true;
                }
                if (this.numBands != (_numBands = this.hBands.next())) {
                    this.numBands = _numBands;
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    this.updateConfig();
                }
            }
            return ok;
        }

        private void updateConfig() {
            boolean reverse;
            boolean bl = reverse = this.maxFreqN < this.minFreqN;
            if (reverse) {
                double tmp = this.minFreqN;
                this.minFreqN = this.maxFreqN;
                this.maxFreqN = tmp;
            }
            double freqF = this.maxFreqN / this.minFreqN;
            int _numBands = this.numBands;
            double q = 1.0 / (scala.math.package$.MODULE$.pow(freqF, 1.0 / (double)_numBands) - 1.0);
            Kernel[] _kernels = new Kernel[_numBands];
            double maxKernLen = q / this.minFreqN;
            int maxKernLenI = (int)scala.math.package$.MODULE$.ceil(maxKernLen);
            double[] win = new double[maxKernLenI];
            this.inBuf = new double[this.size];
            this.outBuf = new double[_numBands];
            int fftSizeK = scala.math.package$.MODULE$.min(this.size, IntFunctions$.MODULE$.nextPowerOfTwo(maxKernLenI));
            int fftSizeC = fftSizeK << 1;
            double[] fftBuf = new double[fftSizeC];
            DoubleFFT_1D fft = DoubleFFT_1D$.MODULE$.apply(fftSizeK);
            double threshSqr = 2.6244E-4;
            int lastKernLen = -1;
            for (int k = 0; k < _numBands; ++k) {
                int specStart;
                double freqK = scala.math.package$.MODULE$.pow(freqF, (double)k / (double)_numBands);
                double kernLenIdeal = maxKernLen / freqK;
                int kernelLen = scala.math.package$.MODULE$.min(fftSizeK, (int)scala.math.package$.MODULE$.ceil(kernLenIdeal));
                int kernelLenE = kernelLen & ~1;
                if (kernelLen != lastKernLen) {
                    GenWindow$Hamming$.MODULE$.fill(kernelLen, 0L, win, 0, kernelLen, 0.0);
                    lastKernLen = kernelLen;
                }
                double centerFreqN = this.minFreqN * freqK;
                double centerFreqRad = centerFreqN * -(Math.PI * 2);
                double weight = (double)6 / ((kernLenIdeal + (double)kernelLen) * (double)fftSizeK);
                int n = fftSizeC - kernelLenE;
                for (int m = kernelLenE; m < n; ++m) {
                    fftBuf[m] = 0.0;
                }
                int j = fftSizeC - kernelLenE;
                for (int i = kernelLen - 1; i >= 0; --i) {
                    double d1 = centerFreqRad * (double)i;
                    double cos = scala.math.package$.MODULE$.cos(d1);
                    double sin = scala.math.package$.MODULE$.sin(d1);
                    double d2 = win[i] * weight;
                    fftBuf[j] = d2 * cos;
                    fftBuf[++j] = d2 * sin;
                    if (++j != fftSizeC) continue;
                    j = 0;
                }
                fft.complexForward(fftBuf);
                Util$.MODULE$.mul(fftBuf, 0, fftSizeK, fftSizeK);
                int i = 0;
                boolean bl2 = false;
                while (!bl2 && i <= fftSizeK) {
                    double f1 = fftBuf[i];
                    double f2 = fftBuf[i + 1];
                    double magSqr = f1 * f1 + f2 * f2;
                    if (magSqr > threshSqr) {
                        bl2 = true;
                        continue;
                    }
                    i += 2;
                }
                int i2 = specStart = i;
                break = false;
                while (!break && i2 <= fftSizeK) {
                    double f1 = fftBuf[i2];
                    double f2 = fftBuf[i2 + 1];
                    double magSqr = f1 * f1 + f2 * f2;
                    if (magSqr <= threshSqr) {
                        break = true;
                        continue;
                    }
                    i2 += 2;
                }
                int specStop = i2;
                _kernels[k] = new Kernel(specStart, new double[specStop - specStart], centerFreqN);
                System.arraycopy(fftBuf, specStart, _kernels[k].data(), 0, specStop - specStart);
            }
            if (reverse) {
                Util$.MODULE$.reverse((Object[])_kernels, 0, _numBands);
            }
            this.kernels = _kernels;
        }

        @Override
        public void readIntoWindow(int n) {
            int offI = (int)this.readOff();
            this.hIn().nextN(this.inBuf, offI, n);
        }

        @Override
        public void writeFromWindow(int n) {
            int offI = (int)this.writeOff();
            this.hOut().nextN(this.outBuf, offI, n);
        }

        @Override
        public void processWindow() {
            double[] _bufIn = this.inBuf;
            double[] _bufOut = this.outBuf;
            int inStop = (int)this.readOff() & ~1;
            int _numBands = this.numBands;
            int k = 0;
            int outOff = 0;
            while (k < _numBands) {
                Kernel kern = this.kernels[k];
                double[] data = kern.data();
                double f1 = 0.0;
                double f2 = 0.0;
                int i = kern.offset();
                int n = scala.math.package$.MODULE$.min(data.length, inStop - i);
                for (int j = 0; j < n; j += 2) {
                    double re1 = _bufIn[i];
                    double im1 = _bufIn[i + 1];
                    double re2 = data[j];
                    double im2 = data[j + 1];
                    f1 += re1 * re2 - im1 * im2;
                    f2 += re1 * im2 + im1 * re2;
                    i += 2;
                }
                _bufOut[outOff] = f1 * f1 + f2 * f2;
                ++k;
                ++outOff;
            }
        }

        public Logic(FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf> shape, int layer, Allocator a) {
            super("ConstQ", layer, shape, shape.in0(), shape.out(), a, DataType$.MODULE$.double());
        }
    }

    private static final class Stage
    extends StageImpl<FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf>> {
        private final int layer;
        private final Allocator a;
        private final FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf> shape;

        @Override
        public FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf> shape() {
            return this.shape;
        }

        @Override
        public NodeImpl<FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf>> createLogic(Attributes attr) {
            return new Logic((FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf>)this.shape(), this.layer, this.a);
        }

        public Stage(int layer, Allocator a) {
            this.layer = layer;
            this.a = a;
            super("ConstQ");
            this.shape = new FanInShape5<Buf, Buf, Buf, Buf, Buf, Buf>(package$.MODULE$.InD(new StringBuilder(3).append(this.name()).append(".in").toString()), package$.MODULE$.InI(new StringBuilder(8).append(this.name()).append(".fftSize").toString()), package$.MODULE$.InD(new StringBuilder(9).append(this.name()).append(".minFreqN").toString()), package$.MODULE$.InD(new StringBuilder(9).append(this.name()).append(".maxFreqN").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".zero").toString()), package$.MODULE$.OutD(new StringBuilder(4).append(this.name()).append(".out").toString()));
        }
    }
}

