/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import de.sciss.fscape.DataType;
import de.sciss.fscape.stream.Control;
import de.sciss.fscape.stream.FileBuffer$;
import de.sciss.fscape.stream.FileBufferD;
import de.sciss.fscape.stream.FileBufferI;
import de.sciss.fscape.stream.FileBufferL;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import scala.math.package$;
import scala.reflect.ScalaSignature;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0005\r\u001dq!B%K\u0011\u0003\u0019f!B+K\u0011\u00031\u0006\"B/\u0002\t\u0003q\u0006\"B0\u0002\t\u0003\u0001\u0007bBA:\u0003\u0011\u0005\u0011Q\u000f\u0005\b\u0003\u0003\u000bA\u0011AAB\u0011\u001d\ty)\u0001C\u0001\u0003#CaaX\u0001\u0005\u0002\u0005ueaBA]\u0003\u0005%\u00111\u0018\u0005\tM\"\u0011)\u0019!C\u0001O\"I\u0011Q\u0019\u0005\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\u000b\u0003cC!\u0011!Q\u0001\n\u0005M\u0006BB/\t\t\u0003\t9\rC\u0004\u0002R\"!\t%a5\t\u0011\u0005\u0015\b\u0002)A\u0005\u0003OD\u0001\"a=\tA\u0003%\u0011Q\u001f\u0005\t\u0005\u000bA\u0001\u0015)\u0003\u0003\b!9!q\u0002\u0005\u0007\u0012\tE\u0001\"B=\t\t\u000bQ\bB\u0002@\t\t\u000b\u0011\u0019\u0002C\u0004\u0002\u0012!!)!a\u0004\t\u000f\t]\u0001B\"\u0005\u0003\u001a!9!Q\u0004\u0005\u0005\u0016\t}\u0001b\u0002B\u0012\u0011\u0019E!Q\u0005\u0005\b\u0003\u000bBA\u0011\u0001B\u0018\u0011\u0019\tY\u0001\u0003C\u0003u\"9\u0011Q\u0002\u0005\u0005\u0006\u0005=\u0001b\u0002B\u001c\u0011\u0011U!\u0011\b\u0005\b\u0005{Aa\u0011\u0003B \u0011\u001d\t\u0019\u0002\u0003C\u0003\u0005\u000f2aAa\u0014\u0002\r\tE\u0003\"\u00034\u001f\u0005\u0003\u0005\u000b\u0011\u00025\n\u0011)\t\tL\bB\u0001B\u0003%\u00111\u0017\u0005\u0007;z!\tAa\u0017\t\u0013\t=aD1A\u0005\u0006\t\r\u0004\u0002\u0003B5=\u0001\u0006iA!\u001a\t\u0011\t-d\u0004)Q\u0005\u0005[BqAa\u0006\u001f\t#\u0011\u0019\bC\u0004\u0003$y!\tBa\u001e\t\u000f\tub\u0004\"\u0005\u0003\b\"9\u0011q\n\u0010\u0005\u0002\t=eA\u0002BK\u0003\u0019\u00119\nC\u0005gS\t\u0005\t\u0015!\u0003i\u0013!Q\u0011\u0011W\u0015\u0003\u0002\u0003\u0006I!a-\t\ruKC\u0011\u0001BN\u0011%\u0011y!\u000bb\u0001\n\u000b\u0011\u0019\u000b\u0003\u0005\u0003j%\u0002\u000bQ\u0002BS\u0011!\u0011Y'\u000bQ!\n\t%\u0006b\u0002B\fS\u0011E!q\u0016\u0005\b\u0005GIC\u0011\u0003BZ\u0011\u001d\u0011i$\u000bC\t\u0005\u0007Dq!a\u0014*\t\u0003\u0011YM\u0002\u0004\u0003R\u00061!1\u001b\u0005\nMR\u0012\t\u0011)A\u0005Q&A!\"!-5\u0005\u0003\u0005\u000b\u0011BAZ\u0011\u0019iF\u0007\"\u0001\u0003X\"I!q\u0002\u001bC\u0002\u0013\u0015!1\r\u0005\t\u0005S\"\u0004\u0015!\u0004\u0003f!A!1\u000e\u001b!B\u0013\u0011y\u000eC\u0004\u0003\u0018Q\"\tB!:\t\u000f\t\rB\u0007\"\u0005\u0003j\"9!Q\b\u001b\u0005\u0012\te\bbBA(i\u0011\u00051\u0011\u0001\u0004\b+*\u0003\n1%\u0001e\u0011\u00151wH\"\u0001h\u0011\u001dIx\b1A\u0007\u0002iDqA` A\u0002\u001b\u0005q\u0010\u0003\u0004\u0002\f}2\tA\u001f\u0005\b\u0003\u001byd\u0011AA\b\u0011\u001d\t\tb\u0010D\u0001\u0003\u001fAq!a\u0005@\r\u0003\t)\u0002C\u0004\u0002F}2\t!a\u0012\t\u000f\u0005=sH\"\u0001\u0002R\u0005Qa)\u001b7f\u0005V4g-\u001a:\u000b\u0005-c\u0015AB:ue\u0016\fWN\u0003\u0002N\u001d\u00061am]2ba\u0016T!a\u0014)\u0002\u000bM\u001c\u0017n]:\u000b\u0003E\u000b!\u0001Z3\u0004\u0001A\u0011A+A\u0007\u0002\u0015\nQa)\u001b7f\u0005V4g-\u001a:\u0014\u0005\u00059\u0006C\u0001-\\\u001b\u0005I&\"\u0001.\u0002\u000bM\u001c\u0017\r\\1\n\u0005qK&AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002'\u0006)\u0011\r\u001d9msV\u0019\u0011-a\u0017\u0015\u0003\t$RaYA/\u0003O\u0002B\u0001V \u0002ZU\u0019Q-!\n\u0014\u0005}:\u0016\u0001\u00024jY\u0016,\u0012\u0001\u001b\t\u0003SZt!A[:\u000f\u0005-\u0014hB\u00017r\u001d\ti\u0007/D\u0001o\u0015\ty'+\u0001\u0004=e>|GOP\u0005\u0002#&\u0011q\nU\u0005\u0003M:K!\u0001^;\u0002\u000fA\f7m[1hK*\u0011aMT\u0005\u0003ob\u0014AAR5mK*\u0011A/^\u0001\ta>\u001c\u0018\u000e^5p]V\t1\u0010\u0005\u0002Yy&\u0011Q0\u0017\u0002\u0005\u0019>tw-\u0001\u0007q_NLG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002\u0002\u0005\u001d\u0001c\u0001-\u0002\u0004%\u0019\u0011QA-\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013\u0011\u0015\u0011!a\u0001w\u0006\u0019\u0001\u0010J\u0019\u0002\u00139,XN\u0012:b[\u0016\u001c\u0018A\u0002:fo&tG\r\u0006\u0002\u0002\u0002\u00059A-[:q_N,\u0017\u0001\u0002:fC\u0012$\u0002\"!\u0001\u0002\u0018\u0005]\u0012\u0011\t\u0005\b\u000331\u0005\u0019AA\u000e\u0003\r\u0011WO\u001a\t\u00061\u0006u\u0011\u0011E\u0005\u0004\u0003?I&!B!se\u0006L\b\u0003BA\u0012\u0003Ka\u0001\u0001B\u0004\u0002(}\u0012\r!!\u000b\u0003\u0003\u0005\u000bB!a\u000b\u00022A\u0019\u0001,!\f\n\u0007\u0005=\u0012LA\u0004O_RD\u0017N\\4\u0011\u0007a\u000b\u0019$C\u0002\u00026e\u00131!\u00118z\u0011\u001d\tID\u0012a\u0001\u0003w\t1a\u001c4g!\rA\u0016QH\u0005\u0004\u0003\u007fI&aA%oi\"9\u00111\t$A\u0002\u0005m\u0012a\u00017f]\u0006)qO]5uKRA\u0011\u0011AA%\u0003\u0017\ni\u0005C\u0004\u0002\u001a\u001d\u0003\r!a\u0007\t\u000f\u0005er\t1\u0001\u0002<!9\u00111I$A\u0002\u0005m\u0012AC<sSR,g+\u00197vKR1\u0011\u0011AA*\u0003/Bq!!\u0016I\u0001\u0004\t\t#A\u0003wC2,X\r\u0003\u0004\u0002D!\u0003\ra\u001f\t\u0005\u0003G\tY\u0006B\u0004\u0002(\r\u0011\r!!\u000b\t\u000f\u0005}3\u0001q\u0001\u0002b\u0005!1\r\u001e:m!\r!\u00161M\u0005\u0004\u0003KR%aB\"p]R\u0014x\u000e\u001c\u0005\b\u0003S\u001a\u00019AA6\u0003\r!\b/\u001a\t\u0007\u0003[\ny'!\u0017\u000e\u00031K1!!\u001dM\u0005!!\u0015\r^1UsB,\u0017A\u00023pk\ndW\r\u0006\u0002\u0002xQ!\u0011\u0011PA@!\r!\u00161P\u0005\u0004\u0003{R%a\u0003$jY\u0016\u0014UO\u001a4fe\u0012Cq!a\u0018\u0005\u0001\b\t\t'A\u0002j]R$\"!!\"\u0015\t\u0005\u001d\u0015Q\u0012\t\u0004)\u0006%\u0015bAAF\u0015\nYa)\u001b7f\u0005V4g-\u001a:J\u0011\u001d\ty&\u0002a\u0002\u0003C\nA\u0001\\8oOR\u0011\u00111\u0013\u000b\u0005\u0003+\u000bY\nE\u0002U\u0003/K1!!'K\u0005-1\u0015\u000e\\3Ck\u001a4WM\u001d'\t\u000f\u0005}c\u0001q\u0001\u0002bU!\u0011qTAT)\u0019\t\t+!,\u00020R!\u00111UAU!\u0011!v(!*\u0011\t\u0005\r\u0012q\u0015\u0003\b\u0003O9!\u0019AA\u0015\u0011\u001d\tIg\u0002a\u0002\u0003W\u0003b!!\u001c\u0002p\u0005\u0015\u0006\"\u00024\b\u0001\u0004A\u0007bBAY\u000f\u0001\u0007\u00111W\u0001\u0010I\u0016dW\r^3P]\u0012K7\u000f]8tKB\u0019\u0001,!.\n\u0007\u0005]\u0016LA\u0004C_>dW-\u00198\u0003\t\t\u000b7/Z\u000b\u0005\u0003{\u000b\u0019m\u0005\u0003\t/\u0006}\u0006\u0003\u0002+@\u0003\u0003\u0004B!a\t\u0002D\u00129\u0011q\u0005\u0005C\u0002\u0005%\u0012!\u00024jY\u0016\u0004CCBAe\u0003\u001b\fy\rE\u0003\u0002L\"\t\t-D\u0001\u0002\u0011\u00151G\u00021\u0001i\u0011\u001d\t\t\f\u0004a\u0001\u0003g\u000b\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003+\u0004B!a6\u0002b6\u0011\u0011\u0011\u001c\u0006\u0005\u00037\fi.\u0001\u0003mC:<'BAAp\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0018\u0011\u001c\u0002\u0007'R\u0014\u0018N\\4\u0002\u0007I\fg\r\u0005\u0003\u0002j\u0006=XBAAv\u0015\u0011\ti/!8\u0002\u0005%|\u0017\u0002BAy\u0003W\u0014\u0001CU1oI>l\u0017iY2fgN4\u0015\u000e\\3\u0002\u0005\rD\u0007\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\tG\"\fgN\\3mg*!\u0011q`Ao\u0003\rq\u0017n\\\u0005\u0005\u0005\u0007\tIPA\u0006GS2,7\t[1o]\u0016d\u0017A\u00012c!\u0011\u0011IAa\u0003\u000e\u0005\u0005u\u0018\u0002\u0002B\u0007\u0003{\u0014!BQ=uK\n+hMZ3s\u0003%!\u0017\r^1TQ&4G/\u0006\u0002\u0002<Q!\u0011\u0011\u0001B\u000b\u0011\u0019\t)f\u0005a\u0001w\u0006Ia.Z<Ck\u001a4WM\u001d\u000b\u0005\u0003\u0003\u0011Y\u0002C\u0004\u0003\u0006U\u0001\rAa\u0002\u0002\u0013\u0015t7/\u001e:f\u0005V4G\u0003BA\u0001\u0005CAa!a\u0011\u0017\u0001\u0004Y\u0018aC2mK\u0006\u0014\u0018I\u001c3QkR$\u0002\"!\u0001\u0003(\t-\"Q\u0006\u0005\b\u000339\u0002\u0019\u0001B\u0015!\u0015A\u0016QDAa\u0011\u001d\tId\u0006a\u0001\u0003wAq!a\u0011\u0018\u0001\u0004\tY\u0004\u0006\u0005\u0002\u0002\tE\"1\u0007B\u001b\u0011\u001d\tI\u0002\u0007a\u0001\u0005SAq!!\u000f\u0019\u0001\u0004\tY\u0004C\u0004\u0002Da\u0001\r!a\u000f\u0002\u001dA|7\u000f^,sSR,g+\u00197vKR!\u0011\u0011\u0001B\u001e\u0011\u0019\t\u0019e\u0007a\u0001w\u0006Y1\r\\3be\u0006sGmR3u)!\t\tA!\u0011\u0003D\t\u0015\u0003bBA\r9\u0001\u0007!\u0011\u0006\u0005\b\u0003sa\u0002\u0019AA\u001e\u0011\u001d\t\u0019\u0005\ba\u0001\u0003w!\u0002\"!\u0001\u0003J\t-#Q\n\u0005\b\u00033i\u0002\u0019\u0001B\u0015\u0011\u001d\tI$\ba\u0001\u0003wAq!a\u0011\u001e\u0001\u0004\tYDA\u0003J[BdGiE\u0003\u001f\u0005'\nI\bE\u0003\u0002L\"\u0011)\u0006E\u0002Y\u0005/J1A!\u0017Z\u0005\u0019!u.\u001e2mKR1!Q\fB0\u0005C\u00022!a3\u001f\u0011\u00151\u0017\u00051\u0001i\u0011\u001d\t\t,\ta\u0001\u0003g+\"A!\u001a\u0010\u0005\t\u001dT$A\u0002\u0002\u0015\u0011\fG/Y*iS\u001a$\b%\u0001\u0002uEB!!\u0011\u0002B8\u0013\u0011\u0011\t(!@\u0003\u0019\u0011{WO\u00197f\u0005V4g-\u001a:\u0015\t\u0005\u0005!Q\u000f\u0005\b\u0005\u000b)\u0003\u0019\u0001B\u0004)!\t\tA!\u001f\u0003\u0004\n\u0015\u0005bBA\rM\u0001\u0007!1\u0010\t\u00061\u0006u!Q\u0010\t\u0005\u0005\u007f\u0012\t)D\u0001\u001f\u0013\u0011\t9#a\u001f\t\u000f\u0005eb\u00051\u0001\u0002<!9\u00111\t\u0014A\u0002\u0005mB\u0003CA\u0001\u0005\u0013\u0013YI!$\t\u000f\u0005eq\u00051\u0001\u0003|!9\u0011\u0011H\u0014A\u0002\u0005m\u0002bBA\"O\u0001\u0007\u00111\b\u000b\u0007\u0003\u0003\u0011\tJa%\t\u000f\u0005U\u0003\u00061\u0001\u0003~!1\u00111\t\u0015A\u0002m\u0014Q!S7qY&\u001bR!\u000bBM\u0003\u000f\u0003R!a3\t\u0003w!bA!(\u0003 \n\u0005\u0006cAAfS!)a\r\fa\u0001Q\"9\u0011\u0011\u0017\u0017A\u0002\u0005MVC\u0001BS\u001f\t\u00119+H\u0001\u0003!\u0011\u0011IAa+\n\t\t5\u0016Q \u0002\n\u0013:$()\u001e4gKJ$B!!\u0001\u00032\"9!Q\u0001\u0019A\u0002\t\u001dA\u0003CA\u0001\u0005k\u0013yL!1\t\u000f\u0005e\u0011\u00071\u0001\u00038B)\u0001,!\b\u0003:B!!1\u0018B_\u001b\u0005I\u0013\u0002BA\u0014\u0003\u0013Cq!!\u000f2\u0001\u0004\tY\u0004C\u0004\u0002DE\u0002\r!a\u000f\u0015\u0011\u0005\u0005!Q\u0019Bd\u0005\u0013Dq!!\u00073\u0001\u0004\u00119\fC\u0004\u0002:I\u0002\r!a\u000f\t\u000f\u0005\r#\u00071\u0001\u0002<Q1\u0011\u0011\u0001Bg\u0005\u001fDq!!\u00164\u0001\u0004\u0011I\f\u0003\u0004\u0002DM\u0002\ra\u001f\u0002\u0006\u00136\u0004H\u000eT\n\u0006i\tU\u0017Q\u0013\t\u0005\u0003\u0017D1\u0010\u0006\u0004\u0003Z\nm'Q\u001c\t\u0004\u0003\u0017$\u0004\"\u000248\u0001\u0004A\u0007bBAYo\u0001\u0007\u00111\u0017\t\u0005\u0005\u0013\u0011\t/\u0003\u0003\u0003d\u0006u(A\u0003'p]\u001e\u0014UO\u001a4feR!\u0011\u0011\u0001Bt\u0011\u001d\u0011)a\u000fa\u0001\u0005\u000f!\u0002\"!\u0001\u0003l\nU(q\u001f\u0005\b\u00033a\u0004\u0019\u0001Bw!\u0015A\u0016Q\u0004Bx!\u0011\u0011\tPa=\u000e\u0003QJA!a\n\u0002\u0018\"9\u0011\u0011\b\u001fA\u0002\u0005m\u0002bBA\"y\u0001\u0007\u00111\b\u000b\t\u0003\u0003\u0011YP!@\u0003\u0000\"9\u0011\u0011D\u001fA\u0002\t5\bbBA\u001d{\u0001\u0007\u00111\b\u0005\b\u0003\u0007j\u0004\u0019AA\u001e)\u0019\t\taa\u0001\u0004\u0006!9\u0011Q\u000b A\u0002\t=\bBBA\"}\u0001\u00071\u0010")
public interface FileBuffer<A> {
    public static <A> FileBuffer<A> apply(File file, boolean deleteOnDispose, DataType<A> tpe) {
        return FileBuffer$.MODULE$.apply(file, deleteOnDispose, tpe);
    }

    public static FileBufferL long(Control ctrl) {
        return FileBuffer$.MODULE$.long(ctrl);
    }

    public static FileBufferI int(Control ctrl) {
        return FileBuffer$.MODULE$.int(ctrl);
    }

    public static FileBufferD double(Control ctrl) {
        return FileBuffer$.MODULE$.double(ctrl);
    }

    public static <A> FileBuffer<A> apply(Control ctrl, DataType<A> tpe) {
        return FileBuffer$.MODULE$.apply(ctrl, tpe);
    }

    public File file();

    public long position();

    public void position_$eq(long var1);

    public long numFrames();

    public void rewind();

    public void dispose();

    public void read(Object var1, int var2, int var3);

    public void write(Object var1, int var2, int var3);

    public void writeValue(A var1, long var2);

    private static abstract class Base<A>
    implements FileBuffer<A> {
        private final File file;
        private final boolean deleteOnDispose;
        private final RandomAccessFile raf;
        private final FileChannel ch;
        private ByteBuffer bb;

        @Override
        public File file() {
            return this.file;
        }

        public String toString() {
            return new StringBuilder(12).append("FileBuffer(").append(this.file()).append(")").toString();
        }

        public abstract int dataShift();

        @Override
        public final long position() {
            return this.ch.position() >> this.dataShift();
        }

        @Override
        public final void position_$eq(long value) {
            this.ch.position(value << this.dataShift());
        }

        @Override
        public final void dispose() {
            this.ch.close();
            if (this.deleteOnDispose) {
                this.file().delete();
                return;
            }
        }

        public abstract void newBuffer(ByteBuffer var1);

        public final void ensureBuf(long len) {
            int lim = (int)package$.MODULE$.min(len, 8192L);
            int limB = lim << this.dataShift();
            if (this.bb == null || this.bb.capacity() < limB) {
                this.bb = ByteBuffer.allocate(limB);
                this.newBuffer(this.bb);
                return;
            }
        }

        public abstract void clearAndPut(Object var1, int var2, int var3);

        @Override
        public void write(Object buf2, int off, int len) {
            this.ensureBuf(len);
            int off0 = off;
            int len0 = len;
            while (len0 > 0) {
                int chunk = package$.MODULE$.min(8192, len0);
                this.clearAndPut(buf2, off0, chunk);
                ((Buffer)this.bb).rewind().limit(chunk << this.dataShift());
                this.ch.write(this.bb);
                len0 -= chunk;
                off0 += chunk;
            }
        }

        @Override
        public final long numFrames() {
            return this.ch.size() >> this.dataShift();
        }

        @Override
        public final void rewind() {
            this.position_$eq(0L);
        }

        public final void postWriteValue(long len) {
            int chunk;
            for (long len0 = len; len0 > 0L; len0 -= (long)chunk) {
                chunk = (int)package$.MODULE$.min(8192L, len0);
                ((Buffer)this.bb).rewind().limit(chunk << this.dataShift());
                this.ch.write(this.bb);
            }
        }

        public abstract void clearAndGet(Object var1, int var2, int var3);

        @Override
        public final void read(Object buf2, int off, int len) {
            this.ensureBuf(len);
            int off0 = off;
            int len0 = len;
            while (len0 > 0) {
                int chunk = package$.MODULE$.min(8192, len0);
                ((Buffer)this.bb).rewind().limit(chunk << this.dataShift());
                this.ch.read(this.bb);
                this.clearAndGet(buf2, off0, chunk);
                len0 -= chunk;
                off0 += chunk;
            }
        }

        public Base(File file, boolean deleteOnDispose) {
            this.file = file;
            this.deleteOnDispose = deleteOnDispose;
            this.raf = new RandomAccessFile(file, "rw");
            this.ch = this.raf.getChannel();
            this.bb = null;
        }
    }

    private static final class ImplD
    extends Base<Object>
    implements FileBufferD {
        private DoubleBuffer tb = null;

        @Override
        public final int dataShift() {
            return 3;
        }

        @Override
        public void newBuffer(ByteBuffer bb) {
            this.tb = bb.asDoubleBuffer();
        }

        public void clearAndPut(double[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.put(buf2, off, len);
        }

        public void clearAndGet(double[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.get(buf2, off, len);
        }

        @Override
        public void writeValue(double value, long len) {
            this.ensureBuf(len);
            int sz = (int)package$.MODULE$.min(len, (long)this.tb.capacity());
            ((Buffer)this.tb).clear();
            for (int i = 0; i < sz; ++i) {
                this.tb.put(value);
            }
            this.postWriteValue(len);
        }

        public ImplD(File file, boolean deleteOnDispose) {
            super(file, deleteOnDispose);
        }
    }

    private static final class ImplI
    extends Base<Object>
    implements FileBufferI {
        private IntBuffer tb = null;

        @Override
        public final int dataShift() {
            return 2;
        }

        @Override
        public void newBuffer(ByteBuffer bb) {
            this.tb = bb.asIntBuffer();
        }

        public void clearAndPut(int[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.put(buf2, off, len);
        }

        public void clearAndGet(int[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.get(buf2, off, len);
        }

        @Override
        public void writeValue(int value, long len) {
            this.ensureBuf(len);
            int sz = (int)package$.MODULE$.min(len, (long)this.tb.capacity());
            ((Buffer)this.tb).clear();
            for (int i = 0; i < sz; ++i) {
                this.tb.put(value);
            }
            this.postWriteValue(len);
        }

        public ImplI(File file, boolean deleteOnDispose) {
            super(file, deleteOnDispose);
        }
    }

    private static final class ImplL
    extends Base<Object>
    implements FileBufferL {
        private LongBuffer tb = null;

        @Override
        public final int dataShift() {
            return 3;
        }

        @Override
        public void newBuffer(ByteBuffer bb) {
            this.tb = bb.asLongBuffer();
        }

        public void clearAndPut(long[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.put(buf2, off, len);
        }

        public void clearAndGet(long[] buf2, int off, int len) {
            ((Buffer)this.tb).clear();
            this.tb.get(buf2, off, len);
        }

        @Override
        public void writeValue(long value, long len) {
            this.ensureBuf(len);
            int sz = (int)package$.MODULE$.min(len, (long)this.tb.capacity());
            ((Buffer)this.tb).clear();
            for (int i = 0; i < sz; ++i) {
                this.tb.put(value);
            }
            this.postWriteValue(len);
        }

        public ImplL(File file, boolean deleteOnDispose) {
            super(file, deleteOnDispose);
        }
    }
}

