/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.fscape.stream;

import akka.stream.Attributes;
import akka.stream.FanInShape3;
import akka.stream.Outlet;
import de.sciss.fscape.DataType$;
import de.sciss.fscape.stream.Allocator;
import de.sciss.fscape.stream.Buf;
import de.sciss.fscape.stream.Builder;
import de.sciss.fscape.stream.NormalizeWindow$;
import de.sciss.fscape.stream.impl.Handlers;
import de.sciss.fscape.stream.impl.Handlers$;
import de.sciss.fscape.stream.impl.NodeImpl;
import de.sciss.fscape.stream.impl.StageImpl;
import de.sciss.fscape.stream.impl.logic.FilterWindowedInAOutA;
import de.sciss.fscape.stream.package$;
import de.sciss.numbers.Implicits$;
import de.sciss.numbers.RichInt$;
import java.io.Serializable;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005]u!B\u000e\u001d\u0011\u0003)c!B\u0014\u001d\u0011\u0003A\u0003\"B\u0018\u0002\t\u0003\u0001\u0004\"B\u0019\u0002\t\u0003\u0011\u0004bB%\u0002\u0005\u0004%iA\u0013\u0005\u0007\u001b\u0006\u0001\u000bQB&\u0006\t9\u000bAa\u0014\u0004\u0005A\u00061\u0011\r\u0003\u0005k\u000f\t\u0005\t\u0015!\u0003l\u0011!qwA!A!\u0002\u0017y\u0007\"B\u0018\b\t\u0003\u0011\bbB<\b\u0005\u0004%\t\u0001\u001f\u0005\u0007\u007f\u001e\u0001\u000b\u0011B=\t\u000f\u0005\u0005q\u0001\"\u0001\u0002\u0004\u00191\u0011QC\u0001\u0007\u0003/A!b\u001e\b\u0003\u0002\u0003\u0006I\u0001[A\u0016\u0011)QgB!A!\u0002\u0013Y\u0017Q\u0006\u0005\u000b]:\u0011\t\u0011)A\u0006_\u0006=\u0002BB\u0018\u000f\t\u0003\t\u0019\u0004\u0003\u0005\u0002@9\u0001\u000b\u0011BA!\u0011!\tyE\u0004Q\u0001\n\u0005\u0005\u0003bBA)\u001d\u0011E\u00111\u000b\u0005\b\u00037rA\u0011CA/\u0011\u001d\t)G\u0004C\t\u0003OBq!a\u001c\u000f\t\u0013\t\t\bC\u0004\u0002\u00009!I!!!\t\u000f\u0005=e\u0002\"\u0003\u0002\u0012\u0006yaj\u001c:nC2L'0Z,j]\u0012|wO\u0003\u0002\u001e=\u000511\u000f\u001e:fC6T!a\b\u0011\u0002\r\u0019\u001c8-\u00199f\u0015\t\t#%A\u0003tG&\u001c8OC\u0001$\u0003\t!Wm\u0001\u0001\u0011\u0005\u0019\nQ\"\u0001\u000f\u0003\u001f9{'/\\1mSj,w+\u001b8e_^\u001c\"!A\u0015\u0011\u0005)jS\"A\u0016\u000b\u00031\nQa]2bY\u0006L!AL\u0016\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tQ%A\u0003baBd\u0017\u0010\u0006\u00034\u0001\n;EC\u0001\u001b<!\t)\u0004H\u0004\u0002'm%\u0011q\u0007H\u0001\ba\u0006\u001c7.Y4f\u0013\tI$H\u0001\u0003PkR$%BA\u001c\u001d\u0011\u0015a4\u0001q\u0001>\u0003\u0005\u0011\u0007C\u0001\u0014?\u0013\tyDDA\u0004Ck&dG-\u001a:\t\u000b\u0005\u001b\u0001\u0019\u0001\u001b\u0002\u0005%t\u0007\"B\"\u0004\u0001\u0004!\u0015\u0001B:ju\u0016\u0004\"!N#\n\u0005\u0019S$\u0001B(vi&CQ\u0001S\u0002A\u0002\u0011\u000bA!\\8eK\u0006!a.Y7f+\u0005Yu\"\u0001'\"\u0003m\tQA\\1nK\u0002\u00121a\u00155q!\u0019\u0001FKV/^-6\t\u0011K\u0003\u0002\u001e%*\t1+\u0001\u0003bW.\f\u0017BA+R\u0005-1\u0015M\\%o'\"\f\u0007/Z\u001a\u0011\u0005]SfB\u0001\u0014Y\u0013\tIF$A\u0002Ck\u001aL!a\u0017/\u0003\u0003\u0011S!!\u0017\u000f\u0011\u0005]s\u0016BA0]\u0005\u0005I%!B*uC\u001e,7CA\u0004c!\r\u0019g\r[\u0007\u0002I*\u0011Q\rH\u0001\u0005S6\u0004H.\u0003\u0002hI\nI1\u000b^1hK&k\u0007\u000f\u001c\t\u0003S\u001ai\u0011!A\u0001\u0006Y\u0006LXM\u001d\t\u0003k1L!!\u001c\u001e\u0003\u000b1\u000b\u00170\u001a:\u0002\u0003\u0005\u0004\"A\n9\n\u0005Ed\"!C!mY>\u001c\u0017\r^8s)\t\u0019h\u000f\u0006\u0002ukB\u0011\u0011n\u0002\u0005\u0006]*\u0001\u001da\u001c\u0005\u0006U*\u0001\ra[\u0001\u0006g\"\f\u0007/Z\u000b\u0002sB\u0011!p_\u0007\u0002\u000f%\u0011A0 \u0002\u0006'\"\f\u0007/Z\u0005\u0003}F\u0013Qa\u0012:ba\"\faa\u001d5ba\u0016\u0004\u0013aC2sK\u0006$X\rT8hS\u000e$B!!\u0002\u0002\fA!1-a\u0002z\u0013\r\tI\u0001\u001a\u0002\t\u001d>$W-S7qY\"9\u0011QB\u0007A\u0002\u0005=\u0011\u0001B1uiJ\u00042\u0001UA\t\u0013\r\t\u0019\"\u0015\u0002\u000b\u0003R$(/\u001b2vi\u0016\u001c(!\u0002'pO&\u001c7c\u0001\b\u0002\u001aA9\u00111DA\u0011\u0003KAWBAA\u000f\u0015\r\ty\u0002Z\u0001\u0006Y><\u0017nY\u0005\u0005\u0003G\tiBA\u000bGS2$XM],j]\u0012|w/\u001a3J]\u0006{U\u000f^!\u0011\u0007)\n9#C\u0002\u0002*-\u0012a\u0001R8vE2,\u0017bA<\u0002\b%\u0019!.a\u0002\n\t\u0005E\u0012qA\u0001\nC2dwnY1u_J$b!!\u000e\u0002<\u0005uB\u0003BA\u001c\u0003s\u0001\"!\u001b\b\t\u000b9\u0014\u00029A8\t\u000b]\u0014\u0002\u0019\u00015\t\u000b)\u0014\u0002\u0019A6\u0002\u000b!\u001c\u0016N_3\u0011\t\u0005\r\u0013\u0011\n\b\u0004G\u0006\u0015\u0013bAA$I\u0006A\u0001*\u00198eY\u0016\u00148/\u0003\u0003\u0002L\u00055#AB%o\u0013\u0006+\bPC\u0002\u0002H\u0011\fQ\u0001['pI\u0016\f!b^5o\u0005V47+\u001b>f+\t\t)\u0006E\u0002+\u0003/J1!!\u0017,\u0005\rIe\u000e^\u0001\u0013iJLxJ\u0019;bS:<\u0016N\u001c)be\u0006l7\u000f\u0006\u0002\u0002`A\u0019!&!\u0019\n\u0007\u0005\r4FA\u0004C_>dW-\u00198\u0002\u001bA\u0014xnY3tg^Kg\u000eZ8x)\t\tI\u0007E\u0002+\u0003WJ1!!\u001c,\u0005\u0011)f.\u001b;\u0002!A\u0014xnY3tg:{'/\\1mSj,GCBA5\u0003g\nY\b\u0003\u0004=1\u0001\u0007\u0011Q\u000f\t\u0006U\u0005]\u0014QE\u0005\u0004\u0003sZ#!B!se\u0006L\bbBA?1\u0001\u0007\u0011QK\u0001\u0002]\u0006y\u0001O]8dKN\u001ch)\u001b;SC:<W\r\u0006\u0006\u0002j\u0005\r\u0015QQAD\u0003\u0017Ca\u0001P\rA\u0002\u0005U\u0004bBA?3\u0001\u0007\u0011Q\u000b\u0005\b\u0003\u0013K\u0002\u0019AA\u0013\u0003\taw\u000eC\u0004\u0002\u000ef\u0001\r!!\n\u0002\u0005!L\u0017a\u00049s_\u000e,7o\u001d.fe>lU-\u00198\u0015\r\u0005%\u00141SAK\u0011\u0019a$\u00041\u0001\u0002v!9\u0011Q\u0010\u000eA\u0002\u0005U\u0003")
public final class NormalizeWindow {
    public static Outlet<Buf> apply(Outlet<Buf> in, Outlet<Buf> size, Outlet<Buf> mode, Builder b) {
        return NormalizeWindow$.MODULE$.apply(in, size, mode, b);
    }

    private static final class Logic
    extends FilterWindowedInAOutA<Object, FanInShape3<Buf, Buf, Buf, Buf>> {
        private final Handlers.InIAux hSize = Handlers$.MODULE$.InIAux(this, ((FanInShape3)super.shape()).in1(), x$1 -> scala.math.package$.MODULE$.max(1, x$1));
        private final Handlers.InIAux hMode = Handlers$.MODULE$.InIAux(this, ((FanInShape3)super.shape()).in2(), x$2 -> RichInt$.MODULE$.clip$extension(Implicits$.MODULE$.intNumberWrapper(x$2), 0, 3));

        @Override
        public int winBufSize() {
            return this.hSize.value();
        }

        @Override
        public boolean tryObtainWinParams() {
            Serializable serializable;
            boolean ok;
            boolean bl = ok = this.hSize.hasNext() && this.hMode.hasNext();
            if (ok) {
                this.hSize.next();
                serializable = BoxesRunTime.boxToInteger(this.hMode.next());
            } else {
                serializable = BoxedUnit.UNIT;
            }
            return ok;
        }

        @Override
        public void processWindow() {
            int mode;
            int n = this.winBufSize();
            Predef$.MODULE$.assert(n > 0);
            double[] win = (double[])this.winBuf();
            int n2 = mode = this.hMode.value();
            switch (n2) {
                case 0: {
                    this.processNormalize(win, n);
                    return;
                }
                case 1: {
                    this.processFitRange(win, n, 0.0, 1.0);
                    return;
                }
                case 2: {
                    this.processFitRange(win, n, -1.0, 1.0);
                    return;
                }
                case 3: {
                    this.processZeroMean(win, n);
                    return;
                }
            }
            throw new MatchError(BoxesRunTime.boxToInteger(n2));
        }

        private void processNormalize(double[] b, int n) {
            int i;
            double max = Double.NEGATIVE_INFINITY;
            for (i = 0; i < n; ++i) {
                double x = scala.math.package$.MODULE$.abs(b[i]);
                if (!(x > max)) continue;
                max = x;
            }
            if (max > 0.0) {
                double mul = 1.0 / max;
                i = 0;
                while (i < n) {
                    int n2 = i++;
                    b[n2] = b[n2] * mul;
                }
                return;
            }
        }

        private void processFitRange(double[] b, int n, double lo, double hi) {
            int i;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (i = 0; i < n; ++i) {
                double x = b[i];
                if (x < min) {
                    min = x;
                }
                if (!(x > max)) continue;
                max = x;
            }
            double add = -min;
            double mul = min < max ? (hi - lo) / (max - min) : 1.0;
            for (i = 0; i < n; ++i) {
                b[i] = (b[i] + add) * mul + lo;
            }
        }

        private void processZeroMean(double[] b, int n) {
            int i;
            double sum = 0.0;
            for (i = 0; i < n; ++i) {
                double x = b[i];
                sum += x;
            }
            double add = -sum / (double)n;
            i = 0;
            while (i < n) {
                int n2 = i++;
                b[n2] = b[n2] + add;
            }
        }

        public Logic(FanInShape3<Buf, Buf, Buf, Buf> shape, int layer, Allocator a) {
            super("NormalizeWindow", layer, shape, shape.in0(), shape.out(), a, DataType$.MODULE$.double());
        }
    }

    private static final class Stage
    extends StageImpl<FanInShape3<Buf, Buf, Buf, Buf>> {
        private final int layer;
        private final Allocator a;
        private final FanInShape3<Buf, Buf, Buf, Buf> shape;

        @Override
        public FanInShape3<Buf, Buf, Buf, Buf> shape() {
            return this.shape;
        }

        @Override
        public NodeImpl<FanInShape3<Buf, Buf, Buf, Buf>> createLogic(Attributes attr) {
            return new Logic((FanInShape3<Buf, Buf, Buf, Buf>)this.shape(), this.layer, this.a);
        }

        public Stage(int layer, Allocator a) {
            this.layer = layer;
            this.a = a;
            super("NormalizeWindow");
            this.shape = new FanInShape3<Buf, Buf, Buf, Buf>(package$.MODULE$.InD(new StringBuilder(3).append(this.name()).append(".in").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".size").toString()), package$.MODULE$.InI(new StringBuilder(5).append(this.name()).append(".mode").toString()), package$.MODULE$.OutD(new StringBuilder(4).append(this.name()).append(".out").toString()));
        }
    }
}

